/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Order;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanQueryEngine;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ScanQueryTest
extends InitializedNullHandlingTest {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();
    private static QuerySegmentSpec intervalSpec;
    private static ScanResultValue s1;
    private static ScanResultValue s2;
    private static ScanResultValue s3;

    @BeforeClass
    public static void setup() {
        intervalSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(new Interval((ReadableInstant)DateTimes.of((String)"2012-01-01"), (ReadableInstant)DateTimes.of((String)"2012-01-01").plusHours(1))));
        ArrayList events1 = new ArrayList();
        HashMap<String, Long> event1 = new HashMap<String, Long>();
        event1.put("__time", new Long(42L));
        events1.add(event1);
        s1 = new ScanResultValue("segmentId", Collections.singletonList("__time"), events1);
        ArrayList events2 = new ArrayList();
        HashMap<String, Long> event2 = new HashMap<String, Long>();
        event2.put("__time", new Long(43L));
        events2.add(event2);
        s2 = new ScanResultValue("segmentId", Collections.singletonList("__time"), events2);
        ArrayList events3 = new ArrayList();
        HashMap<String, String> event3 = new HashMap<String, String>();
        event3.put("yah", "yeet");
        events3.add(event3);
        s3 = new ScanResultValue("segmentId", Collections.singletonList("yah"), events3);
    }

    @Test
    public void testSerdeAndLegacyBackwardsCompat() throws JsonProcessingException {
        ScanQuery query = Druids.newScanQueryBuilder().columns((List)ImmutableList.of((Object)"__time", (Object)"quality")).dataSource("source").intervals(intervalSpec).build();
        Assert.assertFalse((boolean)query.isLegacy());
        String json = JSON_MAPPER.writeValueAsString((Object)query);
        Assert.assertTrue((boolean)json.contains("\"legacy\":false"));
        Assert.assertEquals((Object)query, (Object)JSON_MAPPER.readValue(json, Query.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAscendingScanQueryWithInvalidColumns() {
        Druids.newScanQueryBuilder().order(Order.ASCENDING).columns((List)ImmutableList.of((Object)"not time", (Object)"also not time")).dataSource("source").intervals(intervalSpec).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDescendingScanQueryWithInvalidColumns() {
        Druids.newScanQueryBuilder().order(Order.DESCENDING).columns((List)ImmutableList.of((Object)"not time", (Object)"also not time")).dataSource("source").intervals(intervalSpec).build();
    }

    @Test
    public void testConflictingOrderByAndTimeOrder() {
        Assert.assertThrows((String)"Cannot provide 'order' incompatible with 'orderBy'", IllegalArgumentException.class, () -> Druids.newScanQueryBuilder().order(Order.ASCENDING).orderBy((List)ImmutableList.of((Object)OrderBy.ascending((String)"__time"), (Object)OrderBy.descending((String)"quality"))).columns((List)ImmutableList.of((Object)"__time", (Object)"quality")).dataSource("source").intervals(intervalSpec).build());
    }

    @Test
    public void testCompatibleOrderByAndTimeOrder() {
        Assert.assertNotNull((Object)Druids.newScanQueryBuilder().order(Order.ASCENDING).orderBy((List)ImmutableList.of((Object)OrderBy.ascending((String)"__time"))).columns((List)ImmutableList.of((Object)"__time", (Object)"quality")).dataSource("source").intervals(intervalSpec).build());
    }

    @Test
    public void testValidScanQueryInitialization() {
        List<Order> nonOrderedOrders = Arrays.asList(null, Order.NONE);
        for (Order order : nonOrderedOrders) {
            Druids.newScanQueryBuilder().order(order).columns((List)ImmutableList.of((Object)"not time")).dataSource("source").intervals(intervalSpec).build();
            Druids.newScanQueryBuilder().order(order).dataSource("source").intervals(intervalSpec).build();
            Druids.newScanQueryBuilder().order(order).columns((List)ImmutableList.of()).dataSource("source").intervals(intervalSpec).build();
            Druids.newScanQueryBuilder().order(order).columns((List)ImmutableList.of((Object)"__time")).dataSource("source").intervals(intervalSpec).build();
        }
        ImmutableSet orderedOrders = ImmutableSet.of((Object)Order.ASCENDING, (Object)Order.DESCENDING);
        for (Order order : orderedOrders) {
            Druids.newScanQueryBuilder().order(order).columns((List)null).dataSource("source").intervals(intervalSpec).build();
            Druids.newScanQueryBuilder().order(order).columns((List)ImmutableList.of()).dataSource("source").intervals(intervalSpec).build();
            Druids.newScanQueryBuilder().order(order).dataSource("source").intervals(intervalSpec).build();
            Druids.newScanQueryBuilder().order(order).columns((List)ImmutableList.of((Object)"__time", (Object)"col2")).dataSource("source").intervals(intervalSpec).build();
        }
    }

    @Test
    public void testMergeSequenceForResults() {
        ScanQuery noOrderScan = Druids.newScanQueryBuilder().order(Order.NONE).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).dataSource("some src").intervals(intervalSpec).build();
        ScanQuery descendingOrderScan = Druids.newScanQueryBuilder().order(Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).dataSource("some src").intervals(intervalSpec).build();
        ScanQuery ascendingOrderScan = Druids.newScanQueryBuilder().order(Order.ASCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).dataSource("some src").intervals(intervalSpec).build();
        Sequence noOrderSeq = Sequences.simple((Iterable)ImmutableList.of((Object)Sequences.simple((Iterable)ImmutableList.of((Object)s1, (Object)s3)), (Object)Sequences.simple((Iterable)ImmutableList.of((Object)s2)))).flatMerge(seq -> seq, noOrderScan.getResultOrdering());
        List noOrderList = noOrderSeq.toList();
        Assert.assertEquals((long)3L, (long)noOrderList.size());
        Sequence ascendingOrderSeq = Sequences.simple((Iterable)ImmutableList.of((Object)Sequences.simple((Iterable)ImmutableList.of((Object)s1)), (Object)Sequences.simple((Iterable)ImmutableList.of((Object)s2)))).flatMerge(seq -> seq, ascendingOrderScan.getResultOrdering());
        List ascendingList = ascendingOrderSeq.toList();
        Assert.assertEquals((long)2L, (long)ascendingList.size());
        Assert.assertEquals((Object)s1, ascendingList.get(0));
        Assert.assertEquals((Object)s2, ascendingList.get(1));
        Sequence descendingOrderSeq = Sequences.simple((Iterable)ImmutableList.of((Object)Sequences.simple((Iterable)ImmutableList.of((Object)s1)), (Object)Sequences.simple((Iterable)ImmutableList.of((Object)s2)))).flatMerge(seq -> seq, descendingOrderScan.getResultOrdering());
        List descendingList = descendingOrderSeq.toList();
        Assert.assertEquals((long)2L, (long)descendingList.size());
        Assert.assertEquals((Object)s2, descendingList.get(0));
        Assert.assertEquals((Object)s1, descendingList.get(1));
    }

    @Test(expected=ISE.class)
    public void testTimeOrderingWithoutTimeColumn() {
        ScanQuery descendingOrderScan = Druids.newScanQueryBuilder().order(Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).dataSource("some src").intervals(intervalSpec).build();
        Sequence borkedSequence = Sequences.simple((Iterable)ImmutableList.of((Object)Sequences.simple((Iterable)ImmutableList.of((Object)s1)), (Object)Sequences.simple((Iterable)ImmutableList.of((Object)s2, (Object)s3)))).flatMerge(seq -> seq, descendingOrderScan.getResultOrdering());
        List res = borkedSequence.toList();
    }

    @Test
    public void testGetResultOrderingWithTimeBasedOrderBy() {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().columns(new String[]{"__time"}).orderBy(Collections.singletonList(OrderBy.descending((String)"__time"))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).dataSource("some src").intervals(intervalSpec).build();
        Assert.assertNotNull((Object)scanQuery.getResultOrdering());
    }

    @Test
    public void testGetResultOrderingWithNonTimeOrderBy() {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().columns(new String[]{"quality"}).orderBy(Collections.singletonList(OrderBy.ascending((String)"quality"))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).dataSource("some src").intervals(intervalSpec).build();
        Assert.assertThrows((String)"Cannot execute query with orderBy [quality ASC]", ISE.class, () -> ((ScanQuery)scanQuery).getResultOrdering());
    }

    @Test
    public void testGetRequiredColumnsWithNoColumns() {
        ScanQuery query = Druids.newScanQueryBuilder().order(Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).dataSource("some src").intervals(intervalSpec).build();
        Assert.assertNull((Object)query.getRequiredColumns());
    }

    @Test
    public void testGetRequiredColumnsWithEmptyColumns() {
        ScanQuery query = Druids.newScanQueryBuilder().order(Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).dataSource("some src").intervals(intervalSpec).columns(Collections.emptyList()).build();
        Assert.assertNull((Object)query.getRequiredColumns());
    }

    @Test
    public void testGetRequiredColumnsWithColumns() {
        ScanQuery query = Druids.newScanQueryBuilder().resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).dataSource("some src").intervals(intervalSpec).columns(new String[]{"foo", "bar"}).build();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"__time", (Object)"foo", (Object)"bar"), (Object)query.getRequiredColumns());
    }

    @Test
    public void testGetRowSignature() {
        ScanQuery query = Druids.newScanQueryBuilder().resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).dataSource("some src").intervals(intervalSpec).columns(new String[]{"foo", "bar"}).columnTypes((List)ImmutableList.builder().add((Object[])new ColumnType[]{ColumnType.LONG, ColumnType.FLOAT}).build()).build();
        RowSignature sig = RowSignature.builder().add("foo", ColumnType.LONG).add("bar", ColumnType.FLOAT).build();
        Assert.assertEquals((Object)sig, (Object)query.getRowSignature());
    }

    @Test
    public void testAsCursorBuildSpec() {
        VirtualColumns virtualColumns = VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{new ExpressionVirtualColumn("v0", "concat(placement, 'foo')", ColumnType.STRING, ExprMacroTable.nil())});
        ScanQuery query = Druids.newScanQueryBuilder().resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).dataSource("some src").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).virtualColumns(virtualColumns).columns(new String[]{"foo", "bar"}).build();
        CursorBuildSpec buildSpec = ScanQueryEngine.makeCursorBuildSpec((ScanQuery)query, null);
        Assert.assertEquals(QueryRunnerTestHelper.FIRST_TO_THIRD.getIntervals().get(0), (Object)buildSpec.getInterval());
        Assert.assertNull((Object)buildSpec.getGroupingColumns());
        Assert.assertNull((Object)buildSpec.getAggregators());
        Assert.assertEquals((Object)virtualColumns, (Object)buildSpec.getVirtualColumns());
    }
}

