/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeseries;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.QueryToolChestTestHelper;
import org.apache.druid.query.Result;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.firstlast.last.StringLastAggregatorFactory;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeseriesQueryQueryToolChestTest {
    private static final String TIMESTAMP_RESULT_FIELD_NAME = "d0";
    private static final TimeseriesQueryQueryToolChest TOOL_CHEST = new TimeseriesQueryQueryToolChest(null);
    private final boolean descending;

    @BeforeClass
    public static void setUpClass() {
        NullHandling.initializeForTests();
    }

    @Parameterized.Parameters(name="descending={0}")
    public static Iterable<Object[]> constructorFeeder() {
        return QueryRunnerTestHelper.transformToConstructionFeeder(Arrays.asList(false, true));
    }

    public TimeseriesQueryQueryToolChestTest(boolean descending) {
        this.descending = descending;
    }

    @Test
    public void testCacheStrategy() throws Exception {
        CacheStrategy strategy = TOOL_CHEST.getCacheStrategy(new TimeseriesQuery((DataSource)new TableDataSource("dummy"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01/2015-01-02"))), this.descending, VirtualColumns.EMPTY, null, Granularities.ALL, (List)ImmutableList.of((Object)new CountAggregatorFactory("metric1"), (Object)new LongSumAggregatorFactory("metric0", "metric0"), (Object)new StringLastAggregatorFactory("complexMetric", "test", null, null)), (List)ImmutableList.of((Object)new ConstantPostAggregator("post", (Number)10)), 0, (Map)ImmutableMap.of((Object)"timestampResultField", (Object)"ts_field")));
        Result result1 = new Result(DateTimes.utc((long)123L), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"ts_field", (Object)123L, (Object)"metric1", (Object)2, (Object)"metric0", (Object)3, (Object)"complexMetric", (Object)new SerializablePairLongString(Long.valueOf(123L), "val1"))));
        Object preparedValue = strategy.prepareForSegmentLevelCache().apply((Object)result1);
        ObjectMapper objectMapper = TestHelper.makeJsonMapper();
        Object fromCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedValue), strategy.getCacheObjectClazz());
        Result fromCacheResult = (Result)strategy.pullFromSegmentLevelCache().apply(fromCacheValue);
        Assert.assertEquals((Object)result1, (Object)fromCacheResult);
        Result result2 = new Result(DateTimes.utc((long)123L), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"ts_field", (Object)123L, (Object)"metric1", (Object)2, (Object)"metric0", (Object)3, (Object)"complexMetric", (Object)"val1", (Object)"post", (Object)10)));
        Object preparedResultLevelCacheValue = strategy.prepareForCache(true).apply((Object)result2);
        Object fromResultLevelCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedResultLevelCacheValue), strategy.getCacheObjectClazz());
        Result fromResultLevelCacheRes = (Result)strategy.pullFromCache(true).apply(fromResultLevelCacheValue);
        Assert.assertEquals((Object)result2, (Object)fromResultLevelCacheRes);
        Result result3 = new Result(null, (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric1", (Object)2, (Object)"metric0", (Object)3, (Object)"complexMetric", (Object)"val1", (Object)"post", (Object)10)));
        preparedResultLevelCacheValue = strategy.prepareForCache(true).apply((Object)result3);
        fromResultLevelCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedResultLevelCacheValue), strategy.getCacheObjectClazz());
        fromResultLevelCacheRes = (Result)strategy.pullFromCache(true).apply(fromResultLevelCacheValue);
        Assert.assertEquals((Object)result3, (Object)fromResultLevelCacheRes);
    }

    @Test
    public void testCacheKey() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2015-01-01/2015-01-02").descending(this.descending).granularity(Granularities.ALL).aggregators((List)ImmutableList.of((Object)new CountAggregatorFactory("metric1"), (Object)new LongSumAggregatorFactory("metric0", "metric0"))).build();
        TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2015-01-01/2015-01-02").descending(this.descending).granularity(Granularities.ALL).aggregators((List)ImmutableList.of((Object)new LongSumAggregatorFactory("metric0", "metric0"), (Object)new CountAggregatorFactory("metric1"))).build();
        Assert.assertFalse((boolean)Arrays.equals(TOOL_CHEST.getCacheStrategy(query1).computeCacheKey((Query)query1), TOOL_CHEST.getCacheStrategy(query2).computeCacheKey((Query)query2)));
    }

    @Test
    public void testResultLevelCacheKey() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2015-01-01/2015-01-02").descending(this.descending).granularity(Granularities.ALL).aggregators((List)ImmutableList.of((Object)new LongSumAggregatorFactory("metric0", "metric0"), (Object)new CountAggregatorFactory("metric1"))).postAggregators((List)ImmutableList.of((Object)new ArithmeticPostAggregator("post", "+", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "metric1"), (Object)new FieldAccessPostAggregator(null, "metric0"))))).build();
        TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2015-01-01/2015-01-02").descending(this.descending).granularity(Granularities.ALL).aggregators((List)ImmutableList.of((Object)new LongSumAggregatorFactory("metric0", "metric0"), (Object)new CountAggregatorFactory("metric1"))).postAggregators((List)ImmutableList.of((Object)new ArithmeticPostAggregator("post", "/", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "metric1"), (Object)new FieldAccessPostAggregator(null, "metric0"))))).build();
        Assert.assertTrue((boolean)Arrays.equals(TOOL_CHEST.getCacheStrategy(query1).computeCacheKey((Query)query1), TOOL_CHEST.getCacheStrategy(query2).computeCacheKey((Query)query2)));
        Assert.assertFalse((boolean)Arrays.equals(TOOL_CHEST.getCacheStrategy(query1).computeResultLevelCacheKey((Query)query1), TOOL_CHEST.getCacheStrategy(query2).computeResultLevelCacheKey((Query)query2)));
    }

    @Test
    public void testResultLevelCacheKeyWithGrandTotal() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2015-01-01/2015-01-02").descending(this.descending).granularity(Granularities.ALL).aggregators((List)ImmutableList.of((Object)new LongSumAggregatorFactory("metric0", "metric0"), (Object)new CountAggregatorFactory("metric1"))).postAggregators((List)ImmutableList.of((Object)new ArithmeticPostAggregator("post", "+", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "metric1"), (Object)new FieldAccessPostAggregator(null, "metric0"))))).context((Map)ImmutableMap.of((Object)"grandTotal", (Object)true)).build();
        TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2015-01-01/2015-01-02").descending(this.descending).granularity(Granularities.ALL).aggregators((List)ImmutableList.of((Object)new LongSumAggregatorFactory("metric0", "metric0"), (Object)new CountAggregatorFactory("metric1"))).postAggregators((List)ImmutableList.of((Object)new ArithmeticPostAggregator("post", "/", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "metric1"), (Object)new FieldAccessPostAggregator(null, "metric0"))))).context((Map)ImmutableMap.of((Object)"grandTotal", (Object)true)).build();
        Assert.assertTrue((boolean)Arrays.equals(TOOL_CHEST.getCacheStrategy(query1).computeCacheKey((Query)query1), TOOL_CHEST.getCacheStrategy(query2).computeCacheKey((Query)query2)));
        Assert.assertFalse((boolean)Arrays.equals(TOOL_CHEST.getCacheStrategy(query1).computeResultLevelCacheKey((Query)query1), TOOL_CHEST.getCacheStrategy(query2).computeResultLevelCacheKey((Query)query2)));
    }

    @Test
    public void testResultArraySignatureWithoutTimestampResultField() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").descending(this.descending).granularity(Granularities.HOUR).aggregators(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.CONSTANT}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("rows", ColumnType.LONG).add("index", ColumnType.DOUBLE).add("uniques", null).add("const", ColumnType.LONG).build(), (Object)TOOL_CHEST.resultArraySignature(query));
    }

    @Test
    public void testResultArraySignatureWithTimestampResultField() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").descending(this.descending).granularity(Granularities.HOUR).aggregators(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.CONSTANT}).context((Map)ImmutableMap.of((Object)"timestampResultField", (Object)TIMESTAMP_RESULT_FIELD_NAME)).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add(TIMESTAMP_RESULT_FIELD_NAME, ColumnType.LONG).add("rows", ColumnType.LONG).add("index", ColumnType.DOUBLE).add("uniques", null).add("const", ColumnType.LONG).build(), (Object)TOOL_CHEST.resultArraySignature(query));
    }

    @Test
    public void testResultsAsArrays() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").descending(this.descending).granularity(Granularities.HOUR).aggregators(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.CONSTANT}).build();
        QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[]{DateTimes.of((String)"2000").getMillis(), 1L, 2L, 3L, 1L}, (Object)new Object[]{DateTimes.of((String)"2000T01").getMillis(), 4L, 5L, 6L, 1L}), (Sequence<Object[]>)TOOL_CHEST.resultsAsArrays(query, Sequences.simple((Iterable)ImmutableList.of((Object)new Result(DateTimes.of((String)"2000"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)2L, (Object)"uniques", (Object)3L, (Object)"const", (Object)1L))), (Object)new Result(DateTimes.of((String)"2000T01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)4L, (Object)"index", (Object)5L, (Object)"uniques", (Object)6L, (Object)"const", (Object)1L)))))));
    }
}

