/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeseries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.query.Druids;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.MetricsEmittingQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.first.DoubleFirstAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.DoubleLastAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.RegexDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeseriesQueryRunnerTest
extends InitializedNullHandlingTest {
    private static final String TIMESTAMP_RESULT_FIELD_NAME = "d0";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    protected final QueryRunner<Result<TimeseriesResultValue>> runner;
    protected final boolean descending;
    protected final boolean vectorize;
    protected final List<AggregatorFactory> aggregatorFactoryList;

    @Parameterized.Parameters(name="{0}:descending={1},vectorize={2}")
    public static Iterable<Object[]> constructorFeeder() {
        Iterable<Object[]> baseConstructors = QueryRunnerTestHelper.cartesian(QueryRunnerTestHelper.makeQueryRunnersToMerge(new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER), false), Arrays.asList(false, true), Arrays.asList(false, true), Arrays.asList(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS, QueryRunnerTestHelper.COMMON_FLOAT_AGGREGATORS));
        return StreamSupport.stream(baseConstructors.spliterator(), false).filter(constructor -> {
            boolean canVectorize = QueryRunnerTestHelper.isTestRunnerVectorizable((QueryRunner)constructor[0]) && (Boolean)constructor[1] == false;
            boolean vectorize = (Boolean)constructor[2];
            return !vectorize || canVectorize;
        }).collect(Collectors.toList());
    }

    protected <T> void assertExpectedResults(Iterable<Result<T>> expectedResults, Iterable<Result<T>> results) {
        if (this.descending) {
            expectedResults = TestHelper.revert(expectedResults);
        }
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    public TimeseriesQueryRunnerTest(QueryRunner<Result<TimeseriesResultValue>> runner, boolean descending, boolean vectorize, List<AggregatorFactory> aggregatorFactoryList) {
        this.runner = runner;
        this.descending = descending;
        this.vectorize = vectorize;
        this.aggregatorFactoryList = aggregatorFactoryList;
    }

    @Test
    public void testEmptyTimeseries() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.EMPTY_INTERVAL).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_DOUBLE_SUM, new DoubleFirstAggregatorFactory("first", "index", null))).descending(this.descending).context(this.makeContext()).build();
        HashMap<String, Number> resultMap = new HashMap<String, Number>();
        resultMap.put("rows", 0L);
        resultMap.put("index", NullHandling.defaultDoubleValue());
        resultMap.put("first", NullHandling.defaultDoubleValue());
        ImmutableList expectedResults = ImmutableList.of((Object)new Result(DateTimes.of((String)"2020-04-02"), (Object)new TimeseriesResultValue(resultMap)));
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testFullOnTimeseries() {
        Granularity gran = Granularities.DAY;
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(gran).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_DOUBLE_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        StubServiceEmitter stubServiceEmitter = new StubServiceEmitter("", "");
        MetricsEmittingQueryRunner metricsEmittingQueryRunner = new MetricsEmittingQueryRunner((ServiceEmitter)stubServiceEmitter, (QueryToolChest)new TimeseriesQueryQueryToolChest(), this.runner, (obj, lng) -> {}, metrics -> {}).withWaitMeasuredFromNow();
        List results = metricsEmittingQueryRunner.run(QueryPlus.wrap((Query)query)).toList();
        String[] expectedIndex = this.descending ? QueryRunnerTestHelper.EXPECTED_FULL_ON_INDEX_VALUES_DESC : QueryRunnerTestHelper.EXPECTED_FULL_ON_INDEX_VALUES;
        DateTime expectedLast = this.descending ? QueryRunnerTestHelper.EARLIEST : QueryRunnerTestHelper.LAST;
        int count = 0;
        Result lastResult = null;
        for (Result result : results) {
            DateTime current = result.getTimestamp();
            Assert.assertFalse((String)StringUtils.format((String)"Timestamp[%s] > expectedLast[%s]", (Object[])new Object[]{current, expectedLast}), (boolean)(this.descending ? current.isBefore((ReadableInstant)expectedLast) : current.isAfter((ReadableInstant)expectedLast)));
            TimeseriesResultValue value = (TimeseriesResultValue)result.getValue();
            Assert.assertEquals((String)result.toString(), (long)(QueryRunnerTestHelper.SKIPPED_DAY.equals((Object)current) ? 0L : 13L), (long)value.getLongMetric("rows"));
            if (!QueryRunnerTestHelper.SKIPPED_DAY.equals((Object)current)) {
                Assert.assertEquals((String)result.toString(), (double)Doubles.tryParse((String)expectedIndex[count]), (double)value.getDoubleMetric("index"), (double)(value.getDoubleMetric("index") * 1.0E-6));
                Assert.assertEquals((String)result.toString(), (double)(new Double(expectedIndex[count]) + 13.0 + 1.0), (double)value.getDoubleMetric("addRowsIndexConstant"), (double)(value.getDoubleMetric("addRowsIndexConstant") * 1.0E-6));
                Assert.assertEquals((double)value.getDoubleMetric("uniques"), (double)9.0, (double)0.02);
            } else if (NullHandling.replaceWithDefault()) {
                Assert.assertEquals((String)result.toString(), (double)0.0, (double)value.getDoubleMetric("index"), (double)(value.getDoubleMetric("index") * 1.0E-6));
                Assert.assertEquals((String)result.toString(), (double)(new Double(expectedIndex[count]) + 1.0), (double)value.getDoubleMetric("addRowsIndexConstant"), (double)(value.getDoubleMetric("addRowsIndexConstant") * 1.0E-6));
                Assert.assertEquals((double)0.0, (double)value.getDoubleMetric("uniques"), (double)0.02);
            } else {
                Assert.assertNull((String)result.toString(), (Object)value.getDoubleMetric("index"));
                Assert.assertNull((String)result.toString(), (Object)value.getDoubleMetric("addRowsIndexConstant"));
                Assert.assertEquals((double)value.getDoubleMetric("uniques"), (double)0.0, (double)0.02);
            }
            lastResult = result;
            ++count;
        }
        stubServiceEmitter.verifyEmitted("query/wait/time", (Map)ImmutableMap.of((Object)"vectorized", (Object)this.vectorize), 1);
        Assert.assertEquals((String)lastResult.toString(), (Object)expectedLast, (Object)lastResult.getTimestamp());
    }

    @Test
    public void testTimeseriesNoAggregators() {
        Granularity gran = Granularities.DAY;
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(gran).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).descending(this.descending).context(this.makeContext()).build();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        DateTime expectedLast = this.descending ? QueryRunnerTestHelper.EARLIEST : QueryRunnerTestHelper.LAST;
        Result lastResult = null;
        for (Result result : results) {
            DateTime current = result.getTimestamp();
            Assert.assertFalse((String)StringUtils.format((String)"Timestamp[%s] > expectedLast[%s]", (Object[])new Object[]{current, expectedLast}), (boolean)(this.descending ? current.isBefore((ReadableInstant)expectedLast) : current.isAfter((ReadableInstant)expectedLast)));
            Assert.assertEquals((Object)ImmutableMap.of(), (Object)((TimeseriesResultValue)result.getValue()).getBaseObject());
            lastResult = result;
        }
        Assert.assertEquals((String)lastResult.toString(), (Object)expectedLast, (Object)lastResult.getTimestamp());
    }

    @Test
    public void testFullOnTimeseriesMaxMin() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(Granularities.ALL).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(Arrays.asList(new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index"))).descending(this.descending).context(this.makeContext()).build();
        DateTime expectedEarliest = DateTimes.of((String)"2011-01-12");
        DateTime expectedLast = DateTimes.of((String)"2011-04-15");
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        Result result = (Result)results.iterator().next();
        Assert.assertEquals((Object)expectedEarliest, (Object)result.getTimestamp());
        Assert.assertFalse((String)StringUtils.format((String)"Timestamp[%s] > expectedLast[%s]", (Object[])new Object[]{result.getTimestamp(), expectedLast}), (boolean)result.getTimestamp().isAfter((ReadableInstant)expectedLast));
        TimeseriesResultValue value = (TimeseriesResultValue)result.getValue();
        Assert.assertEquals((String)result.toString(), (double)1870.061029, (double)value.getDoubleMetric("maxIndex"), (double)0.0018700610289999998);
        Assert.assertEquals((String)result.toString(), (double)59.021022, (double)value.getDoubleMetric("minIndex"), (double)5.9021021999999996E-5);
    }

    @Test
    public void testFullOnTimeseriesMinMaxAggregators() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(Granularities.ALL).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.INDEX_LONG_MIN, QueryRunnerTestHelper.INDEX_LONG_MAX, QueryRunnerTestHelper.INDEX_DOUBLE_MIN, QueryRunnerTestHelper.INDEX_DOUBLE_MAX, QueryRunnerTestHelper.INDEX_FLOAT_MIN, QueryRunnerTestHelper.INDEX_FLOAT_MAX}).descending(this.descending).context(this.makeContext()).build();
        DateTime expectedEarliest = DateTimes.of((String)"2011-01-12");
        DateTime expectedLast = DateTimes.of((String)"2011-04-15");
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        Result result = (Result)results.iterator().next();
        Assert.assertEquals((Object)expectedEarliest, (Object)result.getTimestamp());
        Assert.assertFalse((String)StringUtils.format((String)"Timestamp[%s] > expectedLast[%s]", (Object[])new Object[]{result.getTimestamp(), expectedLast}), (boolean)result.getTimestamp().isAfter((ReadableInstant)expectedLast));
        Assert.assertEquals((long)59L, (long)((TimeseriesResultValue)result.getValue()).getLongMetric("longMinIndex"));
        Assert.assertEquals((long)1870L, (long)((TimeseriesResultValue)result.getValue()).getLongMetric("longMaxIndex"));
        Assert.assertEquals((double)59.021022, (double)((TimeseriesResultValue)result.getValue()).getDoubleMetric("doubleMinIndex"), (double)0.0);
        Assert.assertEquals((double)1870.061029, (double)((TimeseriesResultValue)result.getValue()).getDoubleMetric("doubleMaxIndex"), (double)0.0);
        Assert.assertEquals((float)59.021023f, (float)((TimeseriesResultValue)result.getValue()).getFloatMetric("floatMinIndex").floatValue(), (float)0.0f);
        Assert.assertEquals((float)1870.061f, (float)((TimeseriesResultValue)result.getValue()).getFloatMetric("floatMaxIndex").floatValue(), (float)0.0f);
    }

    @Test
    public void testFullOnTimeseriesWithFilter() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("market", "upfront").intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.QUALITY_UNIQUES)).descending(this.descending).context(this.makeContext()).build();
        Assert.assertEquals((Object)new SelectorDimFilter("market", "upfront", null), (Object)query.getDimensionsFilter());
        DateTime expectedLast = this.descending ? QueryRunnerTestHelper.EARLIEST : QueryRunnerTestHelper.LAST;
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        for (Result result : results) {
            DateTime current = result.getTimestamp();
            Assert.assertFalse((String)StringUtils.format((String)"Timestamp[%s] > expectedLast[%s]", (Object[])new Object[]{current, expectedLast}), (boolean)(this.descending ? current.isBefore((ReadableInstant)expectedLast) : current.isAfter((ReadableInstant)expectedLast)));
            TimeseriesResultValue value = (TimeseriesResultValue)result.getValue();
            Assert.assertEquals((String)result.toString(), (long)(QueryRunnerTestHelper.SKIPPED_DAY.equals((Object)result.getTimestamp()) ? 0L : 2L), (long)value.getLongMetric("rows"));
            Assert.assertEquals((String)result.toString(), (double)(QueryRunnerTestHelper.SKIPPED_DAY.equals((Object)result.getTimestamp()) ? 0.0 : 2.0), (double)value.getDoubleMetric("uniques"), (double)0.01);
        }
    }

    @Test
    public void testTimeseries() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.QUALITY_UNIQUES, QueryRunnerTestHelper.INDEX_LONG_MIN, QueryRunnerTestHelper.INDEX_FLOAT_MAX)).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)6619L, (Object)"uniques", (Object)9.019833517963864, (Object)"longMinIndex", (Object)78L, (Object)"floatMaxIndex", (Object)1522.043701171875))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864, (Object)"longMinIndex", (Object)97L, (Object)"floatMaxIndex", (Object)Float.valueOf(1321.375f)))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesGrandTotal() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES, QueryRunnerTestHelper.INDEX_LONG_MIN, QueryRunnerTestHelper.INDEX_DOUBLE_MAX, QueryRunnerTestHelper.INDEX_FLOAT_MIN)).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context((Map)ImmutableMap.of((Object)"grandTotal", (Object)true)).build();
        ArrayList expectedResults = new ArrayList();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        expectedResults.add(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)builder.put((Object)"rows", (Object)13L).put((Object)"index", (Object)6619L).put((Object)"uniques", (Object)9.019833517963864).put((Object)"addRowsIndexConstant", (Object)6633.0).put((Object)"longMinIndex", (Object)78L).put((Object)"doubleMaxIndex", (Object)1522.043733).put((Object)"floatMinIndex", (Object)Float.valueOf(78.62254f)).build())));
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        expectedResults.add(new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)builder2.put((Object)"rows", (Object)13L).put((Object)"index", (Object)5827L).put((Object)"uniques", (Object)9.019833517963864).put((Object)"addRowsIndexConstant", (Object)5841.0).put((Object)"longMinIndex", (Object)97L).put((Object)"doubleMaxIndex", (Object)1321.375057).put((Object)"floatMinIndex", (Object)Float.valueOf(97.387436f)).build())));
        if (this.descending) {
            Collections.reverse(expectedResults);
        }
        ImmutableMap.Builder builder3 = ImmutableMap.builder();
        expectedResults.add(new Result(null, (Object)new TimeseriesResultValue((Map)builder3.put((Object)"rows", (Object)26L).put((Object)"index", (Object)12446L).put((Object)"uniques", (Object)9.019833517963864).put((Object)"addRowsIndexConstant", (Object)12473.0).put((Object)"longMinIndex", (Object)78L).put((Object)"doubleMaxIndex", (Object)1522.043733).put((Object)"floatMinIndex", (Object)Float.valueOf(78.62254f)).build())));
        TimeseriesQueryQueryToolChest toolChest = new TimeseriesQueryQueryToolChest();
        FinalizeResultsQueryRunner finalRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(this.runner), (QueryToolChest)toolChest);
        List results = finalRunner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesIntervalOutOfRanges() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.EMPTY_INTERVAL).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.INDEX_LONG_MIN, QueryRunnerTestHelper.INDEX_LONG_MAX, QueryRunnerTestHelper.INDEX_DOUBLE_MIN, QueryRunnerTestHelper.INDEX_DOUBLE_MAX, QueryRunnerTestHelper.INDEX_FLOAT_MIN, QueryRunnerTestHelper.INDEX_FLOAT_MAX)).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context((Map)ImmutableMap.of((Object)"skipEmptyBuckets", (Object)false)).build();
        ArrayList expectedResults = new ArrayList();
        expectedResults.add(new Result(((Interval)QueryRunnerTestHelper.EMPTY_INTERVAL.getIntervals().get(0)).getStart(), (Object)new TimeseriesResultValue(TestHelper.makeMap("rows", 0L, "index", NullHandling.defaultLongValue(), "addRowsIndexConstant", NullHandling.sqlCompatible() ? null : Double.valueOf(1.0), "longMinIndex", NullHandling.sqlCompatible() ? null : Long.valueOf(Long.MAX_VALUE), "longMaxIndex", NullHandling.sqlCompatible() ? null : Long.valueOf(Long.MIN_VALUE), "doubleMinIndex", NullHandling.sqlCompatible() ? null : Double.valueOf(Double.POSITIVE_INFINITY), "doubleMaxIndex", NullHandling.sqlCompatible() ? null : Double.valueOf(Double.NEGATIVE_INFINITY), "floatMinIndex", NullHandling.sqlCompatible() ? null : Float.valueOf(Float.POSITIVE_INFINITY), "floatMaxIndex", NullHandling.sqlCompatible() ? null : Float.valueOf(Float.NEGATIVE_INFINITY)))));
        TimeseriesQueryQueryToolChest toolChest = new TimeseriesQueryQueryToolChest();
        FinalizeResultsQueryRunner finalRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(this.runner), (QueryToolChest)toolChest);
        List results = finalRunner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithVirtualColumn() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "expr"), QueryRunnerTestHelper.QUALITY_UNIQUES)).descending(this.descending).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("expr", "index", ColumnType.FLOAT, TestExprMacroTable.INSTANCE)}).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)6619L, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithTimeZone() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").intervals("2011-03-31T00:00:00-07:00/2011-04-02T00:00:00-07:00").aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"))).granularity((Granularity)new PeriodGranularity(new Period((Object)"P1D"), null, DateTimes.inferTzFromString((String)"America/Los_Angeles"))).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(new DateTime((Object)"2011-03-31", DateTimes.inferTzFromString((String)"America/Los_Angeles")), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)6619L))), new Result(new DateTime((Object)"2011-04-01T", DateTimes.inferTzFromString((String)"America/Los_Angeles")), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithVaryingGran() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).intervals(Collections.singletonList(Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z"))).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.QUALITY_UNIQUES)).descending(this.descending).context(this.makeContext()).build();
        List expectedResults1 = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results1 = this.runner.run(QueryPlus.wrap((Query)query1)).toList();
        this.assertExpectedResults(expectedResults1, results1);
        TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity("DAY").intervals(Collections.singletonList(Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z"))).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.QUALITY_UNIQUES)).context(this.makeContext()).build();
        List expectedResults2 = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results2 = this.runner.run(QueryPlus.wrap((Query)query2)).toList();
        this.assertExpectedResults(expectedResults2, results2);
    }

    @Test
    public void testTimeseriesGranularityNotAlignedOnSegmentBoundariesWithFilter() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").filters("market", "spot", new String[]{"upfront", "total_market"}).granularity((Granularity)new PeriodGranularity(new Period((Object)"P7D"), null, DateTimes.inferTzFromString((String)"America/Los_Angeles"))).intervals(Collections.singletonList(Intervals.of((String)"2011-01-12T00:00:00.000-08:00/2011-01-20T00:00:00.000-08:00"))).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"))).descending(this.descending).context(this.makeContext()).build();
        List expectedResults1 = Arrays.asList(new Result(new DateTime((Object)"2011-01-06T00:00:00.000-08:00", DateTimes.inferTzFromString((String)"America/Los_Angeles")), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)6071L))), new Result(new DateTime((Object)"2011-01-13T00:00:00.000-08:00", DateTimes.inferTzFromString((String)"America/Los_Angeles")), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)91L, (Object)"idx", (Object)33382L))));
        List results1 = this.runner.run(QueryPlus.wrap((Query)query1)).toList();
        this.assertExpectedResults(expectedResults1, results1);
    }

    @Test
    public void testTimeseriesQueryZeroFilling() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").filters("market", "spot", new String[]{"upfront", "total_market"}).granularity(Granularities.HOUR).intervals(Collections.singletonList(Intervals.of((String)"2011-04-14T00:00:00.000Z/2011-05-01T00:00:00.000Z"))).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"))).descending(this.descending).context(this.makeContext()).build();
        ArrayList<Result> lotsOfZeroes = new ArrayList<Result>();
        Iterable iterable = Granularities.HOUR.getIterable(new Interval((ReadableInstant)DateTimes.of((String)"2011-04-14T01"), (ReadableInstant)DateTimes.of((String)"2011-04-15")));
        HashMap<String, Long> noRowsResult = new HashMap<String, Long>();
        noRowsResult.put("rows", 0L);
        noRowsResult.put("idx", NullHandling.defaultLongValue());
        for (Interval interval : iterable) {
            lotsOfZeroes.add(new Result(interval.getStart(), (Object)new TimeseriesResultValue(noRowsResult)));
        }
        ArrayList expectedResults1 = Lists.newArrayList((Iterable)Iterables.concat(Collections.singletonList(new Result(DateTimes.of((String)"2011-04-14T00"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)4907L)))), lotsOfZeroes, Collections.singletonList(new Result(DateTimes.of((String)"2011-04-15T00"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)4717L))))));
        List results1 = this.runner.run(QueryPlus.wrap((Query)query1)).toList();
        this.assertExpectedResults(expectedResults1, results1);
    }

    @Test
    public void testTimeseriesQueryGranularityNotAlignedWithRollupGranularity() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").filters("market", "spot", new String[]{"upfront", "total_market"}).granularity((Granularity)new PeriodGranularity(new Period((Object)"PT1H"), DateTimes.utc((long)60000L), DateTimeZone.UTC)).intervals(Collections.singletonList(Intervals.of((String)"2011-04-15T00:00:00.000Z/2012"))).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"))).descending(this.descending).context(this.makeContext()).build();
        List expectedResults1 = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-14T23:01Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)4717L))));
        List results1 = this.runner.run(QueryPlus.wrap((Query)query1)).toList();
        this.assertExpectedResults(expectedResults1, results1);
    }

    @Test
    public void testTimeseriesWithVaryingGranWithFilter() {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").filters("market", "spot", new String[]{"upfront", "total_market"}).granularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).intervals(Collections.singletonList(Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z"))).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.QUALITY_UNIQUES)).descending(this.descending).context(this.makeContext()).build();
        List expectedResults1 = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results1 = this.runner.run(QueryPlus.wrap((Query)query1)).toList();
        this.assertExpectedResults(expectedResults1, results1);
        TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("testing").filters("market", "spot", new String[]{"upfront", "total_market"}).granularity("DAY").intervals(Collections.singletonList(Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z"))).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.QUALITY_UNIQUES)).context(this.makeContext()).build();
        List expectedResults2 = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864))));
        List results2 = this.runner.run(QueryPlus.wrap((Query)query2)).toList();
        this.assertExpectedResults(expectedResults2, results2);
    }

    @Test
    public void testTimeseriesQueryBeyondTimeRangeOfData() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2015-01-01/2015-01-10")))).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"))).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Collections.emptyList();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithOrFilter() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("market", "spot", new String[]{"upfront", "total_market"}).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)6619L, (Object)"addRowsIndexConstant", (Object)6633.0, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)5827L, (Object)"addRowsIndexConstant", (Object)5841.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithRegexFilter() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)new RegexDimFilter("market", "^.p.*$", null)).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)11L, (Object)"index", (Object)3783L, (Object)"addRowsIndexConstant", (Object)3795.0, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)11L, (Object)"index", (Object)3313L, (Object)"addRowsIndexConstant", (Object)3325.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithFilter1() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("market", "spot").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES, QueryRunnerTestHelper.INDEX_LONG_MIN}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)9L, (Object)"index", (Object)1102L, (Object)"addRowsIndexConstant", (Object)1112.0, (Object)"uniques", (Object)9.019833517963864, (Object)"longMinIndex", (Object)78L))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)9L, (Object)"index", (Object)1120L, (Object)"addRowsIndexConstant", (Object)1130.0, (Object)"uniques", (Object)9.019833517963864, (Object)"longMinIndex", (Object)97L))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithFilter2() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("market", "upfront").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)2681L, (Object)"addRowsIndexConstant", (Object)2684.0, (Object)"uniques", (Object)2.000977198748901))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)2193L, (Object)"addRowsIndexConstant", (Object)2196.0, (Object)"uniques", (Object)2.000977198748901))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithFilter3() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("market", "total_market").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)2836L, (Object)"addRowsIndexConstant", (Object)2839.0, (Object)"uniques", (Object)2.000977198748901))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)2514L, (Object)"addRowsIndexConstant", (Object)2517.0, (Object)"uniques", (Object)2.000977198748901))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithMultiDimFilterAndOr() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new OrDimFilter("quality", "automotive", new String[]{"business"})});
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)254.4554443359375, (Object)"addRowsIndexConstant", (Object)257.4554443359375, (Object)"uniques", (Object)2.000977198748901))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)260.4129638671875, (Object)"addRowsIndexConstant", (Object)263.4129638671875, (Object)"uniques", (Object)2.000977198748901))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithMultiDimFilter() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("quality", "automotive", null)});
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)new Float(135.885094).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(137.885094).doubleValue(), (Object)"uniques", (Object)1.0002442201269182))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)new Float(147.425935).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(149.425935).doubleValue(), (Object)"uniques", (Object)1.0002442201269182))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithOtherMultiDimFilter() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("quality", "business", null)});
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)new Float(118.57034).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(120.57034).doubleValue(), (Object)"uniques", (Object)1.0002442201269182))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)new Float(112.987027).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(114.987027).doubleValue(), (Object)"uniques", (Object)1.0002442201269182))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithNonExistentFilterInOr() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("market", "spot", new String[]{"upfront", "total_market", "billyblank"}).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)6619L, (Object)"addRowsIndexConstant", (Object)6633.0, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)5827L, (Object)"addRowsIndexConstant", (Object)5841.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithInFilter() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)new InDimFilter("market", Arrays.asList("spot", "upfront", "total_market", "billyblank"), null)).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)6619L, (Object)"addRowsIndexConstant", (Object)6633.0, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)5827L, (Object)"addRowsIndexConstant", (Object)5841.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithNonExistentFilterAndMultiDimAndOr() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new OrDimFilter("quality", "automotive", new String[]{"business", "billyblank"})});
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)254.4554443359375, (Object)"addRowsIndexConstant", (Object)257.4554443359375, (Object)"uniques", (Object)2.000977198748901))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)260.4129638671875, (Object)"addRowsIndexConstant", (Object)263.4129638671875, (Object)"uniques", (Object)2.000977198748901))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithFilterOnNonExistentDimension() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("bobby", "billy").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        HashMap<String, Number> resultMap = new HashMap<String, Number>();
        resultMap.put("rows", 0L);
        resultMap.put("index", NullHandling.defaultDoubleValue());
        resultMap.put("addRowsIndexConstant", NullHandling.replaceWithDefault() ? Double.valueOf(1.0) : null);
        resultMap.put("uniques", 0.0);
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue(resultMap)), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue(resultMap)));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithFilterOnNonExistentDimensionSkipBuckets() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("bobby", "billy").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext((Map<String, Object>)ImmutableMap.of((Object)"skipEmptyBuckets", (Object)"true"))).build();
        List expectedResults = Collections.emptyList();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithNullFilterOnNonExistentDimension() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("bobby", null).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)6626.151596069336, (Object)"addRowsIndexConstant", (Object)6640.151596069336, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)5833.2095947265625, (Object)"addRowsIndexConstant", (Object)5847.2095947265625, (Object)"uniques", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithInvertedFilterOnNonExistentDimension() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("bobby", "sally", null))).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List<Object> expectedResults = NullHandling.sqlCompatible() ? Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue(TestHelper.makeMap("rows", 0L, "index", null, "uniques", 0.0, "addRowsIndexConstant", null))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue(TestHelper.makeMap("rows", 0L, "index", null, "uniques", 0.0, "addRowsIndexConstant", null)))) : Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)6626.151596069336, (Object)"addRowsIndexConstant", (Object)6640.151596069336, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"index", (Object)5833.2095947265625, (Object)"addRowsIndexConstant", (Object)5847.2095947265625, (Object)"uniques", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithNonExistentFilter() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("market", "billy").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        HashMap<String, Number> resultMap = new HashMap<String, Number>();
        resultMap.put("rows", 0L);
        resultMap.put("index", NullHandling.defaultDoubleValue());
        resultMap.put("addRowsIndexConstant", NullHandling.replaceWithDefault() ? Double.valueOf(1.0) : null);
        resultMap.put("uniques", 0.0);
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue(resultMap)), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue(resultMap)));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithNonExistentFilterAndMultiDim() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "billy", null), new SelectorDimFilter("quality", "business", null)});
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        HashMap<String, Number> resultMap = new HashMap<String, Number>();
        resultMap.put("rows", 0L);
        resultMap.put("index", NullHandling.defaultDoubleValue());
        resultMap.put("addRowsIndexConstant", NullHandling.replaceWithDefault() ? Double.valueOf(1.0) : null);
        resultMap.put("uniques", 0.0);
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue(resultMap)), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue(resultMap)));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithMultiValueFilteringJavascriptAggregator() {
        this.cannotVectorize();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators((List)ImmutableList.of((Object)QueryRunnerTestHelper.INDEX_DOUBLE_SUM, (Object)QueryRunnerTestHelper.JS_INDEX_SUM_IF_PLACEMENTISH_A, (Object)QueryRunnerTestHelper.JS_PLACEMENTISH_COUNT)).descending(this.descending).context(this.makeContext()).build();
        ImmutableList expectedResults = ImmutableList.of((Object)new Result(((Interval)QueryRunnerTestHelper.FIRST_TO_THIRD.getIntervals().get(0)).getStart(), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"index", (Object)12459.361190795898, (Object)"nindex", (Object)283.31103515625, (Object)"pishcount", (Object)52.0))));
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults((Iterable)expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithMultiValueFilteringJavascriptAggregatorAndAlsoRegularFilters() {
        this.cannotVectorize();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters("placementish", "a").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators((List)ImmutableList.of((Object)QueryRunnerTestHelper.INDEX_DOUBLE_SUM, (Object)QueryRunnerTestHelper.JS_INDEX_SUM_IF_PLACEMENTISH_A, (Object)QueryRunnerTestHelper.JS_PLACEMENTISH_COUNT)).descending(this.descending).context(this.makeContext()).build();
        ImmutableList expectedResults = ImmutableList.of((Object)new Result(((Interval)QueryRunnerTestHelper.FIRST_TO_THIRD.getIntervals().get(0)).getStart(), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"index", (Object)283.31103515625, (Object)"nindex", (Object)283.31103515625, (Object)"pishcount", (Object)4.0))));
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults((Iterable)expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithFirstLastAggregator() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.MONTH_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)ImmutableList.of((Object)new DoubleFirstAggregatorFactory("first", "index", null), (Object)new DoubleLastAggregatorFactory("last", "index", null))).descending(this.descending).context(this.makeContext()).build();
        ImmutableList expectedAscendingResults = ImmutableList.of((Object)new Result(DateTimes.of((String)"2011-01-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(100.0).doubleValue(), (Object)"last", (Object)new Float(943.497198).doubleValue()))), (Object)new Result(DateTimes.of((String)"2011-02-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(132.123776).doubleValue(), (Object)"last", (Object)new Float(1101.91827).doubleValue()))), (Object)new Result(DateTimes.of((String)"2011-03-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(153.059937).doubleValue(), (Object)"last", (Object)new Float(1063.201156).doubleValue()))), (Object)new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(135.885094).doubleValue(), (Object)"last", (Object)new Float(780.271977).doubleValue()))));
        ImmutableList expectedDescendingResults = ImmutableList.of((Object)new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(1234.247546).doubleValue(), (Object)"last", (Object)new Float(106.7937).doubleValue()))), (Object)new Result(DateTimes.of((String)"2011-03-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(1004.940887).doubleValue(), (Object)"last", (Object)new Float(151.752485).doubleValue()))), (Object)new Result(DateTimes.of((String)"2011-02-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(913.561076).doubleValue(), (Object)"last", (Object)new Float(122.258195).doubleValue()))), (Object)new Result(DateTimes.of((String)"2011-01-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"first", (Object)new Float(800.0).doubleValue(), (Object)"last", (Object)new Float(133.740047).doubleValue()))));
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        if (this.descending) {
            TestHelper.assertExpectedResults(expectedDescendingResults, actualResults);
        } else {
            TestHelper.assertExpectedResults(expectedAscendingResults, actualResults);
        }
    }

    @Test
    public void testTimeseriesWithMultiValueDimFilter1() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("placementish", "preferred").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = this.runner.run(QueryPlus.wrap((Query)query1)).toList();
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithMultiValueDimFilter2() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("placementish", "a").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("quality", "automotive").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = this.runner.run(QueryPlus.wrap((Query)query1)).toList();
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithMultiValueDimFilterAndOr1() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("placementish", "a", null)});
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        AndDimFilter andDimFilter2 = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("quality", "automotive", null)});
        TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)andDimFilter2).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = this.runner.run(QueryPlus.wrap((Query)query2)).toList();
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithMultiValueDimFilterAndOr2() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new OrDimFilter("placementish", "a", new String[]{"b"})});
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)andDimFilter).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        AndDimFilter andDimFilter2 = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "spot", null), new OrDimFilter("quality", "automotive", new String[]{"business"})});
        TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)andDimFilter2).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = this.runner.run(QueryPlus.wrap((Query)query2)).toList();
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeSeriesWithFilteredAgg() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.aggregatorFactoryList, (Iterable)ImmutableList.of((Object)new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("filteredAgg"), (DimFilter)new SelectorDimFilter("market", "spot", null)))))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"filteredAgg", (Object)18L).put((Object)"addRowsIndexConstant", (Object)12486.361190795898).put((Object)"index", (Object)12459.361190795898).put((Object)"uniques", (Object)9.019833517963864).put((Object)"rows", (Object)26L).build())));
        this.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeSeriesWithFilteredAggAndExpressionFilteredAgg() {
        this.cannotVectorizeUnlessFallback();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.aggregatorFactoryList, (Iterable)ImmutableList.of((Object)new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("filteredAgg"), (DimFilter)new SelectorDimFilter("market", "spot", null)), (Object)new LongSumAggregatorFactory("altLongCount", null, "if (market == 'spot', 1, 0)", TestExprMacroTable.INSTANCE), (Object)new DoubleSumAggregatorFactory("altDoubleCount", null, "if (market == 'spot', 1, 0)", TestExprMacroTable.INSTANCE), (Object)new FloatSumAggregatorFactory("altFloatCount", null, "if (market == 'spot', 1, 0)", TestExprMacroTable.INSTANCE))))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"filteredAgg", (Object)18L).put((Object)"addRowsIndexConstant", (Object)12486.361190795898).put((Object)"index", (Object)12459.361190795898).put((Object)"uniques", (Object)9.019833517963864).put((Object)"rows", (Object)26L).put((Object)"altLongCount", (Object)18L).put((Object)"altDoubleCount", (Object)18.0).put((Object)"altFloatCount", (Object)Float.valueOf(18.0f)).build())));
        this.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeSeriesWithFilteredAggDimensionNotPresentNotNullValue() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.aggregatorFactoryList, Collections.singletonList(new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("filteredAgg"), (DimFilter)new SelectorDimFilter("abraKaDabra", "Lol", null)))))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"filteredAgg", (Object)0L, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"index", (Object)12459.361190795898, (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)26L))));
        this.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeSeriesWithFilteredAggDimensionNotPresentNullValue() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.aggregatorFactoryList, Collections.singletonList(new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("filteredAgg"), (DimFilter)new SelectorDimFilter("abraKaDabra", null, null)))))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"filteredAgg", (Object)26L, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"index", (Object)12459.361190795898, (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)26L))));
        this.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeSeriesWithFilteredAggValueNotPresent() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.aggregatorFactoryList, Collections.singletonList(new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("filteredAgg"), (DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("market", "LolLol", null))))))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"filteredAgg", (Object)26L, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"index", (Object)12459.361190795898, (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)26L))));
        this.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeSeriesWithFilteredAggInvertedNullValue() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.aggregatorFactoryList, Collections.singletonList(new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("filteredAgg"), (DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("market", null, null))))))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"filteredAgg", (Object)26L, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"index", (Object)12459.361190795898, (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)26L))));
        this.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithTimeColumn() {
        this.cannotVectorize();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.JS_COUNT_IF_TIME_GREATER_THAN, QueryRunnerTestHelper.TIME_LONG_SUM}).granularity(QueryRunnerTestHelper.ALL_GRAN).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)26L, (Object)"ntimestamps", (Object)13.0, (Object)"sumtime", (Object)33843139200000L))));
        List actualResults = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, actualResults);
    }

    @Test
    public void testTimeseriesWithBoundFilter1() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)new AndDimFilter(Arrays.asList(new BoundDimFilter("market", "spa", "spot", Boolean.valueOf(true), null, null, null, StringComparators.LEXICOGRAPHIC), new BoundDimFilter("market", "spot", "spotify", null, Boolean.valueOf(true), null, null, StringComparators.LEXICOGRAPHIC), new BoundDimFilter("market", "SPOT", "spot", null, null, null, null, StringComparators.LEXICOGRAPHIC)))).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)9L, (Object)"index", (Object)1102L, (Object)"addRowsIndexConstant", (Object)1112.0, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)9L, (Object)"index", (Object)1120L, (Object)"addRowsIndexConstant", (Object)1130.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithTimestampResultFieldContextForArrayResponse() {
        Granularity gran = Granularities.DAY;
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(gran).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_DOUBLE_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext((Map<String, Object>)ImmutableMap.of((Object)"timestampResultField", (Object)TIMESTAMP_RESULT_FIELD_NAME, (Object)"skipEmptyBuckets", (Object)true))).build();
        Assert.assertEquals((Object)TIMESTAMP_RESULT_FIELD_NAME, (Object)query.getTimestampResultField());
        TimeseriesQueryQueryToolChest toolChest = new TimeseriesQueryQueryToolChest();
        RowSignature rowSignature = toolChest.resultArraySignature((Query)query);
        Assert.assertNotNull((Object)rowSignature);
        List columnNames = rowSignature.getColumnNames();
        Assert.assertNotNull((Object)columnNames);
        Assert.assertEquals((long)6L, (long)columnNames.size());
        Assert.assertEquals((Object)"__time", columnNames.get(0));
        Assert.assertEquals((Object)TIMESTAMP_RESULT_FIELD_NAME, columnNames.get(1));
        Assert.assertEquals((Object)"rows", columnNames.get(2));
        Assert.assertEquals((Object)"index", columnNames.get(3));
        Assert.assertEquals((Object)"uniques", columnNames.get(4));
        Assert.assertEquals((Object)"addRowsIndexConstant", columnNames.get(5));
        Sequence results = this.runner.run(QueryPlus.wrap((Query)query));
        Sequence resultsAsArrays = toolChest.resultsAsArrays((Query)query, results);
        Assert.assertNotNull((Object)resultsAsArrays);
        String[] expectedIndex = this.descending ? QueryRunnerTestHelper.EXPECTED_FULL_ON_INDEX_VALUES_DESC : QueryRunnerTestHelper.EXPECTED_FULL_ON_INDEX_VALUES;
        String[] expectedIndexToUse = (String[])Arrays.stream(expectedIndex).filter(eachIndex -> !"0.0".equals(eachIndex)).toArray(String[]::new);
        Long expectedLast = this.descending ? QueryRunnerTestHelper.EARLIEST.getMillis() : QueryRunnerTestHelper.LAST.getMillis();
        int count = 0;
        Object[] lastResult = null;
        for (Object[] result : resultsAsArrays.toList()) {
            Long current = (Long)result[0];
            Assert.assertFalse((String)StringUtils.format((String)"Timestamp[%s] > expectedLast[%s]", (Object[])new Object[]{current, expectedLast}), (boolean)(this.descending ? current < expectedLast : current > expectedLast));
            Assert.assertEquals((float)((Long)result[1]).longValue(), (float)current.longValue(), (float)0.0f);
            Assert.assertEquals((Object)(QueryRunnerTestHelper.SKIPPED_DAY.getMillis() == current.longValue() ? Long.valueOf(0L) : Long.valueOf(13L)), (Object)result[2]);
            if (QueryRunnerTestHelper.SKIPPED_DAY.getMillis() != current.longValue()) {
                Assert.assertEquals((double)Doubles.tryParse((String)expectedIndexToUse[count]), (double)((Double)result[3]), (double)((Double)result[3] * 1.0E-6));
                Assert.assertEquals((double)((Double)result[4]), (double)9.0, (double)0.02);
                Assert.assertEquals((double)(new Double(expectedIndexToUse[count]) + 13.0 + 1.0), (double)((Double)result[5]), (double)((Double)result[5] * 1.0E-6));
            } else if (NullHandling.replaceWithDefault()) {
                Assert.assertEquals((double)0.0, (double)((Double)result[3]), (double)((Double)result[3] * 1.0E-6));
                Assert.assertEquals((double)0.0, (double)((Double)result[4]), (double)0.02);
                Assert.assertEquals((double)(new Double(expectedIndexToUse[count]) + 1.0), (double)((Double)result[5]), (double)((Double)result[5] * 1.0E-6));
            } else {
                Assert.assertNull((Object)result[3]);
                Assert.assertEquals((double)((Double)result[4]), (double)0.0, (double)0.02);
                Assert.assertNull((Object)result[5]);
            }
            lastResult = result;
            ++count;
        }
        Assert.assertEquals((Object)expectedLast, (Object)lastResult[0]);
    }

    @Test
    public void testTimeseriesWithTimestampResultFieldContextForMapResponse() {
        Granularity gran = Granularities.DAY;
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(gran).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_DOUBLE_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext((Map<String, Object>)ImmutableMap.of((Object)"timestampResultField", (Object)TIMESTAMP_RESULT_FIELD_NAME, (Object)"skipEmptyBuckets", (Object)true))).build();
        Assert.assertEquals((Object)TIMESTAMP_RESULT_FIELD_NAME, (Object)query.getTimestampResultField());
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        String[] expectedIndex = this.descending ? QueryRunnerTestHelper.EXPECTED_FULL_ON_INDEX_VALUES_DESC : QueryRunnerTestHelper.EXPECTED_FULL_ON_INDEX_VALUES;
        String[] expectedIndexToUse = (String[])Arrays.stream(expectedIndex).filter(eachIndex -> !"0.0".equals(eachIndex)).toArray(String[]::new);
        DateTime expectedLast = this.descending ? QueryRunnerTestHelper.EARLIEST : QueryRunnerTestHelper.LAST;
        int count = 0;
        Result lastResult = null;
        for (Result result : results) {
            DateTime current = result.getTimestamp();
            Assert.assertFalse((String)StringUtils.format((String)"Timestamp[%s] > expectedLast[%s]", (Object[])new Object[]{current, expectedLast}), (boolean)(this.descending ? current.isBefore((ReadableInstant)expectedLast) : current.isAfter((ReadableInstant)expectedLast)));
            TimeseriesResultValue value = (TimeseriesResultValue)result.getValue();
            Assert.assertEquals((float)value.getLongMetric(TIMESTAMP_RESULT_FIELD_NAME).longValue(), (float)current.getMillis(), (float)0.0f);
            Assert.assertEquals((String)result.toString(), (long)(QueryRunnerTestHelper.SKIPPED_DAY.equals((Object)current) ? 0L : 13L), (long)value.getLongMetric("rows"));
            if (!QueryRunnerTestHelper.SKIPPED_DAY.equals((Object)current)) {
                Assert.assertEquals((String)result.toString(), (double)Doubles.tryParse((String)expectedIndexToUse[count]), (double)value.getDoubleMetric("index"), (double)(value.getDoubleMetric("index") * 1.0E-6));
                Assert.assertEquals((String)result.toString(), (double)(new Double(expectedIndexToUse[count]) + 13.0 + 1.0), (double)value.getDoubleMetric("addRowsIndexConstant"), (double)(value.getDoubleMetric("addRowsIndexConstant") * 1.0E-6));
                Assert.assertEquals((double)value.getDoubleMetric("uniques"), (double)9.0, (double)0.02);
            } else if (NullHandling.replaceWithDefault()) {
                Assert.assertEquals((String)result.toString(), (double)0.0, (double)value.getDoubleMetric("index"), (double)(value.getDoubleMetric("index") * 1.0E-6));
                Assert.assertEquals((String)result.toString(), (double)(new Double(expectedIndexToUse[count]) + 1.0), (double)value.getDoubleMetric("addRowsIndexConstant"), (double)(value.getDoubleMetric("addRowsIndexConstant") * 1.0E-6));
                Assert.assertEquals((double)0.0, (double)value.getDoubleMetric("uniques"), (double)0.02);
            } else {
                Assert.assertNull((String)result.toString(), (Object)value.getDoubleMetric("index"));
                Assert.assertNull((String)result.toString(), (Object)value.getDoubleMetric("addRowsIndexConstant"));
                Assert.assertEquals((double)value.getDoubleMetric("uniques"), (double)0.0, (double)0.02);
            }
            lastResult = result;
            ++count;
        }
        Assert.assertEquals((String)lastResult.toString(), (Object)expectedLast, (Object)lastResult.getTimestamp());
    }

    @Test
    public void testTimeSeriesWithSelectionFilterLookupExtractionFn() {
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        extractionMap.put("spot", "upfront");
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, true, null, Boolean.valueOf(true), Boolean.valueOf(true));
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)new SelectorDimFilter("market", "upfront", (ExtractionFn)lookupExtractionFn)).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_LONG_SUM, QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)11L, (Object)"index", (Object)3783L, (Object)"addRowsIndexConstant", (Object)3795.0, (Object)"uniques", (Object)9.019833517963864))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)11L, (Object)"index", (Object)3313L, (Object)"addRowsIndexConstant", (Object)3325.0, (Object)"uniques", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, results);
        TimeseriesQueryQueryToolChest toolChest = new TimeseriesQueryQueryToolChest();
        QueryRunner optimizedRunner = toolChest.postMergeQueryDecoration(toolChest.mergeResults(toolChest.preMergeQueryDecoration(this.runner)));
        List results2 = new FinalizeResultsQueryRunner(optimizedRunner, (QueryToolChest)toolChest).run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, results2);
    }

    @Test
    public void testTimeseriesWithLimit() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.QUALITY_UNIQUES)).descending(this.descending).limit(10).context(this.makeContext()).build();
        List list = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        Assert.assertEquals((long)10L, (long)list.size());
    }

    @Test
    public void testTimeseriesWithPostAggregatorReferencingTimestampResultField() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters("market", "spot").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).postAggregators(new PostAggregator[]{new FieldAccessPostAggregator("timestampInPostAgg", "myTimestamp")}).descending(this.descending).context(this.makeContext((Map<String, Object>)ImmutableMap.of((Object)"timestampResultField", (Object)"myTimestamp"))).build();
        DateTime aprilFirst = DateTimes.of((String)"2011-04-01");
        DateTime aprilSecond = DateTimes.of((String)"2011-04-02");
        List expectedResults = Arrays.asList(new Result(aprilFirst, (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"myTimestamp", (Object)aprilFirst.getMillis(), (Object)"timestampInPostAgg", (Object)aprilFirst.getMillis()))), new Result(aprilSecond, (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"myTimestamp", (Object)aprilSecond.getMillis(), (Object)"timestampInPostAgg", (Object)aprilSecond.getMillis()))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithExpressionAggregator() {
        this.cannotVectorize();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(Arrays.asList(new ExpressionLambdaAggregatorFactory("diy_count", (Set)ImmutableSet.of(), null, "0", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), "__acc + 1", "__acc + diy_count", null, null, null, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("diy_sum", (Set)ImmutableSet.of((Object)"index"), null, "0.0", null, null, Boolean.valueOf(false), Boolean.valueOf(false), "__acc + index", null, null, null, null, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("diy_decomposed_sum", (Set)ImmutableSet.of((Object)"index"), null, "0.0", "ARRAY<DOUBLE>[]", null, Boolean.valueOf(false), Boolean.valueOf(false), "__acc + index", "array_concat(__acc, diy_decomposed_sum)", null, "fold((x, acc) -> x + acc, o, 0.0)", null, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("array_agg_distinct", (Set)ImmutableSet.of((Object)"market"), "acc", "[]", null, null, Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(acc, market)", "array_set_add_all(acc, array_agg_distinct)", null, null, null, TestExprMacroTable.INSTANCE))).descending(this.descending).context(this.makeContext()).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"diy_count", (Object)13L, (Object)"diy_sum", (Object)6626.151569, (Object)"diy_decomposed_sum", (Object)6626.151569, (Object)"array_agg_distinct", (Object)new String[]{"spot", "total_market", "upfront"}))), new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"diy_count", (Object)13L, (Object)"diy_sum", (Object)5833.209718, (Object)"diy_decomposed_sum", (Object)5833.209718, (Object)"array_agg_distinct", (Object)new String[]{"spot", "total_market", "upfront"}))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesWithExpressionAggregatorTooBig() {
        this.cannotVectorize();
        if (!this.vectorize) {
            this.expectedException.expectMessage("Exceeded memory usage when aggregating type [ARRAY<STRING>]");
        }
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(Granularities.DAY).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(Collections.singletonList(new ExpressionLambdaAggregatorFactory("array_agg_distinct", (Set)ImmutableSet.of((Object)"market"), "acc", "[]", null, null, Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(acc, market)", "array_set_add_all(acc, array_agg_distinct)", null, null, HumanReadableBytes.valueOf((int)10), TestExprMacroTable.INSTANCE))).descending(this.descending).context(this.makeContext()).build();
        this.runner.run(QueryPlus.wrap((Query)query)).toList();
    }

    @Test
    public void testTimeseriesCardinalityAggOnMultiStringExpression() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "concat(quality,market)", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new CardinalityAggregatorFactory("numVals", (List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"v0")), false)}).granularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)26L, (Object)"numVals", (Object)13.041435202975777))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    @Test
    public void testTimeseriesCardinalityAggOnHyperUnique() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new CardinalityAggregatorFactory("cardinality", (List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"quality_uniques")), false), new HyperUniquesAggregatorFactory("hyperUnique", "quality_uniques", false, false)}).granularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)26L, (Object)"cardinality", (Object)(NullHandling.replaceWithDefault() ? 1.0002442201269182 : 0.0), (Object)"hyperUnique", (Object)9.019833517963864))));
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        this.assertExpectedResults(expectedResults, results);
    }

    protected Map<String, Object> makeContext() {
        return this.makeContext((Map<String, Object>)ImmutableMap.of());
    }

    protected Map<String, Object> makeContext(Map<String, Object> myContext) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("vectorize", this.vectorize ? "force" : "false");
        context.put("vectorizeVirtualColumns", this.vectorize ? "force" : "false");
        context.put("vectorSize", 16);
        context.putAll(myContext);
        return context;
    }

    protected void cannotVectorize() {
        if (this.vectorize) {
            this.expectedException.expect(RuntimeException.class);
            this.expectedException.expectMessage("Cannot vectorize!");
        }
    }

    protected void cannotVectorizeUnlessFallback() {
        if (this.vectorize && !ExpressionProcessing.allowVectorizeFallback()) {
            this.expectedException.expect(RuntimeException.class);
            this.expectedException.expectMessage("Cannot vectorize!");
        }
    }
}

