/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.NestedDataTestUtils;
import org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.topn.DimensionTopNMetricSpec;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.query.topn.TopNQueryConfig;
import org.apache.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.virtual.NestedFieldVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class NestedDataTopNQueryTest
extends InitializedNullHandlingTest {
    private static final Logger LOG = new Logger(NestedDataTopNQueryTest.class);
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    private final AggregationTestHelper helper;
    private final BiFunction<TemporaryFolder, Closer, List<Segment>> segmentsGenerator;
    private final Closer closer;

    public NestedDataTopNQueryTest(BiFunction<TemporaryFolder, Closer, List<Segment>> segmentGenerator) {
        BuiltInTypesModule.registerHandlersAndSerde();
        this.helper = AggregationTestHelper.createTopNQueryAggregationTestHelper(BuiltInTypesModule.getJacksonModulesList(), this.tempFolder);
        this.segmentsGenerator = segmentGenerator;
        this.closer = Closer.create();
    }

    @Parameterized.Parameters(name="segments = {0}")
    public static Collection<?> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        List<BiFunction<TemporaryFolder, Closer, List<Segment>>> segmentsGenerators = NestedDataTestUtils.getSegmentGenerators("nested-simple-test-data.json");
        for (BiFunction<TemporaryFolder, Closer, List<Segment>> generatorFn : segmentsGenerators) {
            constructors.add(new Object[]{generatorFn});
        }
        return constructors;
    }

    @After
    public void teardown() throws IOException {
        this.closer.close();
    }

    @Test
    public void testGroupBySomeField() {
        TopNQuery topN = new TopNQueryBuilder().dataSource("test_datasource").granularity(Granularities.ALL).intervals(Collections.singletonList(Intervals.ETERNITY)).dimension((DimensionSpec)DefaultDimensionSpec.of((String)"v0")).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0")}).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(10).build();
        Sequence seq = this.helper.runQueryOnSegmentsObjs(this.segmentsGenerator.apply(this.tempFolder, this.closer), topN);
        Sequence resultsSeq = new TopNQueryQueryToolChest(new TopNQueryConfig()).resultsAsArrays(topN, seq);
        List results = resultsSeq.toList();
        NestedDataTopNQueryTest.verifyResults(results, (List<Object[]>)ImmutableList.of((Object)new Object[]{1672531200000L, null, 8L}, (Object)new Object[]{1672531200000L, "100", 2L}, (Object)new Object[]{1672531200000L, "200", 2L}, (Object)new Object[]{1672531200000L, "300", 4L}));
    }

    @Test
    public void testGroupBySomeFieldAggregateSomeField() {
        TopNQuery topN = new TopNQueryBuilder().dataSource("test_datasource").granularity(Granularities.ALL).intervals(Collections.singletonList(Intervals.ETERNITY)).dimension((DimensionSpec)DefaultDimensionSpec.of((String)"v0")).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "v0"), new NestedFieldVirtualColumn("nest", "$.x", "v1", ColumnType.DOUBLE)}).aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "v1", null, TestExprMacroTable.INSTANCE)}).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(10).build();
        Sequence seq = this.helper.runQueryOnSegmentsObjs(this.segmentsGenerator.apply(this.tempFolder, this.closer), topN);
        Sequence resultsSeq = new TopNQueryQueryToolChest(new TopNQueryConfig()).resultsAsArrays(topN, seq);
        List results = resultsSeq.toList();
        NestedDataTopNQueryTest.verifyResults(results, (List<Object[]>)ImmutableList.of((Object)new Object[]{1672531200000L, null, NullHandling.defaultDoubleValue()}, (Object)new Object[]{1672531200000L, "100", 200.0}, (Object)new Object[]{1672531200000L, "200", 400.0}, (Object)new Object[]{1672531200000L, "300", 1200.0}));
    }

    private static void verifyResults(List<Object[]> results, List<Object[]> expected) {
        Assert.assertEquals((long)expected.size(), (long)results.size());
        for (int i = 0; i < expected.size(); ++i) {
            LOG.info("result #%d, %s", new Object[]{i, Arrays.toString(results.get(i))});
            Assert.assertArrayEquals((String)StringUtils.format((String)"result #%d", (Object[])new Object[]{i + 1}), (Object[])expected.get(i), (Object[])results.get(i));
        }
    }
}

