/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.google.caliper.Param;
import com.google.caliper.Runner;
import com.google.caliper.SimpleBenchmark;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.topn.NumericTopNMetricSpec;
import org.apache.druid.query.topn.TopNBinaryFn;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNResultValue;
import org.joda.time.DateTime;

public class TopNBinaryFnBenchmark
extends SimpleBenchmark {
    @Param(value={"1", "5", "10", "15"})
    int aggCount;
    @Param(value={"1", "5", "10", "15"})
    int postAggCount;
    @Param(value={"1000", "10000"})
    int threshold;
    Result<TopNResultValue> result1;
    Result<TopNResultValue> result2;
    TopNBinaryFn fn;

    public static void main(String[] args) {
        Runner.main(TopNBinaryFnBenchmark.class, (String[])args);
    }

    protected void setUp() {
        ConstantPostAggregator constant = new ConstantPostAggregator("const", (Number)1L);
        FieldAccessPostAggregator rowsPostAgg = new FieldAccessPostAggregator("rows", "rows");
        FieldAccessPostAggregator indexPostAgg = new FieldAccessPostAggregator("index", "index");
        ArrayList<Object> aggregatorFactories = new ArrayList<Object>();
        aggregatorFactories.add(new CountAggregatorFactory("rows"));
        aggregatorFactories.add(new LongSumAggregatorFactory("index", "index"));
        for (int i = 1; i < this.aggCount; ++i) {
            aggregatorFactories.add(new CountAggregatorFactory("rows" + i));
        }
        ArrayList<ArithmeticPostAggregator> postAggregators = new ArrayList<ArithmeticPostAggregator>();
        for (int i = 0; i < this.postAggCount; ++i) {
            postAggregators.add(new ArithmeticPostAggregator("addrowsindexconstant" + i, "+", (List)Lists.newArrayList((Object[])new PostAggregator[]{constant, rowsPostAgg, indexPostAgg})));
        }
        DateTime currTime = DateTimes.nowUtc();
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.threshold; ++i) {
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("testdim", "" + i);
            res.put("rows", 1L);
            for (int j = 0; j < this.aggCount; ++j) {
                res.put("rows" + j, 1L);
            }
            res.put("index", 1L);
            list.add(res);
        }
        this.result1 = new Result(currTime, (Object)TopNResultValue.create(list));
        ArrayList list2 = new ArrayList();
        for (int i = 0; i < this.threshold; ++i) {
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("testdim", "" + i);
            res.put("rows", 2L);
            for (int j = 0; j < this.aggCount; ++j) {
                res.put("rows" + j, 2L);
            }
            res.put("index", 2L);
            list2.add(res);
        }
        this.result2 = new Result(currTime, (Object)TopNResultValue.create(list2));
        this.fn = new TopNBinaryFn(Granularities.ALL, (DimensionSpec)new DefaultDimensionSpec("testdim", null), (TopNMetricSpec)new NumericTopNMetricSpec("index"), 100, aggregatorFactories, postAggregators);
    }

    public void timeMerge(int nReps) {
        for (int i = 0; i < nReps; ++i) {
            this.fn.apply(this.result1, this.result2);
        }
    }
}

