/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TopNQueryBuilderTest {
    private TopNQueryBuilder builder;

    @Before
    public void setup() {
        this.builder = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("index").intervals(QueryRunnerTestHelper.EMPTY_INTERVAL).threshold(4).aggregators(new AggregatorFactory[]{new DoubleMaxAggregatorFactory("index", "index")});
    }

    @Test
    public void testQueryIdWhenContextInBuilderIsNullReturnContextContainingQueryId() {
        TopNQuery query = this.builder.queryId("queryId").build();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"queryId", (Object)"queryId"), (Object)query.getContext());
    }

    @Test
    public void testQueryIdWhenBuilderHasNonnullContextWithoutQueryIdReturnMergedContext() {
        TopNQuery query = this.builder.context((Map)ImmutableMap.of((Object)"my", (Object)"context")).queryId("queryId").build();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"queryId", (Object)"queryId", (Object)"my", (Object)"context"), (Object)query.getContext());
    }

    @Test
    public void testQueryIdWhenBuilderHasNonnullContextWithQueryIdReturnMergedContext() {
        TopNQuery query = this.builder.context((Map)ImmutableMap.of((Object)"my", (Object)"context", (Object)"queryId", (Object)"queryId")).queryId("realQueryId").build();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"queryId", (Object)"realQueryId", (Object)"my", (Object)"context"), (Object)query.getContext());
    }

    @Test
    public void testContextAfterSettingQueryIdReturnContextWithoutQueryId() {
        TopNQuery query = this.builder.queryId("queryId").context((Map)ImmutableMap.of((Object)"my", (Object)"context")).build();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"my", (Object)"context"), (Object)query.getContext());
    }

    @Test
    public void testContextContainingQueryIdAfterSettingQueryIdOverwriteQueryId() {
        TopNQuery query = this.builder.queryId("queryId").context((Map)ImmutableMap.of((Object)"my", (Object)"context", (Object)"queryId", (Object)"realQueryId")).build();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"queryId", (Object)"realQueryId", (Object)"my", (Object)"context"), (Object)query.getContext());
    }
}

