/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.collections.CloseableStupidPool;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.BySegmentResultValue;
import org.apache.druid.query.BySegmentResultValueClass;
import org.apache.druid.query.Order;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.Result;
import org.apache.druid.query.TestQueryRunner;
import org.apache.druid.query.TestQueryRunners;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMaxAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMinAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.SimpleDoubleAggregatorFactory;
import org.apache.druid.query.aggregation.SimpleFloatAggregatorFactory;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.first.DoubleFirstAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.first.FloatFirstAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.first.LongFirstAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.FloatLastAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.LongLastAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniqueFinalizingPostAggregator;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.aggregation.post.ExpressionPostAggregator;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.dimension.ListFilteredDimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.extraction.DimExtractionFn;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.JavaScriptExtractionFn;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.extraction.RegexDimExtractionFn;
import org.apache.druid.query.extraction.StringFormatExtractionFn;
import org.apache.druid.query.extraction.StrlenExtractionFn;
import org.apache.druid.query.extraction.TimeFormatExtractionFn;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.ExtractionDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.topn.BySegmentTopNResultValue;
import org.apache.druid.query.topn.DimensionTopNMetricSpec;
import org.apache.druid.query.topn.InvertedTopNMetricSpec;
import org.apache.druid.query.topn.LexicographicTopNMetricSpec;
import org.apache.druid.query.topn.NumericTopNMetricSpec;
import org.apache.druid.query.topn.PooledTopNAlgorithm;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.query.topn.TopNQueryConfig;
import org.apache.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.druid.query.topn.TopNQueryRunnerFactory;
import org.apache.druid.query.topn.TopNQueryRunnerTestHelper;
import org.apache.druid.query.topn.TopNResultValue;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TopNQueryRunnerTest
extends InitializedNullHandlingTest {
    private static final Closer RESOURCE_CLOSER = Closer.create();
    private final TestQueryRunner<Result<TopNResultValue>> runner;
    private final boolean duplicateSingleAggregatorQueries;
    private final List<AggregatorFactory> commonAggregators;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @AfterClass
    public static void teardown() throws IOException {
        RESOURCE_CLOSER.close();
    }

    @Parameterized.Parameters(name="{7}")
    public static Iterable<Object[]> constructorFeeder() {
        List<QueryRunner<Result<TopNResultValue>>> retVal = TopNQueryRunnerTest.queryRunners(true);
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        for (int i = 0; i < 32; ++i) {
            for (QueryRunner<Result<TopNResultValue>> firstParameter : retVal) {
                Object[] params = new Object[]{firstParameter, (i & 1) != 0, (i & 2) != 0, (i & 4) != 0, (i & 8) != 0, (i & 0x10) != 0, QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS, firstParameter + " double aggs"};
                Object[] params2 = Arrays.copyOf(params, 8);
                params2[6] = QueryRunnerTestHelper.COMMON_FLOAT_AGGREGATORS;
                params2[7] = firstParameter + " float aggs";
                parameters.add(params);
                parameters.add(params2);
            }
        }
        return parameters;
    }

    public static List<QueryRunner<Result<TopNResultValue>>> queryRunners(boolean includeNonTimeOrdered) {
        CloseableStupidPool<ByteBuffer> defaultPool = TestQueryRunners.createDefaultNonBlockingPool();
        CloseableStupidPool customPool = new CloseableStupidPool("TopNQueryRunnerFactory-bufferPool", () -> ByteBuffer.allocate(20000));
        ArrayList<QueryRunner<Result<TopNResultValue>>> retVal = new ArrayList<QueryRunner<Result<TopNResultValue>>>();
        retVal.addAll(QueryRunnerTestHelper.makeQueryRunnersToMerge(new TopNQueryRunnerFactory(defaultPool, new TopNQueryQueryToolChest(new TopNQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER), includeNonTimeOrdered));
        retVal.addAll(QueryRunnerTestHelper.makeQueryRunnersToMerge(new TopNQueryRunnerFactory(customPool, new TopNQueryQueryToolChest(new TopNQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER), includeNonTimeOrdered));
        RESOURCE_CLOSER.register(() -> {
            Assert.assertEquals((String)"defaultPool objects created", (long)defaultPool.poolSize(), (long)defaultPool.objectsCreatedCount());
            Assert.assertEquals((String)"customPool objects created", (long)customPool.poolSize(), (long)customPool.objectsCreatedCount());
            defaultPool.close();
            customPool.close();
        });
        return retVal;
    }

    public TopNQueryRunnerTest(TestQueryRunner<Result<TopNResultValue>> runner, boolean specializeGeneric1AggPooledTopN, boolean specializeGeneric2AggPooledTopN, boolean specializeHistorical1SimpleDoubleAggPooledTopN, boolean specializeHistoricalSingleValueDimSelector1SimpleDoubleAggPooledTopN, boolean duplicateSingleAggregatorQueries, List<AggregatorFactory> commonAggregators, String testName) {
        this.runner = runner;
        PooledTopNAlgorithm.setSpecializeGeneric1AggPooledTopN((boolean)specializeGeneric1AggPooledTopN);
        PooledTopNAlgorithm.setSpecializeGeneric2AggPooledTopN((boolean)specializeGeneric2AggPooledTopN);
        PooledTopNAlgorithm.setSpecializeHistorical1SimpleDoubleAggPooledTopN((boolean)specializeHistorical1SimpleDoubleAggPooledTopN);
        PooledTopNAlgorithm.setSpecializeHistoricalSingleValueDimSelector1SimpleDoubleAggPooledTopN((boolean)specializeHistoricalSingleValueDimSelector1SimpleDoubleAggPooledTopN);
        this.duplicateSingleAggregatorQueries = duplicateSingleAggregatorQueries;
        this.commonAggregators = commonAggregators;
    }

    private List<AggregatorFactory> duplicateAggregators(AggregatorFactory aggregatorFactory, AggregatorFactory duplicate) {
        if (this.duplicateSingleAggregatorQueries) {
            return ImmutableList.of((Object)aggregatorFactory, (Object)duplicate);
        }
        return Collections.singletonList(aggregatorFactory);
    }

    private List<Map<String, Object>> withDuplicateResults(List<? extends Map<String, Object>> results, String key, String duplicateKey) {
        if (!this.duplicateSingleAggregatorQueries) {
            return results;
        }
        ArrayList<Map<String, Object>> resultsWithDuplicates = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> result : results) {
            resultsWithDuplicates.add((Map<String, Object>)ImmutableMap.builder().putAll(result).put((Object)duplicateKey, result.get(key)).build());
        }
        return resultsWithDuplicates;
    }

    private Sequence<Result<TopNResultValue>> assertExpectedResults(Iterable<Result<TopNResultValue>> expectedResults, TopNQuery query) {
        Sequence<Result<TopNResultValue>> retval = this.runWithMerge(query);
        TestHelper.assertExpectedResults(expectedResults, retval);
        return retval;
    }

    private Sequence<Result<TopNResultValue>> runWithMerge(TopNQuery query) {
        return this.runWithMerge(query, ResponseContext.createEmpty());
    }

    private Sequence<Result<TopNResultValue>> runWithMerge(TopNQuery query, ResponseContext context) {
        return this.runner.run((QueryPlus<Result<TopNResultValue>>)QueryPlus.wrap((Query)query), context);
    }

    @Test
    public void testEmptyTopN() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.EMPTY_INTERVAL).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index"), new DoubleFirstAggregatorFactory("first", "index", null)})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        ImmutableList expectedResults = ImmutableList.of((Object)new Result(DateTimes.of((String)"2020-04-02T00:00:00.000Z"), (Object)TopNResultValue.create((List)ImmutableList.of())));
        this.assertExpectedResults((Iterable<Result<TopNResultValue>>)expectedResults, query);
    }

    @Test
    public void testFullOnTopN() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)186L).put((Object)"index", (Object)215679.82879638672).put((Object)"addRowsIndexConstant", (Object)215866.82879638672).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1743.92175).put((Object)"minIndex", (Object)792.3260498046875).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"rows", (Object)186L).put((Object)"index", (Object)192046.1060180664).put((Object)"addRowsIndexConstant", (Object)192233.1060180664).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1870.061029).put((Object)"minIndex", (Object)545.9906005859375).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)837L).put((Object)"index", (Object)95606.57232284546).put((Object)"addRowsIndexConstant", (Object)96444.57232284546).put((Object)"uniques", (Object)9.019833517963864).put((Object)"maxIndex", (Object)277.273533).put((Object)"minIndex", (Object)59.02102279663086).build()))));
        this.assertExpectedResults(expectedResults, query);
        this.assertExpectedResults(expectedResults, query.withAggregatorSpecs((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.COMMON_FLOAT_AGGREGATORS, (Iterable)Lists.newArrayList((Object[])new SimpleFloatAggregatorFactory[]{new FloatMaxAggregatorFactory("maxIndex", "indexFloat"), new FloatMinAggregatorFactory("minIndex", "indexFloat")})))));
    }

    @Test
    public void testTopNOnMissingColumn() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new DefaultDimensionSpec("nonexistentColumn", "alias")).metric("rows").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("rows")}).build();
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        resultMap.put("alias", null);
        resultMap.put("rows", 1209L);
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Collections.singletonList(resultMap))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNOnMissingColumnWithExtractionFn() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("nonexistentColumn", "alias", (ExtractionFn)new StringFormatExtractionFn("theValue"))).metric("rows").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("rows")}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Collections.singletonList(ImmutableMap.builder().put((Object)"alias", (Object)"theValue").put((Object)"rows", (Object)1209L).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testFullOnTopNOverPostAggs() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("addRowsIndexConstant").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)186L).put((Object)"index", (Object)215679.82879638672).put((Object)"addRowsIndexConstant", (Object)215866.82879638672).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1743.92175).put((Object)"minIndex", (Object)792.3260498046875).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"rows", (Object)186L).put((Object)"index", (Object)192046.1060180664).put((Object)"addRowsIndexConstant", (Object)192233.1060180664).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1870.061029).put((Object)"minIndex", (Object)545.9906005859375).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)837L).put((Object)"index", (Object)95606.57232284546).put((Object)"addRowsIndexConstant", (Object)96444.57232284546).put((Object)"uniques", (Object)9.019833517963864).put((Object)"maxIndex", (Object)277.273533).put((Object)"minIndex", (Object)59.02102279663086).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testFullOnTopNOverPostAggsOnDimension() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("dimPostAgg").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{new ExpressionPostAggregator("dimPostAgg", "market + 'x'", null, null, TestExprMacroTable.INSTANCE)}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"dimPostAgg", (Object)"upfrontx").put((Object)"rows", (Object)186L).put((Object)"index", (Object)192046.1060180664).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1870.061029).put((Object)"minIndex", (Object)545.9906005859375).build(), ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"dimPostAgg", (Object)"total_marketx").put((Object)"rows", (Object)186L).put((Object)"index", (Object)215679.82879638672).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1743.92175).put((Object)"minIndex", (Object)792.3260498046875).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"dimPostAgg", (Object)"spotx").put((Object)"rows", (Object)837L).put((Object)"index", (Object)95606.57232284546).put((Object)"uniques", (Object)9.019833517963864).put((Object)"maxIndex", (Object)277.273533).put((Object)"minIndex", (Object)59.02102279663086).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testFullOnTopNOverUniques() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("uniques").threshold(3).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)837L).put((Object)"index", (Object)95606.57232284546).put((Object)"addRowsIndexConstant", (Object)96444.57232284546).put((Object)"uniques", (Object)9.019833517963864).put((Object)"maxIndex", (Object)277.273533).put((Object)"minIndex", (Object)59.02102279663086).build(), ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)186L).put((Object)"index", (Object)215679.82879638672).put((Object)"addRowsIndexConstant", (Object)215866.82879638672).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1743.92175).put((Object)"minIndex", (Object)792.3260498046875).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"rows", (Object)186L).put((Object)"index", (Object)192046.1060180664).put((Object)"addRowsIndexConstant", (Object)192233.1060180664).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1870.061029).put((Object)"minIndex", (Object)545.9906005859375).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNOverMissingUniques() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("uniques").threshold(3).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{new HyperUniquesAggregatorFactory("uniques", "missingUniques")}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"uniques", (Object)0.0).build(), ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"uniques", (Object)0.0).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"uniques", (Object)0.0).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNOverHyperUniqueFinalizingPostAggregator() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("hyperUniqueFinalizingPostAggMetric").threshold(3).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{new HyperUniqueFinalizingPostAggregator("hyperUniqueFinalizingPostAggMetric", "uniques")}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"uniques", (Object)9.019833517963864).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)9.019833517963864).build(), ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"uniques", (Object)2.000977198748901).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)2.000977198748901).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"uniques", (Object)2.000977198748901).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)2.000977198748901).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNOverHyperUniqueExpression() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("hyperUniqueFinalizingPostAggMetric").threshold(3).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.QUALITY_UNIQUES}).postAggregators(new PostAggregator[]{new ExpressionPostAggregator("hyperUniqueFinalizingPostAggMetric", "uniques + 1", null, null, TestExprMacroTable.INSTANCE)}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"uniques", (Object)9.019833517963864).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)10.019833517963864).build(), ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"uniques", (Object)2.000977198748901).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)3.000977198748901).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"uniques", (Object)2.000977198748901).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)3.000977198748901).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNOverHyperUniqueExpressionRounded() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("hyperUniqueFinalizingPostAggMetric").threshold(3).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.QUALITY_UNIQUES_ROUNDED}).postAggregators(new PostAggregator[]{new ExpressionPostAggregator("hyperUniqueFinalizingPostAggMetric", "uniques + 1", null, null, TestExprMacroTable.INSTANCE)}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"uniques", (Object)9L).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)10L).build(), ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"uniques", (Object)2L).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)3L).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"uniques", (Object)2L).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)3L).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNOverFirstLastAggregator() {
        this.assumeTimeOrdered();
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.MONTH_GRAN).dimension("market").metric("last").threshold(3).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{new LongFirstAggregatorFactory("first", "index", null), new LongLastAggregatorFactory("last", "index", null)}).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-01-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"first", (Object)1000L).put((Object)"last", (Object)1127L).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"first", (Object)800L).put((Object)"last", (Object)943L).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"first", (Object)100L).put((Object)"last", (Object)155L).build()))), new Result(DateTimes.of((String)"2011-02-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"first", (Object)1203L).put((Object)"last", (Object)1292L).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"first", (Object)1667L).put((Object)"last", (Object)1101L).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"first", (Object)132L).put((Object)"last", (Object)114L).build()))), new Result(DateTimes.of((String)"2011-03-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"first", (Object)1124L).put((Object)"last", (Object)1366L).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"first", (Object)1166L).put((Object)"last", (Object)1063L).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"first", (Object)153L).put((Object)"last", (Object)125L).build()))), new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"first", (Object)1314L).put((Object)"last", (Object)1029L).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"first", (Object)1447L).put((Object)"last", (Object)780L).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"first", (Object)135L).put((Object)"last", (Object)120L).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNOverFirstLastFloatAggregatorUsingDoubleColumn() {
        this.assumeTimeOrdered();
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.MONTH_GRAN).dimension("market").metric("last").threshold(3).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{new FloatFirstAggregatorFactory("first", "index", null), new FloatLastAggregatorFactory("last", "index", null)}).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-01-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"first", (Object)Float.valueOf(1000.0f)).put((Object)"last", (Object)Float.valueOf(1127.231f)).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"first", (Object)Float.valueOf(800.0f)).put((Object)"last", (Object)Float.valueOf(943.4972f)).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"first", (Object)Float.valueOf(100.0f)).put((Object)"last", (Object)Float.valueOf(155.74495f)).build()))), new Result(DateTimes.of((String)"2011-02-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"first", (Object)Float.valueOf(1203.4656f)).put((Object)"last", (Object)Float.valueOf(1292.5428f)).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"first", (Object)Float.valueOf(1667.4978f)).put((Object)"last", (Object)Float.valueOf(1101.9182f)).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"first", (Object)Float.valueOf(132.12378f)).put((Object)"last", (Object)Float.valueOf(114.28457f)).build()))), new Result(DateTimes.of((String)"2011-03-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"first", (Object)Float.valueOf(1124.2014f)).put((Object)"last", (Object)Float.valueOf(1366.4476f)).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"first", (Object)Float.valueOf(1166.1411f)).put((Object)"last", (Object)Float.valueOf(1063.2012f)).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"first", (Object)Float.valueOf(153.05994f)).put((Object)"last", (Object)Float.valueOf(125.83968f)).build()))), new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"first", (Object)Float.valueOf(1314.8397f)).put((Object)"last", (Object)Float.valueOf(1029.057f)).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"first", (Object)1447.3412).put((Object)"last", (Object)780.272).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"first", (Object)Float.valueOf(135.8851f)).put((Object)"last", (Object)Float.valueOf(120.290344f)).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNOverFirstLastFloatAggregatorUsingFloatColumn() {
        this.assumeTimeOrdered();
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.MONTH_GRAN).dimension("market").metric("last").threshold(3).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{new FloatFirstAggregatorFactory("first", "indexFloat", null), new FloatLastAggregatorFactory("last", "indexFloat", null)}).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-01-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"first", (Object)Float.valueOf(1000.0f)).put((Object)"last", (Object)Float.valueOf(1127.231f)).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"first", (Object)Float.valueOf(800.0f)).put((Object)"last", (Object)Float.valueOf(943.4972f)).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"first", (Object)Float.valueOf(100.0f)).put((Object)"last", (Object)Float.valueOf(155.74495f)).build()))), new Result(DateTimes.of((String)"2011-02-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"first", (Object)Float.valueOf(1203.4656f)).put((Object)"last", (Object)Float.valueOf(1292.5428f)).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"first", (Object)Float.valueOf(1667.4978f)).put((Object)"last", (Object)Float.valueOf(1101.9182f)).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"first", (Object)Float.valueOf(132.12378f)).put((Object)"last", (Object)Float.valueOf(114.28457f)).build()))), new Result(DateTimes.of((String)"2011-03-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"first", (Object)Float.valueOf(1124.2014f)).put((Object)"last", (Object)Float.valueOf(1366.4476f)).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"first", (Object)Float.valueOf(1166.1411f)).put((Object)"last", (Object)Float.valueOf(1063.2012f)).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"first", (Object)Float.valueOf(153.05994f)).put((Object)"last", (Object)Float.valueOf(125.83968f)).build()))), new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"first", (Object)Float.valueOf(1314.8397f)).put((Object)"last", (Object)Float.valueOf(1029.057f)).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"first", (Object)1447.3412).put((Object)"last", (Object)780.272).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"first", (Object)Float.valueOf(135.8851f)).put((Object)"last", (Object)Float.valueOf(120.290344f)).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNBySegment() {
        HashMap<String, String> specialContext = new HashMap<String, String>();
        specialContext.put("bySegment", "true");
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).context(specialContext).build();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"index", (Object)5351.814783, (Object)"market", (Object)"total_market", (Object)"uniques", (Object)2.000977198748901, (Object)"rows", (Object)4L), ImmutableMap.of((Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"index", (Object)4875.669692, (Object)"market", (Object)"upfront", (Object)"uniques", (Object)2.000977198748901, (Object)"rows", (Object)4L), ImmutableMap.of((Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"index", (Object)2231.876812, (Object)"market", (Object)"spot", (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)18L)))));
        Sequence<Result<TopNResultValue>> results = this.runWithMerge(query);
        List resultList = results.map(input -> {
            Object val = input.getValue();
            if (val instanceof BySegmentResultValue) {
                BySegmentResultValue bySegVal = (BySegmentResultValue)val;
                return new Result(input.getTimestamp(), (Object)new BySegmentTopNResultValue(Lists.transform((List)bySegVal.getResults(), res -> {
                    Result theResult;
                    Object resVal;
                    if (Preconditions.checkNotNull((Object)res) instanceof Result && (resVal = (theResult = (Result)res).getValue()) instanceof TopNResultValue) {
                        return new Result(theResult.getTimestamp(), (Object)((TopNResultValue)resVal));
                    }
                    throw new IAE("Bad input: [%s]", new Object[]{res});
                }), bySegVal.getSegmentId(), bySegVal.getInterval()));
            }
            throw new ISE("Bad type", new Object[0]);
        }).toList();
        Result result = (Result)resultList.get(0);
        TestHelper.assertExpectedResults(expectedResults, ((BySegmentTopNResultValue)result.getValue()).getResults());
    }

    @Test
    public void testTopN() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNByUniques() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric((TopNMetricSpec)new NumericTopNMetricSpec("uniques")).threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithOrFilter1() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters("market", "total_market", new String[]{"upfront", "spot"}).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithOrFilter2() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters("market", "total_market", new String[]{"upfront"}).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithFilter1() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters("market", "upfront").dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Collections.singletonList(ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithFilter2() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters("quality", "mezzanine").dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)2L, (Object)"index", (Object)2591.68359375, (Object)"addRowsIndexConstant", (Object)2594.68359375, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)2L, (Object)"index", (Object)2508.39599609375, (Object)"addRowsIndexConstant", (Object)2511.39599609375, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)2L, (Object)"index", (Object)220.63774871826172, (Object)"addRowsIndexConstant", (Object)223.63774871826172, (Object)"uniques", (Object)1.0002442201269182)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithFilter2OneDay() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters("quality", "mezzanine").dimension("market").metric("index").threshold(4).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"2011-04-01T00:00:00.000Z/2011-04-02T00:00:00.000Z")))).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)1L, (Object)"index", (Object)new Float(1447.34116).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(1449.34116).doubleValue(), (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)1L, (Object)"index", (Object)new Float(1314.839715).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(1316.839715).doubleValue(), (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)1L, (Object)"index", (Object)new Float(109.705815).doubleValue(), (Object)"addRowsIndexConstant", (Object)new Float(111.705815).doubleValue(), (Object)"uniques", (Object)1.0002442201269182)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithNonExistentFilterInOr() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters("market", "total_market", new String[]{"upfront", "billyblank"}).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithNonExistentFilter() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters("market", "billyblank").dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        this.assertExpectedResults(Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Collections.emptyList()))), query);
    }

    @Test
    public void testTopNWithNonExistentFilterMultiDim() {
        AndDimFilter andDimFilter = new AndDimFilter(new DimFilter[]{new SelectorDimFilter("market", "billyblank", null), new SelectorDimFilter("quality", "mezzanine", null)});
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters((DimFilter)andDimFilter).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        this.assertExpectedResults(Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Collections.emptyList()))), query);
    }

    @Test
    public void testTopNWithMultiValueDimFilter1() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters("placementish", "m").dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        this.assertExpectedResults(this.runWithMerge(new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters("quality", "mezzanine").dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build()).toList(), query);
    }

    @Test
    public void testTopNWithMultiValueDimFilter2() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters("placementish", "m", new String[]{"a", "b"}).dimension("quality").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        this.assertExpectedResults(this.runWithMerge(new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters("quality", "mezzanine", new String[]{"automotive", "business"}).dimension("quality").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build()).toList(), query);
    }

    @Test
    public void testTopNWithMultiValueDimFilter3() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters("placementish", "a").dimension("placementish").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"placementish", (Object)"a", (Object)"rows", (Object)2L, (Object)"index", (Object)283.31103515625, (Object)"addRowsIndexConstant", (Object)286.31103515625, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"placementish", (Object)"preferred", (Object)"rows", (Object)2L, (Object)"index", (Object)283.31103515625, (Object)"addRowsIndexConstant", (Object)286.31103515625, (Object)"uniques", (Object)1.0002442201269182)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithMultiValueDimFilter4() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters("placementish", "a", new String[]{"b"}).dimension("placementish").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"placementish", (Object)"preferred", (Object)"rows", (Object)4L, (Object)"index", (Object)514.868408203125, (Object)"addRowsIndexConstant", (Object)519.868408203125, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"placementish", (Object)"a", (Object)"rows", (Object)2L, (Object)"index", (Object)283.31103515625, (Object)"addRowsIndexConstant", (Object)286.31103515625, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"placementish", (Object)"b", (Object)"rows", (Object)2L, (Object)"index", (Object)231.557373046875, (Object)"addRowsIndexConstant", (Object)234.557373046875, (Object)"uniques", (Object)1.0002442201269182)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithMultiValueDimFilter5() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters("placementish", "preferred").dimension("placementish").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"placementish", (Object)"preferred", (Object)"rows", (Object)26L, (Object)"index", (Object)12459.361190795898, (Object)"addRowsIndexConstant", (Object)12486.361190795898, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"placementish", (Object)"p", (Object)"rows", (Object)6L, (Object)"index", (Object)5407.213653564453, (Object)"addRowsIndexConstant", (Object)5414.213653564453, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"placementish", (Object)"m", (Object)"rows", (Object)6L, (Object)"index", (Object)5320.717338562012, (Object)"addRowsIndexConstant", (Object)5327.717338562012, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"placementish", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)422.3440856933594, (Object)"addRowsIndexConstant", (Object)427.3440856933594, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithNonExistentDimension() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("doesn't exist").metric("index").threshold(1).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Collections.singletonList(QueryRunnerTestHelper.orderedMap("doesn't exist", null, "rows", 26L, "index", 12459.361190795898, "addRowsIndexConstant", 12486.361190795898, "uniques", 9.019833517963864)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithNonExistentDimensionAndActualFilter() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters("market", "upfront").dimension("doesn't exist").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Collections.singletonList(QueryRunnerTestHelper.orderedMap("doesn't exist", null, "rows", 4L, "index", 4875.669692, "addRowsIndexConstant", 4880.669692, "uniques", 2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithNonExistentDimensionAndNonExistentFilter() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters("doesn't exist", null).dimension("doesn't exist").metric("index").threshold(1).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Collections.singletonList(QueryRunnerTestHelper.orderedMap("doesn't exist", null, "rows", 26L, "index", 12459.361190795898, "addRowsIndexConstant", 12486.361190795898, "uniques", 9.019833517963864)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNLexicographic() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric((TopNMetricSpec)new DimensionTopNMetricSpec("", StringComparators.LEXICOGRAPHIC)).threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNLexicographicNoAggregators() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric((TopNMetricSpec)new DimensionTopNMetricSpec("", StringComparators.LEXICOGRAPHIC)).threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot"), ImmutableMap.of((Object)"market", (Object)"total_market"), ImmutableMap.of((Object)"market", (Object)"upfront")))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNLexicographicWithPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric((TopNMetricSpec)new DimensionTopNMetricSpec("spot", StringComparators.LEXICOGRAPHIC)).threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNLexicographicWithNonExistingPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric((TopNMetricSpec)new DimensionTopNMetricSpec("t", StringComparators.LEXICOGRAPHIC)).threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNInvertedLexicographicWithPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new DimensionTopNMetricSpec("upfront", StringComparators.LEXICOGRAPHIC))).threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNInvertedLexicographicWithNonExistingPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new DimensionTopNMetricSpec("u", StringComparators.LEXICOGRAPHIC))).threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNDimExtractionToOne() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new JavaScriptExtractionFn("function(f) { return \"POTATO\"; }", false, JavaScriptConfig.getEnabledInstance()))).metric("rows").threshold(10).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Collections.singletonList(ImmutableMap.of((Object)"addRowsIndexConstant", (Object)504542.5071372986, (Object)"index", (Object)503332.5071372986, (Object)"market", (Object)"POTATO", (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)1209L)))));
        List list = this.runWithMerge(query).toList();
        Assert.assertEquals((long)list.size(), (long)1L);
        Assert.assertEquals((String)"Didn't merge results", (long)((TopNResultValue)((Result)list.get(0)).getValue()).getValue().size(), (long)1L);
        TestHelper.assertExpectedResults(expectedResults, list, "Failed to match");
    }

    @Test
    public void testTopNDimExtractionTimeToOneLong() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("__time", "t", ColumnType.LONG, (ExtractionFn)new JavaScriptExtractionFn("function(f) { return \"42\"; }", false, JavaScriptConfig.getEnabledInstance()))).metric("rows").threshold(10).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Collections.singletonList(ImmutableMap.of((Object)"addRowsIndexConstant", (Object)504542.5071372986, (Object)"index", (Object)503332.5071372986, (Object)"t", (Object)42L, (Object)"uniques", (Object)9.019833517963864, (Object)"rows", (Object)1209L)))));
        List list = this.runWithMerge(query).toList();
        Assert.assertEquals((long)list.size(), (long)1L);
        Assert.assertEquals((String)"Didn't merge results", (long)((TopNResultValue)((Result)list.get(0)).getValue()).getValue().size(), (long)1L);
        TestHelper.assertExpectedResults(expectedResults, list, "Failed to match");
    }

    @Test
    public void testTopNCollapsingDimExtraction() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("quality", "quality", (ExtractionFn)new RegexDimExtractionFn(".(.)", Boolean.valueOf(false), null))).metric("index").threshold(2).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_DOUBLE_SUM}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"quality", (Object)"e", (Object)"rows", (Object)558L, (Object)"index", (Object)246645.1204032898, (Object)"addRowsIndexConstant", (Object)247204.1204032898), ImmutableMap.of((Object)"quality", (Object)"r", (Object)"rows", (Object)372L, (Object)"index", (Object)222051.08961486816, (Object)"addRowsIndexConstant", (Object)222424.08961486816)))));
        this.assertExpectedResults(expectedResults, query);
        query = query.withAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new DoubleSumAggregatorFactory("index", null, "-index + 100", ExprMacroTable.nil())));
        expectedResults = Collections.singletonList(TopNQueryRunnerTestHelper.createExpectedRows("2011-01-12T00:00:00.000Z", new String[]{"quality", "rows", "index", "addRowsIndexConstant"}, Arrays.asList({"n", 93L, -2786.4727909999997, -2692.4727909999997}, {"u", 186L, -3949.824348000002, -3762.824348000002})));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNDimExtraction() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new RegexDimExtractionFn("(.)", Boolean.valueOf(false), null))).metric("rows").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"s", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"u", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNDimExtractionNoAggregators() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new RegexDimExtractionFn("(.)", Boolean.valueOf(false), null))).metric((TopNMetricSpec)new LexicographicTopNMetricSpec("market")).threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"s"), ImmutableMap.of((Object)"market", (Object)"t"), ImmutableMap.of((Object)"market", (Object)"u")))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNDimExtractionFastTopNOptimalWithReplaceMissing() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"spot", (Object)"2spot0", (Object)"total_market", (Object)"1total_market0", (Object)"upfront", (Object)"3upfront0"), false), false, "MISSING", Boolean.valueOf(true), Boolean.valueOf(false)))).metric("rows").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"2spot0", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"1total_market0", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"3upfront0", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNDimExtractionFastTopNUnOptimalWithReplaceMissing() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"spot", (Object)"2spot0", (Object)"total_market", (Object)"1total_market0", (Object)"upfront", (Object)"3upfront0"), false), false, "MISSING", Boolean.valueOf(false), Boolean.valueOf(false)))).metric("rows").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"2spot0", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"1total_market0", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"3upfront0", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNDimExtractionFastTopNOptimal() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"spot", (Object)"2spot0", (Object)"total_market", (Object)"1total_market0", (Object)"upfront", (Object)"3upfront0"), false), true, null, Boolean.valueOf(true), Boolean.valueOf(false)))).metric("rows").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"2spot0", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"1total_market0", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"3upfront0", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNDimExtractionFastTopNUnOptimal() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"spot", (Object)"spot0", (Object)"total_market", (Object)"total_market0", (Object)"upfront", (Object)"upfront0"), false), true, null, Boolean.valueOf(false), Boolean.valueOf(false)))).metric("rows").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot0", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"total_market0", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront0", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNLexicographicDimExtractionOptimalNamespace() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"spot", (Object)"2spot", (Object)"total_market", (Object)"3total_market", (Object)"upfront", (Object)"1upfront"), false), true, null, Boolean.valueOf(true), Boolean.valueOf(false)))).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"1upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"2spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"3total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNLexicographicDimExtractionUnOptimalNamespace() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"spot", (Object)"2spot", (Object)"total_market", (Object)"3total_market", (Object)"upfront", (Object)"1upfront"), false), true, null, Boolean.valueOf(false), Boolean.valueOf(false)))).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"1upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"2spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"3total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNLexicographicDimExtractionOptimalNamespaceWithRunner() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"spot", (Object)"2spot", (Object)"total_market", (Object)"3total_market", (Object)"upfront", (Object)"1upfront"), false), true, null, Boolean.valueOf(true), Boolean.valueOf(false)))).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"1upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"2spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"3total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNLexicographicDimExtraction() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new RegexDimExtractionFn("(.)", Boolean.valueOf(false), null))).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"s", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"u", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testInvertedTopNLexicographicDimExtraction2() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new RegexDimExtractionFn("..(.)", Boolean.valueOf(false), null))).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC))).threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"o", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"f", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNLexicographicDimExtractionWithPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new RegexDimExtractionFn("(.)", Boolean.valueOf(false), null))).metric((TopNMetricSpec)new DimensionTopNMetricSpec("s", StringComparators.LEXICOGRAPHIC)).threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"u", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNLexicographicDimExtractionWithSortingPreservedAndPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new DimExtractionFn(){

            public byte[] getCacheKey() {
                return new byte[0];
            }

            public String apply(String value) {
                return value.substring(0, 1);
            }

            public boolean preservesOrdering() {
                return true;
            }

            public ExtractionFn.ExtractionType getExtractionType() {
                return ExtractionFn.ExtractionType.MANY_TO_ONE;
            }
        })).metric((TopNMetricSpec)new DimensionTopNMetricSpec("s", StringComparators.LEXICOGRAPHIC)).threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"u", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testInvertedTopNLexicographicDimExtractionWithPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new RegexDimExtractionFn("(.)", Boolean.valueOf(false), null))).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new DimensionTopNMetricSpec("u", StringComparators.LEXICOGRAPHIC))).threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"s", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testInvertedTopNLexicographicDimExtractionWithPreviousStop2() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new RegexDimExtractionFn("..(.)", Boolean.valueOf(false), null))).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new DimensionTopNMetricSpec("p", StringComparators.LEXICOGRAPHIC))).threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"o", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"f", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithNullProducingDimExtractionFn() {
        DimExtractionFn nullStringDimExtraction = new DimExtractionFn(){

            public byte[] getCacheKey() {
                return new byte[]{-1};
            }

            public String apply(String dimValue) {
                return "total_market".equals(dimValue) ? null : dimValue;
            }

            public boolean preservesOrdering() {
                return false;
            }

            public ExtractionFn.ExtractionType getExtractionType() {
                return ExtractionFn.ExtractionType.MANY_TO_ONE;
            }
        };
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).metric("rows").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)nullStringDimExtraction)).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864), QueryRunnerTestHelper.orderedMap("market", null, "rows", 4L, "index", 5351.814783, "addRowsIndexConstant", 5356.814783, "uniques", 2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithEmptyStringProducingDimExtractionFn() {
        DimExtractionFn emptyStringDimExtraction = new DimExtractionFn(){

            public byte[] getCacheKey() {
                return new byte[]{-1};
            }

            public String apply(String dimValue) {
                return "total_market".equals(dimValue) ? "" : dimValue;
            }

            public boolean preservesOrdering() {
                return false;
            }

            public ExtractionFn.ExtractionType getExtractionType() {
                return ExtractionFn.ExtractionType.MANY_TO_ONE;
            }
        };
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).metric("rows").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)emptyStringDimExtraction)).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864), QueryRunnerTestHelper.orderedMap("market", "", "rows", 4L, "index", 5351.814783, "addRowsIndexConstant", 5356.814783, "uniques", 2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testInvertedTopNQuery() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("index"))).threshold(3).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNQueryByComplexMetric() {
        ImmutableList aggregatorDimensionSpecs = ImmutableList.of((Object)new DefaultDimensionSpec("quality", "quality"));
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric((TopNMetricSpec)new NumericTopNMetricSpec("numVals")).threshold(10).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.duplicateAggregators((AggregatorFactory)new CardinalityAggregatorFactory("numVals", (List)aggregatorDimensionSpecs, false), (AggregatorFactory)new CardinalityAggregatorFactory("numVals1", (List)aggregatorDimensionSpecs, false))).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(this.withDuplicateResults(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"numVals", (Object)9.019833517963864), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"numVals", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"numVals", (Object)2.000977198748901)), "numVals", "numVals1"))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNQueryCardinalityAggregatorWithExtractionFn() {
        String helloJsFn = "function(str) { return 'hello' }";
        JavaScriptExtractionFn helloFn = new JavaScriptExtractionFn(helloJsFn, false, JavaScriptConfig.getEnabledInstance());
        ExtractionDimensionSpec dimSpec = new ExtractionDimensionSpec("market", "market", (ExtractionFn)helloFn);
        ImmutableList aggregatorDimensionSpecs = ImmutableList.of((Object)new ExtractionDimensionSpec("quality", "quality", (ExtractionFn)helloFn));
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)dimSpec).metric((TopNMetricSpec)new NumericTopNMetricSpec("numVals")).threshold(10).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.duplicateAggregators((AggregatorFactory)new CardinalityAggregatorFactory("numVals", (List)aggregatorDimensionSpecs, false), (AggregatorFactory)new CardinalityAggregatorFactory("numVals1", (List)aggregatorDimensionSpecs, false))).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(this.withDuplicateResults(Collections.singletonList(ImmutableMap.of((Object)"market", (Object)"hello", (Object)"numVals", (Object)1.0002442201269182)), "numVals", "numVals1"))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNDependentPostAgg() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric(QueryRunnerTestHelper.dependentPostAggMetric).threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT, QueryRunnerTestHelper.DEPENDENT_POST_AGG, QueryRunnerTestHelper.hyperUniqueFinalizingPostAgg}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)186L).put((Object)"index", (Object)215679.82879638672).put((Object)"addRowsIndexConstant", (Object)215866.82879638672).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)216053.82879638672).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1743.92175).put((Object)"minIndex", (Object)792.3260498046875).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)3.000977198748901).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"rows", (Object)186L).put((Object)"index", (Object)192046.1060180664).put((Object)"addRowsIndexConstant", (Object)192233.1060180664).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)192420.1060180664).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1870.061029).put((Object)"minIndex", (Object)545.9906005859375).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)3.000977198748901).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)837L).put((Object)"index", (Object)95606.57232284546).put((Object)"addRowsIndexConstant", (Object)96444.57232284546).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)97282.57232284546).put((Object)"uniques", (Object)9.019833517963864).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)10.019833517963864).put((Object)"maxIndex", (Object)277.273533).put((Object)"minIndex", (Object)59.02102279663086).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNBySegmentResults() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric(QueryRunnerTestHelper.dependentPostAggMetric).threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT, QueryRunnerTestHelper.DEPENDENT_POST_AGG}).context((Map)ImmutableMap.of((Object)"finalize", (Object)true, (Object)"bySegment", (Object)true)).build();
        TopNResultValue topNResult = TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)186L).put((Object)"index", (Object)215679.82879638672).put((Object)"addRowsIndexConstant", (Object)215866.82879638672).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)216053.82879638672).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1743.92175).put((Object)"minIndex", (Object)792.3260498046875).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"rows", (Object)186L).put((Object)"index", (Object)192046.1060180664).put((Object)"addRowsIndexConstant", (Object)192233.1060180664).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)192420.1060180664).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1870.061029).put((Object)"minIndex", (Object)545.9906005859375).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)837L).put((Object)"index", (Object)95606.57232284546).put((Object)"addRowsIndexConstant", (Object)96444.57232284546).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)97282.57232284546).put((Object)"uniques", (Object)9.019833517963864).put((Object)"maxIndex", (Object)277.273533).put((Object)"minIndex", (Object)59.02102279663086).build()));
        List<Result> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new BySegmentResultValueClass(Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)topNResult)), QueryRunnerTestHelper.SEGMENT_ID.toString(), Intervals.of((String)"1970-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z"))));
        Sequence<Result<TopNResultValue>> results = this.runWithMerge(query);
        for (Result result : results.toList()) {
            Assert.assertEquals((Object)result.getValue(), (Object)result.getValue());
        }
    }

    @Test
    public void testTopNWithTimeColumn() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.JS_COUNT_IF_TIME_GREATER_THAN, QueryRunnerTestHelper.TIME_LONG_SUM}).granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("ntimestamps").threshold(3).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"ntimestamps", (Object)9.0, (Object)"sumtime", (Object)23429865600000L), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"ntimestamps", (Object)2.0, (Object)"sumtime", (Object)5206636800000L), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"ntimestamps", (Object)2.0, (Object)"sumtime", (Object)5206636800000L)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNTimeExtraction() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("__time", "dayOfWeek", (ExtractionFn)new TimeFormatExtractionFn("EEEE", null, null, null, false))).metric("index").threshold(2).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_DOUBLE_SUM}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"dayOfWeek", (Object)"Wednesday", (Object)"rows", (Object)182L, (Object)"index", (Object)76010.28100585938, (Object)"addRowsIndexConstant", (Object)76193.28100585938), ImmutableMap.of((Object)"dayOfWeek", (Object)"Thursday", (Object)"rows", (Object)182L, (Object)"index", (Object)75203.26300811768, (Object)"addRowsIndexConstant", (Object)75386.26300811768)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNOverNullDimension() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("null_column").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("null_column", null);
        map.put("rows", 1209L);
        map.put("index", 503332.5071372986);
        map.put("addRowsIndexConstant", 504542.5071372986);
        map.put("uniques", 9.019833517963864);
        map.put("maxIndex", 1870.061029);
        map.put("minIndex", 59.02102279663086);
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Collections.singletonList(map))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNOverNullDimensionWithFilter() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("null_column").filters((DimFilter)new SelectorDimFilter("null_column", null, null)).metric("index").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("null_column", null);
        map.put("rows", 1209L);
        map.put("index", 503332.5071372986);
        map.put("addRowsIndexConstant", 504542.5071372986);
        map.put("uniques", 9.019833517963864);
        map.put("maxIndex", 1870.061029);
        map.put("minIndex", 59.02102279663086);
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Collections.singletonList(map))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNOverPartialNullDimension() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(Granularities.ALL).dimension("partial_null_column").metric("uniques").threshold(1000).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).build();
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("partial_null_column", null);
        map.put("rows", 22L);
        map.put("index", 7583.691513061523);
        map.put("uniques", 9.019833517963864);
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(map, ImmutableMap.of((Object)"partial_null_column", (Object)"value", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNOverPartialNullDimensionWithFilterOnNullValue() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(Granularities.ALL).dimension("partial_null_column").metric("uniques").filters((DimFilter)new SelectorDimFilter("partial_null_column", null, null)).threshold(1000).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).build();
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("partial_null_column", null);
        map.put("rows", 22L);
        map.put("index", 7583.691513061523);
        map.put("uniques", 9.019833517963864);
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Collections.singletonList(map))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNOverPartialNullDimensionWithFilterOnNOTNullValue() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(Granularities.ALL).dimension("partial_null_column").metric("uniques").filters((DimFilter)new SelectorDimFilter("partial_null_column", "value", null)).threshold(1000).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Collections.singletonList(ImmutableMap.of((Object)"partial_null_column", (Object)"value", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testAlphaNumericTopNWithNullPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(Granularities.ALL).dimension("market").metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.ALPHANUMERIC)).threshold(2).intervals(QueryRunnerTestHelper.SECOND_ONLY).aggregators(this.duplicateAggregators((AggregatorFactory)QueryRunnerTestHelper.ROWS_COUNT, (AggregatorFactory)new CountAggregatorFactory("rows1"))).build();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-02T00:00:00.000Z"), (Object)TopNResultValue.create(this.withDuplicateResults(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)9L), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)2L)), "rows", "rows1"))));
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((QueryPlus<Result<TopNResultValue>>)QueryPlus.wrap((Query)query)));
    }

    @Test
    public void testNumericDimensionTopNWithNullPreviousStop() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(Granularities.ALL).dimension("market").metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.NUMERIC)).threshold(2).intervals(QueryRunnerTestHelper.SECOND_ONLY).aggregators(this.duplicateAggregators((AggregatorFactory)QueryRunnerTestHelper.ROWS_COUNT, (AggregatorFactory)new CountAggregatorFactory("rows1"))).build();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-02T00:00:00.000Z"), (Object)TopNResultValue.create(this.withDuplicateResults(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)9L), ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)2L)), "rows", "rows1"))));
        TestHelper.assertExpectedResults(expectedResults, this.runner.run((QueryPlus<Result<TopNResultValue>>)QueryPlus.wrap((Query)query)));
    }

    @Test
    public void testTopNWithExtractionFilter() {
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        extractionMap.put("spot", "spot0");
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, null, Boolean.valueOf(true), Boolean.valueOf(false));
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("rows").threshold(3).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).filters((DimFilter)new ExtractionDimFilter("market", "spot0", (ExtractionFn)lookupExtractionFn, null)).build();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Collections.singletonList(ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864)))));
        this.assertExpectedResults(expectedResults, query);
        Sequence<Result<TopNResultValue>> retval = this.runWithPreMergeAndMerge(query);
        TestHelper.assertExpectedResults(expectedResults, retval);
    }

    @Test
    public void testTopNWithExtractionFilterAndFilteredAggregatorCaseNoExistingValue() {
        LookupExtractionFn lookupExtractionFn;
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        if (NullHandling.replaceWithDefault()) {
            lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, null, Boolean.valueOf(true), Boolean.valueOf(false));
            extractionMap.put("", "NULL");
        } else {
            lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, "NULL", Boolean.valueOf(true), Boolean.valueOf(false));
        }
        ExtractionDimFilter extractionFilter = new ExtractionDimFilter("null_column", "NULL", (ExtractionFn)lookupExtractionFn, null);
        TopNQueryBuilder topNQueryBuilder = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("null_column").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new DoubleMaxAggregatorFactory("maxIndex", "index"), (DimFilter)extractionFilter), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT});
        TopNQuery topNQueryWithNULLValueExtraction = topNQueryBuilder.filters((DimFilter)extractionFilter).build();
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("null_column", null);
        map.put("rows", 1209L);
        map.put("index", 503332.5071372986);
        map.put("addRowsIndexConstant", 504542.5071372986);
        map.put("uniques", 9.019833517963864);
        map.put("maxIndex", 1870.061029);
        map.put("minIndex", 59.02102279663086);
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Collections.singletonList(map))));
        this.assertExpectedResults(expectedResults, topNQueryWithNULLValueExtraction);
    }

    private Sequence<Result<TopNResultValue>> runWithPreMergeAndMerge(TopNQuery query) {
        return this.runWithMerge(query, ResponseContext.createEmpty());
    }

    @Test
    public void testTopNWithExtractionFilterNoExistingValue() {
        LookupExtractionFn lookupExtractionFn;
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        if (NullHandling.replaceWithDefault()) {
            lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, null, Boolean.valueOf(true), Boolean.valueOf(true));
            extractionMap.put("", "NULL");
        } else {
            extractionMap.put("", "NOT_USED");
            lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, "NULL", Boolean.valueOf(true), Boolean.valueOf(true));
        }
        ExtractionDimFilter extractionFilter = new ExtractionDimFilter("null_column", "NULL", (ExtractionFn)lookupExtractionFn, null);
        TopNQueryBuilder topNQueryBuilder = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("null_column").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new DoubleMaxAggregatorFactory("maxIndex", "index"), (DimFilter)extractionFilter), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT});
        TopNQuery topNQueryWithNULLValueExtraction = topNQueryBuilder.filters((DimFilter)extractionFilter).build();
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("null_column", null);
        map.put("rows", 1209L);
        map.put("index", 503332.5071372986);
        map.put("addRowsIndexConstant", 504542.5071372986);
        map.put("uniques", 9.019833517963864);
        map.put("maxIndex", 1870.061029);
        map.put("minIndex", 59.02102279663086);
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Collections.singletonList(map))));
        this.assertExpectedResults(expectedResults, topNQueryWithNULLValueExtraction);
        Sequence<Result<TopNResultValue>> retval = this.runWithPreMergeAndMerge(topNQueryWithNULLValueExtraction);
        TestHelper.assertExpectedResults(expectedResults, retval);
    }

    @Test
    public void testFullOnTopNFloatColumn() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new DefaultDimensionSpec("index", "index_alias", ColumnType.FLOAT)).metric("index").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"index_alias", (Object)Float.valueOf(1000.0f)).put((Object)"index", (Object)2000.0).put((Object)"rows", (Object)2L).put((Object)"addRowsIndexConstant", (Object)2003.0).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1000.0).put((Object)"minIndex", (Object)1000.0).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)Float.valueOf(1870.061f)).put((Object)"index", (Object)1870.061029).put((Object)"rows", (Object)1L).put((Object)"addRowsIndexConstant", (Object)1872.06103515625).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1870.061029).put((Object)"minIndex", (Object)1870.061029).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)Float.valueOf(1862.7379f)).put((Object)"index", (Object)1862.737933).put((Object)"rows", (Object)1L).put((Object)"addRowsIndexConstant", (Object)1864.7379150390625).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1862.737933).put((Object)"minIndex", (Object)1862.737933).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)Float.valueOf(1743.9218f)).put((Object)"index", (Object)1743.92175).put((Object)"rows", (Object)1L).put((Object)"addRowsIndexConstant", (Object)1745.9217529296875).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1743.92175).put((Object)"minIndex", (Object)1743.92175).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testFullOnTopNFloatColumnWithExFn() {
        String jsFn = "function(str) { return 'super-' + str; }";
        JavaScriptExtractionFn jsExtractionFn = new JavaScriptExtractionFn(jsFn, false, JavaScriptConfig.getEnabledInstance());
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("index", "index_alias", (ExtractionFn)jsExtractionFn)).metric("index").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"index_alias", (Object)"super-1000").put((Object)"index", (Object)2000.0).put((Object)"rows", (Object)2L).put((Object)"addRowsIndexConstant", (Object)2003.0).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1000.0).put((Object)"minIndex", (Object)1000.0).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)"super-1870.061029").put((Object)"index", (Object)1870.061029).put((Object)"rows", (Object)1L).put((Object)"addRowsIndexConstant", (Object)1872.06103515625).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1870.061029).put((Object)"minIndex", (Object)1870.061029).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)"super-1862.737933").put((Object)"index", (Object)1862.737933).put((Object)"rows", (Object)1L).put((Object)"addRowsIndexConstant", (Object)1864.7379150390625).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1862.737933).put((Object)"minIndex", (Object)1862.737933).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)"super-1743.92175").put((Object)"index", (Object)1743.92175).put((Object)"rows", (Object)1L).put((Object)"addRowsIndexConstant", (Object)1745.9217529296875).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1743.92175).put((Object)"minIndex", (Object)1743.92175).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testFullOnTopNFloatColumnAsString() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new DefaultDimensionSpec("qualityFloat", "qf_alias")).metric("maxIndex").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"qf_alias", (Object)"14000.0").put((Object)"index", (Object)217725.41940800005).put((Object)"rows", (Object)279L).put((Object)"addRowsIndexConstant", (Object)218005.41940800005).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1870.061029).put((Object)"minIndex", (Object)91.270553).build(), ImmutableMap.builder().put((Object)"qf_alias", (Object)"16000.0").put((Object)"index", (Object)210865.67977600006).put((Object)"rows", (Object)279L).put((Object)"addRowsIndexConstant", (Object)211145.67977600006).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1862.737933).put((Object)"minIndex", (Object)99.284525).build(), ImmutableMap.builder().put((Object)"qf_alias", (Object)"10000.0").put((Object)"index", (Object)12270.807093).put((Object)"rows", (Object)93L).put((Object)"addRowsIndexConstant", (Object)12364.807093).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)277.273533).put((Object)"minIndex", (Object)71.315931).build(), ImmutableMap.builder().put((Object)"qf_alias", (Object)"12000.0").put((Object)"index", (Object)12086.472791).put((Object)"rows", (Object)93L).put((Object)"addRowsIndexConstant", (Object)12180.472791).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)193.787574).put((Object)"minIndex", (Object)84.710523).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testFullOnTopNLongColumn() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new DefaultDimensionSpec("qualityLong", "ql_alias", ColumnType.LONG)).metric("maxIndex").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"ql_alias", (Object)1400L).put((Object)"index", (Object)217725.41940800005).put((Object)"rows", (Object)279L).put((Object)"addRowsIndexConstant", (Object)218005.41940800005).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1870.061029).put((Object)"minIndex", (Object)91.270553).build(), ImmutableMap.builder().put((Object)"ql_alias", (Object)1600L).put((Object)"index", (Object)210865.67977600006).put((Object)"rows", (Object)279L).put((Object)"addRowsIndexConstant", (Object)211145.67977600006).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1862.737933).put((Object)"minIndex", (Object)99.284525).build(), ImmutableMap.builder().put((Object)"ql_alias", (Object)1000L).put((Object)"index", (Object)12270.807093).put((Object)"rows", (Object)93L).put((Object)"addRowsIndexConstant", (Object)12364.807093).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)277.273533).put((Object)"minIndex", (Object)71.315931).build(), ImmutableMap.builder().put((Object)"ql_alias", (Object)1200L).put((Object)"index", (Object)12086.472791).put((Object)"rows", (Object)93L).put((Object)"addRowsIndexConstant", (Object)12180.472791).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)193.787574).put((Object)"minIndex", (Object)84.710523).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testFullOnTopNLongVirtualColumn() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new DefaultDimensionSpec("ql_expr", "ql_alias", ColumnType.LONG)).metric("maxIndex").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("ql_expr", "qualityLong", ColumnType.LONG, ExprMacroTable.nil())}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"ql_alias", (Object)1400L).put((Object)"index", (Object)217725.41940800005).put((Object)"rows", (Object)279L).put((Object)"addRowsIndexConstant", (Object)218005.41940800005).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1870.061029).put((Object)"minIndex", (Object)91.270553).build(), ImmutableMap.builder().put((Object)"ql_alias", (Object)1600L).put((Object)"index", (Object)210865.67977600006).put((Object)"rows", (Object)279L).put((Object)"addRowsIndexConstant", (Object)211145.67977600006).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1862.737933).put((Object)"minIndex", (Object)99.284525).build(), ImmutableMap.builder().put((Object)"ql_alias", (Object)1000L).put((Object)"index", (Object)12270.807093).put((Object)"rows", (Object)93L).put((Object)"addRowsIndexConstant", (Object)12364.807093).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)277.273533).put((Object)"minIndex", (Object)71.315931).build(), ImmutableMap.builder().put((Object)"ql_alias", (Object)1200L).put((Object)"index", (Object)12086.472791).put((Object)"rows", (Object)93L).put((Object)"addRowsIndexConstant", (Object)12180.472791).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)193.787574).put((Object)"minIndex", (Object)84.710523).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testFullOnTopNAggregateLongVirtualColumn() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "index", ColumnType.LONG, ExprMacroTable.nil())}).dimension((DimensionSpec)new DefaultDimensionSpec("quality", "quality")).metric("sumIndex").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(Collections.singletonList(new LongSumAggregatorFactory("sumIndex", "v0"))).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"quality", (Object)"mezzanine").put((Object)"sumIndex", (Object)217586L).build(), ImmutableMap.builder().put((Object)"quality", (Object)"premium").put((Object)"sumIndex", (Object)210722L).build(), ImmutableMap.builder().put((Object)"quality", (Object)"automotive").put((Object)"sumIndex", (Object)12226L).build(), ImmutableMap.builder().put((Object)"quality", (Object)"entertainment").put((Object)"sumIndex", (Object)12038L).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNStringVirtualColumn() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("vc", "market + ' ' + market", ColumnType.STRING, TestExprMacroTable.INSTANCE)}).dimension("vc").metric("rows").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"vc", (Object)"spot spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"vc", (Object)"total_market total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"vc", (Object)"upfront upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testFullOnTopNLongColumnWithExFn() {
        String jsFn = "function(str) { return 'super-' + str; }";
        JavaScriptExtractionFn jsExtractionFn = new JavaScriptExtractionFn(jsFn, false, JavaScriptConfig.getEnabledInstance());
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("qualityLong", "ql_alias", (ExtractionFn)jsExtractionFn)).metric("maxIndex").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"ql_alias", (Object)"super-1400").put((Object)"index", (Object)217725.41940800005).put((Object)"rows", (Object)279L).put((Object)"addRowsIndexConstant", (Object)218005.41940800005).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1870.061029).put((Object)"minIndex", (Object)91.270553).build(), ImmutableMap.builder().put((Object)"ql_alias", (Object)"super-1600").put((Object)"index", (Object)210865.67977600006).put((Object)"rows", (Object)279L).put((Object)"addRowsIndexConstant", (Object)211145.67977600006).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1862.737933).put((Object)"minIndex", (Object)99.284525).build(), ImmutableMap.builder().put((Object)"ql_alias", (Object)"super-1000").put((Object)"index", (Object)12270.807093).put((Object)"rows", (Object)93L).put((Object)"addRowsIndexConstant", (Object)12364.807093).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)277.273533).put((Object)"minIndex", (Object)71.315931).build(), ImmutableMap.builder().put((Object)"ql_alias", (Object)"super-1200").put((Object)"index", (Object)12086.472791).put((Object)"rows", (Object)93L).put((Object)"addRowsIndexConstant", (Object)12180.472791).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)193.787574).put((Object)"minIndex", (Object)84.710523).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testFullOnTopNLongColumnAsString() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new DefaultDimensionSpec("qualityLong", "ql_alias")).metric("maxIndex").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"ql_alias", (Object)"1400").put((Object)"index", (Object)217725.41940800005).put((Object)"rows", (Object)279L).put((Object)"addRowsIndexConstant", (Object)218005.41940800005).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1870.061029).put((Object)"minIndex", (Object)91.270553).build(), ImmutableMap.builder().put((Object)"ql_alias", (Object)"1600").put((Object)"index", (Object)210865.67977600006).put((Object)"rows", (Object)279L).put((Object)"addRowsIndexConstant", (Object)211145.67977600006).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1862.737933).put((Object)"minIndex", (Object)99.284525).build(), ImmutableMap.builder().put((Object)"ql_alias", (Object)"1000").put((Object)"index", (Object)12270.807093).put((Object)"rows", (Object)93L).put((Object)"addRowsIndexConstant", (Object)12364.807093).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)277.273533).put((Object)"minIndex", (Object)71.315931).build(), ImmutableMap.builder().put((Object)"ql_alias", (Object)"1200").put((Object)"index", (Object)12086.472791).put((Object)"rows", (Object)93L).put((Object)"addRowsIndexConstant", (Object)12180.472791).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)193.787574).put((Object)"minIndex", (Object)84.710523).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testFullOnTopNNumericStringColumnAsLong() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new DefaultDimensionSpec("qualityNumericString", "qns_alias", ColumnType.LONG)).metric("maxIndex").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"qns_alias", (Object)140000L).put((Object)"index", (Object)217725.41940800005).put((Object)"rows", (Object)279L).put((Object)"addRowsIndexConstant", (Object)218005.41940800005).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1870.061029).put((Object)"minIndex", (Object)91.270553).build(), ImmutableMap.builder().put((Object)"qns_alias", (Object)160000L).put((Object)"index", (Object)210865.67977600006).put((Object)"rows", (Object)279L).put((Object)"addRowsIndexConstant", (Object)211145.67977600006).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1862.737933).put((Object)"minIndex", (Object)99.284525).build(), ImmutableMap.builder().put((Object)"qns_alias", (Object)100000L).put((Object)"index", (Object)12270.807093).put((Object)"rows", (Object)93L).put((Object)"addRowsIndexConstant", (Object)12364.807093).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)277.273533).put((Object)"minIndex", (Object)71.315931).build(), ImmutableMap.builder().put((Object)"qns_alias", (Object)120000L).put((Object)"index", (Object)12086.472791).put((Object)"rows", (Object)93L).put((Object)"addRowsIndexConstant", (Object)12180.472791).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)193.787574).put((Object)"minIndex", (Object)84.710523).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testFullOnTopNNumericStringColumnAsFloat() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new DefaultDimensionSpec("qualityNumericString", "qns_alias", ColumnType.FLOAT)).metric("maxIndex").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"qns_alias", (Object)Float.valueOf(140000.0f)).put((Object)"index", (Object)217725.41940800005).put((Object)"rows", (Object)279L).put((Object)"addRowsIndexConstant", (Object)218005.41940800005).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1870.061029).put((Object)"minIndex", (Object)91.270553).build(), ImmutableMap.builder().put((Object)"qns_alias", (Object)Float.valueOf(160000.0f)).put((Object)"index", (Object)210865.67977600006).put((Object)"rows", (Object)279L).put((Object)"addRowsIndexConstant", (Object)211145.67977600006).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1862.737933).put((Object)"minIndex", (Object)99.284525).build(), ImmutableMap.builder().put((Object)"qns_alias", (Object)Float.valueOf(100000.0f)).put((Object)"index", (Object)12270.807093).put((Object)"rows", (Object)93L).put((Object)"addRowsIndexConstant", (Object)12364.807093).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)277.273533).put((Object)"minIndex", (Object)71.315931).build(), ImmutableMap.builder().put((Object)"qns_alias", (Object)Float.valueOf(120000.0f)).put((Object)"index", (Object)12086.472791).put((Object)"rows", (Object)93L).put((Object)"addRowsIndexConstant", (Object)12180.472791).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)193.787574).put((Object)"minIndex", (Object)84.710523).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testFullOnTopNLongTimeColumn() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new DefaultDimensionSpec("__time", "time_alias", ColumnType.LONG)).metric("maxIndex").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"time_alias", (Object)1296345600000L).put((Object)"index", (Object)5497.331253051758).put((Object)"rows", (Object)13L).put((Object)"addRowsIndexConstant", (Object)5511.331253051758).put((Object)"uniques", (Object)9.019833517963864).put((Object)"maxIndex", (Object)1870.061029).put((Object)"minIndex", (Object)97.02391052246094).build(), ImmutableMap.builder().put((Object)"time_alias", (Object)1298678400000L).put((Object)"index", (Object)6541.463027954102).put((Object)"rows", (Object)13L).put((Object)"addRowsIndexConstant", (Object)6555.463027954102).put((Object)"uniques", (Object)9.019833517963864).put((Object)"maxIndex", (Object)1862.737933).put((Object)"minIndex", (Object)83.099365234375).build(), ImmutableMap.builder().put((Object)"time_alias", (Object)1301529600000L).put((Object)"index", (Object)6814.467971801758).put((Object)"rows", (Object)13L).put((Object)"addRowsIndexConstant", (Object)6828.467971801758).put((Object)"uniques", (Object)9.019833517963864).put((Object)"maxIndex", (Object)1734.27490234375).put((Object)"minIndex", (Object)93.39083862304688).build(), ImmutableMap.builder().put((Object)"time_alias", (Object)1294876800000L).put((Object)"index", (Object)6077.949111938477).put((Object)"rows", (Object)13L).put((Object)"addRowsIndexConstant", (Object)6091.949111938477).put((Object)"uniques", (Object)9.019833517963864).put((Object)"maxIndex", (Object)1689.0128173828125).put((Object)"minIndex", (Object)94.87471008300781).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testSortOnDoubleAsLong() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new DefaultDimensionSpec("index", "index_alias", ColumnType.LONG)).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.NUMERIC)).threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"index_alias", (Object)59L).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)67L).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)68L).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)69L).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testSortOnTimeAsLong() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new DefaultDimensionSpec("__time", "__time_alias", ColumnType.LONG)).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.NUMERIC)).threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"__time_alias", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z").getMillis()).build(), ImmutableMap.builder().put((Object)"__time_alias", (Object)DateTimes.of((String)"2011-01-13T00:00:00.000Z").getMillis()).build(), ImmutableMap.builder().put((Object)"__time_alias", (Object)DateTimes.of((String)"2011-01-14T00:00:00.000Z").getMillis()).build(), ImmutableMap.builder().put((Object)"__time_alias", (Object)DateTimes.of((String)"2011-01-15T00:00:00.000Z").getMillis()).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testSortOnStringAsDouble() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new DefaultDimensionSpec("market", "alias", ColumnType.DOUBLE)).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.NUMERIC)).threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).build();
        HashMap<String, Object> nullAliasMap = new HashMap<String, Object>();
        nullAliasMap.put("alias", null);
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Collections.singletonList(nullAliasMap))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testSortOnDoubleAsDouble() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new DefaultDimensionSpec("index", "index_alias", ColumnType.DOUBLE)).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.NUMERIC)).threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"index_alias", (Object)59.021022).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)59.266595).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)67.73117).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)68.573162).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testFullOnTopNLongTimeColumnWithExFn() {
        String jsFn = "function(str) { return 'super-' + str; }";
        JavaScriptExtractionFn jsExtractionFn = new JavaScriptExtractionFn(jsFn, false, JavaScriptConfig.getEnabledInstance());
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("__time", "time_alias", (ExtractionFn)jsExtractionFn)).metric("maxIndex").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"time_alias", (Object)"super-1296345600000").put((Object)"index", (Object)5497.331253051758).put((Object)"rows", (Object)13L).put((Object)"addRowsIndexConstant", (Object)5511.331253051758).put((Object)"uniques", (Object)9.019833517963864).put((Object)"maxIndex", (Object)1870.061029).put((Object)"minIndex", (Object)97.02391052246094).build(), ImmutableMap.builder().put((Object)"time_alias", (Object)"super-1298678400000").put((Object)"index", (Object)6541.463027954102).put((Object)"rows", (Object)13L).put((Object)"addRowsIndexConstant", (Object)6555.463027954102).put((Object)"uniques", (Object)9.019833517963864).put((Object)"maxIndex", (Object)1862.737933).put((Object)"minIndex", (Object)83.099365234375).build(), ImmutableMap.builder().put((Object)"time_alias", (Object)"super-1301529600000").put((Object)"index", (Object)6814.467971801758).put((Object)"rows", (Object)13L).put((Object)"addRowsIndexConstant", (Object)6828.467971801758).put((Object)"uniques", (Object)9.019833517963864).put((Object)"maxIndex", (Object)1734.27490234375).put((Object)"minIndex", (Object)93.39083862304688).build(), ImmutableMap.builder().put((Object)"time_alias", (Object)"super-1294876800000").put((Object)"index", (Object)6077.949111938477).put((Object)"rows", (Object)13L).put((Object)"addRowsIndexConstant", (Object)6091.949111938477).put((Object)"uniques", (Object)9.019833517963864).put((Object)"maxIndex", (Object)1689.0128173828125).put((Object)"minIndex", (Object)94.87471008300781).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testFullOnTopNDimExtractionAllNulls() {
        String jsFn = "function(str) { return null; }";
        JavaScriptExtractionFn jsExtractionFn = new JavaScriptExtractionFn(jsFn, false, JavaScriptConfig.getEnabledInstance());
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)jsExtractionFn)).metric("index").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        HashMap<String, Number> expectedMap = new HashMap<String, Number>();
        expectedMap.put("market", null);
        expectedMap.put("rows", 1209L);
        expectedMap.put("index", 503332.5071372986);
        expectedMap.put("addRowsIndexConstant", 504542.5071372986);
        expectedMap.put("uniques", 9.019833517963864);
        expectedMap.put("maxIndex", 1870.061029);
        expectedMap.put("minIndex", 59.02102279663086);
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Collections.singletonList(expectedMap))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testFullOnTopNStringOutputAsLong() {
        StrlenExtractionFn strlenFn = StrlenExtractionFn.instance();
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new ExtractionDimensionSpec("quality", "alias", ColumnType.LONG, (ExtractionFn)strlenFn)).metric("maxIndex").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"alias", (Object)9L).put((Object)"index", (Object)217725.41940800005).put((Object)"rows", (Object)279L).put((Object)"addRowsIndexConstant", (Object)218005.41940800005).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1870.061029).put((Object)"minIndex", (Object)91.270553).build(), ImmutableMap.builder().put((Object)"alias", (Object)7L).put((Object)"index", (Object)210865.67977600006).put((Object)"rows", (Object)279L).put((Object)"addRowsIndexConstant", (Object)211145.67977600006).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1862.737933).put((Object)"minIndex", (Object)99.284525).build(), ImmutableMap.builder().put((Object)"alias", (Object)10L).put((Object)"index", (Object)20479.497562408447).put((Object)"rows", (Object)186L).put((Object)"addRowsIndexConstant", (Object)20666.497562408447).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)277.273533).put((Object)"minIndex", (Object)59.02102279663086).build(), ImmutableMap.builder().put((Object)"alias", (Object)13L).put((Object)"index", (Object)12086.472791).put((Object)"rows", (Object)93L).put((Object)"addRowsIndexConstant", (Object)12180.472791).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)193.787574).put((Object)"minIndex", (Object)84.710523).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testFullOnTopNNumericStringColumnWithDecoration() {
        ListFilteredDimensionSpec filteredSpec = new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("qualityNumericString", "qns_alias", ColumnType.LONG), (Set)Sets.newHashSet((Object[])new String[]{"120000", "140000", "160000"}), Boolean.valueOf(true));
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)filteredSpec).metric("maxIndex").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"qns_alias", (Object)140000L).put((Object)"index", (Object)217725.41940800005).put((Object)"rows", (Object)279L).put((Object)"addRowsIndexConstant", (Object)218005.41940800005).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1870.061029).put((Object)"minIndex", (Object)91.270553).build(), ImmutableMap.builder().put((Object)"qns_alias", (Object)160000L).put((Object)"index", (Object)210865.67977600006).put((Object)"rows", (Object)279L).put((Object)"addRowsIndexConstant", (Object)211145.67977600006).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1862.737933).put((Object)"minIndex", (Object)99.284525).build(), ImmutableMap.builder().put((Object)"qns_alias", (Object)120000L).put((Object)"index", (Object)12086.472791).put((Object)"rows", (Object)93L).put((Object)"addRowsIndexConstant", (Object)12180.472791).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)193.787574).put((Object)"minIndex", (Object)84.710523).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testFullOnTopNDecorationOnNumeric() {
        ListFilteredDimensionSpec filteredSpec = new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("qualityLong", "ql_alias", ColumnType.LONG), (Set)Sets.newHashSet((Object[])new String[]{"1200", "1400", "1600"}), Boolean.valueOf(true));
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)filteredSpec).metric("maxIndex").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"ql_alias", (Object)1400L).put((Object)"index", (Object)217725.41940800005).put((Object)"rows", (Object)279L).put((Object)"addRowsIndexConstant", (Object)218005.41940800005).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1870.061029).put((Object)"minIndex", (Object)91.270553).build(), ImmutableMap.builder().put((Object)"ql_alias", (Object)1600L).put((Object)"index", (Object)210865.67977600006).put((Object)"rows", (Object)279L).put((Object)"addRowsIndexConstant", (Object)211145.67977600006).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)1862.737933).put((Object)"minIndex", (Object)99.284525).build(), ImmutableMap.builder().put((Object)"ql_alias", (Object)1200L).put((Object)"index", (Object)12086.472791).put((Object)"rows", (Object)93L).put((Object)"addRowsIndexConstant", (Object)12180.472791).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)193.787574).put((Object)"minIndex", (Object)84.710523).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testFullOnTopNWithAggsOnNumericDims() {
        ArrayList<Pair> aggregations = new ArrayList<Pair>();
        aggregations.add(new Pair((Object)QueryRunnerTestHelper.ROWS_COUNT, (Object)Longs.asList((long[])new long[]{186L, 186L, 837L})));
        Pair indexAggregation = new Pair((Object)QueryRunnerTestHelper.INDEX_DOUBLE_SUM, (Object)Doubles.asList((double[])new double[]{215679.82879638672, 192046.1060180664, 95606.57232284546}));
        aggregations.add(indexAggregation);
        aggregations.add(new Pair((Object)QueryRunnerTestHelper.QUALITY_UNIQUES, (Object)Doubles.asList((double[])new double[]{2.000977198748901, 2.000977198748901, 9.019833517963864})));
        aggregations.add(new Pair((Object)new DoubleMaxAggregatorFactory("maxIndex", "index"), (Object)Doubles.asList((double[])new double[]{1743.92175, 1870.061029, 277.273533})));
        aggregations.add(new Pair((Object)new DoubleMinAggregatorFactory("minIndex", "index"), (Object)Doubles.asList((double[])new double[]{792.3260498046875, 545.9906005859375, 59.02102279663086})));
        aggregations.add(new Pair((Object)new LongSumAggregatorFactory("qlLong", "qualityLong"), (Object)Longs.asList((long[])new long[]{279000L, 279000L, 1171800L})));
        aggregations.add(new Pair((Object)new DoubleSumAggregatorFactory("qlFloat", "qualityLong"), (Object)Doubles.asList((double[])new double[]{279000.0, 279000.0, 1171800.0})));
        aggregations.add(new Pair((Object)new DoubleSumAggregatorFactory("qfFloat", "qualityFloat"), (Object)Doubles.asList((double[])new double[]{2790000.0, 2790000.0, 1.1718E7})));
        aggregations.add(new Pair((Object)new LongSumAggregatorFactory("qfLong", "qualityFloat"), (Object)Longs.asList((long[])new long[]{2790000L, 2790000L, 11718000L})));
        ArrayList<List<Pair>> aggregationCombinations = new ArrayList<List<Pair>>();
        for (Pair pair : aggregations) {
            aggregationCombinations.add(Collections.singletonList(pair));
        }
        aggregationCombinations.add(aggregations);
        for (List list : aggregationCombinations) {
            boolean hasIndexAggregator = list.stream().anyMatch(agg -> "index".equals(((AggregatorFactory)agg.lhs).getName()));
            boolean hasRowsAggregator = list.stream().anyMatch(agg -> "rows".equals(((AggregatorFactory)agg.lhs).getName()));
            TopNQueryBuilder queryBuilder = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(list.stream().map(agg -> (AggregatorFactory)agg.lhs).collect(Collectors.toList()));
            String metric = hasIndexAggregator ? "index" : ((AggregatorFactory)((Pair)list.get((int)0)).lhs).getName();
            queryBuilder.metric(metric);
            if (hasIndexAggregator && hasRowsAggregator) {
                queryBuilder.postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT});
            }
            TopNQuery query = queryBuilder.build();
            ImmutableMap.Builder row1 = ImmutableMap.builder().put((Object)"market", (Object)"total_market");
            ImmutableMap.Builder row2 = ImmutableMap.builder().put((Object)"market", (Object)"upfront");
            ImmutableMap.Builder row3 = ImmutableMap.builder().put((Object)"market", (Object)"spot");
            if (hasIndexAggregator && hasRowsAggregator) {
                row1.put((Object)"addRowsIndexConstant", (Object)215866.82879638672);
                row2.put((Object)"addRowsIndexConstant", (Object)192233.1060180664);
                row3.put((Object)"addRowsIndexConstant", (Object)96444.57232284546);
            }
            list.forEach(agg -> {
                row1.put((Object)((AggregatorFactory)agg.lhs).getName(), ((List)agg.rhs).get(0));
                row2.put((Object)((AggregatorFactory)agg.lhs).getName(), ((List)agg.rhs).get(1));
                row3.put((Object)((AggregatorFactory)agg.lhs).getName(), ((List)agg.rhs).get(2));
            });
            ArrayList rows = Lists.newArrayList((Object[])new ImmutableMap[]{row1.build(), row2.build(), row3.build()});
            rows.sort((r1, r2) -> ((Comparable)r2.get((Object)metric)).compareTo(r1.get((Object)metric)));
            List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create((List)rows)));
            this.assertExpectedResults(expectedResults, query);
        }
    }

    @Test
    public void testFullOnTopNBoundFilterAndLongSumMetric() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market", "Market").filters((DimFilter)new BoundDimFilter("index", "0", "46.64980229268867", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.NUMERIC)).metric("Count").threshold(5).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("Count", "qualityLong")}).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Collections.emptyList())));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNWithNonBitmapFilter() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).filters((DimFilter)new BoundDimFilter("__time", "0", String.valueOf(Long.MAX_VALUE), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.NUMERIC)).dimension("market").metric("count").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("count", "qualityDouble")}).build();
        Assert.assertNotNull((Object)this.runWithMerge(query).toList());
    }

    @Test
    public void test_topN_orderByLongNumericColumnWithNulls_returnsDescendingResults() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new DefaultDimensionSpec("index", "index_alias", ColumnType.LONG)).metric((TopNMetricSpec)new NumericTopNMetricSpec("longNumericNull")).threshold(10000).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("longNumericNull", "longNumericNull")}).intervals(QueryRunnerTestHelper.SECOND_ONLY).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-02T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"index_alias", (Object)97L).put((Object)"longNumericNull", (Object)80L).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)135L).put((Object)"longNumericNull", (Object)70L).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)1049L).put((Object)"longNumericNull", (Object)70L).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)1321L).put((Object)"longNumericNull", (Object)70L).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)110L).put((Object)"longNumericNull", (Object)50L).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)1144L).put((Object)"longNumericNull", (Object)50L).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)1193L).put((Object)"longNumericNull", (Object)50L).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)113L).put((Object)"longNumericNull", (Object)40L).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)112L).put((Object)"longNumericNull", (Object)20L).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)147L).put((Object)"longNumericNull", (Object)10L).build(), TopNQueryRunnerTest.makeRowWithNulls("index_alias", 114L, "longNumericNull", NullHandling.defaultLongValue()), TopNQueryRunnerTest.makeRowWithNulls("index_alias", 126L, "longNumericNull", NullHandling.defaultLongValue()), TopNQueryRunnerTest.makeRowWithNulls("index_alias", 166L, "longNumericNull", NullHandling.defaultLongValue())))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void test_topN_orderByFloatNumericColumnWithNulls_returnsDescendingResults() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new DefaultDimensionSpec("index", "index_alias", ColumnType.LONG)).metric((TopNMetricSpec)new NumericTopNMetricSpec("floatNumericNull")).threshold(10000).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("floatNumericNull", "floatNumericNull")}).intervals(QueryRunnerTestHelper.SECOND_ONLY).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-02T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"index_alias", (Object)97L).put((Object)"floatNumericNull", (Object)Float.valueOf(80.0f)).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)135L).put((Object)"floatNumericNull", (Object)Float.valueOf(70.0f)).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)1049L).put((Object)"floatNumericNull", (Object)Float.valueOf(70.0f)).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)1321L).put((Object)"floatNumericNull", (Object)Float.valueOf(70.0f)).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)110L).put((Object)"floatNumericNull", (Object)Float.valueOf(50.0f)).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)1144L).put((Object)"floatNumericNull", (Object)Float.valueOf(50.0f)).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)1193L).put((Object)"floatNumericNull", (Object)Float.valueOf(50.0f)).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)113L).put((Object)"floatNumericNull", (Object)Float.valueOf(40.0f)).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)112L).put((Object)"floatNumericNull", (Object)Float.valueOf(20.0f)).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)147L).put((Object)"floatNumericNull", (Object)Float.valueOf(10.0f)).build(), TopNQueryRunnerTest.makeRowWithNulls("index_alias", 114L, "floatNumericNull", NullHandling.defaultFloatValue()), TopNQueryRunnerTest.makeRowWithNulls("index_alias", 126L, "floatNumericNull", NullHandling.defaultFloatValue()), TopNQueryRunnerTest.makeRowWithNulls("index_alias", 166L, "floatNumericNull", NullHandling.defaultFloatValue())))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void test_topN_orderByDoubleNumericColumnWithNulls_returnsDescendingResults() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new DefaultDimensionSpec("index", "index_alias", ColumnType.LONG)).metric((TopNMetricSpec)new NumericTopNMetricSpec("doubleNumericNull")).threshold(10000).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("doubleNumericNull", "doubleNumericNull")}).intervals(QueryRunnerTestHelper.SECOND_ONLY).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-02T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"index_alias", (Object)97L).put((Object)"doubleNumericNull", (Object)80.0).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)135L).put((Object)"doubleNumericNull", (Object)70.0).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)1049L).put((Object)"doubleNumericNull", (Object)70.0).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)1321L).put((Object)"doubleNumericNull", (Object)70.0).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)110L).put((Object)"doubleNumericNull", (Object)50.0).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)1144L).put((Object)"doubleNumericNull", (Object)50.0).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)1193L).put((Object)"doubleNumericNull", (Object)50.0).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)113L).put((Object)"doubleNumericNull", (Object)40.0).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)112L).put((Object)"doubleNumericNull", (Object)20.0).build(), ImmutableMap.builder().put((Object)"index_alias", (Object)147L).put((Object)"doubleNumericNull", (Object)10.0).build(), TopNQueryRunnerTest.makeRowWithNulls("index_alias", 114L, "doubleNumericNull", NullHandling.defaultDoubleValue()), TopNQueryRunnerTest.makeRowWithNulls("index_alias", 126L, "doubleNumericNull", NullHandling.defaultDoubleValue()), TopNQueryRunnerTest.makeRowWithNulls("index_alias", 166L, "doubleNumericNull", NullHandling.defaultDoubleValue())))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testAggregateOnLongNumericNull() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new DefaultDimensionSpec("longNumericNull", "dim", ColumnType.LONG)).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.NUMERIC)).threshold(10000).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(TopNQueryRunnerTest.makeRowWithNulls("dim", NullHandling.defaultLongValue(), "count", 279L), TopNQueryRunnerTest.makeRowWithNulls("dim", 10L, "count", 93L), TopNQueryRunnerTest.makeRowWithNulls("dim", 20L, "count", 93L), TopNQueryRunnerTest.makeRowWithNulls("dim", 40L, "count", 93L), TopNQueryRunnerTest.makeRowWithNulls("dim", 50L, "count", 279L), TopNQueryRunnerTest.makeRowWithNulls("dim", 70L, "count", 279L), TopNQueryRunnerTest.makeRowWithNulls("dim", 80L, "count", 93L)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testAggregateOnDoubleNumericNull() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new DefaultDimensionSpec("doubleNumericNull", "dim", ColumnType.DOUBLE)).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.NUMERIC)).threshold(10000).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(TopNQueryRunnerTest.makeRowWithNulls("dim", NullHandling.defaultDoubleValue(), "count", 279L), TopNQueryRunnerTest.makeRowWithNulls("dim", 10.0, "count", 93L), TopNQueryRunnerTest.makeRowWithNulls("dim", 20.0, "count", 93L), TopNQueryRunnerTest.makeRowWithNulls("dim", 40.0, "count", 93L), TopNQueryRunnerTest.makeRowWithNulls("dim", 50.0, "count", 279L), TopNQueryRunnerTest.makeRowWithNulls("dim", 70.0, "count", 279L), TopNQueryRunnerTest.makeRowWithNulls("dim", 80.0, "count", 93L)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testAggregateOnFloatNumericNull() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension((DimensionSpec)new DefaultDimensionSpec("floatNumericNull", "dim", ColumnType.FLOAT)).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.NUMERIC)).threshold(10000).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(TopNQueryRunnerTest.makeRowWithNulls("dim", NullHandling.defaultFloatValue(), "count", 279L), TopNQueryRunnerTest.makeRowWithNulls("dim", Float.valueOf(10.0f), "count", 93L), TopNQueryRunnerTest.makeRowWithNulls("dim", Float.valueOf(20.0f), "count", 93L), TopNQueryRunnerTest.makeRowWithNulls("dim", Float.valueOf(40.0f), "count", 93L), TopNQueryRunnerTest.makeRowWithNulls("dim", Float.valueOf(50.0f), "count", 279L), TopNQueryRunnerTest.makeRowWithNulls("dim", Float.valueOf(70.0f), "count", 279L), TopNQueryRunnerTest.makeRowWithNulls("dim", Float.valueOf(80.0f), "count", 93L)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testExpressionAggregator() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("array_agg_distinct").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList(Arrays.asList(new ExpressionLambdaAggregatorFactory("diy_count", Collections.emptySet(), null, "0", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), "__acc + 1", "__acc + diy_count", null, null, null, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("diy_sum", (Set)ImmutableSet.of((Object)"index"), null, "0.0", null, null, Boolean.valueOf(false), Boolean.valueOf(false), "__acc + index", null, null, null, null, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("diy_decomposed_sum", (Set)ImmutableSet.of((Object)"index"), null, "0.0", "ARRAY<DOUBLE>[]", null, Boolean.valueOf(false), Boolean.valueOf(false), "__acc + index", "array_concat(__acc, diy_decomposed_sum)", null, "fold((x, acc) -> x + acc, o, 0.0)", null, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("array_agg_distinct", (Set)ImmutableSet.of((Object)"quality"), "acc", "[]", null, null, Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(acc, quality)", "array_set_add_all(acc, array_agg_distinct)", "if(array_length(o1) > array_length(o2), 1, if (array_length(o1) == array_length(o2), 0, -1))", null, null, TestExprMacroTable.INSTANCE)))).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"diy_count", (Object)837L).put((Object)"diy_sum", (Object)95606.57232284546).put((Object)"diy_decomposed_sum", (Object)95606.57232284546).put((Object)"array_agg_distinct", (Object)new String[]{"automotive", "business", "entertainment", "health", "mezzanine", "news", "premium", "technology", "travel"}).build(), ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"diy_count", (Object)186L).put((Object)"diy_sum", (Object)215679.82879638672).put((Object)"diy_decomposed_sum", (Object)215679.82879638672).put((Object)"array_agg_distinct", (Object)new String[]{"mezzanine", "premium"}).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"diy_count", (Object)186L).put((Object)"diy_sum", (Object)192046.1060180664).put((Object)"diy_decomposed_sum", (Object)192046.1060180664).put((Object)"array_agg_distinct", (Object)new String[]{"mezzanine", "premium"}).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testExpressionAggregatorComplex() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("carExpr").threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)ImmutableList.of((Object)new CardinalityAggregatorFactory("car", (List)ImmutableList.of((Object)new DefaultDimensionSpec("quality", "quality")), false), (Object)new ExpressionLambdaAggregatorFactory("carExpr", (Set)ImmutableSet.of((Object)"quality"), null, "hyper_unique()", null, null, Boolean.valueOf(false), Boolean.valueOf(false), "hyper_unique_add(quality, __acc)", "hyper_unique_add(carExpr, __acc)", null, "hyper_unique_estimate(o)", null, TestExprMacroTable.INSTANCE))).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"car", (Object)9.019833517963864).put((Object)"carExpr", (Object)9.019833517963864).build(), ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"car", (Object)2.000977198748901).put((Object)"carExpr", (Object)2.000977198748901).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"car", (Object)2.000977198748901).put((Object)"carExpr", (Object)2.000977198748901).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNAggregateTopnMetricFirst() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).context((Map)ImmutableMap.of((Object)"doAggregateTopNMetricFirst", (Object)true)).build();
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"market", (Object)"total_market", (Object)"rows", (Object)4L, (Object)"index", (Object)5351.814783, (Object)"addRowsIndexConstant", (Object)5356.814783, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"upfront", (Object)"rows", (Object)4L, (Object)"index", (Object)4875.669692, (Object)"addRowsIndexConstant", (Object)4880.669692, (Object)"uniques", (Object)2.000977198748901), ImmutableMap.of((Object)"market", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864)))));
        this.assertExpectedResults(expectedResults, query);
    }

    @Test
    public void testTopNAggregateTopnMetricFirstWithGranularity() {
        this.assumeTimeOrdered();
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.MONTH_GRAN).dimension("market").metric("last").threshold(3).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{new LongFirstAggregatorFactory("first", "index", null), new LongLastAggregatorFactory("last", "index", null)}).context((Map)ImmutableMap.of((Object)"doAggregateTopNMetricFirst", (Object)true)).build();
        List<Result<TopNResultValue>> expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-01-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"first", (Object)1000L).put((Object)"last", (Object)1127L).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"first", (Object)800L).put((Object)"last", (Object)943L).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"first", (Object)100L).put((Object)"last", (Object)155L).build()))), new Result(DateTimes.of((String)"2011-02-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"first", (Object)1203L).put((Object)"last", (Object)1292L).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"first", (Object)1667L).put((Object)"last", (Object)1101L).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"first", (Object)132L).put((Object)"last", (Object)114L).build()))), new Result(DateTimes.of((String)"2011-03-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"first", (Object)1124L).put((Object)"last", (Object)1366L).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"first", (Object)1166L).put((Object)"last", (Object)1063L).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"first", (Object)153L).put((Object)"last", (Object)125L).build()))), new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"first", (Object)1314L).put((Object)"last", (Object)1029L).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"first", (Object)1447L).put((Object)"last", (Object)780L).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"first", (Object)135L).put((Object)"last", (Object)120L).build()))));
        this.assertExpectedResults(expectedResults, query);
    }

    private void assumeTimeOrdered() {
        try (CursorHolder cursorHolder = this.runner.getSegment().asCursorFactory().makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            Assume.assumeTrue((Cursors.getTimeOrdering((List)cursorHolder.getOrdering()) == Order.ASCENDING ? 1 : 0) != 0);
        }
    }

    private static Map<String, Object> makeRowWithNulls(String dimName, @Nullable Object dimValue, String metric, @Nullable Object metricVal) {
        HashMap<String, Object> nullRow = new HashMap<String, Object>();
        nullRow.put(dimName, dimValue);
        nullRow.put(metric, metricVal);
        return nullRow;
    }
}

