/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexIndexableAdapter;
import org.apache.druid.segment.SimpleQueryableIndex;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ListIndexed;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.chrono.ISOChronology;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class IndexMergerLongestSharedDimOrderTest {
    @Mock
    Supplier<ColumnHolder> mockSupplier;
    @Mock
    ColumnHolder mockColumnHolder;
    @Mock
    SmooshedFileMapper mockSmooshedFileMapper;
    @Mock
    BitmapFactory mockBitmapFactory;

    @Before
    public void setUp() {
        Mockito.when((Object)this.mockSupplier.get()).thenReturn((Object)this.mockColumnHolder);
        Mockito.when((Object)this.mockColumnHolder.getLength()).thenReturn((Object)1);
    }

    @Test
    public void testGetLongestSharedDimOrderWithNullDimensionSpecAndEmptyIndex() {
        List actual = IndexMerger.getLongestSharedDimOrder((List)ImmutableList.of(), null);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testGetLongestSharedDimOrderWithNullDimensionSpecAndValidOrdering() {
        QueryableIndexIndexableAdapter index1 = this.makeIndexWithDimensionList((List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        QueryableIndexIndexableAdapter index2 = this.makeIndexWithDimensionList((List<String>)ImmutableList.of((Object)"b", (Object)"c"));
        List actual = IndexMerger.getLongestSharedDimOrder((List)ImmutableList.of((Object)index1, (Object)index2), null);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)ImmutableList.of((Object)"__time", (Object)"a", (Object)"b", (Object)"c"), (Object)actual);
        index1 = this.makeIndexWithDimensionList((List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        index2 = this.makeIndexWithDimensionList((List<String>)ImmutableList.of((Object)"a", (Object)"c"));
        actual = IndexMerger.getLongestSharedDimOrder((List)ImmutableList.of((Object)index1, (Object)index2), null);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)ImmutableList.of((Object)"__time", (Object)"a", (Object)"b", (Object)"c"), (Object)actual);
    }

    @Test
    public void testGetLongestSharedDimOrderWithNullDimensionSpecAndNoValidOrdering() {
        QueryableIndexIndexableAdapter index1 = this.makeIndexWithDimensionList((List<String>)ImmutableList.of((Object)"a", (Object)"b"));
        QueryableIndexIndexableAdapter index2 = this.makeIndexWithDimensionList((List<String>)ImmutableList.of((Object)"b", (Object)"c"));
        List actual = IndexMerger.getLongestSharedDimOrder((List)ImmutableList.of((Object)index1, (Object)index2), null);
        Assert.assertNull((Object)actual);
        index1 = this.makeIndexWithDimensionList((List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        index2 = this.makeIndexWithDimensionList((List<String>)ImmutableList.of((Object)"c", (Object)"b"));
        actual = IndexMerger.getLongestSharedDimOrder((List)ImmutableList.of((Object)index1, (Object)index2), null);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testGetLongestSharedDimOrderWithSchemalessDimensionSpecAndNoValidOrdering() {
        DimensionsSpec empty = new DimensionsSpec((List)ImmutableList.of());
        QueryableIndexIndexableAdapter index1 = this.makeIndexWithDimensionList((List<String>)ImmutableList.of((Object)"a", (Object)"b"));
        QueryableIndexIndexableAdapter index2 = this.makeIndexWithDimensionList((List<String>)ImmutableList.of((Object)"b", (Object)"c"));
        List actual = IndexMerger.getLongestSharedDimOrder((List)ImmutableList.of((Object)index1, (Object)index2), (DimensionsSpec)empty);
        Assert.assertNull((Object)actual);
        index1 = this.makeIndexWithDimensionList((List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        index2 = this.makeIndexWithDimensionList((List<String>)ImmutableList.of((Object)"c", (Object)"b"));
        actual = IndexMerger.getLongestSharedDimOrder((List)ImmutableList.of((Object)index1, (Object)index2), (DimensionsSpec)empty);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testGetLongestSharedDimOrderWithValidSchemaDimensionSpecAndNoValidOrdering() {
        DimensionsSpec valid = new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")));
        QueryableIndexIndexableAdapter index1 = this.makeIndexWithDimensionList((List<String>)ImmutableList.of((Object)"a", (Object)"b"));
        QueryableIndexIndexableAdapter index2 = this.makeIndexWithDimensionList((List<String>)ImmutableList.of((Object)"b", (Object)"c"));
        List actual = IndexMerger.getLongestSharedDimOrder((List)ImmutableList.of((Object)index1, (Object)index2), (DimensionsSpec)valid);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)ImmutableList.of((Object)"__time", (Object)"a", (Object)"b", (Object)"c"), (Object)actual);
    }

    @Test
    public void testGetLongestSharedDimOrderWithInvalidSchemaDimensionSpecAndNoValidOrdering() {
        DimensionsSpec valid = new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")));
        QueryableIndexIndexableAdapter index1 = this.makeIndexWithDimensionList((List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        QueryableIndexIndexableAdapter index2 = this.makeIndexWithDimensionList((List<String>)ImmutableList.of((Object)"c", (Object)"b"));
        List actual = IndexMerger.getLongestSharedDimOrder((List)ImmutableList.of((Object)index1, (Object)index2), (DimensionsSpec)valid);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testGetLongestSharedDimOrderWithValidSchemaDimensionSpecAndInvalidOrdering() {
        DimensionsSpec valid = new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")));
        QueryableIndexIndexableAdapter index1 = this.makeIndexWithDimensionList((List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        QueryableIndexIndexableAdapter index2 = this.makeIndexWithDimensionList((List<String>)ImmutableList.of((Object)"c", (Object)"b", (Object)"e"));
        List actual = IndexMerger.getLongestSharedDimOrder((List)ImmutableList.of((Object)index1, (Object)index2), (DimensionsSpec)valid);
        Assert.assertNull((Object)actual);
    }

    private QueryableIndexIndexableAdapter makeIndexWithDimensionList(List<String> dimensions) {
        return new QueryableIndexIndexableAdapter((QueryableIndex)new SimpleQueryableIndex(new Interval((Object)"2012-01-01/2012-01-02", (Chronology)ISOChronology.getInstance((DateTimeZone)DateTimes.inferTzFromString((String)"America/Los_Angeles"))), (Indexed)new ListIndexed(dimensions), this.mockBitmapFactory, (Map)ImmutableMap.of((Object)"__time", this.mockSupplier), this.mockSmooshedFileMapper, true){

            public Metadata getMetadata() {
                return null;
            }
        });
    }
}

