/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.ResourceInputSource;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.NestedDataTestUtils;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowBasedCursorFactory;
import org.apache.druid.segment.TestCursorFactory;
import org.apache.druid.segment.UnnestCursorFactory;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.FilterTestUtils;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.filter.OrFilter;
import org.apache.druid.segment.filter.SelectorFilter;
import org.apache.druid.segment.generator.GeneratorBasicSchemas;
import org.apache.druid.segment.generator.GeneratorSchemaInfo;
import org.apache.druid.segment.generator.SegmentGenerator;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexCursorFactory;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.join.PostJoinCursor;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.utils.CloseableUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class UnnestCursorFactoryTest
extends InitializedNullHandlingTest {
    @ClassRule
    public static TemporaryFolder tmp = new TemporaryFolder();
    private static Closer CLOSER;
    private static IncrementalIndex INCREMENTAL_INDEX;
    private static IncrementalIndexCursorFactory INCREMENTAL_INDEX_CURSOR_FACTORY;
    private static QueryableIndex QUERYABLE_INDEX;
    private static UnnestCursorFactory UNNEST_CURSOR_FACTORY;
    private static UnnestCursorFactory UNNEST_CURSOR_FACTORY1;
    private static UnnestCursorFactory UNNEST_ARRAYS;
    private static List<UnnestCursorFactory> CURSOR_FACTORIES;
    private static String INPUT_COLUMN_NAME;
    private static String OUTPUT_COLUMN_NAME;
    private static String OUTPUT_COLUMN_NAME1;

    @BeforeClass
    public static void setup() throws IOException {
        CLOSER = Closer.create();
        GeneratorSchemaInfo schemaInfo = (GeneratorSchemaInfo)GeneratorBasicSchemas.SCHEMA_MAP.get("expression-testbench");
        DataSegment dataSegment = DataSegment.builder().dataSource("foo").interval(schemaInfo.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        SegmentGenerator segmentGenerator = (SegmentGenerator)CLOSER.register((Closeable)new SegmentGenerator());
        int numRows = 2;
        INCREMENTAL_INDEX = (IncrementalIndex)CLOSER.register((Closeable)segmentGenerator.generateIncrementalIndex(dataSegment, schemaInfo, Granularities.HOUR, 2));
        INCREMENTAL_INDEX_CURSOR_FACTORY = new IncrementalIndexCursorFactory(INCREMENTAL_INDEX);
        UNNEST_CURSOR_FACTORY = new UnnestCursorFactory((CursorFactory)INCREMENTAL_INDEX_CURSOR_FACTORY, (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_COLUMN_NAME, "\"" + INPUT_COLUMN_NAME + "\"", null, ExprMacroTable.nil()), null);
        UNNEST_CURSOR_FACTORY1 = new UnnestCursorFactory((CursorFactory)UNNEST_CURSOR_FACTORY, (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_COLUMN_NAME1, "\"" + INPUT_COLUMN_NAME + "\"", null, ExprMacroTable.nil()), null);
        ResourceInputSource inputSource = ResourceInputSource.of(UnnestCursorFactoryTest.class.getClassLoader(), "nested-all-types-test-data.json");
        IndexBuilder bob = IndexBuilder.create().tmpDir(tmp.newFolder()).schema(IncrementalIndexSchema.builder().withTimestampSpec(NestedDataTestUtils.TIMESTAMP_SPEC).withDimensionsSpec(NestedDataTestUtils.AUTO_DISCOVERY).withQueryGranularity(Granularities.DAY).withRollup(false).withMinTimestamp(0L).build()).indexSpec(IndexSpec.DEFAULT).inputSource((InputSource)inputSource).inputFormat((InputFormat)NestedDataTestUtils.DEFAULT_JSON_INPUT_FORMAT).transform(TransformSpec.NONE).inputTmpDir(tmp.newFolder());
        QUERYABLE_INDEX = (QueryableIndex)CLOSER.register((Closeable)bob.buildMMappedIndex());
        UNNEST_ARRAYS = new UnnestCursorFactory((CursorFactory)new QueryableIndexCursorFactory(QUERYABLE_INDEX), (VirtualColumn)new ExpressionVirtualColumn("u", "\"arrayLongNulls\"", ColumnType.LONG, ExprMacroTable.nil()), null);
        CURSOR_FACTORIES = ImmutableList.of((Object)UNNEST_CURSOR_FACTORY, (Object)UNNEST_CURSOR_FACTORY1);
    }

    @AfterClass
    public static void teardown() {
        CloseableUtils.closeAndSuppressExceptions((Closeable)CLOSER, throwable -> {});
    }

    @Test
    public void test_capabilities() {
        String colName = "multi-string1";
        for (UnnestCursorFactory cursorFactory : CURSOR_FACTORIES) {
            cursorFactory.getColumnCapabilities(colName);
            Assert.assertEquals((Object)cursorFactory.getColumnCapabilities(colName).toColumnType(), (Object)INCREMENTAL_INDEX_CURSOR_FACTORY.getColumnCapabilities(colName).toColumnType());
            UnnestCursorFactoryTest.assertColumnReadsIdentifier(cursorFactory.getUnnestColumn(), colName);
        }
    }

    @Test
    public void test_unnest_factory_column_capabilities() {
        String colName = "multi-string1";
        List<String> columnsInTable = Arrays.asList("string1", "long1", "double1", "float1", "multi-string1", OUTPUT_COLUMN_NAME);
        List<ValueType> valueTypes = Arrays.asList(ValueType.STRING, ValueType.LONG, ValueType.DOUBLE, ValueType.FLOAT, ValueType.STRING, ValueType.STRING);
        UnnestCursorFactory cursorFactory = UNNEST_CURSOR_FACTORY;
        for (int i = 0; i < columnsInTable.size(); ++i) {
            ColumnCapabilities capabilities = cursorFactory.getColumnCapabilities(columnsInTable.get(i));
            Assert.assertEquals((Object)capabilities.getType(), (Object)valueTypes.get(i));
        }
        UnnestCursorFactoryTest.assertColumnReadsIdentifier(cursorFactory.getUnnestColumn(), colName);
        Assert.assertEquals((Object)cursorFactory.getColumnCapabilities(OUTPUT_COLUMN_NAME).isDictionaryEncoded(), (Object)ColumnCapabilities.Capable.TRUE);
        Assert.assertEquals((Object)cursorFactory.getColumnCapabilities(OUTPUT_COLUMN_NAME).hasMultipleValues(), (Object)ColumnCapabilities.Capable.FALSE);
    }

    @Test
    public void test_unnest_factory_basic() {
        try (CursorHolder cursorHolder = UNNEST_CURSOR_FACTORY.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            Cursor cursor = cursorHolder.asCursor();
            ColumnSelectorFactory factory = cursor.getColumnSelectorFactory();
            DimensionSelector dimSelector = factory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)OUTPUT_COLUMN_NAME));
            int count = 0;
            ArrayList<Object> rows = new ArrayList<Object>();
            while (!cursor.isDone()) {
                cursor.advance();
            }
            cursor.reset();
            while (!cursor.isDone()) {
                Object dimSelectorVal = dimSelector.getObject();
                rows.add(dimSelectorVal);
                cursor.advance();
                ++count;
            }
            Assert.assertEquals((long)count, (long)16L);
            Assert.assertEquals(Arrays.asList("0", "1", "2", "3", "4", "5", "6", "7", "10", "11", "12", "13", "14", "15", "8", "9"), rows);
        }
    }

    @Test
    public void test_unnest_factory_basic_array_column() {
        try (CursorHolder cursorHolder = UNNEST_ARRAYS.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            Cursor cursor = cursorHolder.asCursor();
            ColumnSelectorFactory factory = cursor.getColumnSelectorFactory();
            ColumnValueSelector dimSelector = factory.makeColumnValueSelector("u");
            int count = 0;
            ArrayList<Object> rows = new ArrayList<Object>();
            while (!cursor.isDone()) {
                cursor.advance();
            }
            cursor.reset();
            while (!cursor.isDone()) {
                Object dimSelectorVal = dimSelector.getObject();
                rows.add(dimSelectorVal);
                cursor.advance();
                ++count;
            }
            Assert.assertEquals((long)count, (long)12L);
            Assert.assertEquals(Arrays.asList(2L, 3L, 1L, null, 3L, 1L, null, 2L, 9L, 1L, 2L, 3L), rows);
        }
    }

    @Test
    public void test_unnest_factory_basic_row_based_array_column() {
        UnnestCursorFactory cursorFactory = new UnnestCursorFactory((CursorFactory)new RowBasedCursorFactory(Sequences.simple(Arrays.asList({1L, new Object[]{1L, 2L}}, {1L, new Object[]{3L, 4L, 5L}}, {2L, new Object[]{6L, null, 7L}}, {2L, null}, {3L, new Object[]{8L, 9L, 10L}})), (RowAdapter)new RowAdapter<Object[]>(){

            public ToLongFunction<Object[]> timestampFunction() {
                return value -> (Long)value[0];
            }

            public Function<Object[], Object> columnFunction(String columnName) {
                if ("a".equals(columnName)) {
                    return objects -> objects[1];
                }
                return null;
            }
        }, RowSignature.builder().add("arrayLongNulls", ColumnType.LONG_ARRAY).build()), (VirtualColumn)new ExpressionVirtualColumn("u", "\"a\"", ColumnType.LONG, ExprMacroTable.nil()), null);
        try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            Cursor cursor = cursorHolder.asCursor();
            ColumnSelectorFactory factory = cursor.getColumnSelectorFactory();
            ColumnValueSelector dimSelector = factory.makeColumnValueSelector("u");
            int count = 0;
            ArrayList<Object> rows = new ArrayList<Object>();
            while (!cursor.isDone()) {
                cursor.advance();
            }
            cursor.reset();
            while (!cursor.isDone()) {
                Object dimSelectorVal = dimSelector.getObject();
                rows.add(dimSelectorVal);
                cursor.advance();
                ++count;
            }
            Assert.assertEquals((long)count, (long)11L);
            Assert.assertEquals(Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, null, 7L, 8L, 9L, 10L), rows);
        }
    }

    @Test
    public void test_two_levels_of_unnest() {
        try (CursorHolder cursorHolder = UNNEST_CURSOR_FACTORY1.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            Cursor cursor = cursorHolder.asCursor();
            ColumnSelectorFactory factory = cursor.getColumnSelectorFactory();
            DimensionSelector dimSelector = factory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)OUTPUT_COLUMN_NAME1));
            ColumnValueSelector valueSelector = factory.makeColumnValueSelector(OUTPUT_COLUMN_NAME1);
            int count = 0;
            while (!cursor.isDone()) {
                Object dimSelectorVal = dimSelector.getObject();
                Object valueSelectorVal = valueSelector.getObject();
                if (dimSelectorVal == null) {
                    Assert.assertNull((Object)dimSelectorVal);
                } else if (valueSelectorVal == null) {
                    Assert.assertNull((Object)valueSelectorVal);
                }
                cursor.advance();
                ++count;
            }
            Assert.assertEquals((long)count, (long)128L);
            Assert.assertEquals((long)dimSelector.getValueCardinality(), (long)17L);
        }
    }

    @Test
    public void test_pushdown_or_filters_unnested_and_original_dimension_with_unnest() {
        TestCursorFactory testCursorFactory = new TestCursorFactory(INCREMENTAL_INDEX);
        UnnestCursorFactory cursorFactory = new UnnestCursorFactory((CursorFactory)testCursorFactory, (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_COLUMN_NAME, "\"" + INPUT_COLUMN_NAME + "\"", null, ExprMacroTable.nil()), null);
        VirtualColumn vc = cursorFactory.getUnnestColumn();
        String inputColumn = cursorFactory.getUnnestInputIfDirectAccess(vc);
        OrFilter baseFilter = new OrFilter((List)ImmutableList.of((Object)FilterTestUtils.selector(OUTPUT_COLUMN_NAME, "1"), (Object)FilterTestUtils.selector(inputColumn, "2")));
        OrFilter expectedPushDownFilter = new OrFilter((List)ImmutableList.of((Object)FilterTestUtils.selector(inputColumn, "1"), (Object)FilterTestUtils.selector(inputColumn, "2")));
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setFilter((Filter)baseFilter).build();
        try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            Filter pushDownFilter = testCursorFactory.getPushDownFilter();
            Assert.assertEquals((Object)expectedPushDownFilter, (Object)pushDownFilter);
            Assert.assertEquals(cursor.getClass(), PostJoinCursor.class);
            Filter postFilter = ((PostJoinCursor)cursor).getPostJoinFilter();
            Assert.assertEquals((Object)baseFilter, (Object)postFilter);
        }
    }

    @Test
    public void test_nested_filters_unnested_and_original_dimension_with_unnest() {
        TestCursorFactory testCursorFactory = new TestCursorFactory(INCREMENTAL_INDEX);
        UnnestCursorFactory cursorFactory = new UnnestCursorFactory((CursorFactory)testCursorFactory, (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_COLUMN_NAME, "\"" + INPUT_COLUMN_NAME + "\"", null, ExprMacroTable.nil()), null);
        VirtualColumn vc = cursorFactory.getUnnestColumn();
        String inputColumn = cursorFactory.getUnnestInputIfDirectAccess(vc);
        OrFilter baseFilter = new OrFilter((List)ImmutableList.of((Object)FilterTestUtils.selector(OUTPUT_COLUMN_NAME, "1"), (Object)new AndFilter((List)ImmutableList.of((Object)FilterTestUtils.selector(inputColumn, "2"), (Object)FilterTestUtils.selector(OUTPUT_COLUMN_NAME, "10")))));
        OrFilter expectedPushDownFilter = new OrFilter((List)ImmutableList.of((Object)FilterTestUtils.selector(inputColumn, "1"), (Object)new AndFilter((List)ImmutableList.of((Object)FilterTestUtils.selector(inputColumn, "2"), (Object)FilterTestUtils.selector(inputColumn, "10")))));
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setFilter((Filter)baseFilter).build();
        try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            Filter pushDownFilter = testCursorFactory.getPushDownFilter();
            Assert.assertEquals((Object)expectedPushDownFilter, (Object)pushDownFilter);
            Assert.assertEquals(cursor.getClass(), PostJoinCursor.class);
            Filter postFilter = ((PostJoinCursor)cursor).getPostJoinFilter();
            Assert.assertEquals((Object)baseFilter, (Object)postFilter);
        }
    }

    @Test
    public void test_nested_filters_unnested_and_topLevel1And3filtersInOR() {
        Filter testQueryFilter = Filters.and((List)ImmutableList.of((Object)FilterTestUtils.selector(OUTPUT_COLUMN_NAME, "3"), (Object)Filters.or((List)ImmutableList.of((Object)FilterTestUtils.selector("newcol", "2"), (Object)FilterTestUtils.selector(INPUT_COLUMN_NAME, "2"), (Object)FilterTestUtils.selector(OUTPUT_COLUMN_NAME, "1")))));
        this.testComputeBaseAndPostUnnestFilters(testQueryFilter, "(multi-string1 = 3 && (newcol = 2 || multi-string1 = 2 || multi-string1 = 1))", "(unnested-multi-string1 = 3 && (newcol = 2 || multi-string1 = 2 || unnested-multi-string1 = 1))");
    }

    @Test
    public void test_nested_multiLevel_filters_unnested() {
        Filter testQueryFilter = Filters.and((List)ImmutableList.of((Object)FilterTestUtils.selector(OUTPUT_COLUMN_NAME, "3"), (Object)Filters.or((List)ImmutableList.of((Object)Filters.or((List)ImmutableList.of((Object)FilterTestUtils.selector("newcol", "2"), (Object)FilterTestUtils.selector(INPUT_COLUMN_NAME, "2"), (Object)Filters.and((List)ImmutableList.of((Object)FilterTestUtils.selector("newcol", "3"), (Object)FilterTestUtils.selector(INPUT_COLUMN_NAME, "7"))))), (Object)FilterTestUtils.selector(OUTPUT_COLUMN_NAME, "1")))));
        this.testComputeBaseAndPostUnnestFilters(testQueryFilter, "(multi-string1 = 3 && (newcol = 2 || multi-string1 = 2 || (newcol = 3 && multi-string1 = 7) || multi-string1 = 1))", "(unnested-multi-string1 = 3 && (newcol = 2 || multi-string1 = 2 || (newcol = 3 && multi-string1 = 7) || unnested-multi-string1 = 1))");
    }

    @Test
    public void test_nested_multiLevel_filters_unnested5Level() {
        Filter testQueryFilter = Filters.or((List)ImmutableList.of((Object)FilterTestUtils.selector(OUTPUT_COLUMN_NAME, "3"), (Object)Filters.or((List)ImmutableList.of((Object)Filters.or((List)ImmutableList.of((Object)FilterTestUtils.selector("newcol", "2"), (Object)FilterTestUtils.selector(INPUT_COLUMN_NAME, "2"), (Object)Filters.and((List)ImmutableList.of((Object)FilterTestUtils.selector("newcol", "3"), (Object)Filters.and((List)ImmutableList.of((Object)FilterTestUtils.selector(INPUT_COLUMN_NAME, "7"), (Object)FilterTestUtils.selector("newcol_1", "10"))))))), (Object)FilterTestUtils.selector(OUTPUT_COLUMN_NAME, "1")))));
        this.testComputeBaseAndPostUnnestFilters(testQueryFilter, "(multi-string1 = 3 || newcol = 2 || multi-string1 = 2 || (newcol = 3 && multi-string1 = 7 && newcol_1 = 10) || multi-string1 = 1)", "(unnested-multi-string1 = 3 || newcol = 2 || multi-string1 = 2 || (newcol = 3 && multi-string1 = 7 && newcol_1 = 10) || unnested-multi-string1 = 1)");
    }

    @Test
    public void test_nested_filters_unnested_and_topLevelORAnd3filtersInOR() {
        Filter testQueryFilter = Filters.or((List)ImmutableList.of((Object)FilterTestUtils.selector(OUTPUT_COLUMN_NAME, "3"), (Object)Filters.and((List)ImmutableList.of((Object)FilterTestUtils.selector("newcol", "2"), (Object)FilterTestUtils.selector(INPUT_COLUMN_NAME, "2"), (Object)FilterTestUtils.selector(OUTPUT_COLUMN_NAME, "1")))));
        this.testComputeBaseAndPostUnnestFilters(testQueryFilter, "(multi-string1 = 3 || (newcol = 2 && multi-string1 = 2 && multi-string1 = 1))", "(unnested-multi-string1 = 3 || (newcol = 2 && multi-string1 = 2 && unnested-multi-string1 = 1))");
    }

    @Test
    public void test_nested_filters_unnested_and_topLevelAND3filtersInORWithNestedOrs() {
        Filter testQueryFilter = Filters.and((List)ImmutableList.of((Object)FilterTestUtils.selector(OUTPUT_COLUMN_NAME, "3"), (Object)Filters.or((List)ImmutableList.of((Object)FilterTestUtils.selector("newcol", "2"), (Object)FilterTestUtils.selector(INPUT_COLUMN_NAME, "2"))), (Object)Filters.or((List)ImmutableList.of((Object)FilterTestUtils.selector("newcol", "4"), (Object)FilterTestUtils.selector(INPUT_COLUMN_NAME, "8"), (Object)FilterTestUtils.selector(OUTPUT_COLUMN_NAME, "6")))));
        this.testComputeBaseAndPostUnnestFilters(testQueryFilter, "(multi-string1 = 3 && (newcol = 2 || multi-string1 = 2) && (newcol = 4 || multi-string1 = 8 || multi-string1 = 6))", "(unnested-multi-string1 = 3 && (newcol = 2 || multi-string1 = 2) && (newcol = 4 || multi-string1 = 8 || unnested-multi-string1 = 6))");
    }

    @Test
    public void test_nested_filters_unnested_and_topLevelAND2sdf() {
        Filter testQueryFilter = Filters.and((List)ImmutableList.of((Object)FilterTestUtils.not((Filter)FilterTestUtils.selector(OUTPUT_COLUMN_NAME, "3")), (Object)FilterTestUtils.selector(INPUT_COLUMN_NAME, "2")));
        this.testComputeBaseAndPostUnnestFilters(testQueryFilter, "multi-string1 = 2", "(~(unnested-multi-string1 = 3) && multi-string1 = 2)");
    }

    @Test
    public void test_nested_filters_unnested_and_topLevelOR2sdf() {
        Filter testQueryFilter = Filters.or((List)ImmutableList.of((Object)FilterTestUtils.not((Filter)FilterTestUtils.selector(OUTPUT_COLUMN_NAME, "3")), (Object)FilterTestUtils.selector(INPUT_COLUMN_NAME, "2")));
        this.testComputeBaseAndPostUnnestFilters(testQueryFilter, "(multi-string1 = 2)", "(~(unnested-multi-string1 = 3) || multi-string1 = 2)");
    }

    @Test
    public void test_not_pushdown_not_filter() {
        Filter testQueryFilter = Filters.and((List)ImmutableList.of((Object)FilterTestUtils.not((Filter)FilterTestUtils.selector(OUTPUT_COLUMN_NAME, "3")), (Object)Filters.or((List)ImmutableList.of((Object)Filters.or((List)ImmutableList.of((Object)FilterTestUtils.selector("newcol", "2"), (Object)FilterTestUtils.selector(INPUT_COLUMN_NAME, "2"), (Object)Filters.and((List)ImmutableList.of((Object)FilterTestUtils.selector("newcol", "3"), (Object)FilterTestUtils.selector(INPUT_COLUMN_NAME, "7"))))), (Object)FilterTestUtils.selector(OUTPUT_COLUMN_NAME, "1")))));
        this.testComputeBaseAndPostUnnestFilters(testQueryFilter, "(newcol = 2 || multi-string1 = 2 || (newcol = 3 && multi-string1 = 7) || multi-string1 = 1)", "(~(unnested-multi-string1 = 3) && (newcol = 2 || multi-string1 = 2 || (newcol = 3 && multi-string1 = 7) || unnested-multi-string1 = 1))");
    }

    @Test
    public void testPartialArrayPushdown() {
        Filter testQueryFilter = Filters.and((List)ImmutableList.of((Object)new EqualityFilter("u", ColumnType.LONG, (Object)1L, null), (Object)new EqualityFilter("str", ColumnType.STRING, (Object)"a", null), (Object)new EqualityFilter("long", ColumnType.LONG, (Object)1L, null)));
        this.testComputeBaseAndPostUnnestFilters(UNNEST_ARRAYS, testQueryFilter, "(str = a && long = 1 (LONG))", "(u = 1 (LONG) && str = a && long = 1 (LONG))");
    }

    @Test
    public void testPartialArrayPushdownNested() {
        Filter testQueryFilter = Filters.and((List)ImmutableList.of((Object)Filters.and((List)ImmutableList.of((Object)new EqualityFilter("u", ColumnType.LONG, (Object)1L, null), (Object)new EqualityFilter("str", ColumnType.STRING, (Object)"a", null))), (Object)new EqualityFilter("long", ColumnType.LONG, (Object)1L, null)));
        this.testComputeBaseAndPostUnnestFilters(UNNEST_ARRAYS, testQueryFilter, "(str = a && long = 1 (LONG))", "(u = 1 (LONG) && str = a && long = 1 (LONG))");
    }

    @Test
    public void testPartialArrayPushdown2() {
        Filter testQueryFilter = Filters.and((List)ImmutableList.of((Object)Filters.or((List)ImmutableList.of((Object)new EqualityFilter("u", ColumnType.LONG, (Object)1L, null), (Object)new EqualityFilter("str", ColumnType.STRING, (Object)"a", null))), (Object)new EqualityFilter("long", ColumnType.LONG, (Object)1L, null)));
        this.testComputeBaseAndPostUnnestFilters(UNNEST_ARRAYS, testQueryFilter, "long = 1 (LONG)", "((u = 1 (LONG) || str = a) && long = 1 (LONG))");
    }

    @Test
    public void testArrayCannotPushdown2() {
        Filter testQueryFilter = Filters.or((List)ImmutableList.of((Object)Filters.or((List)ImmutableList.of((Object)new EqualityFilter("u", ColumnType.LONG, (Object)1L, null), (Object)new EqualityFilter("str", ColumnType.STRING, (Object)"a", null))), (Object)new EqualityFilter("long", ColumnType.LONG, (Object)1L, null)));
        this.testComputeBaseAndPostUnnestFilters(UNNEST_ARRAYS, testQueryFilter, "", "(u = 1 (LONG) || str = a || long = 1 (LONG))");
    }

    @Test
    public void test_pushdown_filters_unnested_dimension_with_unnest() {
        TestCursorFactory testCursorFactory = new TestCursorFactory(INCREMENTAL_INDEX);
        SelectorDimFilter filter = new SelectorDimFilter(OUTPUT_COLUMN_NAME, "1", null);
        UnnestCursorFactory unnestCursorFactory = new UnnestCursorFactory((CursorFactory)testCursorFactory, (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_COLUMN_NAME, "\"" + INPUT_COLUMN_NAME + "\"", null, ExprMacroTable.nil()), (DimFilter)filter);
        VirtualColumn vc = unnestCursorFactory.getUnnestColumn();
        String inputColumn = unnestCursorFactory.getUnnestInputIfDirectAccess(vc);
        SelectorFilter expectedPushDownFilter = FilterTestUtils.selector(inputColumn, "1");
        try (CursorHolder cursorHolder = unnestCursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            Cursor cursor = cursorHolder.asCursor();
            Filter pushDownFilter = testCursorFactory.getPushDownFilter();
            Assert.assertEquals((Object)expectedPushDownFilter, (Object)pushDownFilter);
            Assert.assertEquals(cursor.getClass(), PostJoinCursor.class);
            Filter postFilter = ((PostJoinCursor)cursor).getPostJoinFilter();
            Assert.assertEquals((Object)filter.toFilter(), (Object)postFilter);
            int count = 0;
            while (!cursor.isDone()) {
                cursor.advance();
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
        }
    }

    @Test
    public void test_pushdown_filters_unnested_dimension_outside() {
        TestCursorFactory testCursorFactory = new TestCursorFactory(INCREMENTAL_INDEX);
        UnnestCursorFactory unnestCursorFactory = new UnnestCursorFactory((CursorFactory)testCursorFactory, (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_COLUMN_NAME, "\"" + INPUT_COLUMN_NAME + "\"", null, ExprMacroTable.nil()), null);
        VirtualColumn vc = unnestCursorFactory.getUnnestColumn();
        String inputColumn = unnestCursorFactory.getUnnestInputIfDirectAccess(vc);
        SelectorFilter expectedPushDownFilter = FilterTestUtils.selector(inputColumn, "1");
        SelectorFilter queryFilter = new SelectorFilter(OUTPUT_COLUMN_NAME, "1", null);
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setFilter((Filter)queryFilter).build();
        try (CursorHolder cursorHolder = unnestCursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            Filter pushDownFilter = testCursorFactory.getPushDownFilter();
            Assert.assertEquals((Object)expectedPushDownFilter, (Object)pushDownFilter);
            Assert.assertEquals(cursor.getClass(), PostJoinCursor.class);
            Filter postFilter = ((PostJoinCursor)cursor).getPostJoinFilter();
            Assert.assertEquals((Object)queryFilter, (Object)postFilter);
            int count = 0;
            while (!cursor.isDone()) {
                cursor.advance();
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
        }
    }

    @Test
    public void testUnnestValueMatcherValueDoesntExist() {
        String inputColumn = "multi-string5";
        GeneratorSchemaInfo schemaInfo = (GeneratorSchemaInfo)GeneratorBasicSchemas.SCHEMA_MAP.get("expression-testbench");
        DataSegment dataSegment = DataSegment.builder().dataSource("foo").interval(schemaInfo.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        SegmentGenerator segmentGenerator = (SegmentGenerator)CLOSER.register((Closeable)new SegmentGenerator());
        IncrementalIndex index = (IncrementalIndex)CLOSER.register((Closeable)segmentGenerator.generateIncrementalIndex(dataSegment, schemaInfo, Granularities.HOUR, 100));
        IncrementalIndexCursorFactory cursorFactory = new IncrementalIndexCursorFactory(index);
        UnnestCursorFactory unnestCursorFactory = new UnnestCursorFactory((CursorFactory)cursorFactory, (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_COLUMN_NAME, "\"multi-string5\"", null, ExprMacroTable.nil()), null);
        try (CursorHolder cursorHolder = unnestCursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            Cursor cursor = cursorHolder.asCursor();
            ColumnSelectorFactory factory = cursor.getColumnSelectorFactory();
            DimensionSelector dimSelector = factory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)OUTPUT_COLUMN_NAME));
            ValueMatcher matcher = dimSelector.makeValueMatcher("x");
            int count = 0;
            while (!cursor.isDone()) {
                Object dimSelectorVal = dimSelector.getObject();
                if (dimSelectorVal == null) {
                    Assert.assertNull((Object)dimSelectorVal);
                    Assert.assertTrue((boolean)matcher.matches(true));
                }
                Assert.assertFalse((boolean)matcher.matches(false));
                cursor.advance();
                ++count;
            }
            Assert.assertEquals((long)count, (long)618L);
        }
    }

    public void testComputeBaseAndPostUnnestFilters(Filter testQueryFilter, String expectedBasePushDown, String expectedPostUnnest) {
        this.testComputeBaseAndPostUnnestFilters(UNNEST_CURSOR_FACTORY, testQueryFilter, expectedBasePushDown, expectedPostUnnest);
    }

    public void testComputeBaseAndPostUnnestFilters(UnnestCursorFactory cursorFactory, Filter testQueryFilter, String expectedBasePushDown, String expectedPostUnnest) {
        String inputColumn = cursorFactory.getUnnestInputIfDirectAccess(cursorFactory.getUnnestColumn());
        VirtualColumn vc = cursorFactory.getUnnestColumn();
        Pair filterPair = cursorFactory.computeBaseAndPostUnnestFilters(testQueryFilter, null, VirtualColumns.EMPTY, inputColumn, vc.capabilities((ColumnInspector)cursorFactory, inputColumn));
        Filter actualPushDownFilter = (Filter)filterPair.lhs;
        Filter actualPostUnnestFilter = (Filter)filterPair.rhs;
        Assert.assertEquals((String)"Expects only top level child of And Filter to push down to base", (Object)expectedBasePushDown, (Object)(actualPushDownFilter == null ? "" : actualPushDownFilter.toString()));
        Assert.assertEquals((String)"Should have post unnest filter", (Object)expectedPostUnnest, (Object)(actualPostUnnestFilter == null ? "" : actualPostUnnestFilter.toString()));
    }

    private static void assertColumnReadsIdentifier(VirtualColumn column, String identifier) {
        MatcherAssert.assertThat((Object)column, (Matcher)CoreMatchers.instanceOf(ExpressionVirtualColumn.class));
        Assert.assertEquals((Object)("\"" + identifier + "\""), (Object)((ExpressionVirtualColumn)column).getExpression());
    }

    static {
        INPUT_COLUMN_NAME = "multi-string1";
        OUTPUT_COLUMN_NAME = "unnested-multi-string1";
        OUTPUT_COLUMN_NAME1 = "unnested-multi-string1-again";
    }
}

