/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.io.IOUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.Smoosh;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.druid.segment.data.ColumnCapacityExceededException;
import org.apache.druid.segment.data.ColumnarInts;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSerializer;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSupplier;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.WriteOutBytes;
import org.apache.druid.utils.CloseableUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompressedVSizeColumnarIntsSerializerTest {
    private static final int[] MAX_VALUES = new int[]{255, 65535, 0xFFFFFF, 0xFFFFFFF};
    private final SegmentWriteOutMedium segmentWriteOutMedium = new OffHeapMemorySegmentWriteOutMedium();
    private final CompressionStrategy compressionStrategy;
    private final ByteOrder byteOrder;
    private final Random rand = new Random(0L);
    private int[] vals;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public CompressedVSizeColumnarIntsSerializerTest(CompressionStrategy compressionStrategy, ByteOrder byteOrder) {
        this.compressionStrategy = compressionStrategy;
        this.byteOrder = byteOrder;
    }

    /*
     * Exception decompiling
     */
    @Parameterized.Parameters(name="{index}: compression={0}, byteOrder={1}")
    public static Iterable<Object[]> compressionStrategiesAndByteOrders() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Before
    public void setUp() {
        this.vals = null;
    }

    @After
    public void tearDown() throws Exception {
        this.segmentWriteOutMedium.close();
    }

    private void generateVals(int totalSize, int maxValue) {
        this.vals = new int[totalSize];
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = this.rand.nextInt(maxValue);
        }
    }

    private void checkSerializedSizeAndData(int chunkSize) throws Exception {
        FileSmoosher smoosher = new FileSmoosher(this.temporaryFolder.newFolder());
        String columnName = "test";
        CompressedVSizeColumnarIntsSerializer writer = new CompressedVSizeColumnarIntsSerializer("test", this.segmentWriteOutMedium, "test", this.vals.length > 0 ? Ints.max((int[])this.vals) : 0, chunkSize, this.byteOrder, this.compressionStrategy, this.segmentWriteOutMedium.getCloser());
        CompressedVSizeColumnarIntsSupplier supplierFromList = CompressedVSizeColumnarIntsSupplier.fromList((IntList)IntArrayList.wrap((int[])this.vals), (int)(this.vals.length > 0 ? Ints.max((int[])this.vals) : 0), (int)chunkSize, (ByteOrder)this.byteOrder, (CompressionStrategy)this.compressionStrategy, (Closer)this.segmentWriteOutMedium.getCloser());
        writer.open();
        for (int val : this.vals) {
            writer.addValue(val);
        }
        long writtenLength = writer.getSerializedSize();
        WriteOutBytes writeOutBytes = this.segmentWriteOutMedium.makeWriteOutBytes();
        writer.writeTo((WritableByteChannel)writeOutBytes, smoosher);
        smoosher.close();
        Assert.assertEquals((long)writtenLength, (long)supplierFromList.getSerializedSize());
        CompressedVSizeColumnarIntsSupplier supplierFromByteBuffer = CompressedVSizeColumnarIntsSupplier.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(IOUtils.toByteArray((InputStream)writeOutBytes.asInputStream())), (ByteOrder)this.byteOrder);
        ColumnarInts columnarInts = supplierFromByteBuffer.get();
        for (int i = 0; i < this.vals.length; ++i) {
            Assert.assertEquals((long)this.vals[i], (long)columnarInts.get(i));
        }
        CloseableUtils.closeAndWrapExceptions((Closeable)columnarInts);
    }

    @Test
    public void testSmallData() throws Exception {
        for (int maxValue : MAX_VALUES) {
            int maxChunkSize = CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue((int)maxValue);
            this.generateVals(this.rand.nextInt(maxChunkSize), maxValue);
            this.checkSerializedSizeAndData(maxChunkSize);
        }
    }

    @Test
    public void testLargeData() throws Exception {
        for (int maxValue : MAX_VALUES) {
            int maxChunkSize = CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue((int)maxValue);
            this.generateVals((this.rand.nextInt(5) + 5) * maxChunkSize + this.rand.nextInt(maxChunkSize), maxValue);
            this.checkSerializedSizeAndData(maxChunkSize);
        }
    }

    @Ignore
    @Test
    public void testTooManyValues() throws IOException {
        int maxValue = 0xFFFFFFF;
        int maxChunkSize = CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue((int)0xFFFFFFF);
        this.expectedException.expect(ColumnCapacityExceededException.class);
        this.expectedException.expectMessage(ColumnCapacityExceededException.formatMessage((String)"test"));
        try (SegmentWriteOutMedium segmentWriteOutMedium = TmpFileSegmentWriteOutMediumFactory.instance().makeSegmentWriteOutMedium(this.temporaryFolder.newFolder());){
            GenericIndexedWriter genericIndexed = GenericIndexedWriter.ofCompressedByteBuffers((SegmentWriteOutMedium)segmentWriteOutMedium, (String)"test", (CompressionStrategy)this.compressionStrategy, (int)80000, (Closer)segmentWriteOutMedium.getCloser());
            CompressedVSizeColumnarIntsSerializer serializer = new CompressedVSizeColumnarIntsSerializer("test", 0xFFFFFFF, maxChunkSize, this.byteOrder, this.compressionStrategy, genericIndexed, segmentWriteOutMedium.getCloser());
            serializer.open();
            long numRows = 2147483747L;
            for (long i = 0L; i < 2147483747L; ++i) {
                serializer.addValue(ThreadLocalRandom.current().nextInt(0, Integer.MAX_VALUE));
            }
        }
    }

    @Test
    public void testEmpty() throws Exception {
        this.vals = new int[0];
        this.checkSerializedSizeAndData(2);
    }

    private void checkV2SerializedSizeAndData(int chunkSize) throws Exception {
        File tmpDirectory = this.temporaryFolder.newFolder();
        FileSmoosher smoosher = new FileSmoosher(tmpDirectory);
        String columnName = "test";
        GenericIndexedWriter genericIndexed = GenericIndexedWriter.ofCompressedByteBuffers((SegmentWriteOutMedium)this.segmentWriteOutMedium, (String)"test", (CompressionStrategy)this.compressionStrategy, (int)80000, (Closer)this.segmentWriteOutMedium.getCloser());
        CompressedVSizeColumnarIntsSerializer writer = new CompressedVSizeColumnarIntsSerializer("test", this.vals.length > 0 ? Ints.max((int[])this.vals) : 0, chunkSize, this.byteOrder, this.compressionStrategy, genericIndexed, this.segmentWriteOutMedium.getCloser());
        writer.open();
        for (int val : this.vals) {
            writer.addValue(val);
        }
        SmooshedWriter channel = smoosher.addWithSmooshedWriter("test", writer.getSerializedSize());
        writer.writeTo((WritableByteChannel)channel, smoosher);
        channel.close();
        smoosher.close();
        SmooshedFileMapper mapper = Smoosh.map((File)tmpDirectory);
        CompressedVSizeColumnarIntsSupplier supplierFromByteBuffer = CompressedVSizeColumnarIntsSupplier.fromByteBuffer((ByteBuffer)mapper.mapFile("test"), (ByteOrder)this.byteOrder);
        ColumnarInts columnarInts = supplierFromByteBuffer.get();
        for (int i = 0; i < this.vals.length; ++i) {
            Assert.assertEquals((long)this.vals[i], (long)columnarInts.get(i));
        }
        CloseableUtils.closeAll((Closeable)columnarInts, (Closeable[])new Closeable[]{mapper});
    }

    @Test
    public void testMultiValueFileLargeData() throws Exception {
        for (int maxValue : MAX_VALUES) {
            int maxChunkSize = CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue((int)maxValue);
            this.generateVals((this.rand.nextInt(5) + 5) * maxChunkSize + this.rand.nextInt(maxChunkSize), maxValue);
            this.checkV2SerializedSizeAndData(maxChunkSize);
        }
    }
}

