/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.druid.segment.data.CompressedLongsReader;
import org.apache.druid.segment.data.CompressedLongsSerializer;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumn;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumnSerializer;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumnSupplier;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CompressedVariableSizeBlobColumnTest {
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testSomeValues() throws IOException {
        File tmpFile = this.tempFolder.newFolder();
        FileSmoosher smoosher = new FileSmoosher(tmpFile);
        File tmpFile2 = this.tempFolder.newFolder();
        SegmentWriteOutMedium writeOutMedium = TmpFileSegmentWriteOutMediumFactory.instance().makeSegmentWriteOutMedium(tmpFile2);
        String fileNameBase = "test";
        CompressionStrategy compressionStrategy = CompressionStrategy.LZ4;
        CompressedVariableSizedBlobColumnSerializer serializer = new CompressedVariableSizedBlobColumnSerializer("test", writeOutMedium, compressionStrategy);
        serializer.open();
        int numWritten = 0;
        ThreadLocalRandom r = ThreadLocalRandom.current();
        ArrayList<byte[]> values = new ArrayList<byte[]>();
        int i = 0;
        int offset = 0;
        while (offset < 262144) {
            byte[] value = new byte[offset];
            r.nextBytes(value);
            values.add(value);
            serializer.addValue(value);
            ++numWritten;
            offset = 1 << ++i;
        }
        SmooshedWriter writer = smoosher.addWithSmooshedWriter("test", serializer.getSerializedSize());
        serializer.writeTo((WritableByteChannel)writer, smoosher);
        writer.close();
        smoosher.close();
        SmooshedFileMapper fileMapper = SmooshedFileMapper.load((File)tmpFile);
        ByteBuffer base = fileMapper.mapFile("test");
        CompressedVariableSizedBlobColumn column = CompressedVariableSizedBlobColumnSupplier.fromByteBuffer((String)"test", (ByteBuffer)base, (ByteOrder)ByteOrder.nativeOrder(), (SmooshedFileMapper)fileMapper).get();
        for (int row = 0; row < numWritten; ++row) {
            ByteBuffer value = column.get(row);
            byte[] bytes = new byte[value.remaining()];
            value.get(bytes);
            Assert.assertArrayEquals((String)("Row " + row), (byte[])((byte[])values.get(row)), (byte[])bytes);
        }
        for (int rando = 0; rando < numWritten; ++rando) {
            int row = ThreadLocalRandom.current().nextInt(0, numWritten - 1);
            ByteBuffer value = column.get(row);
            byte[] bytes = new byte[value.remaining()];
            value.get(bytes);
            Assert.assertArrayEquals((String)("Row " + row), (byte[])((byte[])values.get(row)), (byte[])bytes);
        }
        column.close();
        fileMapper.close();
    }

    @Test
    public void testSomeValuesByteBuffers() throws IOException {
        File tmpFile = this.tempFolder.newFolder();
        FileSmoosher smoosher = new FileSmoosher(tmpFile);
        File tmpFile2 = this.tempFolder.newFolder();
        SegmentWriteOutMedium writeOutMedium = TmpFileSegmentWriteOutMediumFactory.instance().makeSegmentWriteOutMedium(tmpFile2);
        String fileNameBase = "test";
        CompressionStrategy compressionStrategy = CompressionStrategy.LZ4;
        CompressedVariableSizedBlobColumnSerializer serializer = new CompressedVariableSizedBlobColumnSerializer("test", writeOutMedium, compressionStrategy);
        serializer.open();
        int numWritten = 0;
        ThreadLocalRandom r = ThreadLocalRandom.current();
        ArrayList<byte[]> values = new ArrayList<byte[]>();
        int i = 0;
        int offset = 0;
        while (offset < 262144) {
            byte[] value = new byte[offset];
            r.nextBytes(value);
            values.add(value);
            serializer.addValue(ByteBuffer.wrap(value));
            ++numWritten;
            offset = 1 << ++i;
        }
        SmooshedWriter writer = smoosher.addWithSmooshedWriter("test", serializer.getSerializedSize());
        serializer.writeTo((WritableByteChannel)writer, smoosher);
        writer.close();
        smoosher.close();
        SmooshedFileMapper fileMapper = SmooshedFileMapper.load((File)tmpFile);
        ByteBuffer base = fileMapper.mapFile("test");
        CompressedVariableSizedBlobColumn column = CompressedVariableSizedBlobColumnSupplier.fromByteBuffer((String)"test", (ByteBuffer)base, (ByteOrder)ByteOrder.nativeOrder(), (SmooshedFileMapper)fileMapper).get();
        for (int row = 0; row < numWritten; ++row) {
            ByteBuffer value = column.get(row);
            byte[] bytes = new byte[value.remaining()];
            value.get(bytes);
            Assert.assertArrayEquals((String)("Row " + row), (byte[])((byte[])values.get(row)), (byte[])bytes);
        }
        for (int rando = 0; rando < numWritten; ++rando) {
            int row = ThreadLocalRandom.current().nextInt(0, numWritten - 1);
            ByteBuffer value = column.get(row);
            byte[] bytes = new byte[value.remaining()];
            value.get(bytes);
            Assert.assertArrayEquals((String)("Row " + row), (byte[])((byte[])values.get(row)), (byte[])bytes);
        }
        column.close();
        fileMapper.close();
    }

    @Test
    public void testLongs() throws IOException {
        File tmpFile = this.tempFolder.newFolder();
        FileSmoosher smoosher = new FileSmoosher(tmpFile);
        File tmpFile2 = this.tempFolder.newFolder();
        SegmentWriteOutMedium writeOutMedium = TmpFileSegmentWriteOutMediumFactory.instance().makeSegmentWriteOutMedium(tmpFile2);
        String fileNameBase = "test";
        CompressionStrategy compressionStrategy = CompressionStrategy.LZ4;
        CompressedLongsSerializer serializer = new CompressedLongsSerializer(writeOutMedium, compressionStrategy, writeOutMedium.getCloser());
        serializer.open();
        ThreadLocalRandom r = ThreadLocalRandom.current();
        int numWritten = 0;
        ArrayList<Long> values = new ArrayList<Long>();
        for (int i = 0; i < 5000000; ++i) {
            long l = ((Random)r).nextLong();
            values.add(l);
            serializer.add(l);
            ++numWritten;
        }
        SmooshedWriter writer = smoosher.addWithSmooshedWriter("test", serializer.getSerializedSize());
        serializer.writeTo((WritableByteChannel)writer, smoosher);
        writer.close();
        smoosher.close();
        writeOutMedium.close();
        SmooshedFileMapper fileMapper = SmooshedFileMapper.load((File)tmpFile);
        ByteBuffer base = fileMapper.mapFile("test");
        CompressedLongsReader reader = (CompressedLongsReader)CompressedLongsReader.fromByteBuffer((ByteBuffer)base, (ByteOrder)ByteOrder.nativeOrder()).get();
        for (int row = 0; row < numWritten; ++row) {
            long l = reader.get(row);
            Assert.assertEquals((String)("Row " + row), (long)((Long)values.get(row)), (long)l);
        }
        int random = 0;
        Assert.assertEquals((String)("Row " + random), (long)((Long)values.get(random)), (long)reader.get(random));
        random = 2000000;
        Assert.assertEquals((String)("Row " + random), (long)((Long)values.get(random)), (long)reader.get(random));
        random = 1000000;
        Assert.assertEquals((String)("Row " + random), (long)((Long)values.get(random)), (long)reader.get(random));
        for (int rando = 0; rando < numWritten; ++rando) {
            int row = ThreadLocalRandom.current().nextInt(0, numWritten - 1);
            long l = reader.get(row);
            Assert.assertEquals((String)("Row " + row), (long)((Long)values.get(row)), (long)l);
        }
        reader.close();
        fileMapper.close();
    }
}

