/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import org.apache.druid.segment.data.VByte;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class VByteTest {
    private final ByteOrder order;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{ByteOrder.LITTLE_ENDIAN}, (Object)new Object[]{ByteOrder.BIG_ENDIAN});
    }

    public VByteTest(ByteOrder byteOrder) {
        this.order = byteOrder;
    }

    @Test
    public void testVbyte() {
        ByteBuffer buffer = ByteBuffer.allocate(24).order(this.order);
        VByteTest.roundTrip(buffer, 0, 0, 1);
        VByteTest.roundTrip(buffer, 0, 4, 1);
        VByteTest.roundTrip(buffer, 0, 224, 2);
        VByteTest.roundTrip(buffer, 0, 1024, 2);
        VByteTest.roundTrip(buffer, 0, 8192, 2);
        VByteTest.roundTrip(buffer, 0, 16384, 3);
        VByteTest.roundTrip(buffer, 0, 65536, 3);
        VByteTest.roundTrip(buffer, 0, 0x2000000, 4);
        VByteTest.roundTrip(buffer, 0, 0x8000000, 4);
        VByteTest.roundTrip(buffer, 0, 0x10000000, 5);
        VByteTest.roundTrip(buffer, 0, Integer.MAX_VALUE, 5);
    }

    private static void roundTrip(ByteBuffer buffer, int position, int value, int expectedSize) {
        Assert.assertEquals((long)expectedSize, (long)VByte.computeIntSize((int)value));
        buffer.position(position);
        VByte.writeInt((ByteBuffer)buffer, (int)value);
        Assert.assertEquals((long)expectedSize, (long)(buffer.position() - position));
        buffer.position(position);
        Assert.assertEquals((long)value, (long)VByte.readInt((ByteBuffer)buffer));
        Assert.assertEquals((long)expectedSize, (long)(buffer.position() - position));
    }
}

