/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.JavaScriptExtractionFn;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.filter.BaseFilterTest;
import org.apache.druid.segment.filter.BoundFilter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BoundFilterTest
extends BaseFilterTest {
    private static final List<InputRow> ROWS = ImmutableList.builder().addAll((Iterable)DEFAULT_ROWS).add((Object)BoundFilterTest.makeDefaultSchemaRow("6", "-1000", ImmutableList.of((Object)"a"), null, null, 6.6, null, 10L)).add((Object)BoundFilterTest.makeDefaultSchemaRow("7", "-10.012", ImmutableList.of((Object)"d"), null, "e", null, Float.valueOf(3.0f), null)).build();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public BoundFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<CursorFactory, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, ROWS, indexBuilder, finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(BoundFilterTest.class.getName());
    }

    @Test
    public void testLexicographicMatchEverything() {
        ImmutableList filters = ImmutableList.of((Object)new BoundDimFilter("dim0", null, "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (Object)new BoundDimFilter("vdim0", null, "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (Object)new BoundDimFilter("dim1", null, "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (Object)new BoundDimFilter("vdim1", null, "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (Object)new BoundDimFilter("dim2", null, "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (Object)new BoundDimFilter("vdim2", null, "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (Object)new BoundDimFilter("dim3", null, "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (Object)new BoundDimFilter("vdim3", null, "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC));
        for (BoundDimFilter filter : filters) {
            if (filter.getDimension().equals("dim2")) {
                this.assertFilterMatchesSkipArrays((DimFilter)filter, (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
                continue;
            }
            this.assertFilterMatches((DimFilter)filter, (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        }
    }

    @Test
    public void testLexicographicMatchWithEmptyString() {
        ImmutableList filters = ImmutableList.of((Object)new BoundDimFilter("dim0", "", "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (Object)new BoundDimFilter("dim1", "", "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (Object)new BoundDimFilter("dim2", "", "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (Object)new BoundDimFilter("dim3", "", "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC));
        if (NullHandling.replaceWithDefault()) {
            for (BoundDimFilter filter : filters) {
                if (filter.getDimension().equals("dim2")) {
                    this.assertFilterMatchesSkipArrays((DimFilter)filter, (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
                    continue;
                }
                this.assertFilterMatches((DimFilter)filter, (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
            }
        } else {
            this.assertFilterMatches((DimFilter)filters.get(0), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)filters.get(1), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatchesSkipArrays((DimFilter)filters.get(2), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)filters.get(3), (List<String>)ImmutableList.of());
        }
    }

    @Test
    public void testLexicographicMatchNull() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim0", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0"));
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatchesSkipArrays((DimFilter)new BoundDimFilter("dim2", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
        } else {
            this.assertFilterMatchesSkipArrays((DimFilter)new BoundDimFilter("dim2", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"2"));
        }
    }

    @Test
    public void testLexicographicMatchMissingColumn() {
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "", null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", null, "", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
        } else {
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "", null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", null, "", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        }
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "", "", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "", "", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", null, "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        if (NullHandling.sqlCompatible()) {
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", null, "", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        } else {
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", null, "", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
        }
    }

    @Test
    public void testLexicographicMatchTooStrict() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "abc", "abc", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "abc", "abc", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "abc", "abc", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
    }

    @Test
    public void testLexicographicMatchExactlySingleValue() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "abc", "abc", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"5"));
    }

    @Test
    public void testLexicographicMatchSurroundingSingleValue() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "ab", "abd", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"5"));
    }

    @Test
    public void testLexicographicMatchNoUpperLimit() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "ab", null, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"4", (Object)"5"));
    }

    @Test
    public void testLexicographicMatchNoLowerLimit() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", null, "abd", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"5", (Object)"6", (Object)"7"));
    }

    @Test
    public void testLexicographicMatchNumbers() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "1", "3", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "1", "3", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "-1", "3", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"6", (Object)"7"));
    }

    @Test
    public void testAlphaNumericMatchNull() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim0", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"0"));
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatchesSkipArrays((DimFilter)new BoundDimFilter("dim2", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        } else {
            this.assertFilterMatchesSkipArrays((DimFilter)new BoundDimFilter("dim2", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of());
        }
    }

    @Test
    public void testAlphaNumericMatchTooStrict() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "2", "2", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "2", "2", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "2", "2", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of());
    }

    @Test
    public void testAlphaNumericMatchExactlySingleValue() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "2", "2", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"2"));
    }

    @Test
    public void testAlphaNumericMatchSurroundingSingleValue() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "1", "3", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"2"));
    }

    @Test
    public void testAlphaNumericMatchNoUpperLimit() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "1", null, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "-1", null, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"4", (Object)"5", (Object)"6", (Object)"7"));
    }

    @Test
    public void testAlphaNumericMatchNoLowerLimit() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", null, "2", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", null, "ZZZZZ", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
    }

    @Test
    public void testAlphaNumericMatchWithNegatives() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "-2000", "3", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "3", "-2000", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"1", (Object)"6", (Object)"7"));
    }

    @Test
    public void testNumericMatchNull() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim0", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"0"));
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatchesSkipArrays((DimFilter)new BoundDimFilter("dim2", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        } else {
            this.assertFilterMatchesSkipArrays((DimFilter)new BoundDimFilter("dim2", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of());
        }
    }

    @Test
    public void testNumericMatchTooStrict() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "2", "2", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "2", "2", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "2", "2", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of());
    }

    @Test
    public void testNumericMatchVirtualColumn() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("expr", "1", "2", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("expr", "2", "3", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of());
    }

    @Test
    public void testListFilteredVirtualColumn() {
        this.assertFilterMatchesSkipVectorize((DimFilter)new BoundDimFilter("allow-dim0", "0", "2", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)new BoundDimFilter("allow-dim0", "0", "6", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"3", (Object)"4"));
        this.assertFilterMatchesSkipVectorize((DimFilter)new BoundDimFilter("allow-dim0", null, "6", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        this.assertFilterMatchesSkipVectorize((DimFilter)new BoundDimFilter("deny-dim0", "0", "6", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"5", (Object)"6"));
        this.assertFilterMatchesSkipVectorize((DimFilter)new BoundDimFilter("deny-dim0", "3", "4", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)new BoundDimFilter("deny-dim0", null, "6", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6"));
        if (this.isAutoSchema()) {
            return;
        }
        this.assertFilterMatchesSkipVectorize((DimFilter)new BoundDimFilter("allow-dim2", "a", "c", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"3", (Object)"6"));
        this.assertFilterMatchesSkipVectorize((DimFilter)new BoundDimFilter("allow-dim2", "c", "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)new BoundDimFilter("allow-dim2", null, "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        this.assertFilterMatchesSkipVectorize((DimFilter)new BoundDimFilter("deny-dim2", "a", "b", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)new BoundDimFilter("deny-dim2", "c", "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"4", (Object)"7"));
        this.assertFilterMatchesSkipVectorize((DimFilter)new BoundDimFilter("deny-dim2", null, "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
    }

    @Test
    public void testNumericMatchExactlySingleValue() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "2", "2", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "-10.012", "-10.012", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"7"));
    }

    @Test
    public void testNumericMatchSurroundingSingleValue() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "1", "3", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "-11", "-10", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"7"));
    }

    @Test
    public void testNumericMatchNoUpperLimit() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "1", null, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2"));
    }

    @Test
    public void testNumericMatchNoLowerLimit() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", null, "2", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"0", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
    }

    @Test
    public void testNumericMatchWithNegatives() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "-2000", "3", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"6", (Object)"7"));
    }

    @Test
    public void testMatchWithExtractionFn() {
        String extractionJsFn = "function(str) { return 'super-' + str; }";
        JavaScriptExtractionFn superFn = new JavaScriptExtractionFn(extractionJsFn, false, JavaScriptConfig.getEnabledInstance());
        String nullJsFn = "function(str) { return null; }";
        JavaScriptExtractionFn makeNullFn = new JavaScriptExtractionFn(nullJsFn, false, JavaScriptConfig.getEnabledInstance());
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim0", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)makeNullFn, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        } else {
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim0", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)makeNullFn, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
        }
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "super-ab", "super-abd", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"5"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "super-0", "super-10", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), (ExtractionFn)superFn, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3"));
        this.assertFilterMatchesSkipArrays((DimFilter)new BoundDimFilter("dim2", "super-", "super-zzzzzz", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatchesSkipArrays((DimFilter)new BoundDimFilter("dim2", "super-null", "super-null", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
            this.assertFilterMatchesSkipArrays((DimFilter)new BoundDimFilter("dim2", "super-null", "super-null", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
        } else {
            this.assertFilterMatchesSkipArrays((DimFilter)new BoundDimFilter("dim2", "super-null", "super-null", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
            this.assertFilterMatchesSkipArrays((DimFilter)new BoundDimFilter("dim2", "super-", "super-", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatchesSkipArrays((DimFilter)new BoundDimFilter("dim2", "super-null", "super-null", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
            this.assertFilterMatchesSkipArrays((DimFilter)new BoundDimFilter("dim2", "super-", "super-", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2"));
        }
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "super-null", "super-null", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim4", "super-null", "super-null", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim4", "super-null", "super-null", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
    }

    @Test
    public void testNumericNullsAndZeros() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("d0", "0.0", "1.0", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)(this.canTestNumericNullsAsDefaultValues ? ImmutableList.of((Object)"0", (Object)"2", (Object)"7") : ImmutableList.of((Object)"0")));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("f0", "0.0", "1.0", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)(this.canTestNumericNullsAsDefaultValues ? ImmutableList.of((Object)"0", (Object)"4", (Object)"6") : ImmutableList.of((Object)"0")));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("l0", "0.0", "1.0", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)(NullHandling.replaceWithDefault() && this.canTestNumericNullsAsDefaultValues ? ImmutableList.of((Object)"0", (Object)"3", (Object)"7") : ImmutableList.of((Object)"0")));
    }

    @Test
    public void testVirtualNumericNullsAndZeros() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("vd0", "0.0", "1.0", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)(this.canTestNumericNullsAsDefaultValues ? ImmutableList.of((Object)"0", (Object)"2", (Object)"7") : ImmutableList.of((Object)"0")));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("vf0", "0.0", "1.0", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)(this.canTestNumericNullsAsDefaultValues ? ImmutableList.of((Object)"0", (Object)"4", (Object)"6") : ImmutableList.of((Object)"0")));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("vl0", "0.0", "1.0", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)(NullHandling.replaceWithDefault() && this.canTestNumericNullsAsDefaultValues ? ImmutableList.of((Object)"0", (Object)"3", (Object)"7") : ImmutableList.of((Object)"0")));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("vd0-nvl-2", "0", null, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)"1", (Object)"3", (Object)"4", (Object)"5", (Object)"6") : ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7")));
    }

    @Test
    public void testNumericNulls() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("f0", "1.0", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"5", (Object)"7"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("d0", "1", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"1", (Object)"3", (Object)"4", (Object)"5", (Object)"6"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("l0", "1", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"5", (Object)"6"));
    }

    @Test
    public void testRequiredColumnRewrite() {
        BoundFilter filter = new BoundFilter(new BoundDimFilter("dim0", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC));
        BoundFilter filter2 = new BoundFilter(new BoundDimFilter("dim1", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC));
        Assert.assertTrue((boolean)filter.supportsRequiredColumnRewrite());
        Assert.assertTrue((boolean)filter2.supportsRequiredColumnRewrite());
        Filter rewrittenFilter = filter.rewriteRequiredColumns((Map)ImmutableMap.of((Object)"dim0", (Object)"dim1"));
        Assert.assertEquals((Object)filter2, (Object)rewrittenFilter);
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Received a non-applicable rewrite: {invalidName=dim1}, filter's dimension: dim0");
        filter.rewriteRequiredColumns((Map)ImmutableMap.of((Object)"invalidName", (Object)"dim1"));
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(BoundFilter.class).usingGetClass().withNonnullFields(new String[]{"boundDimFilter"}).verify();
    }

    @Test
    public void test_equals_boundDimFilterDruidPredicateFactory() {
        EqualsVerifier.forClass(BoundFilter.BoundDimFilterDruidPredicateFactory.class).usingGetClass().withIgnoredFields(new String[]{"longPredicateSupplier", "floatPredicateSupplier", "doublePredicateSupplier"}).verify();
    }
}

