/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.filter.TrueDimFilter;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.filter.AndFilterTest;
import org.apache.druid.segment.filter.BaseFilterTest;
import org.apache.druid.segment.filter.OrFilter;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OrFilterTest
extends BaseFilterTest {
    private static final String TIMESTAMP_COLUMN = "timestamp";
    private static final InputRowParser<Map<String, Object>> PARSER = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("timestamp", "iso", DateTimes.of((String)"2000")), DimensionsSpec.EMPTY));
    private static final List<InputRow> ROWS = ImmutableList.of(PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"0", (Object)"dim1", (Object)"0")).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"1", (Object)"dim1", (Object)"0")).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"2", (Object)"dim1", (Object)"0")).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"3", (Object)"dim1", (Object)"0")).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"4", (Object)"dim1", (Object)"0")).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"5", (Object)"dim1", (Object)"0")).get(0));

    public OrFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<CursorFactory, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, ROWS, indexBuilder, finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(AndFilterTest.class.getName());
    }

    @Test
    public void testOneFilterMatchSome() {
        this.assertFilterMatches((DimFilter)new OrDimFilter((List)ImmutableList.of((Object)new SelectorDimFilter("dim0", "1", null))), (List<String>)ImmutableList.of((Object)"1"));
    }

    @Test
    public void testOneFilterMatchAll() {
        this.assertFilterMatches((DimFilter)new OrDimFilter((List)ImmutableList.of((Object)new SelectorDimFilter("dim1", "0", null))), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
    }

    @Test
    public void testOneFilterMatchNone() {
        this.assertFilterMatches((DimFilter)new OrDimFilter((List)ImmutableList.of((Object)new SelectorDimFilter("dim1", "7", null))), (List<String>)ImmutableList.of());
    }

    @Test
    public void testTwoFilterFirstMatchesAllSecondMatchesNone() {
        this.assertFilterMatches((DimFilter)new OrDimFilter((List)ImmutableList.of((Object)new SelectorDimFilter("dim1", "0", null), (Object)new SelectorDimFilter("dim0", "7", null))), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
    }

    @Test
    public void testTwoFilterFirstMatchesNoneSecondMatchesAll() {
        this.assertFilterMatches((DimFilter)new OrDimFilter((List)ImmutableList.of((Object)new SelectorDimFilter("dim0", "7", null), (Object)new SelectorDimFilter("dim1", "0", null))), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
    }

    @Test
    public void testTwoFilterFirstMatchesNoneSecondLiterallyTrue() {
        this.assertFilterMatches((DimFilter)new OrDimFilter((List)ImmutableList.of((Object)new SelectorDimFilter("dim0", "7", null), (Object)TrueDimFilter.instance())), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
    }

    @Test
    public void testTwoFilterFirstMatchesAllSecondMatchesAll() {
        this.assertFilterMatches((DimFilter)new OrDimFilter((List)ImmutableList.of((Object)new SelectorDimFilter("dim1", "0", null), (Object)new NotDimFilter((DimFilter)new SelectorDimFilter("dim0", "7", null)))), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
    }

    @Test
    public void testTwoFilterFirstLiterallyTrueSecondMatchesAll() {
        this.assertFilterMatches((DimFilter)new OrDimFilter((List)ImmutableList.of((Object)TrueDimFilter.instance(), (Object)new NotDimFilter((DimFilter)new SelectorDimFilter("dim0", "7", null)))), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
    }

    @Test
    public void testTwoFilterFirstMatchesSomeSecondMatchesNone() {
        this.assertFilterMatches((DimFilter)new OrDimFilter((List)ImmutableList.of((Object)new SelectorDimFilter("dim0", "3", null), (Object)new SelectorDimFilter("dim1", "7", null))), (List<String>)ImmutableList.of((Object)"3"));
    }

    @Test
    public void testTwoFilterFirstMatchesNoneSecondMatchesSome() {
        this.assertFilterMatches((DimFilter)new OrDimFilter((List)ImmutableList.of((Object)new SelectorDimFilter("dim1", "7", null), (Object)new SelectorDimFilter("dim0", "3", null))), (List<String>)ImmutableList.of((Object)"3"));
    }

    @Test
    public void testTwoFilterFirstMatchesNoneSecondMatchesNone() {
        this.assertFilterMatches((DimFilter)new OrDimFilter((List)ImmutableList.of((Object)new SelectorDimFilter("dim1", "7", null), (Object)new SelectorDimFilter("dim0", "7", null))), (List<String>)ImmutableList.of());
    }

    @Test
    public void testThreeFilterFirstMatchesSomeSecondLiterallyTrueThirdMatchesNone() {
        this.assertFilterMatches((DimFilter)new AndDimFilter(new DimFilter[]{new InDimFilter("dim0", (Set)ImmutableSet.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5")), new OrDimFilter((List)ImmutableList.of((Object)new SelectorDimFilter("dim0", "4", null), (Object)TrueDimFilter.instance(), (Object)new SelectorDimFilter("dim0", "7", null)))}), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(OrDimFilter.class).usingGetClass().withIgnoredFields(new String[]{"optimizedFilterIncludeUnknown", "optimizedFilterNoIncludeUnknown"}).verify();
        EqualsVerifier.forClass(OrFilter.class).usingGetClass().withNonnullFields(new String[]{"filters"}).verify();
    }
}

