/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.CloseableDefaultBlockingPool;
import org.apache.druid.collections.CloseableStupidPool;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.JavaScriptAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DimFilters;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByResourcesReservationPool;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.query.topn.TopNQueryEngine;
import org.apache.druid.query.topn.TopNResultValue;
import org.apache.druid.segment.CloserRule;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.IncrementalIndexTimeBoundaryInspector;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.filter.SelectorFilter;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexCreator;
import org.apache.druid.segment.incremental.IncrementalIndexCursorFactory;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.segment.index.AllTrueBitmapColumnIndex;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IncrementalIndexCursorFactoryTest
extends InitializedNullHandlingTest {
    public final IncrementalIndexCreator indexCreator;
    private final GroupingEngine groupingEngine;
    private final TopNQueryEngine topnQueryEngine;
    private final NonBlockingPool<ByteBuffer> nonBlockingPool;
    public final boolean sortByDim;
    @Rule
    public final CloserRule closer = new CloserRule(false);

    public IncrementalIndexCursorFactoryTest(String indexType, boolean sortByDim) throws JsonProcessingException {
        BuiltInTypesModule.registerHandlersAndSerde();
        this.sortByDim = sortByDim;
        this.indexCreator = this.closer.closeLater(new IncrementalIndexCreator(indexType, (builder, args) -> {
            DimensionsSpec dimensionsSpec = sortByDim ? DimensionsSpec.builder().setDimensions(Collections.singletonList(new StringDimensionSchema("billy"))).setForceSegmentSortByTime(Boolean.valueOf(false)).setIncludeAllDimensions(true).build() : DimensionsSpec.EMPTY;
            return builder.setIndexSchema(IncrementalIndexSchema.builder().withDimensionsSpec(dimensionsSpec).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).build()).setMaxRowCount(1000).build();
        }));
        this.nonBlockingPool = (NonBlockingPool)this.closer.closeLater(new CloseableStupidPool("GroupByQueryEngine-bufferPool", () -> ByteBuffer.allocate(50000)));
        this.groupingEngine = new GroupingEngine(new DruidProcessingConfig(), GroupByQueryConfig::new, new GroupByResourcesReservationPool((BlockingPool)this.closer.closeLater(new CloseableDefaultBlockingPool(() -> ByteBuffer.allocate(50000), 5)), new GroupByQueryConfig()), TestHelper.makeJsonMapper(), TestHelper.makeSmileMapper(), (query, future) -> {});
        this.topnQueryEngine = new TopNQueryEngine(this.nonBlockingPool);
    }

    @Parameterized.Parameters(name="{index}: {0}, sortByDim: {1}")
    public static Collection<?> constructorFeeder() {
        return IncrementalIndexCreator.indexTypeCartesianProduct(new Collection[]{ImmutableList.of((Object)true, (Object)false)});
    }

    @Test
    public void testSanity() throws Exception {
        IncrementalIndex index = this.indexCreator.createIndex(new Object[0]);
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)"hi")));
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, Collections.singletonList("sally"), (Map)ImmutableMap.of((Object)"sally", (Object)"bo")));
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(new Interval((ReadableInstant)DateTimes.EPOCH, (ReadableInstant)DateTimes.nowUtc())).addDimension("billy").addDimension("sally").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("cnt", "cnt")).addOrderByColumn("billy").build();
        IncrementalIndexCursorFactory cursorFactory = new IncrementalIndexCursorFactory(index);
        Sequence rows = this.groupingEngine.process(query, (CursorFactory)cursorFactory, (TimeBoundaryInspector)new IncrementalIndexTimeBoundaryInspector(index), this.nonBlockingPool, null);
        List results = rows.toList();
        Assert.assertEquals((long)2L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Assert.assertArrayEquals((Object[])new Object[]{NullHandling.defaultStringValue(), "bo", 1L}, (Object[])row.getArray());
        row = (ResultRow)results.get(1);
        Assert.assertArrayEquals((Object[])new Object[]{"hi", NullHandling.defaultStringValue(), 1L}, (Object[])row.getArray());
    }

    @Test
    public void testObjectColumnSelectorOnVaryingColumnSchema() throws Exception {
        IncrementalIndex index = this.indexCreator.createIndex(new Object[0]);
        index.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2014-09-01T00:00:00"), Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)"hi")));
        index.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2014-09-01T01:00:00"), (List)Lists.newArrayList((Object[])new String[]{"billy", "sally"}), (Map)ImmutableMap.of((Object)"billy", (Object)"hip", (Object)"sally", (Object)"hop")));
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(new Interval((ReadableInstant)DateTimes.EPOCH, (ReadableInstant)DateTimes.nowUtc())).addDimension("billy").addDimension("sally").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("cnt", "cnt")).addAggregator((AggregatorFactory)new JavaScriptAggregatorFactory("fieldLength", Arrays.asList("sally", "billy"), "function(current, s, b) { return current + (s == null ? 0 : s.length) + (b == null ? 0 : b.length); }", "function() { return 0; }", "function(a,b) { return a + b; }", JavaScriptConfig.getEnabledInstance())).addOrderByColumn("billy").build();
        IncrementalIndexCursorFactory cursorFactory = new IncrementalIndexCursorFactory(index);
        Sequence rows = this.groupingEngine.process(query, (CursorFactory)cursorFactory, (TimeBoundaryInspector)new IncrementalIndexTimeBoundaryInspector(index), this.nonBlockingPool, null);
        List results = rows.toList();
        Assert.assertEquals((long)2L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Assert.assertArrayEquals((Object[])new Object[]{"hi", NullHandling.defaultStringValue(), 1L, 2.0}, (Object[])row.getArray());
        row = (ResultRow)results.get(1);
        Assert.assertArrayEquals((Object[])new Object[]{"hip", "hop", 1L, 6.0}, (Object[])row.getArray());
    }

    @Test
    public void testResetSanity() throws IOException {
        Assume.assumeFalse((boolean)this.sortByDim);
        IncrementalIndex index = this.indexCreator.createIndex(new Object[0]);
        DateTime t = DateTimes.nowUtc();
        Interval interval = new Interval((ReadableInstant)t.minusMinutes(1), (ReadableInstant)t.plusMinutes(1));
        index.add((InputRow)new MapBasedInputRow(t.minus(1L).getMillis(), Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)"hi")));
        index.add((InputRow)new MapBasedInputRow(t.minus(1L).getMillis(), Collections.singletonList("sally"), (Map)ImmutableMap.of((Object)"sally", (Object)"bo")));
        IncrementalIndexCursorFactory cursorFactory = new IncrementalIndexCursorFactory(index);
        for (boolean descending : Arrays.asList(false, true)) {
            CursorBuildSpec buildSpec = CursorBuildSpec.builder().setFilter((Filter)new SelectorFilter("sally", "bo")).setInterval(interval).setPreferredOrdering(descending ? Cursors.descendingTimeOrder() : Cursors.ascendingTimeOrder()).build();
            CursorHolder cursorHolder = cursorFactory.makeCursorHolder(buildSpec);
            Throwable throwable = null;
            try {
                Cursor cursor = cursorHolder.asCursor();
                DimensionSelector dimSelector = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("sally", "sally"));
                Assert.assertEquals((Object)"bo", (Object)dimSelector.lookupName(dimSelector.getRow().get(0)));
                index.add((InputRow)new MapBasedInputRow(t.minus(1L).getMillis(), Collections.singletonList("sally"), (Map)ImmutableMap.of((Object)"sally", (Object)"ah")));
                cursor.reset();
                dimSelector = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("sally", "sally"));
                Assert.assertEquals((Object)"bo", (Object)dimSelector.lookupName(dimSelector.getRow().get(0)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cursorHolder == null) continue;
                if (throwable != null) {
                    try {
                        cursorHolder.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                cursorHolder.close();
            }
        }
    }

    @Test
    public void testSingleValueTopN() throws IOException {
        IncrementalIndex index = this.indexCreator.createIndex(new Object[0]);
        DateTime t = DateTimes.nowUtc();
        index.add((InputRow)new MapBasedInputRow(t.minus(1L).getMillis(), Collections.singletonList("sally"), (Map)ImmutableMap.of((Object)"sally", (Object)"bo")));
        List results = this.topnQueryEngine.query(new TopNQueryBuilder().dataSource("test").granularity(Granularities.ALL).intervals(Collections.singletonList(new Interval((ReadableInstant)DateTimes.EPOCH, (ReadableInstant)DateTimes.nowUtc()))).dimension("sally").metric("cnt").threshold(10).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("cnt", "cnt")}).build(), (Segment)new IncrementalIndexSegment(index, SegmentId.dummy((String)"test")), null).toList();
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)results));
        Assert.assertEquals((long)1L, (long)((TopNResultValue)((Result)results.iterator().next()).getValue()).getValue().size());
    }

    @Test
    public void testFilterByNull() throws Exception {
        IncrementalIndex index = this.indexCreator.createIndex(new Object[0]);
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)"hi")));
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, Collections.singletonList("sally"), (Map)ImmutableMap.of((Object)"sally", (Object)"bo")));
        GroupByQuery query = GroupByQuery.builder().setDataSource("test").setGranularity(Granularities.ALL).setInterval(new Interval((ReadableInstant)DateTimes.EPOCH, (ReadableInstant)DateTimes.nowUtc())).addDimension("billy").addDimension("sally").addAggregator((AggregatorFactory)new LongSumAggregatorFactory("cnt", "cnt")).setDimFilter((DimFilter)DimFilters.dimEquals((String)"sally", (String)null)).build();
        IncrementalIndexCursorFactory cursorFactory = new IncrementalIndexCursorFactory(index);
        Sequence rows = this.groupingEngine.process(query, (CursorFactory)cursorFactory, (TimeBoundaryInspector)new IncrementalIndexTimeBoundaryInspector(index), this.nonBlockingPool, null);
        List results = rows.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Assert.assertArrayEquals((Object[])new Object[]{"hi", NullHandling.defaultStringValue(), 1L}, (Object[])row.getArray());
    }

    @Test
    public void testCursoringAndIndexUpdationInterleaving() throws Exception {
        IncrementalIndex index = this.indexCreator.createIndex(new Object[0]);
        long timestamp = System.currentTimeMillis();
        for (int i2 = 0; i2 < 2; ++i2) {
            index.add((InputRow)new MapBasedInputRow(timestamp, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)("v1" + i2))));
        }
        IncrementalIndexCursorFactory cursorFactory = new IncrementalIndexCursorFactory(index);
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setInterval(Intervals.utc((long)(timestamp - 60000L), (long)(timestamp + 60000L))).build();
        try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            DimensionSelector dimSelector = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("billy", "billy"));
            int cardinality = dimSelector.getValueCardinality();
            try {
                for (int i3 = 0; i3 < 1; ++i3) {
                    index.add((InputRow)new MapBasedInputRow(timestamp, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)("v2" + i3))));
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            int rowNumInCursor = 0;
            while (!cursor.isDone()) {
                IndexedInts row = dimSelector.getRow();
                row.forEach(i -> Assert.assertTrue((i < cardinality ? 1 : 0) != 0));
                cursor.advance();
                ++rowNumInCursor;
            }
            Assert.assertEquals((long)2L, (long)rowNumInCursor);
        }
    }

    @Test
    public void testCursorDictionaryRaceConditionFix() throws Exception {
        IncrementalIndex index = this.indexCreator.createIndex(new Object[0]);
        long timestamp = System.currentTimeMillis();
        for (int i2 = 0; i2 < 5; ++i2) {
            index.add((InputRow)new MapBasedInputRow(timestamp, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)("v1" + i2))));
        }
        IncrementalIndexCursorFactory cursorFactory = new IncrementalIndexCursorFactory(index);
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setFilter((Filter)new DictionaryRaceTestFilter(index, timestamp)).setInterval(Intervals.utc((long)(timestamp - 60000L), (long)(timestamp + 60000L))).build();
        try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            DimensionSelector dimSelector = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("billy", "billy"));
            int cardinality = dimSelector.getValueCardinality();
            int rowNumInCursor = 0;
            while (!cursor.isDone()) {
                IndexedInts row = dimSelector.getRow();
                row.forEach(i -> Assert.assertTrue((i < cardinality ? 1 : 0) != 0));
                cursor.advance();
                ++rowNumInCursor;
            }
            Assert.assertEquals((long)5L, (long)rowNumInCursor);
        }
    }

    @Test
    public void testCursoringAndSnapshot() throws Exception {
        IncrementalIndex index = this.indexCreator.createIndex(new Object[0]);
        long timestamp = System.currentTimeMillis();
        ImmutableList rows = ImmutableList.of((Object)new MapBasedInputRow(timestamp, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)"v00")), (Object)new MapBasedInputRow(timestamp, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)"v01")), (Object)new MapBasedInputRow(timestamp, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)"v1")), (Object)new MapBasedInputRow(timestamp, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)"v2")), (Object)new MapBasedInputRow(timestamp, Collections.singletonList("billy2"), (Map)ImmutableMap.of((Object)"billy2", (Object)"v3")), (Object)new MapBasedInputRow(timestamp, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)"v3")), (Object)new MapBasedInputRow(timestamp, Collections.singletonList("billy3"), (Map)ImmutableMap.of((Object)"billy3", (Object)"")));
        for (int i2 = 0; i2 < 2; ++i2) {
            index.add((InputRow)rows.get(i2));
        }
        IncrementalIndexCursorFactory cursorFactory = new IncrementalIndexCursorFactory(index);
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setInterval(Intervals.utc((long)(timestamp - 60000L), (long)(timestamp + 60000L))).build();
        try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            DimensionSelector dimSelector1A = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("billy", "billy"));
            int cardinalityA = dimSelector1A.getValueCardinality();
            try {
                index.add((InputRow)rows.get(2));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            DimensionSelector dimSelector1B = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("billy", "billy"));
            try {
                index.add((InputRow)rows.get(3));
                index.add((InputRow)rows.get(4));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            DimensionSelector dimSelector1C = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("billy", "billy"));
            DimensionSelector dimSelector2D = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("billy2", "billy2"));
            try {
                index.add((InputRow)rows.get(5));
                index.add((InputRow)rows.get(6));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            DimensionSelector dimSelector3E = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("billy3", "billy3"));
            int rowNumInCursor = 0;
            while (!cursor.isDone()) {
                IndexedInts rowA = dimSelector1A.getRow();
                rowA.forEach(i -> Assert.assertTrue((i < cardinalityA ? 1 : 0) != 0));
                IndexedInts rowB = dimSelector1B.getRow();
                rowB.forEach(i -> Assert.assertTrue((i < cardinalityA ? 1 : 0) != 0));
                IndexedInts rowC = dimSelector1C.getRow();
                rowC.forEach(i -> Assert.assertTrue((i < cardinalityA ? 1 : 0) != 0));
                IndexedInts rowD = dimSelector2D.getRow();
                Assert.assertEquals((long)0L, (long)rowD.size());
                IndexedInts rowE = dimSelector3E.getRow();
                if (NullHandling.replaceWithDefault()) {
                    Assert.assertEquals((long)1L, (long)rowE.size());
                    Assert.assertEquals((long)0L, (long)rowE.get(0));
                } else {
                    Assert.assertEquals((long)0L, (long)rowE.size());
                }
                cursor.advance();
                ++rowNumInCursor;
            }
            Assert.assertEquals((long)2L, (long)rowNumInCursor);
        }
    }

    private static class DictionaryRaceTestFilter
    implements Filter {
        private final IncrementalIndex index;
        private final long timestamp;

        private DictionaryRaceTestFilter(IncrementalIndex index, long timestamp) {
            this.index = index;
            this.timestamp = timestamp;
        }

        @Nullable
        public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
            return new AllTrueBitmapColumnIndex(selector);
        }

        public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
            return Filters.makeValueMatcher((ColumnSelectorFactory)factory, (String)"billy", (DruidPredicateFactory)new DictionaryRaceTestFilterDruidPredicateFactory());
        }

        public Set<String> getRequiredColumns() {
            return Collections.emptySet();
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        private class DictionaryRaceTestFilterDruidPredicateFactory
        implements DruidPredicateFactory {
            private DictionaryRaceTestFilterDruidPredicateFactory() {
            }

            public DruidObjectPredicate<String> makeStringPredicate() {
                try {
                    DictionaryRaceTestFilter.this.index.add((InputRow)new MapBasedInputRow(DictionaryRaceTestFilter.this.timestamp, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)"v31234")));
                }
                catch (IndexSizeExceededException isee) {
                    throw new RuntimeException(isee);
                }
                return DruidObjectPredicate.alwaysTrue();
            }

            public DruidLongPredicate makeLongPredicate() {
                throw new UnsupportedOperationException();
            }

            public DruidFloatPredicate makeFloatPredicate() {
                throw new UnsupportedOperationException();
            }

            public DruidDoublePredicate makeDoublePredicate() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

