/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.filter.FalseFilter;
import org.apache.druid.segment.filter.SelectorFilter;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinPrefixUtils;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.segment.join.NoopJoinableFactory;
import org.apache.druid.segment.join.lookup.LookupJoinable;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.IndexedTableJoinable;
import org.apache.druid.segment.join.table.RowBasedIndexedTable;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class JoinableFactoryWrapperTest
extends InitializedNullHandlingTest {
    public static final JoinableFactoryWrapper NOOP_JOINABLE_FACTORY_WRAPPER = new JoinableFactoryWrapper((JoinableFactory)NoopJoinableFactory.INSTANCE);
    private static final Map<String, String> TEST_LOOKUP = ImmutableMap.builder().put((Object)"MX", (Object)"Mexico").put((Object)"NO", (Object)"Norway").put((Object)"SV", (Object)"El Salvador").put((Object)"US", (Object)"United States").put((Object)"", (Object)"Empty key").build();
    private static final Set<String> TEST_LOOKUP_KEYS = NullHandling.sqlCompatible() ? TEST_LOOKUP.keySet() : Sets.difference(TEST_LOOKUP.keySet(), Collections.singleton(""));
    private static final InlineDataSource INDEXED_TABLE_DS = InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{"Mexico"}, (Object)new Object[]{"Norway"}, (Object)new Object[]{"El Salvador"}, (Object)new Object[]{"United States"}, (Object)new Object[]{"United States"}), (RowSignature)RowSignature.builder().add("country", ColumnType.STRING).build());
    private static final InlineDataSource INDEXED_TABLE_DS_THREE_COLS = InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{"El Salvador", 1, 1.0}, (Object)new Object[]{"Mexico", 2, 2.0}, (Object)new Object[]{"United States", 3, 3.0}, (Object)new Object[]{"Norway", 4, 4.0}, (Object)new Object[]{"India", 5, 5.0}, (Object)new Object[]{"United States", 6, 3.0}), (RowSignature)RowSignature.builder().add("country", ColumnType.STRING).add("m1", ColumnType.LONG).add("m2", ColumnType.DOUBLE).build());
    private static final InlineDataSource INDEXED_TABLE_DS_ONE_ROW = InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{"Mexico"}), (RowSignature)RowSignature.builder().add("country", ColumnType.STRING).build());
    private static final InlineDataSource NULL_INDEXED_TABLE_DS = InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{null}), (RowSignature)RowSignature.builder().add("nullCol", ColumnType.STRING).build());
    private static final IndexedTable TEST_INDEXED_TABLE = new RowBasedIndexedTable(INDEXED_TABLE_DS.getRowsAsList(), INDEXED_TABLE_DS.rowAdapter(), INDEXED_TABLE_DS.getRowSignature(), (Set)ImmutableSet.of((Object)"country"), DateTimes.nowUtc().toString());
    private static final IndexedTable TEST_INDEXED_TABLE_THREE_COLS = new RowBasedIndexedTable(INDEXED_TABLE_DS_THREE_COLS.getRowsAsList(), INDEXED_TABLE_DS_THREE_COLS.rowAdapter(), INDEXED_TABLE_DS_THREE_COLS.getRowSignature(), (Set)ImmutableSet.of((Object)"country", (Object)"m1", (Object)"m2"), DateTimes.nowUtc().toString());
    private static final IndexedTable TEST_INDEXED_TABLE_ONE_ROW = new RowBasedIndexedTable(INDEXED_TABLE_DS_ONE_ROW.getRowsAsList(), INDEXED_TABLE_DS_ONE_ROW.rowAdapter(), INDEXED_TABLE_DS_ONE_ROW.getRowSignature(), (Set)ImmutableSet.of((Object)"country"), DateTimes.nowUtc().toString());
    private static final IndexedTable TEST_NULL_INDEXED_TABLE = new RowBasedIndexedTable(NULL_INDEXED_TABLE_DS.getRowsAsList(), NULL_INDEXED_TABLE_DS.rowAdapter(), NULL_INDEXED_TABLE_DS.getRowSignature(), (Set)ImmutableSet.of((Object)"nullCol"), DateTimes.nowUtc().toString());
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void test_checkClausePrefixesForDuplicatesAndShadowing_noConflicts() {
        List<String> prefixes = Arrays.asList("AA", "AB", "AC", "aa", "ab", "ac", "BA");
        JoinPrefixUtils.checkPrefixesForDuplicatesAndShadowing(prefixes);
    }

    @Test
    public void test_checkClausePrefixesForDuplicatesAndShadowing_duplicate() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Detected duplicate prefix in join clauses: [AA]");
        List<String> prefixes = Arrays.asList("AA", "AA", "ABCD");
        JoinPrefixUtils.checkPrefixesForDuplicatesAndShadowing(prefixes);
    }

    @Test
    public void test_checkClausePrefixesForDuplicatesAndShadowing_shadowing() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Detected conflicting prefixes in join clauses: [ABC.DEF, ABC.]");
        List<String> prefixes = Arrays.asList("BASE.", "BASEBALL", "123.456", "23.45", "ABC.", "ABC.DEF");
        JoinPrefixUtils.checkPrefixesForDuplicatesAndShadowing(prefixes);
    }

    @Test
    public void test_convertJoinsToFilters_convertInnerJoin() {
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)ImmutableList.of((Object)new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()))), (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of((Object)new InDimFilter("x", TEST_LOOKUP_KEYS)), (Object)ImmutableList.of()), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToPartialFilters_convertInnerJoin() {
        JoinableClause joinableClause = new JoinableClause("j.", (Joinable)new IndexedTableJoinable(TEST_INDEXED_TABLE), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.country\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)ImmutableList.of((Object)joinableClause), (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of((Object)new InDimFilter("x", INDEXED_TABLE_DS.getRowsAsList().stream().map(row -> row[0].toString()).collect(Collectors.toSet()))), (Object)ImmutableList.of((Object)joinableClause)), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToPartialFiltersWithSelectorFiltersInsteadOfInsForSingleValue() {
        JoinableClause joinableClause = new JoinableClause("j.", (Joinable)new IndexedTableJoinable(TEST_INDEXED_TABLE_ONE_ROW), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.country\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)ImmutableList.of((Object)joinableClause), (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of((Object)new SelectorFilter("x", "Mexico", null)), (Object)ImmutableList.of()), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_convertTwoInnerJoins() {
        ImmutableList clauses = ImmutableList.of((Object)new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil())), (Object)new JoinableClause("_j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"_j.k\"", (String)"_j.", (ExprMacroTable)ExprMacroTable.nil())), (Object)new JoinableClause("__j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"x == \"__j.k\"", (String)"__j.", (ExprMacroTable)ExprMacroTable.nil())));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)clauses, (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of((Object)new InDimFilter("x", TEST_LOOKUP_KEYS), (Object)new InDimFilter("x", TEST_LOOKUP_KEYS)), (Object)ImmutableList.of((Object)clauses.get(2))), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToPartialAndFullFilters_convertMultipleInnerJoins() {
        ImmutableList clauses = ImmutableList.of((Object)new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil())), (Object)new JoinableClause("_j.", (Joinable)new IndexedTableJoinable(TEST_INDEXED_TABLE), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"_j.country\"", (String)"_j.", (ExprMacroTable)ExprMacroTable.nil())), (Object)new JoinableClause("__j.", (Joinable)new IndexedTableJoinable(TEST_INDEXED_TABLE), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"x == \"__j.country\"", (String)"__j.", (ExprMacroTable)ExprMacroTable.nil())));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)clauses, (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of((Object)new InDimFilter("x", TEST_LOOKUP_KEYS), (Object)new InDimFilter("x", INDEXED_TABLE_DS.getRowsAsList().stream().map(row -> row[0].toString()).collect(Collectors.toSet()))), (Object)ImmutableList.of((Object)clauses.get(1), (Object)clauses.get(2))), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_dontConvertTooManyValues() {
        JoinableClause clause = new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)ImmutableList.of((Object)clause), (Set)ImmutableSet.of((Object)"x"), (int)2);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of(), (Object)ImmutableList.of((Object)clause)), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_dontConvertLeftJoin() {
        JoinableClause clause = new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"x == \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)ImmutableList.of((Object)clause), (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of(), (Object)ImmutableList.of((Object)clause)), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_partialConvertWhenColumnIsUsed() {
        JoinableClause clause = new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)ImmutableList.of((Object)clause), (Set)ImmutableSet.of((Object)"x", (Object)"j.k"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of((Object)new InDimFilter("x", TEST_LOOKUP_KEYS)), (Object)ImmutableList.of((Object)clause)), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_convertToFalseFilterWhenOnlyNullValues() {
        JoinableClause clause = new JoinableClause("j.", (Joinable)new IndexedTableJoinable(TEST_NULL_INDEXED_TABLE), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.nullCol\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)ImmutableList.of((Object)clause), (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of((Object)FalseFilter.instance()), (Object)ImmutableList.of()), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_dontConvertLhsFunctions() {
        JoinableClause clause = new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"concat(x,'') == \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)ImmutableList.of((Object)clause), (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of(), (Object)ImmutableList.of((Object)clause)), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_dontConvertRhsFunctions() {
        JoinableClause clause = new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == concat(\"j.k\",'')", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)ImmutableList.of((Object)clause), (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of(), (Object)ImmutableList.of((Object)clause)), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_dontConvertNonEquiJoin() {
        JoinableClause clause = new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x != \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)ImmutableList.of((Object)clause), (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of(), (Object)ImmutableList.of((Object)clause)), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_dontConvertJoinsDependedOnByLaterJoins() {
        ImmutableList clauses = ImmutableList.of((Object)new JoinableClause("_j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"\"j.k\" == \"_j.k\"", (String)"_j.", (ExprMacroTable)ExprMacroTable.nil())), (Object)new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil())));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)clauses, (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of((Object)new InDimFilter("x", TEST_LOOKUP_KEYS)), (Object)clauses), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_partialConvertJoinsDependedOnByLaterJoins() {
        ImmutableList clauses = ImmutableList.of((Object)new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil())), (Object)new JoinableClause("_j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"\"j.k\" == \"_j.k\"", (String)"_j.", (ExprMacroTable)ExprMacroTable.nil())), (Object)new JoinableClause("__j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"x == \"__j.k\"", (String)"__j.", (ExprMacroTable)ExprMacroTable.nil())));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)clauses, (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of((Object)new InDimFilter("x", TEST_LOOKUP_KEYS)), (Object)clauses), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_partialConvertJoinsDependedOnByLaterJoins2() {
        ImmutableList clauses = ImmutableList.of((Object)new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil())), (Object)new JoinableClause("_j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"_j.k\"", (String)"_j.", (ExprMacroTable)ExprMacroTable.nil())), (Object)new JoinableClause("__j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"\"_j.v\" == \"__j.k\"", (String)"__j.", (ExprMacroTable)ExprMacroTable.nil())));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)clauses, (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of((Object)new InDimFilter("x", TEST_LOOKUP_KEYS), (Object)new InDimFilter("x", TEST_LOOKUP_KEYS)), (Object)clauses.subList(1, clauses.size())), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToFilters_dontConvertJoinsDependedOnByPreviousJoins() {
        ImmutableList clauses = ImmutableList.of((Object)new JoinableClause("j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.RIGHT, JoinConditionAnalysis.forExpression((String)"x == \"j.k\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil())), (Object)new JoinableClause("_j.", (Joinable)LookupJoinable.wrap((LookupExtractor)new MapLookupExtractor(TEST_LOOKUP, false)), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"_j.k\"", (String)"_j.", (ExprMacroTable)ExprMacroTable.nil())));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)clauses, (Set)ImmutableSet.of((Object)"x"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of(), (Object)clauses), (Object)conversion);
    }

    @Test
    public void test_convertJoinsToPartialFiltersMultipleCondtions() {
        JoinableClause joinableClause = new JoinableClause("j.", (Joinable)new IndexedTableJoinable(TEST_INDEXED_TABLE_THREE_COLS), JoinType.INNER, JoinConditionAnalysis.forExpression((String)"x == \"j.country\" && y == \"j.m1\"", (String)"j.", (ExprMacroTable)ExprMacroTable.nil()));
        Pair conversion = JoinableFactoryWrapper.convertJoinsToFilters((List)ImmutableList.of((Object)joinableClause), (Set)ImmutableSet.of((Object)"x", (Object)"y"), (int)Integer.MAX_VALUE);
        Assert.assertEquals((Object)Pair.of((Object)ImmutableList.of(), (Object)ImmutableList.of((Object)joinableClause)), (Object)conversion);
    }
}

