/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.BaseHashJoinSegmentCursorFactoryTest;
import org.apache.druid.segment.join.HashJoinSegment;
import org.apache.druid.segment.join.JoinTestHelper;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.PostJoinCursor;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysis;
import org.apache.druid.timeline.SegmentId;
import org.junit.Assert;
import org.junit.Test;

public class PostJoinCursorTest
extends BaseHashJoinSegmentCursorFactoryTest {
    public QueryableIndexSegment infiniteFactSegment;

    @Test
    public void testAdvanceWithInterruption() throws IOException, InterruptedException {
        this.testAdvance(true);
    }

    @Test
    public void testAdvanceWithoutInterruption() throws IOException, InterruptedException {
        this.testAdvance(false);
    }

    private void testAdvance(boolean withInterruption) throws IOException, InterruptedException {
        int rowsBeforeInterrupt = 1000;
        CountDownLatch countDownLatch = new CountDownLatch(1000);
        this.infiniteFactSegment = new TestInfiniteQueryableIndexSegment(JoinTestHelper.createFactIndexBuilder(this.temporaryFolder.newFolder()).buildMMappedIndex(), SegmentId.dummy((String)"facts"), countDownLatch);
        this.countriesTable = JoinTestHelper.createCountriesIndexedTable();
        Thread joinCursorThread = new Thread(() -> this.makeCursorAndAdvance(withInterruption));
        ExceptionHandler exceptionHandler = new ExceptionHandler();
        joinCursorThread.setUncaughtExceptionHandler(exceptionHandler);
        joinCursorThread.start();
        countDownLatch.await(1L, TimeUnit.SECONDS);
        joinCursorThread.interrupt();
        for (int i = 0; i < 1000; ++i) {
            if (exceptionHandler.getException() != null) {
                Assert.assertTrue((boolean)(exceptionHandler.getException() instanceof QueryInterruptedException));
                return;
            }
            Thread.sleep(1L);
        }
        Assert.fail();
    }

    public void makeCursorAndAdvance(boolean withInterruption) {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnIsoCode(JoinType.LEFT));
        JoinFilterPreAnalysis joinFilterPreAnalysis = PostJoinCursorTest.makeDefaultConfigPreAnalysis(null, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegment hashJoinSegment = new HashJoinSegment((SegmentReference)ReferenceCountingSegment.wrapRootGenerationSegment((Segment)this.infiniteFactSegment), null, (List)joinableClauses, joinFilterPreAnalysis);
        try (CursorHolder cursorHolder = hashJoinSegment.asCursorFactory().makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            Cursor cursor = cursorHolder.asCursor();
            ((PostJoinCursor)cursor).setValueMatcher(new ValueMatcher(){

                public boolean matches(boolean includeUnknown) {
                    return false;
                }

                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                }
            });
            if (withInterruption) {
                cursor.advance();
            } else {
                cursor.advanceUninterruptibly();
            }
        }
    }

    private static class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        Throwable exception;

        private ExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.exception = e;
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    private static class TestInfiniteQueryableIndexSegment
    extends QueryableIndexSegment {
        private final CursorFactory cursorFactory;

        public TestInfiniteQueryableIndexSegment(QueryableIndex index, SegmentId segmentId, CountDownLatch countDownLatch) {
            super(index, segmentId);
            this.cursorFactory = new InfiniteCursorFactory((CursorFactory)new QueryableIndexCursorFactory(index), countDownLatch);
        }

        public CursorFactory asCursorFactory() {
            return this.cursorFactory;
        }

        private static class InfiniteCursorFactory
        implements CursorFactory {
            final CursorFactory delegate;
            CountDownLatch countDownLatch;

            public InfiniteCursorFactory(CursorFactory delegate, CountDownLatch countDownLatch) {
                this.delegate = delegate;
                this.countDownLatch = countDownLatch;
            }

            public CursorHolder makeCursorHolder(CursorBuildSpec spec) {
                final CursorHolder holder = this.delegate.makeCursorHolder(spec);
                return new CursorHolder(){

                    @Nullable
                    public Cursor asCursor() {
                        return new CursorNoAdvance(holder.asCursor(), countDownLatch);
                    }

                    @Nullable
                    public List<OrderBy> getOrdering() {
                        return holder.getOrdering();
                    }

                    public void close() {
                        holder.close();
                    }
                };
            }

            public RowSignature getRowSignature() {
                return this.delegate.getRowSignature();
            }

            @Nullable
            public ColumnCapabilities getColumnCapabilities(String column) {
                return this.delegate.getColumnCapabilities(column);
            }

            private static class CursorNoAdvance
            implements Cursor {
                Cursor cursor;
                CountDownLatch countDownLatch;

                public CursorNoAdvance(Cursor cursor, CountDownLatch countDownLatch) {
                    this.cursor = cursor;
                    this.countDownLatch = countDownLatch;
                }

                public ColumnSelectorFactory getColumnSelectorFactory() {
                    return this.cursor.getColumnSelectorFactory();
                }

                public void advance() {
                    this.countDownLatch.countDown();
                }

                public void advanceUninterruptibly() {
                    this.countDownLatch.countDown();
                }

                public boolean isDone() {
                    return false;
                }

                public boolean isDoneOrInterrupted() {
                    return this.cursor.isDoneOrInterrupted();
                }

                public void reset() {
                    this.cursor.reset();
                }
            }
        }
    }
}

