/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.loading.TombstoneSegmentizerFactory;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.TombstoneShardSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class TombstoneSegmentizerFactoryTest {
    @Test
    public void testSegmentCreation() {
        Interval expectedInterval = Intervals.of((String)"2021/2022");
        TombstoneSegmentizerFactory factory = new TombstoneSegmentizerFactory();
        DataSegment tombstone = DataSegment.builder().dataSource("foo").interval(expectedInterval).version("1").shardSpec((ShardSpec)TombstoneShardSpec.INSTANCE).loadSpec((Map)ImmutableMap.of((Object)"type", (Object)"tombstone")).size(1L).build();
        Segment segment = factory.factorize(tombstone, null, true, null);
        Assert.assertNotNull((Object)segment.asCursorFactory());
        Assert.assertEquals((Object)"foo_2021-01-01T00:00:00.000Z_2022-01-01T00:00:00.000Z_1", (Object)segment.getId().toString());
        Assert.assertEquals((Object)expectedInterval, (Object)segment.getDataInterval());
        QueryableIndex queryableIndex = (QueryableIndex)segment.as(QueryableIndex.class);
        Assert.assertNotNull((Object)queryableIndex);
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((QueryableIndex)queryableIndex).getNumRows());
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((QueryableIndex)queryableIndex).getAvailableDimensions());
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((QueryableIndex)queryableIndex).getBitmapFactoryForDimensions());
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((QueryableIndex)queryableIndex).getMetadata());
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((QueryableIndex)queryableIndex).getDimensionHandlers());
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((QueryableIndex)queryableIndex).getColumnNames());
        Assert.assertThrows(UnsupportedOperationException.class, () -> queryableIndex.getColumnHolder(null));
        Assert.assertTrue((boolean)segment.isTombstone());
        Assert.assertNotNull((Object)segment.asCursorFactory());
    }

    @Test
    public void testDefaultSegmentIsTombstoneFalse() {
        Segment segment = new Segment(){

            public SegmentId getId() {
                return null;
            }

            public Interval getDataInterval() {
                return null;
            }

            @Nullable
            public QueryableIndex asQueryableIndex() {
                return null;
            }

            public CursorFactory asCursorFactory() {
                return new CursorFactory(){

                    public CursorHolder makeCursorHolder(CursorBuildSpec spec) {
                        return new CursorHolder(){

                            @Nullable
                            public Cursor asCursor() {
                                return null;
                            }
                        };
                    }

                    public RowSignature getRowSignature() {
                        return RowSignature.empty();
                    }

                    @Nullable
                    public ColumnCapabilities getColumnCapabilities(String column) {
                        return null;
                    }
                };
            }

            public void close() {
            }
        };
        Assert.assertFalse((boolean)segment.isTombstone());
    }
}

