/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.segment.AutoTypeColumnMerger;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.column.StringEncodingStrategy;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.data.DictionaryWriter;
import org.apache.druid.segment.data.FixedIndexedWriter;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexedWriter;
import org.apache.druid.segment.nested.DictionaryIdLookup;
import org.apache.druid.segment.nested.SortedValueDictionary;
import org.apache.druid.segment.nested.ValueDictionary;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DictionaryIdLookupTest
extends InitializedNullHandlingTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testIdLookup() throws IOException {
        ValueDictionary dictionary = new ValueDictionary();
        dictionary.addStringValue("hello");
        dictionary.addStringValue("world");
        dictionary.addStringValue(null);
        dictionary.addLongValue(Long.valueOf(123L));
        dictionary.addLongValue(Long.valueOf(-123L));
        dictionary.addDoubleValue(Double.valueOf(1.234));
        dictionary.addDoubleValue(Double.valueOf(0.001));
        dictionary.addStringArray(new Object[]{"hello", "world"});
        dictionary.addLongArray(new Object[]{1L, 2L, 3L});
        dictionary.addDoubleArray(new Object[]{0.01, -1.234, 0.001, 1.234});
        SortedValueDictionary sortedValueDictionary = dictionary.getSortedCollector();
        SegmentWriteOutMedium medium = TmpFileSegmentWriteOutMediumFactory.instance().makeSegmentWriteOutMedium(this.temp.newFolder());
        DictionaryWriter stringWriter = StringEncodingStrategies.getStringDictionaryWriter((StringEncodingStrategy)new StringEncodingStrategy.FrontCoded(Integer.valueOf(4), Byte.valueOf((byte)1)), (SegmentWriteOutMedium)medium, (String)"test");
        FixedIndexedWriter longWriter = new FixedIndexedWriter(medium, (TypeStrategy)TypeStrategies.LONG, ByteOrder.nativeOrder(), 8, true);
        FixedIndexedWriter doubleWriter = new FixedIndexedWriter(medium, (TypeStrategy)TypeStrategies.DOUBLE, ByteOrder.nativeOrder(), 8, true);
        FrontCodedIntArrayIndexedWriter arrayWriter = new FrontCodedIntArrayIndexedWriter(medium, ByteOrder.nativeOrder(), 4);
        Path dictTempPath = this.temp.newFolder().toPath();
        DictionaryIdLookup idLookup = new DictionaryIdLookup("test", dictTempPath, stringWriter, (DictionaryWriter)longWriter, (DictionaryWriter)doubleWriter, (DictionaryWriter)arrayWriter);
        stringWriter.open();
        longWriter.open();
        doubleWriter.open();
        arrayWriter.open();
        File tempDir = dictTempPath.toFile();
        Assert.assertEquals((long)0L, (long)tempDir.listFiles().length);
        for (String s : sortedValueDictionary.getSortedStrings()) {
            stringWriter.write((Object)s);
        }
        for (Long l : sortedValueDictionary.getSortedLongs()) {
            longWriter.write((Object)l);
        }
        for (Double d : sortedValueDictionary.getSortedDoubles()) {
            doubleWriter.write((Object)d);
        }
        Iterable sortedArrays = () -> new AutoTypeColumnMerger.ArrayDictionaryMergingIterator(new Iterable[]{sortedValueDictionary.getSortedArrays()}, idLookup);
        Assert.assertEquals((long)0L, (long)tempDir.listFiles().length);
        Assert.assertEquals((long)0L, (long)idLookup.lookupString(null));
        Assert.assertEquals((long)1L, (long)idLookup.lookupString("hello"));
        Assert.assertEquals((long)2L, (long)idLookup.lookupString("world"));
        Assert.assertEquals((long)3L, (long)idLookup.lookupLong(Long.valueOf(-123L)));
        Assert.assertEquals((long)2L, (long)tempDir.listFiles().length);
        for (int[] arr : sortedArrays) {
            arrayWriter.write(arr);
        }
        Assert.assertEquals((long)3L, (long)tempDir.listFiles().length);
        if (NullHandling.sqlCompatible()) {
            Assert.assertEquals((long)8L, (long)idLookup.lookupDouble(Double.valueOf(-1.234)));
            Assert.assertEquals((long)11L, (long)idLookup.lookupDouble(Double.valueOf(1.234)));
            Assert.assertEquals((long)3L, (long)tempDir.listFiles().length);
            Assert.assertEquals((long)12L, (long)idLookup.lookupArray(new int[]{1, 2}));
            Assert.assertEquals((long)13L, (long)idLookup.lookupArray(new int[]{4, 5, 6}));
            Assert.assertEquals((long)14L, (long)idLookup.lookupArray(new int[]{10, 8, 9, 11}));
            Assert.assertEquals((long)4L, (long)tempDir.listFiles().length);
        } else {
            Assert.assertEquals((long)9L, (long)idLookup.lookupDouble(Double.valueOf(-1.234)));
            Assert.assertEquals((long)13L, (long)idLookup.lookupDouble(Double.valueOf(1.234)));
            Assert.assertEquals((long)3L, (long)tempDir.listFiles().length);
            Assert.assertEquals((long)14L, (long)idLookup.lookupArray(new int[]{1, 2}));
            Assert.assertEquals((long)15L, (long)idLookup.lookupArray(new int[]{5, 6, 7}));
            Assert.assertEquals((long)16L, (long)idLookup.lookupArray(new int[]{12, 9, 11, 13}));
            Assert.assertEquals((long)4L, (long)tempDir.listFiles().length);
        }
        idLookup.close();
        Assert.assertEquals((long)0L, (long)tempDir.listFiles().length);
    }
}

