/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.FixedIndexedWriter;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexed;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexedWriter;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.semantic.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.index.semantic.DictionaryEncodedValueIndex;
import org.apache.druid.segment.index.semantic.DruidPredicateIndexes;
import org.apache.druid.segment.index.semantic.LexicographicalRangeIndexes;
import org.apache.druid.segment.index.semantic.NullValueIndex;
import org.apache.druid.segment.index.semantic.NumericRangeIndexes;
import org.apache.druid.segment.index.semantic.SpatialIndex;
import org.apache.druid.segment.index.semantic.StringValueSetIndexes;
import org.apache.druid.segment.nested.CompressedNestedDataComplexColumn;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.NestedFieldColumnIndexSupplier;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.writeout.OnHeapMemorySegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.roaringbitmap.IntIterator;

public class NestedFieldColumnIndexSupplierTest
extends InitializedNullHandlingTest {
    BitmapSerdeFactory roaringFactory = RoaringBitmapSerdeFactory.getInstance();
    BitmapResultFactory<ImmutableBitmap> bitmapResultFactory = new DefaultBitmapResultFactory(this.roaringFactory.getBitmapFactory());
    Supplier<Indexed<ByteBuffer>> globalStrings;
    Supplier<FixedIndexed<Long>> globalLongs;
    Supplier<FixedIndexed<Double>> globalDoubles;
    Supplier<FrontCodedIntArrayIndexed> globalArrays;

    @Before
    public void setup() throws IOException {
        ByteBuffer stringBuffer = ByteBuffer.allocate(4096);
        ByteBuffer longBuffer = ByteBuffer.allocate(4096).order(ByteOrder.nativeOrder());
        ByteBuffer doubleBuffer = ByteBuffer.allocate(4096).order(ByteOrder.nativeOrder());
        ByteBuffer arrayBuffer = ByteBuffer.allocate(4096).order(ByteOrder.nativeOrder());
        GenericIndexedWriter stringWriter = new GenericIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), "strings", GenericIndexed.STRING_STRATEGY);
        stringWriter.open();
        stringWriter.write(null);
        stringWriter.write((Object)"a");
        stringWriter.write((Object)"b");
        stringWriter.write((Object)"fo");
        stringWriter.write((Object)"foo");
        stringWriter.write((Object)"fooo");
        stringWriter.write((Object)"g");
        stringWriter.write((Object)"gg");
        stringWriter.write((Object)"ggg");
        stringWriter.write((Object)"z");
        NestedFieldColumnIndexSupplierTest.writeToBuffer(stringBuffer, (Serializer)stringWriter);
        FixedIndexedWriter longWriter = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), (TypeStrategy)TypeStrategies.LONG, ByteOrder.nativeOrder(), 8, true);
        longWriter.open();
        longWriter.write((Object)1L);
        longWriter.write((Object)2L);
        longWriter.write((Object)3L);
        longWriter.write((Object)5L);
        longWriter.write((Object)100L);
        longWriter.write((Object)300L);
        longWriter.write((Object)9000L);
        NestedFieldColumnIndexSupplierTest.writeToBuffer(longBuffer, (Serializer)longWriter);
        FixedIndexedWriter doubleWriter = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), (TypeStrategy)TypeStrategies.DOUBLE, ByteOrder.nativeOrder(), 8, true);
        doubleWriter.open();
        doubleWriter.write((Object)1.0);
        doubleWriter.write((Object)1.1);
        doubleWriter.write((Object)1.2);
        doubleWriter.write((Object)2.0);
        doubleWriter.write((Object)2.5);
        doubleWriter.write((Object)3.3);
        doubleWriter.write((Object)6.6);
        doubleWriter.write((Object)9.9);
        NestedFieldColumnIndexSupplierTest.writeToBuffer(doubleBuffer, (Serializer)doubleWriter);
        FrontCodedIntArrayIndexedWriter arrayWriter = new FrontCodedIntArrayIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), ByteOrder.nativeOrder(), 4);
        arrayWriter.open();
        NestedFieldColumnIndexSupplierTest.writeToBuffer(arrayBuffer, (Serializer)arrayWriter);
        GenericIndexed strings = GenericIndexed.read((ByteBuffer)stringBuffer, (ObjectStrategy)GenericIndexed.UTF8_STRATEGY);
        this.globalStrings = () -> strings.singleThreaded();
        this.globalLongs = FixedIndexed.read((ByteBuffer)longBuffer, (TypeStrategy)TypeStrategies.LONG, (ByteOrder)ByteOrder.nativeOrder(), (int)8);
        this.globalDoubles = FixedIndexed.read((ByteBuffer)doubleBuffer, (TypeStrategy)TypeStrategies.DOUBLE, (ByteOrder)ByteOrder.nativeOrder(), (int)8);
        this.globalArrays = FrontCodedIntArrayIndexed.read((ByteBuffer)arrayBuffer, (ByteOrder)ByteOrder.nativeOrder());
    }

    @Test
    public void testSingleTypeStringColumnValueIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeStringSupplier();
        NullValueIndex nullIndex = (NullValueIndex)indexSupplier.as(NullValueIndex.class);
        Assert.assertNotNull((Object)nullIndex);
        Assert.assertNull((Object)indexSupplier.as(SpatialIndex.class));
        BitmapColumnIndex columnIndex = nullIndex.get();
        Assert.assertNotNull((Object)columnIndex);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        Assert.assertEquals((long)0L, (long)bitmap.size());
    }

    @Test
    public void testSingleTypeStringColumnValueSetIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeStringSupplier();
        StringValueSetIndexes valueSetIndex = (StringValueSetIndexes)indexSupplier.as(StringValueSetIndexes.class);
        Assert.assertNotNull((Object)valueSetIndex);
        BitmapColumnIndex columnIndex = valueSetIndex.forValue("b");
        Assert.assertNotNull((Object)columnIndex);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 3, 7, 8);
        columnIndex = valueSetIndex.forValue("fo");
        Assert.assertNotNull((Object)columnIndex);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        columnIndex = valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)"b", (Object)"fooo", (Object)"z")));
        Assert.assertNotNull((Object)columnIndex);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 2, 3, 4, 5, 6, 7, 8);
    }

    @Test
    public void testSingleTypeStringColumnRangeIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeStringSupplier();
        LexicographicalRangeIndexes rangeIndex = (LexicographicalRangeIndexes)indexSupplier.as(LexicographicalRangeIndexes.class);
        Assert.assertNotNull((Object)rangeIndex);
        BitmapColumnIndex forRange = rangeIndex.forRange(null, false, "a", false);
        Assert.assertNotNull((Object)forRange);
        ImmutableBitmap bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        forRange = rangeIndex.forRange(null, true, "a", true);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        forRange = rangeIndex.forRange(null, false, "b", true);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        forRange = rangeIndex.forRange(null, false, "b", false);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 3, 7, 8);
        forRange = rangeIndex.forRange("a", false, "b", true);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        forRange = rangeIndex.forRange("a", true, "b", false);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 3, 7, 8);
        forRange = rangeIndex.forRange("b", false, "fon", false);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 3, 7, 8);
        forRange = rangeIndex.forRange("bb", false, "fon", false);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        forRange = rangeIndex.forRange("b", true, "foo", false);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 9);
        forRange = rangeIndex.forRange("f", true, "g", true);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 2, 5, 9);
        forRange = rangeIndex.forRange(null, false, "g", true);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 5, 7, 8, 9);
        forRange = rangeIndex.forRange("f", false, null, true);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 2, 4, 5, 6, 9);
        forRange = rangeIndex.forRange("b", true, "fooo", true);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 9);
        forRange = rangeIndex.forRange("b", true, "fooo", false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 2, 5, 9);
        forRange = rangeIndex.forRange(null, true, "fooo", true);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 1, 3, 7, 8, 9);
        forRange = rangeIndex.forRange("b", true, null, false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 2, 4, 5, 6, 9);
        forRange = rangeIndex.forRange("b", false, null, true);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        forRange = rangeIndex.forRange(null, true, "fooo", false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 5, 7, 8, 9);
        forRange = rangeIndex.forRange(null, true, null, true);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        forRange = rangeIndex.forRange(null, false, null, false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        forRange = rangeIndex.forRange(null, true, "foa", false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 3, 7, 8);
        forRange = rangeIndex.forRange(null, true, "foooa", false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 5, 7, 8, 9);
        forRange = rangeIndex.forRange("foooa", true, "ggg", false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        forRange = rangeIndex.forRange("g", true, "gg", false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        forRange = rangeIndex.forRange("z", true, "zz", false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        forRange = rangeIndex.forRange("z", false, "zz", false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 4, 6);
    }

    @Test
    public void testSingleTypeStringColumnRangeIndexWithPredicate() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeStringSupplier();
        LexicographicalRangeIndexes rangeIndex = (LexicographicalRangeIndexes)indexSupplier.as(LexicographicalRangeIndexes.class);
        Assert.assertNotNull((Object)rangeIndex);
        BitmapColumnIndex forRange = rangeIndex.forRange("f", true, "g", true, DruidObjectPredicate.notEqualTo((Object)"fooo"));
        ImmutableBitmap bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 9);
        forRange = rangeIndex.forRange("f", true, "g", true, DruidObjectPredicate.equalTo((Object)"fooo"));
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 2, 5);
        forRange = rangeIndex.forRange(null, false, "z", false, DruidObjectPredicate.notEqualTo((Object)"fooo"));
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 1, 3, 4, 6, 7, 8, 9);
        forRange = rangeIndex.forRange(null, false, "z", true, DruidObjectPredicate.notEqualTo((Object)"fooo"));
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 1, 3, 7, 8, 9);
        forRange = rangeIndex.forRange("f", true, null, true, DruidObjectPredicate.alwaysTrue());
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 2, 4, 5, 6, 9);
    }

    @Test
    public void testSingleTypeStringColumnPredicateIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeStringSupplier();
        DruidPredicateIndexes predicateIndex = (DruidPredicateIndexes)indexSupplier.as(DruidPredicateIndexes.class);
        Assert.assertNotNull((Object)predicateIndex);
        InDimFilter.InFilterDruidPredicateFactory predicateFactory = new InDimFilter.InFilterDruidPredicateFactory(null, InDimFilter.ValuesSet.copyOf((Collection)ImmutableSet.of((Object)"b", (Object)"z")));
        BitmapColumnIndex columnIndex = predicateIndex.forPredicate((DruidPredicateFactory)predicateFactory);
        Assert.assertNotNull((Object)columnIndex);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 3, 4, 6, 7, 8);
    }

    @Test
    public void testSingleTypeStringColumnWithNullValueIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeStringWithNullsSupplier();
        NullValueIndex nullIndex = (NullValueIndex)indexSupplier.as(NullValueIndex.class);
        Assert.assertNotNull((Object)nullIndex);
        BitmapColumnIndex columnIndex = nullIndex.get();
        Assert.assertNotNull((Object)columnIndex);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 7, 8);
    }

    @Test
    public void testSingleTypeStringColumnWithNullValueSetIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeStringWithNullsSupplier();
        StringValueSetIndexes valueSetIndex = (StringValueSetIndexes)indexSupplier.as(StringValueSetIndexes.class);
        Assert.assertNotNull((Object)valueSetIndex);
        BitmapColumnIndex columnIndex = valueSetIndex.forValue("b");
        Assert.assertNotNull((Object)columnIndex);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 3);
        columnIndex = valueSetIndex.forValue("fo");
        Assert.assertNotNull((Object)columnIndex);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        columnIndex = valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)"b", (Object)"fooo", (Object)"z")));
        Assert.assertNotNull((Object)columnIndex);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 2, 3, 4, 5, 6);
    }

    @Test
    public void testSingleValueStringWithNullRangeIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeStringWithNullsSupplier();
        LexicographicalRangeIndexes rangeIndex = (LexicographicalRangeIndexes)indexSupplier.as(LexicographicalRangeIndexes.class);
        Assert.assertNotNull((Object)rangeIndex);
        BitmapColumnIndex forRange = rangeIndex.forRange("f", true, "g", true);
        Assert.assertNotNull((Object)forRange);
        ImmutableBitmap bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 2, 5, 9);
        forRange = rangeIndex.forRange(null, false, "g", true);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 2, 3, 5, 9);
        forRange = rangeIndex.forRange(null, false, "a", true);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        forRange = rangeIndex.forRange(null, false, "b", true);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        forRange = rangeIndex.forRange(null, false, "b", false);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 3);
        forRange = rangeIndex.forRange("f", false, null, true);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 2, 4, 5, 6, 9);
        forRange = rangeIndex.forRange("b", true, "fooo", true);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 9);
        forRange = rangeIndex.forRange("b", true, "fooo", false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 2, 5, 9);
        forRange = rangeIndex.forRange(null, true, "fooo", true);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 3, 9);
        forRange = rangeIndex.forRange("b", true, null, false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 2, 4, 5, 6, 9);
        forRange = rangeIndex.forRange("b", false, null, true);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 2, 3, 4, 5, 6, 9);
        forRange = rangeIndex.forRange(null, true, "fooo", false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 2, 3, 5, 9);
        forRange = rangeIndex.forRange(null, true, null, true);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 2, 3, 4, 5, 6, 9);
        forRange = rangeIndex.forRange(null, false, null, false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 2, 3, 4, 5, 6, 9);
    }

    @Test
    public void testSingleValueStringWithNullPredicateIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeStringWithNullsSupplier();
        DruidPredicateIndexes predicateIndex = (DruidPredicateIndexes)indexSupplier.as(DruidPredicateIndexes.class);
        Assert.assertNotNull((Object)predicateIndex);
        InDimFilter.InFilterDruidPredicateFactory predicateFactory = new InDimFilter.InFilterDruidPredicateFactory(null, InDimFilter.ValuesSet.copyOf((Collection)ImmutableSet.of((Object)"b", (Object)"z")));
        BitmapColumnIndex columnIndex = predicateIndex.forPredicate((DruidPredicateFactory)predicateFactory);
        Assert.assertNotNull((Object)columnIndex);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 3, 4, 6);
    }

    @Test
    public void testSingleTypeLongColumnValueSetIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeLongSupplier();
        StringValueSetIndexes valueSetIndex = (StringValueSetIndexes)indexSupplier.as(StringValueSetIndexes.class);
        Assert.assertNotNull((Object)valueSetIndex);
        Assert.assertNull((Object)indexSupplier.as(SpatialIndex.class));
        BitmapColumnIndex columnIndex = valueSetIndex.forValue("1");
        Assert.assertNotNull((Object)columnIndex);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 3, 9);
        columnIndex = valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)"1", (Object)"300", (Object)"700")));
        Assert.assertNotNull((Object)columnIndex);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 2, 3, 7, 8, 9);
    }

    @Test
    public void testSingleTypeLongColumnRangeIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeLongSupplier();
        NumericRangeIndexes rangeIndexes = (NumericRangeIndexes)indexSupplier.as(NumericRangeIndexes.class);
        Assert.assertNotNull((Object)rangeIndexes);
        BitmapColumnIndex forRange = rangeIndexes.forRange((Number)10L, true, (Number)400L, true);
        Assert.assertNotNull((Object)forRange);
        ImmutableBitmap bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 2, 6, 7, 8);
        forRange = rangeIndexes.forRange((Number)1, true, (Number)3, true);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        forRange = rangeIndexes.forRange((Number)1, false, (Number)3, true);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 3, 9);
        forRange = rangeIndexes.forRange((Number)1, false, (Number)3, false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 3, 4, 5, 9);
        forRange = rangeIndexes.forRange((Number)100L, true, (Number)300L, true);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        forRange = rangeIndexes.forRange((Number)100L, true, (Number)300L, false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 2, 7, 8);
        forRange = rangeIndexes.forRange((Number)100L, false, (Number)300L, true);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 6);
        forRange = rangeIndexes.forRange((Number)100L, false, (Number)300L, false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 2, 6, 7, 8);
        forRange = rangeIndexes.forRange(null, true, null, true);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        forRange = rangeIndexes.forRange(null, false, null, false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
    }

    @Test
    public void testSingleTypeLongColumnPredicateIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeLongSupplier();
        DruidPredicateIndexes predicateIndex = (DruidPredicateIndexes)indexSupplier.as(DruidPredicateIndexes.class);
        Assert.assertNotNull((Object)predicateIndex);
        InDimFilter.InFilterDruidPredicateFactory predicateFactory = new InDimFilter.InFilterDruidPredicateFactory(null, InDimFilter.ValuesSet.copyOf((Collection)ImmutableSet.of((Object)"1", (Object)"3")));
        BitmapColumnIndex columnIndex = predicateIndex.forPredicate((DruidPredicateFactory)predicateFactory);
        Assert.assertNotNull((Object)columnIndex);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 3, 4, 5, 9);
    }

    @Test
    public void testSingleTypeLongColumnWithNullValueIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeLongSupplierWithNull();
        NullValueIndex nullIndex = (NullValueIndex)indexSupplier.as(NullValueIndex.class);
        Assert.assertNotNull((Object)nullIndex);
        BitmapColumnIndex columnIndex = nullIndex.get();
        Assert.assertNotNull((Object)columnIndex);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 2, 5, 8);
    }

    @Test
    public void testSingleTypeLongColumnWithNullValueSetIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeLongSupplierWithNull();
        StringValueSetIndexes valueSetIndex = (StringValueSetIndexes)indexSupplier.as(StringValueSetIndexes.class);
        Assert.assertNotNull((Object)valueSetIndex);
        BitmapColumnIndex columnIndex = valueSetIndex.forValue("3");
        Assert.assertNotNull((Object)columnIndex);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 4);
        columnIndex = valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)"1", (Object)"3", (Object)"300")));
        Assert.assertNotNull((Object)columnIndex);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 3, 4, 7, 9);
        TreeSet<String> treeSet = new TreeSet<String>((Comparator<String>)Comparators.naturalNullsFirst());
        treeSet.add(null);
        treeSet.add("1");
        treeSet.add("3");
        treeSet.add("300");
        columnIndex = valueSetIndex.forSortedValues(treeSet);
        Assert.assertNotNull((Object)columnIndex);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 2, 3, 4, 5, 7, 8, 9);
        columnIndex = valueSetIndex.forValue(null);
        Assert.assertNotNull((Object)columnIndex);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 2, 5, 8);
    }

    @Test
    public void testSingleValueLongWithNullRangeIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeLongSupplierWithNull();
        NumericRangeIndexes rangeIndexes = (NumericRangeIndexes)indexSupplier.as(NumericRangeIndexes.class);
        Assert.assertNotNull((Object)rangeIndexes);
        BitmapColumnIndex forRange = rangeIndexes.forRange((Number)100, false, (Number)700, true);
        Assert.assertNotNull((Object)forRange);
        ImmutableBitmap bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 6, 7);
        forRange = rangeIndexes.forRange((Number)100, true, (Number)300, true);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        forRange = rangeIndexes.forRange((Number)100, false, (Number)300, true);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 6);
        forRange = rangeIndexes.forRange((Number)100, true, (Number)300, false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 7);
        forRange = rangeIndexes.forRange((Number)100, false, (Number)300, false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 6, 7);
        forRange = rangeIndexes.forRange(null, true, null, true);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 1, 3, 4, 6, 7, 9);
        forRange = rangeIndexes.forRange(null, false, null, false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 1, 3, 4, 6, 7, 9);
        forRange = rangeIndexes.forRange(null, false, (Number)0, false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        forRange = rangeIndexes.forRange(null, false, (Number)1, false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 3, 9);
        forRange = rangeIndexes.forRange(null, false, (Number)1, true);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
    }

    @Test
    public void testSingleValueLongWithNullPredicateIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeLongSupplierWithNull();
        DruidPredicateIndexes predicateIndex = (DruidPredicateIndexes)indexSupplier.as(DruidPredicateIndexes.class);
        Assert.assertNotNull((Object)predicateIndex);
        InDimFilter.InFilterDruidPredicateFactory predicateFactory = new InDimFilter.InFilterDruidPredicateFactory(null, InDimFilter.ValuesSet.copyOf((Collection)ImmutableSet.of((Object)"3", (Object)"100")));
        BitmapColumnIndex columnIndex = predicateIndex.forPredicate((DruidPredicateFactory)predicateFactory);
        Assert.assertNotNull((Object)columnIndex);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 4, 6);
    }

    @Test
    public void testSingleTypeDoubleColumnValueSetIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeDoubleSupplier();
        StringValueSetIndexes valueSetIndex = (StringValueSetIndexes)indexSupplier.as(StringValueSetIndexes.class);
        Assert.assertNotNull((Object)valueSetIndex);
        Assert.assertNull((Object)indexSupplier.as(SpatialIndex.class));
        BitmapColumnIndex columnIndex = valueSetIndex.forValue("1.2");
        Assert.assertNotNull((Object)columnIndex);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 2, 4, 7);
        columnIndex = valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)"1.2", (Object)"3.3", (Object)"6.6")));
        Assert.assertNotNull((Object)columnIndex);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 2, 3, 4, 5, 6, 7, 9);
    }

    @Test
    public void testSingleTypeDoubleColumnRangeIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeDoubleSupplier();
        NumericRangeIndexes rangeIndexes = (NumericRangeIndexes)indexSupplier.as(NumericRangeIndexes.class);
        Assert.assertNotNull((Object)rangeIndexes);
        BitmapColumnIndex forRange = rangeIndexes.forRange((Number)1.0, true, (Number)5.0, true);
        Assert.assertNotNull((Object)forRange);
        ImmutableBitmap bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 4, 6, 7, 8, 9);
        forRange = rangeIndexes.forRange((Number)1.1, false, (Number)3.3, false);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 4, 6, 7, 8, 9);
        forRange = rangeIndexes.forRange((Number)1.1, true, (Number)3.3, true);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 2, 4, 7);
        forRange = rangeIndexes.forRange(null, true, null, true);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        forRange = rangeIndexes.forRange(null, false, null, false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        forRange = rangeIndexes.forRange((Number)1.111, true, (Number)1.19, true);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        forRange = rangeIndexes.forRange((Number)1.01, true, (Number)1.09, true);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        forRange = rangeIndexes.forRange((Number)0.05, true, (Number)0.98, true);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        forRange = rangeIndexes.forRange((Number)0.05, true, (Number)1.1, true);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        forRange = rangeIndexes.forRange((Number)8.99, true, (Number)10.1, true);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        forRange = rangeIndexes.forRange((Number)8.99, true, (Number)10.1, true);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        forRange = rangeIndexes.forRange((Number)10.0, true, (Number)10.1, true);
        Assert.assertNotNull((Object)forRange);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
    }

    @Test
    public void testSingleTypeDoubleColumnPredicateIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeDoubleSupplier();
        DruidPredicateIndexes predicateIndex = (DruidPredicateIndexes)indexSupplier.as(DruidPredicateIndexes.class);
        Assert.assertNotNull((Object)predicateIndex);
        InDimFilter.InFilterDruidPredicateFactory predicateFactory = new InDimFilter.InFilterDruidPredicateFactory(null, InDimFilter.ValuesSet.copyOf((Collection)ImmutableSet.of((Object)"1.2", (Object)"3.3", (Object)"5.0")));
        BitmapColumnIndex columnIndex = predicateIndex.forPredicate((DruidPredicateFactory)predicateFactory);
        Assert.assertNotNull((Object)columnIndex);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 2, 3, 4, 6, 7, 9);
    }

    @Test
    public void testSingleTypeDoubleColumnWithNullValueIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeDoubleSupplierWithNull();
        NullValueIndex nullIndex = (NullValueIndex)indexSupplier.as(NullValueIndex.class);
        Assert.assertNotNull((Object)nullIndex);
        BitmapColumnIndex columnIndex = nullIndex.get();
        Assert.assertNotNull((Object)columnIndex);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 3, 6);
    }

    @Test
    public void testSingleTypeDoubleColumnWithNullValueSetIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeDoubleSupplierWithNull();
        StringValueSetIndexes valueSetIndex = (StringValueSetIndexes)indexSupplier.as(StringValueSetIndexes.class);
        Assert.assertNotNull((Object)valueSetIndex);
        BitmapColumnIndex columnIndex = valueSetIndex.forValue("6.6");
        Assert.assertNotNull((Object)columnIndex);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 5);
        columnIndex = valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)"1.2", (Object)"3.3", (Object)"7.7")));
        Assert.assertNotNull((Object)columnIndex);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 2, 4, 7, 9);
        TreeSet<String> treeSet = new TreeSet<String>((Comparator<String>)Comparators.naturalNullsFirst());
        treeSet.add(null);
        treeSet.add("1.2");
        treeSet.add("3.3");
        treeSet.add("7.7");
        columnIndex = valueSetIndex.forSortedValues(treeSet);
        Assert.assertNotNull((Object)columnIndex);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 2, 3, 4, 6, 7, 9);
        columnIndex = valueSetIndex.forValue(null);
        Assert.assertNotNull((Object)columnIndex);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 3, 6);
    }

    @Test
    public void testSingleValueDoubleWithNullRangeIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeDoubleSupplierWithNull();
        NumericRangeIndexes rangeIndexes = (NumericRangeIndexes)indexSupplier.as(NumericRangeIndexes.class);
        Assert.assertNotNull((Object)rangeIndexes);
        BitmapColumnIndex forRange = rangeIndexes.forRange((Number)1.1, false, (Number)5.0, true);
        Assert.assertNotNull((Object)forRange);
        ImmutableBitmap bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 2, 4, 7, 8, 9);
        forRange = rangeIndexes.forRange(null, true, null, true);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 2, 4, 5, 7, 8, 9);
        forRange = rangeIndexes.forRange(null, false, null, false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 2, 4, 5, 7, 8, 9);
        forRange = rangeIndexes.forRange(null, true, (Number)1.0, true);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
        forRange = rangeIndexes.forRange(null, true, (Number)1.1, false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 8);
        forRange = rangeIndexes.forRange((Number)6.6, false, null, false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 5);
        forRange = rangeIndexes.forRange((Number)6.6, true, null, false);
        bitmap = (ImmutableBitmap)forRange.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
    }

    @Test
    public void testSingleValueDoubleWithNullPredicateIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeSingleTypeDoubleSupplierWithNull();
        DruidPredicateIndexes predicateIndex = (DruidPredicateIndexes)indexSupplier.as(DruidPredicateIndexes.class);
        Assert.assertNotNull((Object)predicateIndex);
        InDimFilter.InFilterDruidPredicateFactory predicateFactory = new InDimFilter.InFilterDruidPredicateFactory(null, InDimFilter.ValuesSet.copyOf((Collection)ImmutableSet.of((Object)"1.2", (Object)"3.3")));
        BitmapColumnIndex columnIndex = predicateIndex.forPredicate((DruidPredicateFactory)predicateFactory);
        Assert.assertNotNull((Object)columnIndex);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 2, 4, 7, 9);
    }

    @Test
    public void testVariantNullValueIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeVariantSupplierWithNull();
        NullValueIndex nullIndex = (NullValueIndex)indexSupplier.as(NullValueIndex.class);
        Assert.assertNotNull((Object)nullIndex);
        Assert.assertNull((Object)indexSupplier.as(SpatialIndex.class));
        BitmapColumnIndex columnIndex = nullIndex.get();
        Assert.assertNotNull((Object)columnIndex);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 2, 7);
    }

    @Test
    public void testVariantValueSetIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeVariantSupplierWithNull();
        StringValueSetIndexes valueSetIndex = (StringValueSetIndexes)indexSupplier.as(StringValueSetIndexes.class);
        Assert.assertNotNull((Object)valueSetIndex);
        BitmapColumnIndex columnIndex = valueSetIndex.forValue("b");
        Assert.assertNotNull((Object)columnIndex);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 9);
        columnIndex = valueSetIndex.forValue("1");
        Assert.assertNotNull((Object)columnIndex);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0, 5);
        columnIndex = valueSetIndex.forValue("1.1");
        Assert.assertNotNull((Object)columnIndex);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 8);
        columnIndex = valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)"b", (Object)"300", (Object)"9.9", (Object)"1.6")));
        Assert.assertNotNull((Object)columnIndex);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 3, 4, 9);
        TreeSet<String> treeSet = new TreeSet<String>((Comparator<String>)Comparators.naturalNullsFirst());
        treeSet.add(null);
        treeSet.add("b");
        treeSet.add("300");
        treeSet.add("9.9");
        treeSet.add("1.6");
        columnIndex = valueSetIndex.forSortedValues(treeSet);
        Assert.assertNotNull((Object)columnIndex);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 2, 3, 4, 7, 9);
        columnIndex = valueSetIndex.forValue(null);
        Assert.assertNotNull((Object)columnIndex);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 2, 7);
    }

    @Test
    public void testVariantRangeIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeVariantSupplierWithNull();
        LexicographicalRangeIndexes rangeIndex = (LexicographicalRangeIndexes)indexSupplier.as(LexicographicalRangeIndexes.class);
        Assert.assertNull((Object)rangeIndex);
        NumericRangeIndexes numericRangeIndexes = (NumericRangeIndexes)indexSupplier.as(NumericRangeIndexes.class);
        Assert.assertNull((Object)numericRangeIndexes);
    }

    @Test
    public void testVariantPredicateIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeVariantSupplierWithNull();
        DruidPredicateIndexes predicateIndex = (DruidPredicateIndexes)indexSupplier.as(DruidPredicateIndexes.class);
        Assert.assertNotNull((Object)predicateIndex);
        InDimFilter.InFilterDruidPredicateFactory predicateFactory = new InDimFilter.InFilterDruidPredicateFactory(null, InDimFilter.ValuesSet.copyOf((Collection)ImmutableSet.of((Object)"b", (Object)"z", (Object)"9.9", (Object)"300")));
        BitmapColumnIndex columnIndex = predicateIndex.forPredicate((DruidPredicateFactory)predicateFactory);
        Assert.assertNotNull((Object)columnIndex);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 1, 3, 4, 6, 9);
    }

    @Test
    public void testDictionaryEncodedStringValueIndex() throws IOException {
        NestedFieldColumnIndexSupplier<?> indexSupplier = this.makeVariantSupplierWithNull();
        DictionaryEncodedStringValueIndex lowLevelIndex = (DictionaryEncodedStringValueIndex)indexSupplier.as(DictionaryEncodedStringValueIndex.class);
        Assert.assertNotNull((Object)lowLevelIndex);
        Assert.assertNotNull((Object)indexSupplier.as(DictionaryEncodedValueIndex.class));
        Assert.assertNull((Object)lowLevelIndex.getValue(0));
        Assert.assertEquals((Object)"b", (Object)lowLevelIndex.getValue(1));
        Assert.assertEquals((Object)"z", (Object)lowLevelIndex.getValue(2));
        Assert.assertEquals((Object)"1", (Object)lowLevelIndex.getValue(3));
        Assert.assertEquals((Object)"300", (Object)lowLevelIndex.getValue(4));
        Assert.assertEquals((Object)"1.1", (Object)lowLevelIndex.getValue(5));
        Assert.assertEquals((Object)"9.9", (Object)lowLevelIndex.getValue(6));
        Assert.assertEquals((long)7L, (long)lowLevelIndex.getCardinality());
        this.checkBitmap(lowLevelIndex.getBitmap(0), 2, 7);
        this.checkBitmap(lowLevelIndex.getBitmap(1), 1, 9);
        this.checkBitmap(lowLevelIndex.getBitmap(-1), new int[0]);
    }

    @Test
    public void testEnsureNoImproperSelectionFromAdjustedGlobals() throws IOException {
        ByteBuffer localDictionaryBuffer = ByteBuffer.allocate(1024).order(ByteOrder.nativeOrder());
        ByteBuffer bitmapsBuffer = ByteBuffer.allocate(1024);
        ByteBuffer stringBuffer = ByteBuffer.allocate(1024);
        ByteBuffer longBuffer = ByteBuffer.allocate(1024).order(ByteOrder.nativeOrder());
        ByteBuffer doubleBuffer = ByteBuffer.allocate(1024).order(ByteOrder.nativeOrder());
        GenericIndexedWriter stringWriter = new GenericIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), "strings", GenericIndexed.STRING_STRATEGY);
        stringWriter.open();
        stringWriter.write(null);
        stringWriter.write((Object)"1");
        NestedFieldColumnIndexSupplierTest.writeToBuffer(stringBuffer, (Serializer)stringWriter);
        FixedIndexedWriter longWriter = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), (TypeStrategy)TypeStrategies.LONG, ByteOrder.nativeOrder(), 8, true);
        longWriter.open();
        longWriter.write((Object)-2L);
        NestedFieldColumnIndexSupplierTest.writeToBuffer(longBuffer, (Serializer)longWriter);
        FixedIndexedWriter doubleWriter = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), (TypeStrategy)TypeStrategies.DOUBLE, ByteOrder.nativeOrder(), 8, true);
        doubleWriter.open();
        NestedFieldColumnIndexSupplierTest.writeToBuffer(doubleBuffer, (Serializer)doubleWriter);
        GenericIndexed strings = GenericIndexed.read((ByteBuffer)stringBuffer, (ObjectStrategy)GenericIndexed.UTF8_STRATEGY);
        Supplier stringIndexed = () -> strings.singleThreaded();
        Supplier longIndexed = FixedIndexed.read((ByteBuffer)longBuffer, (TypeStrategy)TypeStrategies.LONG, (ByteOrder)ByteOrder.nativeOrder(), (int)8);
        Supplier doubleIndexed = FixedIndexed.read((ByteBuffer)doubleBuffer, (TypeStrategy)TypeStrategies.DOUBLE, (ByteOrder)ByteOrder.nativeOrder(), (int)8);
        FixedIndexedWriter localDictionaryWriter = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), (TypeStrategy)CompressedNestedDataComplexColumn.INT_TYPE_STRATEGY, ByteOrder.nativeOrder(), 4, true);
        localDictionaryWriter.open();
        GenericIndexedWriter bitmapWriter = new GenericIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), "bitmaps", this.roaringFactory.getObjectStrategy());
        bitmapWriter.setObjectsNotSorted();
        bitmapWriter.open();
        localDictionaryWriter.write((Object)0);
        bitmapWriter.write((Object)this.fillBitmap(1));
        localDictionaryWriter.write((Object)1);
        bitmapWriter.write((Object)this.fillBitmap(0));
        localDictionaryWriter.write((Object)2);
        bitmapWriter.write((Object)this.fillBitmap(2));
        NestedFieldColumnIndexSupplierTest.writeToBuffer(localDictionaryBuffer, (Serializer)localDictionaryWriter);
        NestedFieldColumnIndexSupplierTest.writeToBuffer(bitmapsBuffer, (Serializer)bitmapWriter);
        Supplier dictionarySupplier = FixedIndexed.read((ByteBuffer)localDictionaryBuffer, (TypeStrategy)CompressedNestedDataComplexColumn.INT_TYPE_STRATEGY, (ByteOrder)ByteOrder.nativeOrder(), (int)4);
        GenericIndexed bitmaps = GenericIndexed.read((ByteBuffer)bitmapsBuffer, (ObjectStrategy)this.roaringFactory.getObjectStrategy());
        NestedFieldColumnIndexSupplier indexSupplier = new NestedFieldColumnIndexSupplier(new FieldTypeInfo.TypeSet(new FieldTypeInfo.MutableTypeSet().add(ColumnType.STRING).add(ColumnType.LONG).getByteValue()), this.roaringFactory.getBitmapFactory(), ColumnConfig.SELECTION_SIZE, bitmaps, dictionarySupplier, stringIndexed, longIndexed, doubleIndexed, this.globalArrays, null, null);
        StringValueSetIndexes valueSetIndex = (StringValueSetIndexes)indexSupplier.as(StringValueSetIndexes.class);
        Assert.assertNotNull((Object)valueSetIndex);
        BitmapColumnIndex columnIndex = valueSetIndex.forValue("1");
        Assert.assertNotNull((Object)columnIndex);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 0);
        columnIndex = valueSetIndex.forValue("-2");
        Assert.assertNotNull((Object)columnIndex);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, 2);
        columnIndex = valueSetIndex.forValue("2");
        Assert.assertNotNull((Object)columnIndex);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory, false);
        this.checkBitmap(bitmap, new int[0]);
    }

    private NestedFieldColumnIndexSupplier<?> makeSingleTypeStringSupplier() throws IOException {
        return this.makeSingleTypeStringSupplier(ColumnConfig.SELECTION_SIZE);
    }

    private NestedFieldColumnIndexSupplier<?> makeSingleTypeStringSupplier(ColumnConfig columnConfig) throws IOException {
        ByteBuffer localDictionaryBuffer = ByteBuffer.allocate(4096).order(ByteOrder.nativeOrder());
        ByteBuffer bitmapsBuffer = ByteBuffer.allocate(4096);
        FixedIndexedWriter localDictionaryWriter = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), (TypeStrategy)CompressedNestedDataComplexColumn.INT_TYPE_STRATEGY, ByteOrder.nativeOrder(), 4, true);
        localDictionaryWriter.open();
        GenericIndexedWriter bitmapWriter = new GenericIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), "bitmaps", this.roaringFactory.getObjectStrategy());
        bitmapWriter.setObjectsNotSorted();
        bitmapWriter.open();
        localDictionaryWriter.write((Object)2);
        bitmapWriter.write((Object)this.fillBitmap(1, 3, 7, 8));
        localDictionaryWriter.write((Object)4);
        bitmapWriter.write((Object)this.fillBitmap(0, 9));
        localDictionaryWriter.write((Object)5);
        bitmapWriter.write((Object)this.fillBitmap(2, 5));
        localDictionaryWriter.write((Object)9);
        bitmapWriter.write((Object)this.fillBitmap(4, 6));
        NestedFieldColumnIndexSupplierTest.writeToBuffer(localDictionaryBuffer, (Serializer)localDictionaryWriter);
        NestedFieldColumnIndexSupplierTest.writeToBuffer(bitmapsBuffer, (Serializer)bitmapWriter);
        Supplier dictionarySupplier = FixedIndexed.read((ByteBuffer)localDictionaryBuffer, (TypeStrategy)CompressedNestedDataComplexColumn.INT_TYPE_STRATEGY, (ByteOrder)ByteOrder.nativeOrder(), (int)4);
        GenericIndexed bitmaps = GenericIndexed.read((ByteBuffer)bitmapsBuffer, (ObjectStrategy)this.roaringFactory.getObjectStrategy());
        return new NestedFieldColumnIndexSupplier(new FieldTypeInfo.TypeSet(new FieldTypeInfo.MutableTypeSet().add(ColumnType.STRING).getByteValue()), this.roaringFactory.getBitmapFactory(), columnConfig, bitmaps, dictionarySupplier, this.globalStrings, this.globalLongs, this.globalDoubles, this.globalArrays, null, null);
    }

    private NestedFieldColumnIndexSupplier<?> makeSingleTypeStringWithNullsSupplier() throws IOException {
        return this.makeSingleTypeStringWithNullsSupplier(ColumnConfig.SELECTION_SIZE);
    }

    private NestedFieldColumnIndexSupplier<?> makeSingleTypeStringWithNullsSupplier(ColumnConfig columnConfig) throws IOException {
        ByteBuffer localDictionaryBuffer = ByteBuffer.allocate(4096).order(ByteOrder.nativeOrder());
        ByteBuffer bitmapsBuffer = ByteBuffer.allocate(4096);
        FixedIndexedWriter localDictionaryWriter = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), (TypeStrategy)CompressedNestedDataComplexColumn.INT_TYPE_STRATEGY, ByteOrder.nativeOrder(), 4, true);
        localDictionaryWriter.open();
        GenericIndexedWriter bitmapWriter = new GenericIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), "bitmaps", this.roaringFactory.getObjectStrategy());
        bitmapWriter.setObjectsNotSorted();
        bitmapWriter.open();
        localDictionaryWriter.write((Object)0);
        bitmapWriter.write((Object)this.fillBitmap(1, 7, 8));
        localDictionaryWriter.write((Object)2);
        bitmapWriter.write((Object)this.fillBitmap(3));
        localDictionaryWriter.write((Object)4);
        bitmapWriter.write((Object)this.fillBitmap(0, 9));
        localDictionaryWriter.write((Object)5);
        bitmapWriter.write((Object)this.fillBitmap(2, 5));
        localDictionaryWriter.write((Object)9);
        bitmapWriter.write((Object)this.fillBitmap(4, 6));
        NestedFieldColumnIndexSupplierTest.writeToBuffer(localDictionaryBuffer, (Serializer)localDictionaryWriter);
        NestedFieldColumnIndexSupplierTest.writeToBuffer(bitmapsBuffer, (Serializer)bitmapWriter);
        Supplier dictionarySupplier = FixedIndexed.read((ByteBuffer)localDictionaryBuffer, (TypeStrategy)CompressedNestedDataComplexColumn.INT_TYPE_STRATEGY, (ByteOrder)ByteOrder.nativeOrder(), (int)4);
        GenericIndexed bitmaps = GenericIndexed.read((ByteBuffer)bitmapsBuffer, (ObjectStrategy)this.roaringFactory.getObjectStrategy());
        return new NestedFieldColumnIndexSupplier(new FieldTypeInfo.TypeSet(new FieldTypeInfo.MutableTypeSet().add(ColumnType.STRING).getByteValue()), this.roaringFactory.getBitmapFactory(), columnConfig, bitmaps, dictionarySupplier, this.globalStrings, this.globalLongs, this.globalDoubles, this.globalArrays, null, null);
    }

    private NestedFieldColumnIndexSupplier<?> makeSingleTypeLongSupplier() throws IOException {
        return this.makeSingleTypeLongSupplier(ColumnConfig.SELECTION_SIZE);
    }

    private NestedFieldColumnIndexSupplier<?> makeSingleTypeLongSupplier(ColumnConfig columnConfig) throws IOException {
        ByteBuffer localDictionaryBuffer = ByteBuffer.allocate(4096).order(ByteOrder.nativeOrder());
        ByteBuffer bitmapsBuffer = ByteBuffer.allocate(4096);
        FixedIndexedWriter localDictionaryWriter = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), (TypeStrategy)CompressedNestedDataComplexColumn.INT_TYPE_STRATEGY, ByteOrder.nativeOrder(), 4, true);
        localDictionaryWriter.open();
        GenericIndexedWriter bitmapWriter = new GenericIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), "bitmaps", this.roaringFactory.getObjectStrategy());
        bitmapWriter.setObjectsNotSorted();
        bitmapWriter.open();
        localDictionaryWriter.write((Object)10);
        bitmapWriter.write((Object)this.fillBitmap(1, 3, 9));
        localDictionaryWriter.write((Object)12);
        bitmapWriter.write((Object)this.fillBitmap(4, 5));
        localDictionaryWriter.write((Object)14);
        bitmapWriter.write((Object)this.fillBitmap(0, 6));
        localDictionaryWriter.write((Object)15);
        bitmapWriter.write((Object)this.fillBitmap(2, 7, 8));
        NestedFieldColumnIndexSupplierTest.writeToBuffer(localDictionaryBuffer, (Serializer)localDictionaryWriter);
        NestedFieldColumnIndexSupplierTest.writeToBuffer(bitmapsBuffer, (Serializer)bitmapWriter);
        Supplier dictionarySupplier = FixedIndexed.read((ByteBuffer)localDictionaryBuffer, (TypeStrategy)CompressedNestedDataComplexColumn.INT_TYPE_STRATEGY, (ByteOrder)ByteOrder.nativeOrder(), (int)4);
        GenericIndexed bitmaps = GenericIndexed.read((ByteBuffer)bitmapsBuffer, (ObjectStrategy)this.roaringFactory.getObjectStrategy());
        return new NestedFieldColumnIndexSupplier(new FieldTypeInfo.TypeSet(new FieldTypeInfo.MutableTypeSet().add(ColumnType.LONG).getByteValue()), this.roaringFactory.getBitmapFactory(), columnConfig, bitmaps, dictionarySupplier, this.globalStrings, this.globalLongs, this.globalDoubles, this.globalArrays, null, null);
    }

    private NestedFieldColumnIndexSupplier<?> makeSingleTypeLongSupplierWithNull() throws IOException {
        return this.makeSingleTypeLongSupplierWithNull(ColumnConfig.SELECTION_SIZE);
    }

    private NestedFieldColumnIndexSupplier<?> makeSingleTypeLongSupplierWithNull(ColumnConfig columnConfig) throws IOException {
        ByteBuffer localDictionaryBuffer = ByteBuffer.allocate(4096).order(ByteOrder.nativeOrder());
        ByteBuffer bitmapsBuffer = ByteBuffer.allocate(4096);
        FixedIndexedWriter localDictionaryWriter = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), (TypeStrategy)CompressedNestedDataComplexColumn.INT_TYPE_STRATEGY, ByteOrder.nativeOrder(), 4, true);
        localDictionaryWriter.open();
        GenericIndexedWriter bitmapWriter = new GenericIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), "bitmaps", this.roaringFactory.getObjectStrategy());
        bitmapWriter.setObjectsNotSorted();
        bitmapWriter.open();
        localDictionaryWriter.write((Object)0);
        bitmapWriter.write((Object)this.fillBitmap(2, 5, 8));
        localDictionaryWriter.write((Object)10);
        bitmapWriter.write((Object)this.fillBitmap(1, 3, 9));
        localDictionaryWriter.write((Object)12);
        bitmapWriter.write((Object)this.fillBitmap(4));
        localDictionaryWriter.write((Object)14);
        bitmapWriter.write((Object)this.fillBitmap(0, 6));
        localDictionaryWriter.write((Object)15);
        bitmapWriter.write((Object)this.fillBitmap(7));
        NestedFieldColumnIndexSupplierTest.writeToBuffer(localDictionaryBuffer, (Serializer)localDictionaryWriter);
        NestedFieldColumnIndexSupplierTest.writeToBuffer(bitmapsBuffer, (Serializer)bitmapWriter);
        Supplier dictionarySupplier = FixedIndexed.read((ByteBuffer)localDictionaryBuffer, (TypeStrategy)CompressedNestedDataComplexColumn.INT_TYPE_STRATEGY, (ByteOrder)ByteOrder.nativeOrder(), (int)4);
        GenericIndexed bitmaps = GenericIndexed.read((ByteBuffer)bitmapsBuffer, (ObjectStrategy)this.roaringFactory.getObjectStrategy());
        return new NestedFieldColumnIndexSupplier(new FieldTypeInfo.TypeSet(new FieldTypeInfo.MutableTypeSet().add(ColumnType.LONG).getByteValue()), this.roaringFactory.getBitmapFactory(), columnConfig, bitmaps, dictionarySupplier, this.globalStrings, this.globalLongs, this.globalDoubles, this.globalArrays, null, null);
    }

    private NestedFieldColumnIndexSupplier<?> makeSingleTypeDoubleSupplier() throws IOException {
        return this.makeSingleTypeDoubleSupplier(ColumnConfig.SELECTION_SIZE);
    }

    private NestedFieldColumnIndexSupplier<?> makeSingleTypeDoubleSupplier(ColumnConfig columnConfig) throws IOException {
        ByteBuffer localDictionaryBuffer = ByteBuffer.allocate(4096).order(ByteOrder.nativeOrder());
        ByteBuffer bitmapsBuffer = ByteBuffer.allocate(4096);
        FixedIndexedWriter localDictionaryWriter = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), (TypeStrategy)CompressedNestedDataComplexColumn.INT_TYPE_STRATEGY, ByteOrder.nativeOrder(), 4, true);
        localDictionaryWriter.open();
        GenericIndexedWriter bitmapWriter = new GenericIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), "bitmaps", this.roaringFactory.getObjectStrategy());
        bitmapWriter.setObjectsNotSorted();
        bitmapWriter.open();
        localDictionaryWriter.write((Object)18);
        bitmapWriter.write((Object)this.fillBitmap(0, 1, 8));
        localDictionaryWriter.write((Object)19);
        bitmapWriter.write((Object)this.fillBitmap(2, 4, 7));
        localDictionaryWriter.write((Object)22);
        bitmapWriter.write((Object)this.fillBitmap(3, 6, 9));
        localDictionaryWriter.write((Object)23);
        bitmapWriter.write((Object)this.fillBitmap(5));
        NestedFieldColumnIndexSupplierTest.writeToBuffer(localDictionaryBuffer, (Serializer)localDictionaryWriter);
        NestedFieldColumnIndexSupplierTest.writeToBuffer(bitmapsBuffer, (Serializer)bitmapWriter);
        Supplier dictionarySupplier = FixedIndexed.read((ByteBuffer)localDictionaryBuffer, (TypeStrategy)CompressedNestedDataComplexColumn.INT_TYPE_STRATEGY, (ByteOrder)ByteOrder.nativeOrder(), (int)4);
        GenericIndexed bitmaps = GenericIndexed.read((ByteBuffer)bitmapsBuffer, (ObjectStrategy)this.roaringFactory.getObjectStrategy());
        return new NestedFieldColumnIndexSupplier(new FieldTypeInfo.TypeSet(new FieldTypeInfo.MutableTypeSet().add(ColumnType.DOUBLE).getByteValue()), this.roaringFactory.getBitmapFactory(), columnConfig, bitmaps, dictionarySupplier, this.globalStrings, this.globalLongs, this.globalDoubles, this.globalArrays, null, null);
    }

    private NestedFieldColumnIndexSupplier<?> makeSingleTypeDoubleSupplierWithNull() throws IOException {
        return this.makeSingleTypeDoubleSupplierWithNull(ColumnConfig.SELECTION_SIZE);
    }

    private NestedFieldColumnIndexSupplier<?> makeSingleTypeDoubleSupplierWithNull(ColumnConfig columnConfig) throws IOException {
        ByteBuffer localDictionaryBuffer = ByteBuffer.allocate(4096).order(ByteOrder.nativeOrder());
        ByteBuffer bitmapsBuffer = ByteBuffer.allocate(4096);
        FixedIndexedWriter localDictionaryWriter = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), (TypeStrategy)CompressedNestedDataComplexColumn.INT_TYPE_STRATEGY, ByteOrder.nativeOrder(), 4, true);
        localDictionaryWriter.open();
        GenericIndexedWriter bitmapWriter = new GenericIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), "bitmaps", this.roaringFactory.getObjectStrategy());
        bitmapWriter.setObjectsNotSorted();
        bitmapWriter.open();
        localDictionaryWriter.write((Object)0);
        bitmapWriter.write((Object)this.fillBitmap(1, 3, 6));
        localDictionaryWriter.write((Object)18);
        bitmapWriter.write((Object)this.fillBitmap(0, 8));
        localDictionaryWriter.write((Object)19);
        bitmapWriter.write((Object)this.fillBitmap(2, 4, 7));
        localDictionaryWriter.write((Object)22);
        bitmapWriter.write((Object)this.fillBitmap(9));
        localDictionaryWriter.write((Object)23);
        bitmapWriter.write((Object)this.fillBitmap(5));
        NestedFieldColumnIndexSupplierTest.writeToBuffer(localDictionaryBuffer, (Serializer)localDictionaryWriter);
        NestedFieldColumnIndexSupplierTest.writeToBuffer(bitmapsBuffer, (Serializer)bitmapWriter);
        Supplier dictionarySupplier = FixedIndexed.read((ByteBuffer)localDictionaryBuffer, (TypeStrategy)CompressedNestedDataComplexColumn.INT_TYPE_STRATEGY, (ByteOrder)ByteOrder.nativeOrder(), (int)4);
        GenericIndexed bitmaps = GenericIndexed.read((ByteBuffer)bitmapsBuffer, (ObjectStrategy)this.roaringFactory.getObjectStrategy());
        return new NestedFieldColumnIndexSupplier(new FieldTypeInfo.TypeSet(new FieldTypeInfo.MutableTypeSet().add(ColumnType.DOUBLE).getByteValue()), this.roaringFactory.getBitmapFactory(), columnConfig, bitmaps, dictionarySupplier, this.globalStrings, this.globalLongs, this.globalDoubles, this.globalArrays, null, null);
    }

    private NestedFieldColumnIndexSupplier<?> makeVariantSupplierWithNull() throws IOException {
        return this.makeVariantSupplierWithNull(ColumnConfig.SELECTION_SIZE);
    }

    private NestedFieldColumnIndexSupplier<?> makeVariantSupplierWithNull(ColumnConfig columnConfig) throws IOException {
        ByteBuffer localDictionaryBuffer = ByteBuffer.allocate(4096).order(ByteOrder.nativeOrder());
        ByteBuffer bitmapsBuffer = ByteBuffer.allocate(4096);
        FixedIndexedWriter localDictionaryWriter = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), (TypeStrategy)CompressedNestedDataComplexColumn.INT_TYPE_STRATEGY, ByteOrder.nativeOrder(), 4, true);
        localDictionaryWriter.open();
        GenericIndexedWriter bitmapWriter = new GenericIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), "bitmaps", this.roaringFactory.getObjectStrategy());
        bitmapWriter.setObjectsNotSorted();
        bitmapWriter.open();
        localDictionaryWriter.write((Object)0);
        bitmapWriter.write((Object)this.fillBitmap(2, 7));
        localDictionaryWriter.write((Object)2);
        bitmapWriter.write((Object)this.fillBitmap(1, 9));
        localDictionaryWriter.write((Object)9);
        bitmapWriter.write((Object)this.fillBitmap(6));
        localDictionaryWriter.write((Object)10);
        bitmapWriter.write((Object)this.fillBitmap(0, 5));
        localDictionaryWriter.write((Object)15);
        bitmapWriter.write((Object)this.fillBitmap(4));
        localDictionaryWriter.write((Object)18);
        bitmapWriter.write((Object)this.fillBitmap(8));
        localDictionaryWriter.write((Object)24);
        bitmapWriter.write((Object)this.fillBitmap(3));
        NestedFieldColumnIndexSupplierTest.writeToBuffer(localDictionaryBuffer, (Serializer)localDictionaryWriter);
        NestedFieldColumnIndexSupplierTest.writeToBuffer(bitmapsBuffer, (Serializer)bitmapWriter);
        Supplier dictionarySupplier = FixedIndexed.read((ByteBuffer)localDictionaryBuffer, (TypeStrategy)CompressedNestedDataComplexColumn.INT_TYPE_STRATEGY, (ByteOrder)ByteOrder.nativeOrder(), (int)4);
        GenericIndexed bitmaps = GenericIndexed.read((ByteBuffer)bitmapsBuffer, (ObjectStrategy)this.roaringFactory.getObjectStrategy());
        return new NestedFieldColumnIndexSupplier(new FieldTypeInfo.TypeSet(new FieldTypeInfo.MutableTypeSet().add(ColumnType.STRING).add(ColumnType.LONG).add(ColumnType.DOUBLE).getByteValue()), this.roaringFactory.getBitmapFactory(), columnConfig, bitmaps, dictionarySupplier, this.globalStrings, this.globalLongs, this.globalDoubles, this.globalArrays, null, null);
    }

    private ImmutableBitmap fillBitmap(int ... rows) {
        MutableBitmap bitmap = this.roaringFactory.getBitmapFactory().makeEmptyMutableBitmap();
        for (int i : rows) {
            bitmap.add(i);
        }
        return this.roaringFactory.getBitmapFactory().makeImmutableBitmap(bitmap);
    }

    void checkBitmap(ImmutableBitmap bitmap, int ... expectedRows) {
        IntIterator iterator = bitmap.iterator();
        for (int i : expectedRows) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((long)i, (long)iterator.next());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    static void writeToBuffer(final ByteBuffer buffer, Serializer serializer) throws IOException {
        WritableByteChannel channel = new WritableByteChannel(){

            @Override
            public int write(ByteBuffer src) {
                int size = src.remaining();
                buffer.put(src);
                return size;
            }

            @Override
            public boolean isOpen() {
                return true;
            }

            @Override
            public void close() {
            }
        };
        serializer.writeTo(channel, null);
        buffer.position(0);
    }
}

