/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.segment.nested.NestedPathArrayElement;
import org.apache.druid.segment.nested.NestedPathField;
import org.apache.druid.segment.nested.NestedPathPart;
import org.junit.Assert;
import org.junit.Test;

public class NestedPathPartTest {
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();
    private static final TypeReference<List<NestedPathPart>> TYPE_REF = new TypeReference<List<NestedPathPart>>(){};

    @Test
    public void testMapFieldSerde() throws JsonProcessingException {
        NestedPathField fieldPart = new NestedPathField("x");
        String json = JSON_MAPPER.writeValueAsString((Object)fieldPart);
        Assert.assertEquals((Object)fieldPart, (Object)JSON_MAPPER.readValue(json, NestedPathPart.class));
    }

    @Test
    public void testArrayElementSerde() throws JsonProcessingException {
        NestedPathArrayElement arrayElementPart = new NestedPathArrayElement(1);
        String json = JSON_MAPPER.writeValueAsString((Object)arrayElementPart);
        Assert.assertEquals((Object)arrayElementPart, (Object)JSON_MAPPER.readValue(json, NestedPathPart.class));
    }

    @Test
    public void testFieldEqualsAndHashCode() {
        EqualsVerifier.forClass(NestedPathField.class).usingGetClass().withNonnullFields(new String[]{"field"}).verify();
    }

    @Test
    public void testArrayElementEqualsAndHashCode() {
        EqualsVerifier.forClass(NestedPathArrayElement.class).usingGetClass().verify();
    }
}

