/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ListIndexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.CombineFirstTwoEntriesIndexed;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class CombineFirstTwoEntriesIndexedTest
extends InitializedNullHandlingTest {
    @Test
    public void testSizeZero() {
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.wrap(Indexed.empty(), "xyz"));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Size[0] must be >= 2")));
    }

    @Test
    public void testSizeOne() {
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.wrap((Indexed)new ListIndexed((Object[])new String[]{"foo"}), (Object)"xyz"));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Size[1] must be >= 2")));
    }

    @Test
    public void testSizeTwo() {
        CombineFirstTwoEntriesIndexed<String> indexed = this.wrap((Indexed)new ListIndexed((Object[])new String[]{"bar", "foo"}), (Object)"xyz");
        Assert.assertEquals((long)0L, (long)indexed.indexOf((Object)"xyz"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"foo"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"bar"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"baz"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"qux"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)""));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf(null));
        Assert.assertEquals((long)1L, (long)indexed.size());
        Assert.assertEquals((Object)"xyz", (Object)indexed.get(0));
        Assert.assertFalse((boolean)indexed.isSorted());
        Assert.assertEquals((Object)ImmutableList.of((Object)"xyz"), (Object)ImmutableList.copyOf(indexed));
    }

    @Test
    public void testSizeThree() {
        CombineFirstTwoEntriesIndexed<String> indexed = this.wrap((Indexed)new ListIndexed((Object[])new String[]{"bar", "baz", "foo"}), (Object)"xyz");
        Assert.assertEquals((long)0L, (long)indexed.indexOf((Object)"xyz"));
        Assert.assertEquals((long)1L, (long)indexed.indexOf((Object)"foo"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"bar"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"baz"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"qux"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)""));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf(null));
        Assert.assertEquals((Object)"xyz", (Object)indexed.get(0));
        Assert.assertEquals((Object)"foo", (Object)indexed.get(1));
        Assert.assertFalse((boolean)indexed.isSorted());
        Assert.assertEquals((Object)ImmutableList.of((Object)"xyz", (Object)"foo"), (Object)ImmutableList.copyOf(indexed));
    }

    @Test
    public void testSizeTwoSorted() {
        CombineFirstTwoEntriesIndexed<Object> indexed = this.wrap((Indexed)GenericIndexed.fromArray((Object[])new String[]{"bar", "foo"}, (ObjectStrategy)GenericIndexed.STRING_STRATEGY), null);
        Assert.assertEquals((long)0L, (long)indexed.indexOf(null));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"foo"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"bar"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"baz"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"qux"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)""));
        Assert.assertEquals((long)1L, (long)indexed.size());
        Assert.assertNull((Object)indexed.get(0));
        Assert.assertTrue((boolean)indexed.isSorted());
        Assert.assertEquals(Collections.singletonList(null), (Object)Lists.newArrayList(indexed));
    }

    @Test
    public void testSizeThreeSorted() {
        CombineFirstTwoEntriesIndexed<Object> indexed = this.wrap((Indexed)GenericIndexed.fromArray((Object[])new String[]{"bar", "baz", "foo"}, (ObjectStrategy)GenericIndexed.STRING_STRATEGY), null);
        Assert.assertEquals((long)0L, (long)indexed.indexOf(null));
        Assert.assertEquals((long)1L, (long)indexed.indexOf((Object)"foo"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"bar"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"baz"));
        Assert.assertEquals((long)-3L, (long)indexed.indexOf((Object)"qux"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)""));
        Assert.assertEquals((long)2L, (long)indexed.size());
        Assert.assertNull((Object)indexed.get(0));
        Assert.assertEquals((Object)"foo", (Object)indexed.get(1));
        Assert.assertTrue((boolean)indexed.isSorted());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{null, "foo"}), (Object)Lists.newArrayList(indexed));
    }

    private <T> CombineFirstTwoEntriesIndexed<T> wrap(Indexed<T> indexed, final @Nullable T newFirstValue) {
        return new CombineFirstTwoEntriesIndexed<T>(indexed){

            protected T newFirstValue() {
                return newFirstValue;
            }
        };
    }
}

