/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.druid.segment.data.ColumnarMultiInts;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.VSizeColumnarInts;
import org.apache.druid.segment.data.VSizeColumnarMultiInts;
import org.apache.druid.segment.serde.CombineFirstTwoValuesColumnarMultiInts;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CombineFirstTwoValuesColumnarMultiIntsTest {
    private ColumnarMultiInts original;
    private CombineFirstTwoValuesColumnarMultiInts combined;

    @Before
    public void setUp() {
        this.original = VSizeColumnarMultiInts.fromIterable((Iterable)ImmutableList.of((Object)VSizeColumnarInts.fromArray((int[])new int[]{1, 2, 3}), (Object)VSizeColumnarInts.fromArray((int[])new int[]{0, 1, 2, 3}), (Object)VSizeColumnarInts.fromArray((int[])new int[]{3, 0, 2, 1, 5, 0})));
        this.combined = new CombineFirstTwoValuesColumnarMultiInts(this.original);
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)this.original.size(), (long)this.combined.size());
    }

    @Test
    public void testGet() {
        this.assertEquals(new int[]{0, 1, 2}, this.combined.get(0));
        this.assertEquals(new int[]{0, 0, 1, 2}, this.combined.get(1));
        this.assertEquals(new int[]{2, 0, 1, 0, 4, 0}, this.combined.get(2));
        Assert.assertSame((Object)this.combined.get(1), (Object)this.combined.get(0));
    }

    @Test
    public void testGetUnshared() {
        this.assertEquals(new int[]{0, 1, 2}, this.combined.getUnshared(0));
        this.assertEquals(new int[]{0, 0, 1, 2}, this.combined.getUnshared(1));
        this.assertEquals(new int[]{2, 0, 1, 0, 4, 0}, this.combined.getUnshared(2));
        Assert.assertNotSame((Object)this.combined.getUnshared(1), (Object)this.combined.getUnshared(0));
    }

    @Test
    public void testIndexOf() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.combined.indexOf(this.original.get(0)));
    }

    @Test
    public void testIsSorted() {
        Assert.assertFalse((boolean)this.combined.isSorted());
    }

    @Test
    public void testIterator() {
        ArrayList fromIterator = Lists.newArrayList((Iterator)this.combined.iterator());
        Assert.assertEquals((long)3L, (long)fromIterator.size());
        this.assertEquals(new int[]{0, 1, 2}, (IndexedInts)fromIterator.get(0));
        this.assertEquals(new int[]{0, 0, 1, 2}, (IndexedInts)fromIterator.get(1));
        this.assertEquals(new int[]{2, 0, 1, 0, 4, 0}, (IndexedInts)fromIterator.get(2));
    }

    public void assertEquals(int[] expected, IndexedInts actual) {
        int sz = actual.size();
        int[] actualArray = new int[sz];
        for (int i = 0; i < sz; ++i) {
            actualArray[i] = actual.get(i);
        }
        Assert.assertArrayEquals((int[])expected, (int[])actualArray);
    }
}

