/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import it.unimi.dsi.fastutil.ints.IntArrays;
import java.util.Arrays;
import java.util.function.Function;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.serde.CombineFirstTwoValuesIndexedInts;
import org.junit.Assert;
import org.junit.Test;

public class CombineFirstTwoValuesIndexedIntsTest {
    @Test
    public void testCombineFirstTwoValues() {
        CombineFirstTwoValuesIndexedIntsTest.assertCombine(new int[]{0, 1, 2}, new int[]{1, 2, 3});
        CombineFirstTwoValuesIndexedIntsTest.assertCombine(new int[]{0, 0, 1, 2}, new int[]{0, 1, 2, 3});
        CombineFirstTwoValuesIndexedIntsTest.assertCombine(new int[]{2, 0, 1, 0, 4, 0}, new int[]{3, 0, 2, 1, 5, 0});
    }

    private static void assertCombine(int[] expectedCombined, int[] original) {
        CombineFirstTwoValuesIndexedIntsTest.assertCombine(expectedCombined, original, arr -> new CombineFirstTwoValuesIndexedInts((IndexedInts)new ArrayBasedIndexedInts(arr)));
    }

    static void assertCombine(int[] expectedCombined, int[] original, Function<int[], IndexedInts> combineFn) {
        IndexedInts combined = combineFn.apply(original);
        Assert.assertEquals((String)StringUtils.format((String)"%s (size)", (Object[])new Object[]{Arrays.toString(original)}), (long)expectedCombined.length, (long)combined.size());
        int[] arr = new int[expectedCombined.length];
        for (int i = 0; i < expectedCombined.length; ++i) {
            arr[i] = combined.get(i);
        }
        Assert.assertArrayEquals((String)StringUtils.format((String)"%s (get)", (Object[])new Object[]{Arrays.toString(original)}), (int[])expectedCombined, (int[])arr);
        Arrays.fill(arr, Integer.MIN_VALUE);
        combined.get(arr, 0, arr.length);
        Assert.assertArrayEquals((String)StringUtils.format((String)"%s (contiguous vector get)", (Object[])new Object[]{Arrays.toString(original)}), (int[])expectedCombined, (int[])arr);
        int[] indexes = new int[expectedCombined.length];
        for (int i = 0; i < expectedCombined.length; ++i) {
            indexes[indexes.length - 1 - i] = i;
        }
        Arrays.fill(arr, Integer.MIN_VALUE);
        combined.get(arr, indexes, arr.length);
        int[] expectedCombinedReversed = IntArrays.reverse((int[])IntArrays.copy((int[])expectedCombined));
        Assert.assertArrayEquals((String)StringUtils.format((String)"%s (noncontiguous vector get, reversed)", (Object[])new Object[]{Arrays.toString(original)}), (int[])expectedCombinedReversed, (int[])arr);
    }
}

