/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.google.common.collect.Lists;
import java.util.Collections;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ListIndexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.ReplaceFirstValueWithNullIndexed;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class ReplaceFirstValueWithNullIndexedTest
extends InitializedNullHandlingTest {
    @Test
    public void testSizeZero() {
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> new ReplaceFirstValueWithNullIndexed(Indexed.empty()));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Size[0] must be >= 1")));
    }

    @Test
    public void testSizeOne() {
        ReplaceFirstValueWithNullIndexed indexed = new ReplaceFirstValueWithNullIndexed((Indexed)new ListIndexed((Object[])new String[]{"bar"}));
        Assert.assertEquals((long)0L, (long)indexed.indexOf(null));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)""));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"foo"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"bar"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"baz"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"qux"));
        Assert.assertEquals((long)1L, (long)indexed.size());
        Assert.assertNull((Object)indexed.get(0));
        Assert.assertFalse((boolean)indexed.isSorted());
        Assert.assertEquals(Collections.singletonList(null), (Object)Lists.newArrayList((Iterable)indexed));
    }

    @Test
    public void testSizeTwo() {
        ReplaceFirstValueWithNullIndexed indexed = new ReplaceFirstValueWithNullIndexed((Indexed)new ListIndexed((Object[])new String[]{"bar", "foo"}));
        Assert.assertEquals((long)0L, (long)indexed.indexOf(null));
        Assert.assertEquals((long)1L, (long)indexed.indexOf((Object)"foo"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)""));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"bar"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"baz"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"qux"));
        Assert.assertEquals((long)2L, (long)indexed.size());
        Assert.assertNull((Object)indexed.get(0));
        Assert.assertEquals((Object)"foo", (Object)indexed.get(1));
        Assert.assertFalse((boolean)indexed.isSorted());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{null, "foo"}), (Object)Lists.newArrayList((Iterable)indexed));
    }

    @Test
    public void testSizeOneSorted() {
        ReplaceFirstValueWithNullIndexed indexed = new ReplaceFirstValueWithNullIndexed((Indexed)GenericIndexed.fromArray((Object[])new String[]{"bar"}, (ObjectStrategy)GenericIndexed.STRING_STRATEGY));
        Assert.assertEquals((long)0L, (long)indexed.indexOf(null));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)""));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"foo"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"bar"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"baz"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"qux"));
        Assert.assertEquals((long)1L, (long)indexed.size());
        Assert.assertNull((Object)indexed.get(0));
        Assert.assertTrue((boolean)indexed.isSorted());
        Assert.assertEquals(Collections.singletonList(null), (Object)Lists.newArrayList((Iterable)indexed));
    }

    @Test
    public void testSizeTwoSorted() {
        ReplaceFirstValueWithNullIndexed indexed = new ReplaceFirstValueWithNullIndexed((Indexed)GenericIndexed.fromArray((Object[])new String[]{"bar", "foo"}, (ObjectStrategy)GenericIndexed.STRING_STRATEGY));
        Assert.assertEquals((long)0L, (long)indexed.indexOf(null));
        Assert.assertEquals((long)1L, (long)indexed.indexOf((Object)"foo"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)""));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"bar"));
        Assert.assertEquals((long)-2L, (long)indexed.indexOf((Object)"baz"));
        Assert.assertEquals((long)-3L, (long)indexed.indexOf((Object)"qux"));
        Assert.assertEquals((long)2L, (long)indexed.size());
        Assert.assertNull((Object)indexed.get(0));
        Assert.assertEquals((Object)"foo", (Object)indexed.get(1));
        Assert.assertTrue((boolean)indexed.isSorted());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{null, "foo"}), (Object)Lists.newArrayList((Iterable)indexed));
    }
}

