/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.timeline.partition.BuildingNumberedShardSpec;
import org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class BuildingNumberedShardSpecTest {
    @Test
    public void testConvert() {
        Assert.assertEquals((Object)new NumberedShardSpec(5, 10), (Object)new BuildingNumberedShardSpec(5).convert(10));
    }

    @Test
    public void testCreateChunk() {
        Assert.assertEquals((Object)new NumberedPartitionChunk(5, 0, (Object)"test"), (Object)new BuildingNumberedShardSpec(5).createChunk((Object)"test"));
    }

    @Test
    public void testSerde() throws JsonProcessingException {
        ObjectMapper mapper = ShardSpecTestUtils.initObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerSubtypes(new NamedType[]{new NamedType(BuildingNumberedShardSpec.class, "building_numbered")});
        BuildingNumberedShardSpec original = new BuildingNumberedShardSpec(5);
        String json = mapper.writeValueAsString((Object)original);
        ShardSpec shardSpec = (ShardSpec)mapper.readValue(json, ShardSpec.class);
        Assert.assertEquals((Object)"building_numbered", (Object)shardSpec.getType());
        BuildingNumberedShardSpec fromJson = (BuildingNumberedShardSpec)shardSpec;
        Assert.assertEquals((Object)original, (Object)fromJson);
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(BuildingNumberedShardSpec.class).usingGetClass().verify();
    }
}

