/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import io.netty.util.SuppressForbidden;
import java.io.Closeable;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.prefetch.ObjectOpenFunction;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.MappedByteBufferHandler;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.StreamUtils;
import org.apache.druid.java.util.common.StringUtils;

public class FileUtils {
    public static final Predicate<Throwable> IS_EXCEPTION = input -> input instanceof Exception;

    public static FileCopyResult retryCopy(ByteSource byteSource, File outFile, Predicate<Throwable> shouldRetry, int maxAttempts) {
        try {
            StreamUtils.retryCopy(byteSource, com.google.common.io.Files.asByteSink((File)outFile, (FileWriteMode[])new FileWriteMode[0]), shouldRetry, maxAttempts);
            return new FileCopyResult(outFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static MappedByteBufferHandler map(File file) throws IOException {
        return FileUtils.map(file, 0L, file.length());
    }

    /*
     * Exception decompiling
     */
    public static MappedByteBufferHandler map(File file, long offset, long length) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static MappedByteBufferHandler map(RandomAccessFile randomAccessFile, long offset, long length) throws IOException {
        if (length > Integer.MAX_VALUE) {
            throw new IAE("Cannot map region larger than %,d bytes", Integer.MAX_VALUE);
        }
        FileChannel channel = randomAccessFile.getChannel();
        MappedByteBuffer mappedByteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, offset, length);
        return new MappedByteBufferHandler(mappedByteBuffer);
    }

    public static <T> T writeAtomically(File file, OutputStreamConsumer<T> f) throws IOException {
        return FileUtils.writeAtomically(file, file.getParentFile(), f);
    }

    public static <T> T writeAtomically(File file, File tmpDir, OutputStreamConsumer<T> f) throws IOException {
        File tmpFile = new File(tmpDir, StringUtils.format(".%s.%s", file.getName(), UUID.randomUUID()));
        try (Closeable deleter = () -> Files.deleteIfExists(tmpFile.toPath());){
            T retVal;
            try (FileChannel fileChannel = FileChannel.open(tmpFile.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
                 OutputStream out = Channels.newOutputStream(fileChannel);){
                retVal = f.apply(FileUtils.uncloseable(out));
                fileChannel.force(true);
            }
            Files.move(tmpFile.toPath(), file.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            var8_7 = null;
            try (FileChannel directory = FileChannel.open(file.getParentFile().toPath(), StandardOpenOption.READ);){
                directory.force(true);
            }
            catch (Throwable throwable) {
                var8_7 = throwable;
                throw throwable;
            }
            T t = retVal;
            return t;
        }
    }

    private static OutputStream uncloseable(OutputStream out) {
        return new FilterOutputStream(out){

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
            }

            @Override
            public void close() {
            }
        };
    }

    public static <T> long copyLarge(T object, ObjectOpenFunction<T> objectOpenFunction, File outFile, byte[] fetchBuffer, Predicate<Throwable> retryCondition, int numTries, String messageOnRetry) throws IOException {
        return FileUtils.copyLarge(() -> objectOpenFunction.open(object), outFile, fetchBuffer, retryCondition, numTries, messageOnRetry);
    }

    public static long copyLarge(InputStreamSupplier inputSource, File outFile, byte[] fetchBuffer, Predicate<Throwable> retryCondition, int numTries, String messageOnRetry) throws IOException {
        try {
            return RetryUtils.retry(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }, retryCondition, outFile::delete, numTries, messageOnRetry);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static long getFileSize(File file) {
        if (file == null) {
            return 0L;
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children == null) {
                return 0L;
            }
            long totalSize = 0L;
            for (File child : children) {
                totalSize += child.length();
            }
            return totalSize;
        }
        return file.length();
    }

    public static File createTempDir() {
        return FileUtils.createTempDir(null);
    }

    public static File createTempDir(@Nullable String prefix) {
        return FileUtils.createTempDirInLocation(FileUtils.getTempDir(), prefix);
    }

    public static Path getTempDir() {
        String parentDirectory = System.getProperty("java.io.tmpdir");
        if (parentDirectory == null) {
            throw new ISE("System property java.io.tmpdir is not set, cannot create temporary directories", new Object[0]);
        }
        return new File(parentDirectory).toPath();
    }

    @SuppressForbidden(reason="Files#createTempDirectory")
    public static File createTempDirInLocation(Path parentDirectory, @Nullable String prefix) {
        try {
            Path tmpPath = Files.createTempDirectory(parentDirectory, prefix == null || prefix.isEmpty() ? "druid" : prefix, new FileAttribute[0]);
            return tmpPath.toFile();
        }
        catch (IOException e) {
            if (e instanceof NoSuchFileException && !parentDirectory.toFile().exists()) {
                throw new ISE("Path [%s] does not exist", parentDirectory);
            }
            if (e instanceof FileSystemException && e.getMessage().contains("Read-only file system") || e instanceof AccessDeniedException) {
                throw new ISE("Path [%s] is not writable, check permissions", parentDirectory);
            }
            throw new ISE(e, "Failed to create temporary directory in path [%s]", parentDirectory);
        }
    }

    @SuppressForbidden(reason="File#mkdirs")
    public static void mkdirp(File directory) throws IOException {
        if (!directory.mkdirs() && !directory.isDirectory()) {
            throw new IOE("Cannot create directory [%s]", directory);
        }
    }

    @SuppressForbidden(reason="FilesUtils#deleteDirectory")
    public static void deleteDirectory(File directory) throws IOException {
        org.apache.commons.io.FileUtils.deleteDirectory((File)directory);
    }

    public static LinkOrCopyResult linkOrCopy(File src, File dest) throws IOException {
        try {
            Files.createLink(dest.toPath(), src.toPath());
            return LinkOrCopyResult.LINK;
        }
        catch (IOException e) {
            Files.copy(src.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return LinkOrCopyResult.COPY;
        }
    }

    public static interface InputStreamSupplier {
        public InputStream openStream() throws IOException;
    }

    public static interface OutputStreamConsumer<T> {
        public T apply(OutputStream var1) throws IOException;
    }

    public static class FileCopyResult {
        private final Collection<File> files = new ArrayList<File>();
        private long size = 0L;

        public Collection<File> getFiles() {
            return ImmutableList.copyOf(this.files);
        }

        public long size() {
            return this.size;
        }

        public FileCopyResult(File ... files) {
            this((Collection<File>)(files == null ? ImmutableList.of() : Arrays.asList(files)));
        }

        public FileCopyResult(Collection<File> files) {
            this.addSizedFiles(files);
        }

        protected void addSizedFiles(Collection<File> files) {
            if (files == null || files.isEmpty()) {
                return;
            }
            long size = 0L;
            for (File file : files) {
                size += file.length();
            }
            this.files.addAll(files);
            this.size += size;
        }

        public void addFiles(Collection<File> files) {
            this.addSizedFiles(files);
        }

        public void addFile(File file) {
            this.addFiles((Collection<File>)ImmutableList.of((Object)file));
        }
    }

    public static enum LinkOrCopyResult {
        LINK,
        COPY;

    }
}

