/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.FeedDefiningMonitor;
import org.apache.druid.java.util.metrics.KeyedDiff;
import org.apache.druid.java.util.metrics.MonitorUtils;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.hardware.VirtualMemory;
import oshi.software.os.FileSystem;
import oshi.software.os.InternetProtocolStats;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;

public class OshiSysMonitor
extends FeedDefiningMonitor {
    private final SystemInfo si;
    private final HardwareAbstractionLayer hal;
    private final OperatingSystem os;
    private static final List<String> NET_ADDRESS_BLACKLIST = ImmutableList.of((Object)"0.0.0.0", (Object)"127.0.0.1");
    private final MemStats memStats;
    private final SwapStats swapStats;
    private final FsStats fsStats;
    private final DiskStats diskStats;
    private final NetStats netStats;
    private final CpuStats cpuStats;
    private final SysStats sysStats;
    private final TcpStats tcpStats;
    private final Map<String, String[]> dimensions;

    public OshiSysMonitor() {
        this((Map<String, String[]>)ImmutableMap.of());
    }

    public OshiSysMonitor(Map<String, String[]> dimensions) {
        this(dimensions, "metrics");
    }

    public OshiSysMonitor(Map<String, String[]> dimensions, String feed) {
        super(feed);
        Preconditions.checkNotNull(dimensions);
        this.dimensions = ImmutableMap.copyOf(dimensions);
        this.si = new SystemInfo();
        this.hal = this.si.getHardware();
        this.os = this.si.getOperatingSystem();
        this.memStats = new MemStats();
        this.swapStats = new SwapStats();
        this.fsStats = new FsStats();
        this.diskStats = new DiskStats();
        this.netStats = new NetStats();
        this.cpuStats = new CpuStats();
        this.sysStats = new SysStats();
        this.tcpStats = new TcpStats();
    }

    public OshiSysMonitor(SystemInfo systemInfo) {
        super("metrics");
        this.dimensions = ImmutableMap.of();
        this.si = systemInfo;
        this.hal = this.si.getHardware();
        this.os = this.si.getOperatingSystem();
        this.memStats = new MemStats();
        this.swapStats = new SwapStats();
        this.fsStats = new FsStats();
        this.diskStats = new DiskStats();
        this.netStats = new NetStats();
        this.cpuStats = new CpuStats();
        this.sysStats = new SysStats();
        this.tcpStats = new TcpStats();
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        this.monitorMemStats(emitter);
        this.monitorSwapStats(emitter);
        this.monitorFsStats(emitter);
        this.monitorDiskStats(emitter);
        this.monitorNetStats(emitter);
        this.monitorCpuStats(emitter);
        this.monitorSysStats(emitter);
        this.monitorTcpStats(emitter);
        return true;
    }

    public void monitorMemStats(ServiceEmitter emitter) {
        this.memStats.emit(emitter);
    }

    public void monitorSwapStats(ServiceEmitter emitter) {
        this.swapStats.emit(emitter);
    }

    public void monitorFsStats(ServiceEmitter emitter) {
        this.fsStats.emit(emitter);
    }

    public void monitorDiskStats(ServiceEmitter emitter) {
        this.diskStats.emit(emitter);
    }

    public void monitorNetStats(ServiceEmitter emitter) {
        this.netStats.emit(emitter);
    }

    public void monitorCpuStats(ServiceEmitter emitter) {
        this.cpuStats.emit(emitter);
    }

    public void monitorSysStats(ServiceEmitter emitter) {
        this.sysStats.emit(emitter);
    }

    public void monitorTcpStats(ServiceEmitter emitter) {
        this.tcpStats.emit(emitter);
    }

    private class TcpStats {
        private final KeyedDiff diff = new KeyedDiff();

        private TcpStats() {
        }

        public void emit(ServiceEmitter emitter) {
            Map<String, Long> stats;
            ServiceMetricEvent.Builder builder = OshiSysMonitor.this.builder();
            MonitorUtils.addDimensionsToBuilder(builder, OshiSysMonitor.this.dimensions);
            InternetProtocolStats ipstats = OshiSysMonitor.this.os.getInternetProtocolStats();
            InternetProtocolStats.TcpStats tcpv4 = ipstats.getTCPv4Stats();
            if (tcpv4 != null && (stats = this.diff.to("tcpv4", (Map<String, Long>)ImmutableMap.builder().put((Object)"sys/tcpv4/activeOpens", (Object)tcpv4.getConnectionsActive()).put((Object)"sys/tcpv4/passiveOpens", (Object)tcpv4.getConnectionsPassive()).put((Object)"sys/tcpv4/attemptFails", (Object)tcpv4.getConnectionFailures()).put((Object)"sys/tcpv4/estabResets", (Object)tcpv4.getConnectionsReset()).put((Object)"sys/tcpv4/in/segs", (Object)tcpv4.getSegmentsReceived()).put((Object)"sys/tcpv4/in/errs", (Object)tcpv4.getInErrors()).put((Object)"sys/tcpv4/out/segs", (Object)tcpv4.getSegmentsSent()).put((Object)"sys/tcpv4/out/rsts", (Object)tcpv4.getOutResets()).put((Object)"sys/tcpv4/retrans/segs", (Object)tcpv4.getSegmentsRetransmitted()).build())) != null) {
                for (Map.Entry<String, Long> entry : stats.entrySet()) {
                    emitter.emit(builder.setMetric(entry.getKey(), entry.getValue()));
                }
            }
        }
    }

    private class SysStats {
        private SysStats() {
        }

        public void emit(ServiceEmitter emitter) {
            ServiceMetricEvent.Builder builder = OshiSysMonitor.this.builder();
            MonitorUtils.addDimensionsToBuilder(builder, OshiSysMonitor.this.dimensions);
            long uptime = OshiSysMonitor.this.os.getSystemUptime();
            ImmutableMap stats = ImmutableMap.of((Object)"sys/uptime", (Object)uptime);
            for (Map.Entry entry : stats.entrySet()) {
                emitter.emit(builder.setMetric((String)entry.getKey(), (Number)entry.getValue()));
            }
            CentralProcessor processor = OshiSysMonitor.this.hal.getProcessor();
            double[] la = processor.getSystemLoadAverage(3);
            if (la != null) {
                ImmutableMap statsCpuLoadAverage = ImmutableMap.of((Object)"sys/la/1", (Object)la[0], (Object)"sys/la/5", (Object)la[1], (Object)"sys/la/15", (Object)la[2]);
                for (Map.Entry entry : statsCpuLoadAverage.entrySet()) {
                    emitter.emit(builder.setMetric((String)entry.getKey(), (Number)entry.getValue()));
                }
            }
        }
    }

    private class CpuStats {
        private final KeyedDiff diff = new KeyedDiff();

        private CpuStats() {
        }

        public void emit(ServiceEmitter emitter) {
            CentralProcessor processor = OshiSysMonitor.this.hal.getProcessor();
            long[][] procTicks = processor.getProcessorCpuLoadTicks();
            for (int i = 0; i < procTicks.length; ++i) {
                String name = Integer.toString(i);
                long[] ticks = procTicks[i];
                long user = ticks[CentralProcessor.TickType.USER.getIndex()];
                long nice = ticks[CentralProcessor.TickType.NICE.getIndex()];
                long sys = ticks[CentralProcessor.TickType.SYSTEM.getIndex()];
                long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()];
                long iowait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()];
                long irq = ticks[CentralProcessor.TickType.IRQ.getIndex()];
                long softirq = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
                long steal = ticks[CentralProcessor.TickType.STEAL.getIndex()];
                long totalCpu = user + nice + sys + idle + iowait + irq + softirq + steal;
                Map<String, Long> stats = this.diff.to(name, (Map<String, Long>)ImmutableMap.builder().put((Object)"user", (Object)user).put((Object)"sys", (Object)sys).put((Object)"nice", (Object)nice).put((Object)"wait", (Object)iowait).put((Object)"irq", (Object)irq).put((Object)"softIrq", (Object)softirq).put((Object)"stolen", (Object)steal).put((Object)"idle", (Object)idle).put((Object)"_total", (Object)totalCpu).build());
                if (stats == null) continue;
                long total = stats.remove("_total");
                for (Map.Entry<String, Long> entry : stats.entrySet()) {
                    ServiceMetricEvent.Builder builder = OshiSysMonitor.this.builder().setDimension("cpuName", name).setDimension("cpuTime", entry.getKey());
                    MonitorUtils.addDimensionsToBuilder(builder, OshiSysMonitor.this.dimensions);
                    if (total == 0L) continue;
                    emitter.emit(builder.setMetric("sys/cpu", entry.getValue() * 100L / total));
                }
            }
        }
    }

    private class NetStats {
        private final KeyedDiff diff = new KeyedDiff();

        private NetStats() {
        }

        public void emit(ServiceEmitter emitter) {
            List networkIFS = OshiSysMonitor.this.hal.getNetworkIFs();
            for (NetworkIF net : networkIFS) {
                String name = net.getName();
                for (String addr : net.getIPv4addr()) {
                    String mapKey;
                    Map<String, Long> stats;
                    if (NET_ADDRESS_BLACKLIST.contains(addr) || (stats = this.diff.to(mapKey = name + "_" + addr, (Map<String, Long>)ImmutableMap.builder().put((Object)"sys/net/read/size", (Object)net.getBytesRecv()).put((Object)"sys/net/read/packets", (Object)net.getPacketsRecv()).put((Object)"sys/net/read/errors", (Object)net.getInErrors()).put((Object)"sys/net/read/dropped", (Object)net.getInDrops()).put((Object)"sys/net/write/size", (Object)net.getBytesSent()).put((Object)"sys/net/write/packets", (Object)net.getPacketsSent()).put((Object)"sys/net/write/errors", (Object)net.getOutErrors()).put((Object)"sys/net/write/collisions", (Object)net.getCollisions()).build())) == null) continue;
                    ServiceMetricEvent.Builder builder = OshiSysMonitor.this.builder().setDimension("netName", net.getName()).setDimension("netAddress", addr).setDimension("netHwaddr", net.getMacaddr());
                    MonitorUtils.addDimensionsToBuilder(builder, OshiSysMonitor.this.dimensions);
                    for (Map.Entry<String, Long> entry : stats.entrySet()) {
                        emitter.emit(builder.setMetric(entry.getKey(), entry.getValue()));
                    }
                }
            }
        }
    }

    private class DiskStats {
        private final KeyedDiff diff = new KeyedDiff();

        private DiskStats() {
        }

        public void emit(ServiceEmitter emitter) {
            List disks = OshiSysMonitor.this.hal.getDiskStores();
            for (HWDiskStore disk : disks) {
                Map<String, Long> stats = this.diff.to(disk.getName(), (Map<String, Long>)ImmutableMap.builder().put((Object)"sys/disk/read/size", (Object)disk.getReadBytes()).put((Object)"sys/disk/read/count", (Object)disk.getReads()).put((Object)"sys/disk/write/size", (Object)disk.getWriteBytes()).put((Object)"sys/disk/write/count", (Object)disk.getWrites()).put((Object)"sys/disk/queue", (Object)disk.getCurrentQueueLength()).put((Object)"sys/disk/transferTime", (Object)disk.getTransferTime()).build());
                if (stats == null) continue;
                ServiceMetricEvent.Builder builder = OshiSysMonitor.this.builder().setDimension("diskName", disk.getName());
                MonitorUtils.addDimensionsToBuilder(builder, OshiSysMonitor.this.dimensions);
                for (Map.Entry<String, Long> entry : stats.entrySet()) {
                    emitter.emit(builder.setMetric(entry.getKey(), entry.getValue()));
                }
            }
        }
    }

    private class FsStats {
        private FsStats() {
        }

        public void emit(ServiceEmitter emitter) {
            FileSystem fileSystem = OshiSysMonitor.this.os.getFileSystem();
            for (OSFileStore fs : fileSystem.getFileStores(true)) {
                ImmutableMap stats = ImmutableMap.builder().put((Object)"sys/fs/max", (Object)fs.getTotalSpace()).put((Object)"sys/fs/used", (Object)(fs.getTotalSpace() - fs.getUsableSpace())).put((Object)"sys/fs/files/count", (Object)fs.getTotalInodes()).put((Object)"sys/fs/files/free", (Object)fs.getFreeInodes()).build();
                ServiceMetricEvent.Builder builder = OshiSysMonitor.this.builder().setDimension("fsDevName", fs.getVolume()).setDimension("fsDirName", fs.getMount());
                MonitorUtils.addDimensionsToBuilder(builder, OshiSysMonitor.this.dimensions);
                for (Map.Entry entry : stats.entrySet()) {
                    emitter.emit(builder.setMetric((String)entry.getKey(), (Number)entry.getValue()));
                }
            }
        }
    }

    private class SwapStats {
        private long prevPageIn = 0L;
        private long prevPageOut = 0L;

        private SwapStats() {
        }

        public void emit(ServiceEmitter emitter) {
            VirtualMemory swap = OshiSysMonitor.this.hal.getMemory().getVirtualMemory();
            if (swap != null) {
                long currPageIn = swap.getSwapPagesIn();
                long currPageOut = swap.getSwapPagesOut();
                ImmutableMap stats = ImmutableMap.of((Object)"sys/swap/pageIn", (Object)(currPageIn - this.prevPageIn), (Object)"sys/swap/pageOut", (Object)(currPageOut - this.prevPageOut), (Object)"sys/swap/max", (Object)swap.getSwapTotal(), (Object)"sys/swap/free", (Object)(swap.getSwapTotal() - swap.getSwapUsed()));
                ServiceMetricEvent.Builder builder = OshiSysMonitor.this.builder();
                MonitorUtils.addDimensionsToBuilder(builder, OshiSysMonitor.this.dimensions);
                for (Map.Entry entry : stats.entrySet()) {
                    emitter.emit(builder.setMetric((String)entry.getKey(), (Number)entry.getValue()));
                }
                this.prevPageIn = currPageIn;
                this.prevPageOut = currPageOut;
            }
        }
    }

    private class MemStats {
        private MemStats() {
        }

        public void emit(ServiceEmitter emitter) {
            GlobalMemory mem = OshiSysMonitor.this.hal.getMemory();
            if (mem != null) {
                ImmutableMap stats = ImmutableMap.of((Object)"sys/mem/max", (Object)mem.getTotal(), (Object)"sys/mem/used", (Object)(mem.getTotal() - mem.getAvailable()), (Object)"sys/mem/free", (Object)mem.getAvailable());
                ServiceMetricEvent.Builder builder = OshiSysMonitor.this.builder();
                MonitorUtils.addDimensionsToBuilder(builder, OshiSysMonitor.this.dimensions);
                for (Map.Entry entry : stats.entrySet()) {
                    emitter.emit(builder.setMetric((String)entry.getKey(), (Number)entry.getValue()));
                }
            }
        }
    }
}

