/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.math.expr.ConstantExpr;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.VectorProcessors;

class LongExpr
extends ConstantExpr<Long> {
    LongExpr(Long value) {
        super(ExpressionType.LONG, Preconditions.checkNotNull((Object)value, (Object)"value"));
    }

    @Override
    protected ExprEval realEval() {
        return ExprEval.ofLong((Number)this.value);
    }

    @Override
    public <T> ExprVectorProcessor<T> asVectorProcessor(Expr.VectorInputBindingInspector inspector) {
        return VectorProcessors.constant((Long)this.value, inspector.getMaxVectorSize());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongExpr longExpr = (LongExpr)o;
        return Objects.equals(this.value, longExpr.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

