/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.data.input.Row;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.NullableTypeStrategy;
import org.apache.druid.segment.column.ValueType;

public class ResultRowObjectMapperDecoratorUtil {
    public static ObjectMapper decorateObjectMapper(ObjectMapper baseObjectMapper, GroupByQuery query, GroupByQueryConfig groupByQueryConfig) {
        final JsonDeserializer<ResultRow> deserializer = ResultRowObjectMapperDecoratorUtil.getDeserializer(baseObjectMapper, query, groupByQueryConfig);
        final JsonSerializer<ResultRow> serializer = ResultRowObjectMapperDecoratorUtil.getSerializer(query, groupByQueryConfig);
        if (deserializer == null && serializer == null) {
            return baseObjectMapper;
        }
        ObjectMapper decoratedObjectMapper = baseObjectMapper.copy();
        class GroupByResultRowModule
        extends SimpleModule {
            GroupByResultRowModule() {
                if (serializer != null) {
                    this.addSerializer(ResultRow.class, serializer);
                }
                if (deserializer != null) {
                    this.addDeserializer(ResultRow.class, deserializer);
                }
            }
        }
        decoratedObjectMapper.registerModule((Module)new GroupByResultRowModule());
        return decoratedObjectMapper;
    }

    @Nullable
    private static JsonDeserializer<ResultRow> getDeserializer(final ObjectMapper objectMapper, final GroupByQuery query, GroupByQueryConfig groupByQueryConfig) {
        boolean resultAsArray = query.context().getBoolean("resultAsArray", false);
        boolean intermediateCompatMode = groupByQueryConfig.isIntermediateResultAsMapCompat();
        boolean arrayBasedRows = resultAsArray && !intermediateCompatMode;
        boolean dimensionsRequireConversion = query.getDimensions().stream().anyMatch(dimensionSpec -> ResultRowObjectMapperDecoratorUtil.dimensionRequiresConversion(dimensionSpec.getOutputType()));
        if (arrayBasedRows && !dimensionsRequireConversion) {
            return null;
        }
        if (!arrayBasedRows && !dimensionsRequireConversion) {
            return new JsonDeserializer<ResultRow>(){

                public ResultRow deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                    if (jp.isExpectedStartObjectToken()) {
                        Row row = (Row)jp.readValueAs(Row.class);
                        return ResultRow.fromLegacyRow(row, query);
                    }
                    return ResultRow.of((Object[])jp.readValueAs(Object[].class));
                }
            };
        }
        return new JsonDeserializer<ResultRow>(){
            final JavaType[] javaTypes;
            {
                this.javaTypes = ResultRowObjectMapperDecoratorUtil.createJavaTypesForResultRow(query);
            }

            public ResultRow deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                if (jp.isExpectedStartObjectToken()) {
                    Row row = (Row)jp.readValueAs(Row.class);
                    ResultRow resultRow = ResultRow.fromLegacyRow(row, query);
                    List<DimensionSpec> queryDimensions = query.getDimensions();
                    for (int i = 0; i < queryDimensions.size(); ++i) {
                        if (!ResultRowObjectMapperDecoratorUtil.dimensionRequiresConversion(queryDimensions.get(i).getOutputType())) continue;
                        int dimensionIndexInResultRow = query.getResultRowDimensionStart() + i;
                        resultRow.set(dimensionIndexInResultRow, objectMapper.convertValue(resultRow.get(dimensionIndexInResultRow), this.javaTypes[dimensionIndexInResultRow]));
                    }
                    return resultRow;
                }
                if (!jp.isExpectedStartArrayToken()) {
                    throw DruidException.defensive("Expected start token, received [%s]", jp.currentToken());
                }
                Object[] objectArray = new Object[query.getResultRowSizeWithPostAggregators()];
                int index = 0;
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    objectArray[index] = JacksonUtils.readObjectUsingDeserializationContext(jp, ctxt, this.javaTypes[index]);
                    ++index;
                }
                return ResultRow.of(objectArray);
            }
        };
    }

    @Nullable
    private static JsonSerializer<ResultRow> getSerializer(final GroupByQuery query, GroupByQueryConfig groupByQueryConfig) {
        boolean arrayBasedRows;
        boolean resultAsArray = query.context().getBoolean("resultAsArray", false);
        boolean intermediateCompatMode = groupByQueryConfig.isIntermediateResultAsMapCompat();
        boolean bl = arrayBasedRows = resultAsArray && !intermediateCompatMode;
        if (arrayBasedRows) {
            return null;
        }
        if (resultAsArray) {
            return new JsonSerializer<ResultRow>(){

                public void serialize(ResultRow resultRow, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    JacksonUtils.writeObjectUsingSerializerProvider(jsonGenerator, serializerProvider, resultRow.getArray());
                }
            };
        }
        return new JsonSerializer<ResultRow>(){

            public void serialize(ResultRow resultRow, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                JacksonUtils.writeObjectUsingSerializerProvider(jsonGenerator, serializerProvider, resultRow.toMapBasedRow(query));
            }
        };
    }

    private static boolean dimensionRequiresConversion(ColumnType dimensionType) {
        return dimensionType.is(ValueType.COMPLEX) && !ColumnType.NESTED_DATA.equals(dimensionType);
    }

    private static JavaType[] createJavaTypesForResultRow(GroupByQuery groupByQuery) {
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        JavaType[] javaTypes = new JavaType[groupByQuery.getResultRowSizeWithPostAggregators()];
        List<DimensionSpec> dimensions = groupByQuery.getDimensions();
        for (int i = 0; i < groupByQuery.getResultRowSizeWithPostAggregators(); ++i) {
            if (i >= groupByQuery.getResultRowDimensionStart() && i < groupByQuery.getResultRowAggregatorStart()) {
                DimensionSpec dimension = dimensions.get(i - groupByQuery.getResultRowDimensionStart());
                ColumnType dimensionType = dimensions.get(i - groupByQuery.getResultRowDimensionStart()).getOutputType();
                if (dimensionType.is(ValueType.COMPLEX)) {
                    NullableTypeStrategy nullableTypeStrategy = dimensionType.getNullableStrategy();
                    if (!nullableTypeStrategy.groupable()) {
                        throw DruidException.defensive("Ungroupable dimension [%s] with type [%s] found in the query.", dimension, dimensionType);
                    }
                    javaTypes[i] = typeFactory.constructType(nullableTypeStrategy.getClazz());
                    continue;
                }
                javaTypes[i] = typeFactory.constructType(Object.class);
                continue;
            }
            javaTypes[i] = typeFactory.constructType(Object.class);
        }
        return javaTypes;
    }
}

