/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.Order;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.Queries;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.operator.OffsetLimit;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.scan.ScanResultValueTimestampComparator;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class ScanQuery
extends BaseQuery<ScanResultValue> {
    public static final String CTX_KEY_OUTERMOST = "scanOutermost";
    public static final int DEFAULT_BATCH_SIZE = 20480;
    private final VirtualColumns virtualColumns;
    private final ResultFormat resultFormat;
    private final int batchSize;
    private final long scanRowsOffset;
    private final long scanRowsLimit;
    private final DimFilter dimFilter;
    private final List<String> columns;
    private final Order timeOrder;
    private final List<OrderBy> orderBys;
    private final Integer maxRowsQueuedForOrdering;
    private final Integer maxSegmentPartitionsOrderedInMemory;
    private final List<ColumnType> columnTypes;

    @JsonCreator
    public ScanQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="virtualColumns") VirtualColumns virtualColumns, @JsonProperty(value="resultFormat") ResultFormat resultFormat, @JsonProperty(value="batchSize") int batchSize, @JsonProperty(value="offset") long scanRowsOffset, @JsonProperty(value="limit") long scanRowsLimit, @JsonProperty(value="order") Order orderFromUser, @JsonProperty(value="orderBy") List<OrderBy> orderBysFromUser, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="columns") List<String> columns, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="columnTypes") List<ColumnType> columnTypes) {
        super(dataSource, querySegmentSpec, context);
        this.virtualColumns = VirtualColumns.nullToEmpty(virtualColumns);
        this.resultFormat = resultFormat == null ? ResultFormat.RESULT_FORMAT_LIST : resultFormat;
        this.batchSize = batchSize == 0 ? 20480 : batchSize;
        Preconditions.checkArgument((this.batchSize > 0 ? 1 : 0) != 0, (Object)"batchSize must be greater than 0");
        this.scanRowsOffset = scanRowsOffset;
        Preconditions.checkArgument((this.scanRowsOffset >= 0L ? 1 : 0) != 0, (Object)"offset must be greater than or equal to 0");
        this.scanRowsLimit = scanRowsLimit == 0L ? Long.MAX_VALUE : scanRowsLimit;
        Preconditions.checkArgument((this.scanRowsLimit > 0L ? 1 : 0) != 0, (Object)"limit must be greater than 0");
        this.dimFilter = dimFilter;
        this.columns = columns;
        this.columnTypes = columnTypes;
        if (columnTypes != null) {
            Preconditions.checkNotNull(columns, (Object)"columns may not be null if columnTypes are specified");
            if (columns.size() != columnTypes.size()) {
                throw new IAE("Inconsistent number of columns[%d] and columnTypes[%d] specified!", columns.size(), columnTypes.size());
            }
        }
        Pair<List<OrderBy>, Order> ordering = ScanQuery.verifyAndReconcileOrdering(orderBysFromUser, orderFromUser);
        this.orderBys = (List)Preconditions.checkNotNull(ordering.lhs);
        this.timeOrder = (Order)((Object)ordering.rhs);
        if (this.columns != null && this.columns.size() > 0) {
            for (OrderBy orderByColumn : this.orderBys) {
                if (this.columns.contains(orderByColumn.getColumnName())) continue;
                if (orderBysFromUser != null) {
                    throw new IAE("Column [%s] from 'orderBy' must also appear in 'columns'.", orderByColumn.getColumnName());
                }
                throw new IllegalArgumentException("The __time column must be selected if the results are time-ordered.");
            }
        }
        this.maxRowsQueuedForOrdering = this.validateAndGetMaxRowsQueuedForOrdering();
        this.maxSegmentPartitionsOrderedInMemory = this.validateAndGetMaxSegmentPartitionsOrderedInMemory();
    }

    public static void verifyOrderByForNativeExecution(ScanQuery query) {
        if (query.getTimeOrder() == Order.NONE && !query.getOrderBys().isEmpty()) {
            throw new ISE("Cannot execute query with orderBy %s", query.getOrderBys());
        }
    }

    private Integer validateAndGetMaxRowsQueuedForOrdering() {
        Integer maxRowsQueuedForOrdering = this.context().getInt("maxRowsQueuedForOrdering");
        Preconditions.checkArgument((maxRowsQueuedForOrdering == null || maxRowsQueuedForOrdering > 0 ? 1 : 0) != 0, (Object)"maxRowsQueuedForOrdering must be greater than 0");
        return maxRowsQueuedForOrdering;
    }

    private Integer validateAndGetMaxSegmentPartitionsOrderedInMemory() {
        Integer maxSegmentPartitionsOrderedInMemory = this.context().getInt("maxSegmentPartitionsOrderedInMemory");
        Preconditions.checkArgument((maxSegmentPartitionsOrderedInMemory == null || maxSegmentPartitionsOrderedInMemory > 0 ? 1 : 0) != 0, (Object)"maxRowsQueuedForOrdering must be greater than 0");
        return maxSegmentPartitionsOrderedInMemory;
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=VirtualColumns.JsonIncludeFilter.class)
    public VirtualColumns getVirtualColumns() {
        return this.virtualColumns;
    }

    @JsonProperty
    public ResultFormat getResultFormat() {
        return this.resultFormat;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=BatchSizeJsonIncludeFilter.class)
    public int getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty(value="offset")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public long getScanRowsOffset() {
        return this.scanRowsOffset;
    }

    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=ScanRowsLimitJsonIncludeFilter.class)
    public long getScanRowsLimit() {
        return this.scanRowsLimit;
    }

    public OffsetLimit getOffsetLimit() {
        return new OffsetLimit(this.scanRowsOffset, this.scanRowsLimit);
    }

    public boolean isLimited() {
        return this.scanRowsLimit != Long.MAX_VALUE;
    }

    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=ScanTimeOrderJsonIncludeFilter.class)
    public Order getTimeOrder() {
        return this.timeOrder;
    }

    public List<OrderBy> getOrderBys() {
        return this.orderBys;
    }

    @Nullable
    @JsonProperty(value="orderBy")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    List<OrderBy> getOrderBysForJson() {
        if (this.orderBys.size() > 1 || this.orderBys.size() == 1 && !((OrderBy)Iterables.getOnlyElement(this.orderBys)).getColumnName().equals("__time")) {
            return this.orderBys;
        }
        return null;
    }

    @Nullable
    @JsonIgnore
    public Integer getMaxRowsQueuedForOrdering() {
        return this.maxRowsQueuedForOrdering;
    }

    @Nullable
    @JsonIgnore
    public Integer getMaxSegmentPartitionsOrderedInMemory() {
        return this.maxSegmentPartitionsOrderedInMemory;
    }

    @Override
    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    @Override
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DimFilter getFilter() {
        return this.dimFilter;
    }

    @Override
    public String getType() {
        return "scan";
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getColumns() {
        return this.columns;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<ColumnType> getColumnTypes() {
        return this.columnTypes;
    }

    @Deprecated
    @JsonProperty(value="legacy")
    public Boolean isLegacy() {
        return false;
    }

    @Override
    public Ordering<ScanResultValue> getResultOrdering() {
        ScanQuery.verifyOrderByForNativeExecution(this);
        if (this.timeOrder == Order.NONE) {
            return Ordering.natural();
        }
        return Ordering.from(new ScanResultValueTimestampComparator(this).thenComparing(this.timeOrder == Order.ASCENDING ? Comparator.naturalOrder() : Comparator.naturalOrder().reversed()));
    }

    @Override
    @Nullable
    public Set<String> getRequiredColumns() {
        if (this.columns == null || this.columns.isEmpty()) {
            return null;
        }
        return Queries.computeRequiredColumns(this.virtualColumns, this.dimFilter, this.columns, Collections.emptyList());
    }

    public ScanQuery withOffset(long newOffset) {
        return Druids.ScanQueryBuilder.copy(this).offset(newOffset).build();
    }

    public ScanQuery withLimit(long newLimit) {
        return Druids.ScanQueryBuilder.copy(this).limit(newLimit).build();
    }

    public ScanQuery withQuerySegmentSpec(QuerySegmentSpec querySegmentSpec) {
        return Druids.ScanQueryBuilder.copy(this).intervals(querySegmentSpec).build();
    }

    public ScanQuery withDataSource(DataSource dataSource) {
        return Druids.ScanQueryBuilder.copy(this).dataSource(dataSource).build();
    }

    public ScanQuery withOverriddenContext(Map<String, Object> contextOverrides) {
        return Druids.ScanQueryBuilder.copy(this).context(ScanQuery.computeOverriddenContext(this.getContext(), contextOverrides)).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScanQuery scanQuery = (ScanQuery)o;
        return this.batchSize == scanQuery.batchSize && this.scanRowsOffset == scanQuery.scanRowsOffset && this.scanRowsLimit == scanQuery.scanRowsLimit && Objects.equals(this.virtualColumns, scanQuery.virtualColumns) && Objects.equals((Object)this.resultFormat, (Object)scanQuery.resultFormat) && Objects.equals(this.dimFilter, scanQuery.dimFilter) && Objects.equals(this.columns, scanQuery.columns) && Objects.equals(this.orderBys, scanQuery.orderBys);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.virtualColumns, this.resultFormat, this.batchSize, this.scanRowsOffset, this.scanRowsLimit, this.dimFilter, this.columns, this.orderBys});
    }

    public String toString() {
        return "ScanQuery{dataSource='" + this.getDataSource() + '\'' + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", virtualColumns=" + this.getVirtualColumns() + ", resultFormat='" + (Object)((Object)this.resultFormat) + '\'' + ", batchSize=" + this.batchSize + ", offset=" + this.scanRowsOffset + ", limit=" + this.scanRowsLimit + ", dimFilter=" + this.dimFilter + ", columns=" + this.columns + (this.orderBys.isEmpty() ? "" : ", orderBy=" + this.orderBys) + ", context=" + this.getContext() + '}';
    }

    private static Pair<List<OrderBy>, Order> verifyAndReconcileOrdering(@Nullable List<OrderBy> orderByFromUser, @Nullable Order orderFromUser) {
        List<Object> orderByRetVal = orderByFromUser != null ? orderByFromUser : (orderFromUser == null || orderFromUser == Order.NONE ? Collections.emptyList() : Collections.singletonList(new OrderBy("__time", orderFromUser)));
        Order orderRetVal = ScanQuery.computeTimeOrderFromOrderBys(orderByRetVal);
        if (orderFromUser != null && orderFromUser != Order.NONE && orderRetVal != orderFromUser) {
            throw new IAE("Cannot provide 'order' incompatible with 'orderBy'", new Object[0]);
        }
        return Pair.of(orderByRetVal, orderRetVal);
    }

    @Nullable
    private static Order computeTimeOrderFromOrderBys(List<OrderBy> orderBys) {
        OrderBy orderByColumn;
        if (orderBys.size() == 1 && "__time".equals((orderByColumn = (OrderBy)Iterables.getOnlyElement(orderBys)).getColumnName())) {
            return orderByColumn.getOrder();
        }
        return Order.NONE;
    }

    @Nullable
    public RowSignature getRowSignature() {
        if (this.columns == null || this.columns.isEmpty()) {
            return RowSignature.empty();
        }
        if (this.columnTypes != null) {
            RowSignature.Builder builder = RowSignature.builder();
            for (int i = 0; i < this.columnTypes.size(); ++i) {
                builder.add(this.columns.get(i), this.columnTypes.get(i));
            }
            return builder.build();
        }
        RowSignature.Builder builder = RowSignature.builder();
        DataSource dataSource = this.getDataSource();
        for (String columnName : this.columns) {
            ColumnType columnType = ScanQuery.guessColumnType(columnName, this.virtualColumns, dataSource);
            builder.add(columnName, columnType);
        }
        return builder.build();
    }

    @Nullable
    private static ColumnType guessColumnType(String columnName, VirtualColumns virtualColumns, DataSource dataSource) {
        InlineDataSource inlineDataSource;
        ColumnCapabilities caps;
        VirtualColumn virtualColumn = virtualColumns.getVirtualColumn(columnName);
        if (virtualColumn != null) {
            ColumnCapabilities capabilities = virtualColumn.capabilities(c -> null, columnName);
            if (capabilities != null) {
                return capabilities.toColumnType();
            }
        } else if (dataSource instanceof InlineDataSource && (caps = (inlineDataSource = (InlineDataSource)dataSource).getRowSignature().getColumnCapabilities(columnName)) != null) {
            return caps.toColumnType();
        }
        return null;
    }

    static class BatchSizeJsonIncludeFilter {
        BatchSizeJsonIncludeFilter() {
        }

        public boolean equals(Object obj) {
            return obj instanceof Integer && (Integer)obj == 20480;
        }
    }

    static class ScanRowsLimitJsonIncludeFilter {
        ScanRowsLimitJsonIncludeFilter() {
        }

        public boolean equals(Object obj) {
            return obj instanceof Long && (Long)obj == Long.MAX_VALUE;
        }
    }

    static class ScanTimeOrderJsonIncludeFilter {
        ScanTimeOrderJsonIncludeFilter() {
        }

        public boolean equals(Object obj) {
            return obj instanceof Order && Order.NONE.equals(obj);
        }
    }

    public static enum ResultFormat {
        RESULT_FORMAT_LIST,
        RESULT_FORMAT_COMPACTED_LIST,
        RESULT_FORMAT_VALUE_VECTOR;


        @JsonValue
        public String toString() {
            switch (this) {
                case RESULT_FORMAT_LIST: {
                    return "list";
                }
                case RESULT_FORMAT_COMPACTED_LIST: {
                    return "compactedList";
                }
                case RESULT_FORMAT_VALUE_VECTOR: {
                    return "valueVector";
                }
            }
            return "";
        }

        @JsonCreator
        public static ResultFormat fromString(String name) {
            switch (name) {
                case "compactedList": {
                    return RESULT_FORMAT_COMPACTED_LIST;
                }
                case "valueVector": {
                    return RESULT_FORMAT_VALUE_VECTOR;
                }
                case "list": {
                    return RESULT_FORMAT_LIST;
                }
            }
            throw new UOE("Scan query result format [%s] is not supported.", name);
        }
    }
}

