/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn.types;

import java.util.Map;
import java.util.function.Function;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.CursorGranularizer;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.topn.BaseTopNAlgorithm;
import org.apache.druid.query.topn.TopNCursorInspector;
import org.apache.druid.query.topn.TopNParams;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNResultBuilder;
import org.apache.druid.query.topn.types.TopNColumnAggregatesProcessor;
import org.apache.druid.segment.BaseNullableColumnValueSelector;
import org.apache.druid.segment.Cursor;

public abstract class NullableNumericTopNColumnAggregatesProcessor<Selector extends BaseNullableColumnValueSelector>
implements TopNColumnAggregatesProcessor<Selector> {
    private final boolean hasNulls = !NullHandling.replaceWithDefault();
    final Function<Object, Object> converter;
    Aggregator[] nullValueAggregates;

    protected NullableNumericTopNColumnAggregatesProcessor(Function<Object, Object> converter) {
        this.converter = converter;
    }

    abstract Aggregator[] getValueAggregators(TopNQuery var1, Selector var2, Cursor var3);

    abstract Map<?, Aggregator[]> getAggregatesStore();

    abstract Object convertAggregatorStoreKeyToColumnValue(Object var1);

    @Override
    public int getCardinality(Selector selector) {
        return -1;
    }

    @Override
    public Aggregator[][] getRowSelector(TopNQuery query, TopNParams params, TopNCursorInspector cursorInspector) {
        return null;
    }

    @Override
    public long scanAndAggregate(TopNQuery query, Selector selector, Cursor cursor, CursorGranularizer granularizer, Aggregator[][] rowSelector) {
        long processedRows = 0L;
        while (!cursor.isDone()) {
            if (this.hasNulls && selector.isNull()) {
                if (this.nullValueAggregates == null) {
                    this.nullValueAggregates = BaseTopNAlgorithm.makeAggregators(cursor, query.getAggregatorSpecs());
                }
                for (Aggregator aggregator : this.nullValueAggregates) {
                    aggregator.aggregate();
                }
            } else {
                Aggregator[] valueAggregates;
                for (Aggregator aggregator : valueAggregates = this.getValueAggregators(query, selector, cursor)) {
                    aggregator.aggregate();
                }
            }
            ++processedRows;
            if (granularizer.advanceCursorWithinBucket()) continue;
            break;
        }
        return processedRows;
    }

    @Override
    public void updateResults(TopNResultBuilder resultBuilder) {
        for (Map.Entry<?, Aggregator[]> entry : this.getAggregatesStore().entrySet()) {
            Aggregator[] aggs = entry.getValue();
            if (aggs == null) continue;
            Object[] vals = new Object[aggs.length];
            for (int i = 0; i < aggs.length; ++i) {
                vals[i] = aggs[i].get();
            }
            Object key = this.convertAggregatorStoreKeyToColumnValue(entry.getKey());
            resultBuilder.addEntry(key, key, vals);
        }
        if (this.nullValueAggregates != null) {
            Object[] nullVals = new Object[this.nullValueAggregates.length];
            for (int i = 0; i < this.nullValueAggregates.length; ++i) {
                nullVals[i] = this.nullValueAggregates[i].get();
            }
            resultBuilder.addEntry(null, null, nullVals);
        }
    }

    @Override
    public void closeAggregators() {
        for (Aggregator[] aggregators : this.getAggregatesStore().values()) {
            for (Aggregator agg : aggregators) {
                agg.close();
            }
        }
        if (this.nullValueAggregates != null) {
            for (Aggregator nullAgg : this.nullValueAggregates) {
                nullAgg.close();
            }
        }
    }
}

