/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.common.semantic.SemanticCreator;
import org.apache.druid.common.semantic.SemanticUtils;
import org.apache.druid.query.rowsandcols.concrete.QueryableIndexRowsAndColumns;
import org.apache.druid.segment.CloseableShapeshifter;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.PhysicalSegmentInspector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.QueryableIndexPhysicalSegmentInspector;
import org.apache.druid.segment.QueryableIndexTimeBoundaryInspector;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SimpleTopNOptimizationInspector;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.TopNOptimizationInspector;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class QueryableIndexSegment
implements Segment {
    private static final Map<Class<?>, Function<QueryableIndexSegment, ?>> AS_MAP = SemanticUtils.makeAsMap(QueryableIndexSegment.class);
    private final QueryableIndex index;
    private final QueryableIndexCursorFactory cursorFactory;
    private final TimeBoundaryInspector timeBoundaryInspector;
    private final SegmentId segmentId;

    public QueryableIndexSegment(QueryableIndex index, SegmentId segmentId) {
        this.index = index;
        this.cursorFactory = new QueryableIndexCursorFactory(index);
        this.timeBoundaryInspector = QueryableIndexTimeBoundaryInspector.create(index);
        this.segmentId = segmentId;
    }

    @Override
    public SegmentId getId() {
        return this.segmentId;
    }

    @Override
    public Interval getDataInterval() {
        return this.index.getDataInterval();
    }

    @Override
    public QueryableIndex asQueryableIndex() {
        return this.index;
    }

    @Override
    public CursorFactory asCursorFactory() {
        return this.cursorFactory;
    }

    @Override
    public void close() {
        this.index.close();
    }

    @Override
    @Nullable
    public <T> T as(@Nonnull Class<T> clazz) {
        Object fnApply;
        Function<QueryableIndexSegment, ?> fn = AS_MAP.get(clazz);
        if (fn != null && (fnApply = fn.apply(this)) != null) {
            return (T)fnApply;
        }
        if (TimeBoundaryInspector.class.equals(clazz)) {
            return (T)this.timeBoundaryInspector;
        }
        if (Metadata.class.equals(clazz)) {
            return (T)this.index.getMetadata();
        }
        if (PhysicalSegmentInspector.class.equals(clazz)) {
            return (T)new QueryableIndexPhysicalSegmentInspector(this.index);
        }
        if (TopNOptimizationInspector.class.equals(clazz)) {
            return (T)new SimpleTopNOptimizationInspector(true);
        }
        return Segment.super.as(clazz);
    }

    @SemanticCreator
    public CloseableShapeshifter toCloseableShapeshifter() {
        return new QueryableIndexRowsAndColumns(this.index);
    }
}

