/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.primitives.Ints;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import org.apache.druid.annotations.SuppressFBWarnings;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.ByteBufferUtils;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.data.DictionaryWriter;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.serde.ColumnSerializerUtils;

public final class DictionaryIdLookup
implements Closeable {
    private final String name;
    private final Path tempBasePath;
    @Nullable
    private final DictionaryWriter<String> stringDictionaryWriter;
    private Path stringDictionaryFile = null;
    private SmooshedFileMapper stringBufferMapper = null;
    private Indexed<ByteBuffer> stringDictionary = null;
    @Nullable
    private final DictionaryWriter<Long> longDictionaryWriter;
    private Path longDictionaryFile = null;
    private MappedByteBuffer longBuffer = null;
    private FixedIndexed<Long> longDictionary = null;
    @Nullable
    private final DictionaryWriter<Double> doubleDictionaryWriter;
    private Path doubleDictionaryFile = null;
    MappedByteBuffer doubleBuffer = null;
    FixedIndexed<Double> doubleDictionary = null;
    @Nullable
    private final DictionaryWriter<int[]> arrayDictionaryWriter;
    private Path arrayDictionaryFile = null;
    private MappedByteBuffer arrayBuffer = null;
    private FrontCodedIntArrayIndexed arrayDictionary = null;

    public DictionaryIdLookup(String name, Path tempBasePath, @Nullable DictionaryWriter<String> stringDictionaryWriter, @Nullable DictionaryWriter<Long> longDictionaryWriter, @Nullable DictionaryWriter<Double> doubleDictionaryWriter, @Nullable DictionaryWriter<int[]> arrayDictionaryWriter) {
        this.name = name;
        this.tempBasePath = tempBasePath;
        this.stringDictionaryWriter = stringDictionaryWriter;
        this.longDictionaryWriter = longDictionaryWriter;
        this.doubleDictionaryWriter = doubleDictionaryWriter;
        this.arrayDictionaryWriter = arrayDictionaryWriter;
    }

    public int[] getArrayValue(int id) {
        this.ensureArrayDictionaryLoaded();
        return this.arrayDictionary.get(id - this.arrayOffset());
    }

    @Nullable
    public Object getDictionaryValue(int id) {
        this.ensureStringDictionaryLoaded();
        this.ensureLongDictionaryLoaded();
        this.ensureDoubleDictionaryLoaded();
        this.ensureArrayDictionaryLoaded();
        if (id < this.longOffset()) {
            return StringUtils.fromUtf8Nullable(this.stringDictionary.get(id));
        }
        if (id < this.doubleOffset()) {
            return this.longDictionary.get(id - this.longOffset());
        }
        if (id < this.arrayOffset()) {
            return this.doubleDictionary.get(id - this.doubleOffset());
        }
        return this.arrayDictionary.get(id - this.arrayOffset());
    }

    public int lookupString(@Nullable String value) {
        this.ensureStringDictionaryLoaded();
        byte[] bytes = StringUtils.toUtf8Nullable(value);
        int index = this.stringDictionary.indexOf(bytes == null ? null : ByteBuffer.wrap(bytes));
        if (index < 0) {
            throw DruidException.defensive("Value not found in column[%s] string dictionary", this.name);
        }
        return index;
    }

    public int lookupLong(@Nullable Long value) {
        this.ensureLongDictionaryLoaded();
        int index = this.longDictionary.indexOf(value);
        if (index < 0) {
            throw DruidException.defensive("Value not found in column[%s] long dictionary", this.name);
        }
        return index + this.longOffset();
    }

    public int lookupDouble(@Nullable Double value) {
        this.ensureDoubleDictionaryLoaded();
        int index = this.doubleDictionary.indexOf(value);
        if (index < 0) {
            throw DruidException.defensive("Value not found in column[%s] double dictionary", this.name);
        }
        return index + this.doubleOffset();
    }

    public int lookupArray(@Nullable int[] value) {
        this.ensureArrayDictionaryLoaded();
        int index = this.arrayDictionary.indexOf(value);
        if (index < 0) {
            throw DruidException.defensive("Value not found in column[%s] array dictionary", this.name);
        }
        return index + this.arrayOffset();
    }

    @Nullable
    public SmooshedFileMapper getStringBufferMapper() {
        return this.stringBufferMapper;
    }

    @Nullable
    public ByteBuffer getLongBuffer() {
        return this.longBuffer;
    }

    @Nullable
    public ByteBuffer getDoubleBuffer() {
        return this.doubleBuffer;
    }

    @Nullable
    public ByteBuffer getArrayBuffer() {
        return this.arrayBuffer;
    }

    @Override
    public void close() {
        if (this.stringBufferMapper != null) {
            this.stringBufferMapper.close();
            this.deleteTempFile(this.stringDictionaryFile);
        }
        if (this.longBuffer != null) {
            ByteBufferUtils.unmap(this.longBuffer);
            this.deleteTempFile(this.longDictionaryFile);
        }
        if (this.doubleBuffer != null) {
            ByteBufferUtils.unmap(this.doubleBuffer);
            this.deleteTempFile(this.doubleDictionaryFile);
        }
        if (this.arrayBuffer != null) {
            ByteBufferUtils.unmap(this.arrayBuffer);
            this.deleteTempFile(this.arrayDictionaryFile);
        }
    }

    private int longOffset() {
        return this.stringDictionaryWriter != null ? this.stringDictionaryWriter.getCardinality() : 0;
    }

    private int doubleOffset() {
        return this.longOffset() + (this.longDictionaryWriter != null ? this.longDictionaryWriter.getCardinality() : 0);
    }

    private int arrayOffset() {
        return this.doubleOffset() + (this.doubleDictionaryWriter != null ? this.doubleDictionaryWriter.getCardinality() : 0);
    }

    private void ensureStringDictionaryLoaded() {
        if (this.stringDictionary == null) {
            File stringSmoosh = FileUtils.createTempDirInLocation(this.tempBasePath, StringUtils.urlEncode(this.name) + "__stringTempSmoosh");
            this.stringDictionaryFile = stringSmoosh.toPath();
            String fileName = ColumnSerializerUtils.getInternalFileName(this.name, "__stringDictionary");
            try (FileSmoosher smoosher = new FileSmoosher(stringSmoosh);
                 SmooshedWriter writer = smoosher.addWithSmooshedWriter(fileName, this.stringDictionaryWriter.getSerializedSize());){
                this.stringDictionaryWriter.writeTo(writer, smoosher);
                writer.close();
                smoosher.close();
                this.stringBufferMapper = SmooshedFileMapper.load(stringSmoosh);
                ByteBuffer stringBuffer = this.stringBufferMapper.mapFile(fileName);
                this.stringDictionary = (Indexed)StringEncodingStrategies.getStringDictionarySupplier(this.stringBufferMapper, stringBuffer, ByteOrder.nativeOrder()).get();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void ensureLongDictionaryLoaded() {
        if (this.longDictionary == null) {
            this.longDictionaryFile = this.makeTempFile(this.name + "__longDictionary");
            this.longBuffer = this.mapWriter(this.longDictionaryFile, this.longDictionaryWriter);
            this.longDictionary = (FixedIndexed)FixedIndexed.read(this.longBuffer, TypeStrategies.LONG, ByteOrder.nativeOrder(), 8).get();
            this.longBuffer.position(0);
        }
    }

    private void ensureDoubleDictionaryLoaded() {
        if (this.doubleDictionary == null) {
            this.doubleDictionaryFile = this.makeTempFile(this.name + "__doubleDictionary");
            this.doubleBuffer = this.mapWriter(this.doubleDictionaryFile, this.doubleDictionaryWriter);
            this.doubleDictionary = (FixedIndexed)FixedIndexed.read(this.doubleBuffer, TypeStrategies.DOUBLE, ByteOrder.nativeOrder(), 8).get();
            this.doubleBuffer.position(0);
        }
    }

    private void ensureArrayDictionaryLoaded() {
        if (this.arrayDictionary == null && this.arrayDictionaryWriter != null) {
            this.arrayDictionaryFile = this.makeTempFile(this.name + "__arrayDictionary");
            this.arrayBuffer = this.mapWriter(this.arrayDictionaryFile, this.arrayDictionaryWriter);
            this.arrayDictionary = (FrontCodedIntArrayIndexed)FrontCodedIntArrayIndexed.read(this.arrayBuffer, ByteOrder.nativeOrder()).get();
            this.arrayBuffer.position(0);
        }
    }

    private Path makeTempFile(String name) {
        try {
            return Files.createTempFile(this.tempBasePath, StringUtils.urlEncode(name), null, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void deleteTempFile(Path path) {
        try {
            File file = path.toFile();
            if (file.isDirectory()) {
                FileUtils.deleteDirectory(file);
            } else {
                Files.delete(path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private MappedByteBuffer mapWriter(Path path, DictionaryWriter<?> writer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private GatheringByteChannel makeWriter(final FileChannel channel, final long size) {
        return new GatheringByteChannel(){
            private boolean isClosed = false;
            private long currOffset = 0L;

            @Override
            public boolean isOpen() {
                return !this.isClosed;
            }

            @Override
            public void close() throws IOException {
                channel.close();
                this.isClosed = true;
            }

            public int bytesLeft() {
                return (int)(size - this.currOffset);
            }

            @Override
            public int write(ByteBuffer buffer) throws IOException {
                return this.addToOffset(channel.write(buffer));
            }

            @Override
            public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
                return this.addToOffset(channel.write(srcs, offset, length));
            }

            @Override
            public long write(ByteBuffer[] srcs) throws IOException {
                return this.addToOffset(channel.write(srcs));
            }

            public int addToOffset(long numBytesWritten) {
                if (numBytesWritten > (long)this.bytesLeft()) {
                    throw DruidException.defensive("Wrote more bytes[%,d] than available[%,d]. Don't do that.", numBytesWritten, this.bytesLeft());
                }
                this.currOffset += numBytesWritten;
                return Ints.checkedCast((long)numBytesWritten);
            }
        };
    }

    public int getStringCardinality() {
        this.ensureStringDictionaryLoaded();
        return this.stringDictionary == null ? 0 : this.stringDictionary.size();
    }

    public int getLongCardinality() {
        this.ensureLongDictionaryLoaded();
        return this.longDictionary == null ? 0 : this.longDictionary.size();
    }

    public int getDoubleCardinality() {
        this.ensureDoubleDictionaryLoaded();
        return this.doubleDictionary == null ? 0 : this.doubleDictionary.size();
    }

    public int getArrayCardinality() {
        this.ensureArrayDictionaryLoaded();
        return this.arrayDictionary == null ? 0 : this.arrayDictionary.size();
    }
}

