/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.StringPredicateDruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.AbstractDimensionSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DoubleColumnSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.LongColumnSelector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.StringUtf8DictionaryEncodedColumn;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.ColumnarDoubles;
import org.apache.druid.segment.data.ColumnarInts;
import org.apache.druid.segment.data.ColumnarLongs;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.SingleIndexedInt;
import org.apache.druid.segment.historical.SingleValueHistoricalDimensionSelector;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.VariantColumn;
import org.apache.druid.segment.vector.BaseDoubleVectorValueSelector;
import org.apache.druid.segment.vector.BaseLongVectorValueSelector;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorSelectorUtils;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.utils.CloseableUtils;
import org.roaringbitmap.PeekableIntIterator;

public class NestedFieldDictionaryEncodedColumn<TStringDictionary extends Indexed<ByteBuffer>>
implements DictionaryEncodedColumn<String> {
    private final FieldTypeInfo.TypeSet types;
    @Nullable
    private final ColumnType singleType;
    private final ColumnType logicalType;
    private final ExpressionType logicalExpressionType;
    private final ColumnarLongs longsColumn;
    private final ColumnarDoubles doublesColumn;
    private final ColumnarInts column;
    private final TStringDictionary globalDictionary;
    private final FixedIndexed<Long> globalLongDictionary;
    private final FixedIndexed<Double> globalDoubleDictionary;
    private final FrontCodedIntArrayIndexed globalArrayDictionary;
    private final FixedIndexed<Integer> dictionary;
    private final ImmutableBitmap nullBitmap;
    private final int adjustLongId;
    private final int adjustDoubleId;
    private final int adjustArrayId;

    public NestedFieldDictionaryEncodedColumn(FieldTypeInfo.TypeSet types, ColumnarLongs longsColumn, ColumnarDoubles doublesColumn, ColumnarInts column, TStringDictionary globalDictionary, FixedIndexed<Long> globalLongDictionary, FixedIndexed<Double> globalDoubleDictionary, @Nullable FrontCodedIntArrayIndexed globalArrayDictionary, FixedIndexed<Integer> dictionary, ImmutableBitmap nullBitmap) {
        this.types = types;
        ColumnType leastRestrictive = null;
        for (ColumnType type : FieldTypeInfo.convertToSet(types.getByteValue())) {
            leastRestrictive = ColumnType.leastRestrictiveType(leastRestrictive, type);
        }
        this.logicalType = leastRestrictive;
        this.logicalExpressionType = ExpressionType.fromColumnTypeStrict(this.logicalType);
        this.singleType = types.getSingleType();
        this.longsColumn = longsColumn;
        this.doublesColumn = doublesColumn;
        this.column = column;
        this.globalDictionary = globalDictionary;
        this.globalLongDictionary = globalLongDictionary;
        this.globalDoubleDictionary = globalDoubleDictionary;
        this.globalArrayDictionary = globalArrayDictionary;
        this.dictionary = dictionary;
        this.nullBitmap = nullBitmap;
        this.adjustLongId = globalDictionary.size();
        this.adjustDoubleId = this.adjustLongId + globalLongDictionary.size();
        this.adjustArrayId = this.adjustDoubleId + globalDoubleDictionary.size();
    }

    @Override
    public int length() {
        return this.column.size();
    }

    @Override
    public boolean hasMultipleValues() {
        return false;
    }

    @Override
    public int getSingleValueRow(int rowNum) {
        return this.column.get(rowNum);
    }

    @Override
    public IndexedInts getMultiValueRow(int rowNum) {
        throw new IllegalStateException("Multi-value row not supported");
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        int globalId = this.dictionary.get(id);
        if (globalId < this.globalDictionary.size()) {
            return StringUtils.fromUtf8Nullable((ByteBuffer)this.globalDictionary.get(globalId));
        }
        if (globalId < this.globalDictionary.size() + this.globalLongDictionary.size()) {
            return String.valueOf(this.globalLongDictionary.get(globalId - this.adjustLongId));
        }
        if (globalId < this.globalDictionary.size() + this.globalLongDictionary.size() + this.globalDoubleDictionary.size()) {
            return String.valueOf(this.globalDoubleDictionary.get(globalId - this.adjustDoubleId));
        }
        return null;
    }

    @Override
    public int lookupId(String name) {
        int globalId = this.getIdFromGlobalDictionary(name);
        if (globalId < 0) {
            return -1;
        }
        return this.dictionary.indexOf(globalId);
    }

    @Override
    public int getCardinality() {
        return this.dictionary.size();
    }

    public FixedIndexed<Integer> getDictionary() {
        return this.dictionary;
    }

    private int getIdFromGlobalDictionary(@Nullable String val) {
        Double d;
        Long l;
        if (val == null) {
            return 0;
        }
        if (this.singleType != null) {
            switch ((ValueType)this.singleType.getType()) {
                case LONG: {
                    Long l2 = GuavaUtils.tryParseLong(val);
                    if (l2 == null) {
                        return -1;
                    }
                    int globalLong = this.globalLongDictionary.indexOf(l2);
                    if (globalLong < 0) {
                        return -1;
                    }
                    return globalLong + this.adjustLongId;
                }
                case DOUBLE: {
                    Double d2 = Doubles.tryParse((String)val);
                    if (d2 == null) {
                        return -1;
                    }
                    int globalDouble = this.globalDoubleDictionary.indexOf(d2);
                    if (globalDouble < 0) {
                        return -1;
                    }
                    return globalDouble + this.adjustDoubleId;
                }
            }
            return this.globalDictionary.indexOf((ByteBuffer)StringUtils.toUtf8ByteBuffer(val));
        }
        int candidate = this.globalDictionary.indexOf((ByteBuffer)StringUtils.toUtf8ByteBuffer(val));
        if (candidate < 0 && (l = GuavaUtils.tryParseLong(val)) != null && (candidate = this.globalLongDictionary.indexOf(l)) >= 0) {
            candidate += this.adjustLongId;
        }
        if (candidate < 0 && (d = Doubles.tryParse((String)val)) != null && (candidate = this.globalDoubleDictionary.indexOf(d)) >= 0) {
            candidate += this.adjustDoubleId;
        }
        return candidate;
    }

    private Object lookupGlobalScalarObject(int globalId) {
        if (globalId < this.globalDictionary.size()) {
            return StringUtils.fromUtf8Nullable((ByteBuffer)this.globalDictionary.get(globalId));
        }
        if (globalId < this.globalDictionary.size() + this.globalLongDictionary.size()) {
            return this.globalLongDictionary.get(globalId - this.adjustLongId);
        }
        if (globalId < this.globalDictionary.size() + this.globalLongDictionary.size() + this.globalDoubleDictionary.size()) {
            return this.globalDoubleDictionary.get(globalId - this.adjustDoubleId);
        }
        throw new IllegalArgumentException("not a scalar in the dictionary");
    }

    @Nullable
    private Object lookupGlobalScalarValueAndCast(int globalId) {
        if (globalId == 0) {
            return null;
        }
        if (this.singleType != null) {
            return this.lookupGlobalScalarObject(globalId);
        }
        ExprEval eval = ExprEval.ofType(this.logicalExpressionType, this.lookupGlobalScalarObject(globalId));
        return eval.value();
    }

    @Override
    public DimensionSelector makeDimensionSelector(final ReadableOffset offset, final @Nullable ExtractionFn extractionFn) {
        class StringDimensionSelector
        extends AbstractDimensionSelector
        implements SingleValueHistoricalDimensionSelector,
        IdLookup {
            private final SingleIndexedInt row = new SingleIndexedInt();

            StringDimensionSelector() {
            }

            @Override
            public IndexedInts getRow() {
                this.row.setValue(this.getRowValue());
                return this.row;
            }

            public int getRowValue() {
                return NestedFieldDictionaryEncodedColumn.this.column.get(offset.getOffset());
            }

            @Override
            public float getFloat() {
                int localId = this.getRowValue();
                int globalId = (Integer)NestedFieldDictionaryEncodedColumn.this.dictionary.get(localId);
                if (globalId == 0) {
                    return 0.0f;
                }
                if (globalId < NestedFieldDictionaryEncodedColumn.this.adjustLongId) {
                    Float f = Floats.tryParse((String)StringUtils.fromUtf8((ByteBuffer)NestedFieldDictionaryEncodedColumn.this.globalDictionary.get(globalId)));
                    return f == null ? 0.0f : f.floatValue();
                }
                if (globalId < NestedFieldDictionaryEncodedColumn.this.adjustDoubleId) {
                    return ((Long)NestedFieldDictionaryEncodedColumn.this.globalLongDictionary.get(globalId - NestedFieldDictionaryEncodedColumn.this.adjustLongId)).floatValue();
                }
                return ((Double)NestedFieldDictionaryEncodedColumn.this.globalDoubleDictionary.get(globalId - NestedFieldDictionaryEncodedColumn.this.adjustDoubleId)).floatValue();
            }

            @Override
            public double getDouble() {
                int localId = this.getRowValue();
                int globalId = (Integer)NestedFieldDictionaryEncodedColumn.this.dictionary.get(localId);
                if (globalId == 0) {
                    return 0.0;
                }
                if (globalId < NestedFieldDictionaryEncodedColumn.this.adjustLongId) {
                    Double d = Doubles.tryParse((String)StringUtils.fromUtf8((ByteBuffer)NestedFieldDictionaryEncodedColumn.this.globalDictionary.get(globalId)));
                    return d == null ? 0.0 : d;
                }
                if (globalId < NestedFieldDictionaryEncodedColumn.this.adjustDoubleId) {
                    return ((Long)NestedFieldDictionaryEncodedColumn.this.globalLongDictionary.get(globalId - NestedFieldDictionaryEncodedColumn.this.adjustLongId)).doubleValue();
                }
                return (Double)NestedFieldDictionaryEncodedColumn.this.globalDoubleDictionary.get(globalId - NestedFieldDictionaryEncodedColumn.this.adjustDoubleId);
            }

            @Override
            public long getLong() {
                int localId = this.getRowValue();
                int globalId = (Integer)NestedFieldDictionaryEncodedColumn.this.dictionary.get(localId);
                if (globalId == 0) {
                    return 0L;
                }
                if (globalId < NestedFieldDictionaryEncodedColumn.this.adjustLongId) {
                    Long l = GuavaUtils.tryParseLong(StringUtils.fromUtf8((ByteBuffer)NestedFieldDictionaryEncodedColumn.this.globalDictionary.get(globalId)));
                    return l == null ? 0L : l;
                }
                if (globalId < NestedFieldDictionaryEncodedColumn.this.adjustDoubleId) {
                    return (Long)NestedFieldDictionaryEncodedColumn.this.globalLongDictionary.get(globalId - NestedFieldDictionaryEncodedColumn.this.adjustLongId);
                }
                return ((Double)NestedFieldDictionaryEncodedColumn.this.globalDoubleDictionary.get(globalId - NestedFieldDictionaryEncodedColumn.this.adjustDoubleId)).longValue();
            }

            @Override
            public boolean isNull() {
                if ((Integer)NestedFieldDictionaryEncodedColumn.this.dictionary.get(this.getRowValue()) == 0) {
                    return true;
                }
                return DimensionHandlerUtils.isNumericNull(this.getObject());
            }

            @Override
            public IndexedInts getRow(int offset2) {
                this.row.setValue(this.getRowValue(offset2));
                return this.row;
            }

            @Override
            public int getRowValue(int offset2) {
                return NestedFieldDictionaryEncodedColumn.this.column.get(offset2);
            }

            @Override
            public ValueMatcher makeValueMatcher(@Nullable String value) {
                if (extractionFn == null) {
                    final int valueId = this.lookupId(value);
                    if (valueId >= 0) {
                        return new ValueMatcher(){

                            @Override
                            public boolean matches(boolean includeUnknown) {
                                int rowId = this.getRowValue();
                                return includeUnknown && rowId == 0 || rowId == valueId;
                            }

                            @Override
                            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                                inspector.visit("column", NestedFieldDictionaryEncodedColumn.this);
                            }
                        };
                    }
                    return new ValueMatcher(){

                        @Override
                        public boolean matches(boolean includeUnknown) {
                            return includeUnknown && this.getRowValue() == 0;
                        }

                        @Override
                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            inspector.visit("column", NestedFieldDictionaryEncodedColumn.this);
                        }
                    };
                }
                return this.makeValueMatcher(StringPredicateDruidPredicateFactory.equalTo(value));
            }

            @Override
            public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
                final BitSet checkedIds = new BitSet(NestedFieldDictionaryEncodedColumn.this.getCardinality());
                final BitSet matchingIds = new BitSet(NestedFieldDictionaryEncodedColumn.this.getCardinality());
                final DruidObjectPredicate<String> predicate = predicateFactory.makeStringPredicate();
                return new ValueMatcher(){

                    @Override
                    public boolean matches(boolean includeUnknown) {
                        int id = this.getRowValue();
                        if (checkedIds.get(id)) {
                            return matchingIds.get(id);
                        }
                        String rowVal = this.lookupName(id);
                        boolean matches = predicate.apply(rowVal).matches(includeUnknown);
                        checkedIds.set(id);
                        if (matches) {
                            matchingIds.set(id);
                        }
                        return matches;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("column", NestedFieldDictionaryEncodedColumn.this);
                    }
                };
            }

            @Override
            public Object getObject() {
                return NestedFieldDictionaryEncodedColumn.this.lookupName(this.getRowValue());
            }

            @Override
            public Class classOfObject() {
                return String.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("column", NestedFieldDictionaryEncodedColumn.this.column);
                inspector.visit("offset", offset);
                inspector.visit("extractionFn", extractionFn);
            }

            @Override
            public int getValueCardinality() {
                return NestedFieldDictionaryEncodedColumn.this.getCardinality();
            }

            @Override
            public String lookupName(int id) {
                String value = NestedFieldDictionaryEncodedColumn.this.lookupName(id);
                return extractionFn == null ? value : extractionFn.apply(value);
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                return true;
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                return extractionFn == null ? this : null;
            }

            @Override
            public int lookupId(String name) {
                if (extractionFn == null) {
                    return NestedFieldDictionaryEncodedColumn.this.lookupId(name);
                }
                throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
            }
        }
        return new StringDimensionSelector();
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final ReadableOffset offset) {
        if (this.singleType != null) {
            if (Types.is(this.singleType, ValueType.LONG)) {
                return new LongColumnSelector(){
                    private PeekableIntIterator nullIterator;
                    private int nullMark;
                    private int offsetMark;
                    {
                        this.nullIterator = NestedFieldDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                        this.nullMark = -1;
                        this.offsetMark = -1;
                    }

                    @Override
                    public long getLong() {
                        return NestedFieldDictionaryEncodedColumn.this.longsColumn.get(offset.getOffset());
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("longColumn", NestedFieldDictionaryEncodedColumn.this.longsColumn);
                        inspector.visit("nullBitmap", NestedFieldDictionaryEncodedColumn.this.nullBitmap);
                    }

                    @Override
                    public boolean isNull() {
                        int i = offset.getOffset();
                        if (i < this.offsetMark) {
                            this.nullMark = -1;
                            this.nullIterator = NestedFieldDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                        }
                        this.offsetMark = i;
                        if (this.nullMark < i) {
                            this.nullIterator.advanceIfNeeded(this.offsetMark);
                            if (this.nullIterator.hasNext()) {
                                this.nullMark = this.nullIterator.next();
                            }
                        }
                        return this.nullMark == this.offsetMark;
                    }
                };
            }
            if (Types.is(this.singleType, ValueType.DOUBLE)) {
                return new DoubleColumnSelector(){
                    private PeekableIntIterator nullIterator;
                    private int nullMark;
                    private int offsetMark;
                    {
                        this.nullIterator = NestedFieldDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                        this.nullMark = -1;
                        this.offsetMark = -1;
                    }

                    @Override
                    public double getDouble() {
                        return NestedFieldDictionaryEncodedColumn.this.doublesColumn.get(offset.getOffset());
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("doubleColumn", NestedFieldDictionaryEncodedColumn.this.doublesColumn);
                        inspector.visit("nullBitmap", NestedFieldDictionaryEncodedColumn.this.nullBitmap);
                    }

                    @Override
                    public boolean isNull() {
                        int i = offset.getOffset();
                        if (i < this.offsetMark) {
                            this.nullMark = -1;
                            this.nullIterator = NestedFieldDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                        }
                        this.offsetMark = i;
                        if (this.nullMark < i) {
                            this.nullIterator.advanceIfNeeded(this.offsetMark);
                            if (this.nullIterator.hasNext()) {
                                this.nullMark = this.nullIterator.next();
                            }
                        }
                        return this.nullMark == this.offsetMark;
                    }
                };
            }
        }
        if (this.singleType == null || this.singleType.isArray()) {
            return new ColumnValueSelector<Object>(){
                private PeekableIntIterator nullIterator;
                private int nullMark;
                private int offsetMark;
                {
                    this.nullIterator = NestedFieldDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                    this.nullMark = -1;
                    this.offsetMark = -1;
                }

                @Override
                @Nullable
                public Object getObject() {
                    int localId = NestedFieldDictionaryEncodedColumn.this.column.get(offset.getOffset());
                    int globalId = (Integer)NestedFieldDictionaryEncodedColumn.this.dictionary.get(localId);
                    if (globalId < NestedFieldDictionaryEncodedColumn.this.adjustArrayId) {
                        return NestedFieldDictionaryEncodedColumn.this.lookupGlobalScalarObject(globalId);
                    }
                    int[] arr = NestedFieldDictionaryEncodedColumn.this.globalArrayDictionary.get(globalId - NestedFieldDictionaryEncodedColumn.this.adjustArrayId);
                    if (arr == null) {
                        return null;
                    }
                    Object[] array = new Object[arr.length];
                    for (int i = 0; i < arr.length; ++i) {
                        array[i] = NestedFieldDictionaryEncodedColumn.this.lookupGlobalScalarObject(arr[i]);
                    }
                    return array;
                }

                @Override
                public float getFloat() {
                    int localId = NestedFieldDictionaryEncodedColumn.this.column.get(offset.getOffset());
                    int globalId = (Integer)NestedFieldDictionaryEncodedColumn.this.dictionary.get(localId);
                    if (globalId == 0) {
                        return 0.0f;
                    }
                    if (globalId < NestedFieldDictionaryEncodedColumn.this.adjustLongId) {
                        Float f = Floats.tryParse((String)StringUtils.fromUtf8((ByteBuffer)NestedFieldDictionaryEncodedColumn.this.globalDictionary.get(globalId)));
                        return f == null ? 0.0f : f.floatValue();
                    }
                    if (globalId < NestedFieldDictionaryEncodedColumn.this.adjustDoubleId) {
                        return ((Long)NestedFieldDictionaryEncodedColumn.this.globalLongDictionary.get(globalId - NestedFieldDictionaryEncodedColumn.this.adjustLongId)).floatValue();
                    }
                    return ((Double)NestedFieldDictionaryEncodedColumn.this.globalDoubleDictionary.get(globalId - NestedFieldDictionaryEncodedColumn.this.adjustDoubleId)).floatValue();
                }

                @Override
                public double getDouble() {
                    int localId = NestedFieldDictionaryEncodedColumn.this.column.get(offset.getOffset());
                    int globalId = (Integer)NestedFieldDictionaryEncodedColumn.this.dictionary.get(localId);
                    if (globalId == 0) {
                        return 0.0;
                    }
                    if (globalId < NestedFieldDictionaryEncodedColumn.this.adjustLongId) {
                        Double d = Doubles.tryParse((String)StringUtils.fromUtf8((ByteBuffer)NestedFieldDictionaryEncodedColumn.this.globalDictionary.get(globalId)));
                        return d == null ? 0.0 : d;
                    }
                    if (globalId < NestedFieldDictionaryEncodedColumn.this.adjustDoubleId) {
                        return ((Long)NestedFieldDictionaryEncodedColumn.this.globalLongDictionary.get(globalId - NestedFieldDictionaryEncodedColumn.this.adjustLongId)).doubleValue();
                    }
                    return (Double)NestedFieldDictionaryEncodedColumn.this.globalDoubleDictionary.get(globalId - NestedFieldDictionaryEncodedColumn.this.adjustDoubleId);
                }

                @Override
                public long getLong() {
                    int localId = NestedFieldDictionaryEncodedColumn.this.column.get(offset.getOffset());
                    int globalId = (Integer)NestedFieldDictionaryEncodedColumn.this.dictionary.get(localId);
                    if (globalId == 0) {
                        return 0L;
                    }
                    if (globalId < NestedFieldDictionaryEncodedColumn.this.adjustLongId) {
                        Long l = GuavaUtils.tryParseLong(StringUtils.fromUtf8((ByteBuffer)NestedFieldDictionaryEncodedColumn.this.globalDictionary.get(globalId)));
                        return l == null ? 0L : l;
                    }
                    if (globalId < NestedFieldDictionaryEncodedColumn.this.adjustDoubleId) {
                        return (Long)NestedFieldDictionaryEncodedColumn.this.globalLongDictionary.get(globalId - NestedFieldDictionaryEncodedColumn.this.adjustLongId);
                    }
                    return ((Double)NestedFieldDictionaryEncodedColumn.this.globalDoubleDictionary.get(globalId - NestedFieldDictionaryEncodedColumn.this.adjustDoubleId)).longValue();
                }

                @Override
                public boolean isNull() {
                    int i = offset.getOffset();
                    if (i < this.offsetMark) {
                        this.nullMark = -1;
                        this.nullIterator = NestedFieldDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                    }
                    this.offsetMark = i;
                    if (this.nullMark < i) {
                        this.nullIterator.advanceIfNeeded(this.offsetMark);
                        if (this.nullIterator.hasNext()) {
                            this.nullMark = this.nullIterator.next();
                        }
                    }
                    if (this.nullMark == this.offsetMark) {
                        return true;
                    }
                    int localId = NestedFieldDictionaryEncodedColumn.this.column.get(offset.getOffset());
                    int globalId = (Integer)NestedFieldDictionaryEncodedColumn.this.dictionary.get(localId);
                    if (globalId == 0) {
                        return true;
                    }
                    if (globalId < NestedFieldDictionaryEncodedColumn.this.adjustLongId) {
                        String value = StringUtils.fromUtf8Nullable((ByteBuffer)NestedFieldDictionaryEncodedColumn.this.globalDictionary.get(globalId));
                        return GuavaUtils.tryParseLong(value) == null && Doubles.tryParse((String)value) == null;
                    }
                    return globalId >= NestedFieldDictionaryEncodedColumn.this.adjustArrayId;
                }

                @Override
                public Class<?> classOfObject() {
                    return Object.class;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("longColumn", NestedFieldDictionaryEncodedColumn.this.longsColumn);
                    inspector.visit("nullBitmap", NestedFieldDictionaryEncodedColumn.this.nullBitmap);
                }
            };
        }
        return this.makeDimensionSelector(offset, null);
    }

    @Override
    public SingleValueDimensionVectorSelector makeSingleValueDimensionVectorSelector(final ReadableVectorOffset offset) {
        final class StringVectorSelector
        extends StringUtf8DictionaryEncodedColumn.StringSingleValueDimensionVectorSelector {
            public StringVectorSelector() {
                super(NestedFieldDictionaryEncodedColumn.this.column, readableVectorOffset);
            }

            @Override
            public int getValueCardinality() {
                return NestedFieldDictionaryEncodedColumn.this.getCardinality();
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                return NestedFieldDictionaryEncodedColumn.this.lookupName(id);
            }

            @Override
            @Nullable
            public ByteBuffer lookupNameUtf8(int id) {
                return (ByteBuffer)NestedFieldDictionaryEncodedColumn.this.globalDictionary.get(NestedFieldDictionaryEncodedColumn.this.dictionary.indexOf(id));
            }

            @Override
            public boolean supportsLookupNameUtf8() {
                return NestedFieldDictionaryEncodedColumn.this.singleType != null && NestedFieldDictionaryEncodedColumn.this.singleType.is(ValueType.STRING);
            }

            @Override
            public int lookupId(@Nullable String name) {
                return NestedFieldDictionaryEncodedColumn.this.lookupId(name);
            }
        }
        return new StringVectorSelector();
    }

    @Override
    public MultiValueDimensionVectorSelector makeMultiValueDimensionVectorSelector(ReadableVectorOffset vectorOffset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VectorObjectSelector makeVectorObjectSelector(final ReadableVectorOffset offset) {
        if (ColumnType.STRING.equals(this.logicalType)) {
            final class StringVectorSelector
            extends StringUtf8DictionaryEncodedColumn.StringVectorObjectSelector {
                public StringVectorSelector() {
                    super(NestedFieldDictionaryEncodedColumn.this.column, readableVectorOffset);
                }

                @Override
                @Nullable
                public String lookupName(int id) {
                    return NestedFieldDictionaryEncodedColumn.this.lookupName(id);
                }
            }
            return new StringVectorSelector();
        }
        return new VariantColumn.VariantVectorObjectSelector(offset, this.column, this.globalArrayDictionary, this.logicalExpressionType, this.adjustArrayId){

            @Override
            public int adjustDictionaryId(int id) {
                return (Integer)NestedFieldDictionaryEncodedColumn.this.dictionary.get(id);
            }

            @Override
            @Nullable
            public Object lookupScalarValue(int dictionaryId) {
                return NestedFieldDictionaryEncodedColumn.this.lookupGlobalScalarObject(dictionaryId);
            }

            @Override
            @Nullable
            public Object lookupScalarValueAndCast(int dictionaryId) {
                return NestedFieldDictionaryEncodedColumn.this.lookupGlobalScalarValueAndCast(dictionaryId);
            }
        };
    }

    @Override
    public VectorValueSelector makeVectorValueSelector(ReadableVectorOffset offset) {
        if (this.singleType != null) {
            if (Types.is(this.singleType, ValueType.LONG)) {
                return new BaseLongVectorValueSelector(offset){
                    private final long[] valueVector;
                    @Nullable
                    private boolean[] nullVector;
                    private int id;
                    @Nullable
                    private PeekableIntIterator nullIterator;
                    private int offsetMark;
                    {
                        this.valueVector = new long[this.offset.getMaxVectorSize()];
                        this.nullVector = null;
                        this.id = -1;
                        this.nullIterator = NestedFieldDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                        this.offsetMark = -1;
                    }

                    @Override
                    public long[] getLongVector() {
                        this.computeVectorsIfNeeded();
                        return this.valueVector;
                    }

                    @Override
                    @Nullable
                    public boolean[] getNullVector() {
                        this.computeVectorsIfNeeded();
                        return this.nullVector;
                    }

                    private void computeVectorsIfNeeded() {
                        if (this.id == this.offset.getId()) {
                            return;
                        }
                        if (this.offset.isContiguous()) {
                            if (this.offset.getStartOffset() < this.offsetMark) {
                                this.nullIterator = NestedFieldDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                            }
                            this.offsetMark = this.offset.getStartOffset() + this.offset.getCurrentVectorSize();
                            NestedFieldDictionaryEncodedColumn.this.longsColumn.get(this.valueVector, this.offset.getStartOffset(), this.offset.getCurrentVectorSize());
                        } else {
                            int[] offsets = this.offset.getOffsets();
                            if (offsets[offsets.length - 1] < this.offsetMark) {
                                this.nullIterator = NestedFieldDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                            }
                            this.offsetMark = offsets[offsets.length - 1];
                            NestedFieldDictionaryEncodedColumn.this.longsColumn.get(this.valueVector, offsets, this.offset.getCurrentVectorSize());
                        }
                        if (this.nullIterator != null) {
                            this.nullVector = VectorSelectorUtils.populateNullVector(this.nullVector, this.offset, this.nullIterator);
                        }
                        this.id = this.offset.getId();
                    }
                };
            }
            if (Types.is(this.singleType, ValueType.DOUBLE)) {
                return new BaseDoubleVectorValueSelector(offset){
                    private final double[] valueVector;
                    @Nullable
                    private boolean[] nullVector;
                    private int id;
                    @Nullable
                    private PeekableIntIterator nullIterator;
                    private int offsetMark;
                    {
                        this.valueVector = new double[this.offset.getMaxVectorSize()];
                        this.nullVector = null;
                        this.id = -1;
                        this.nullIterator = NestedFieldDictionaryEncodedColumn.this.nullBitmap != null ? NestedFieldDictionaryEncodedColumn.this.nullBitmap.peekableIterator() : null;
                        this.offsetMark = -1;
                    }

                    @Override
                    public double[] getDoubleVector() {
                        this.computeVectorsIfNeeded();
                        return this.valueVector;
                    }

                    @Override
                    @Nullable
                    public boolean[] getNullVector() {
                        this.computeVectorsIfNeeded();
                        return this.nullVector;
                    }

                    private void computeVectorsIfNeeded() {
                        if (this.id == this.offset.getId()) {
                            return;
                        }
                        if (this.offset.isContiguous()) {
                            if (this.offset.getStartOffset() < this.offsetMark) {
                                this.nullIterator = NestedFieldDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                            }
                            this.offsetMark = this.offset.getStartOffset() + this.offset.getCurrentVectorSize();
                            NestedFieldDictionaryEncodedColumn.this.doublesColumn.get(this.valueVector, this.offset.getStartOffset(), this.offset.getCurrentVectorSize());
                        } else {
                            int[] offsets = this.offset.getOffsets();
                            if (offsets[offsets.length - 1] < this.offsetMark) {
                                this.nullIterator = NestedFieldDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                            }
                            this.offsetMark = offsets[offsets.length - 1];
                            NestedFieldDictionaryEncodedColumn.this.doublesColumn.get(this.valueVector, offsets, this.offset.getCurrentVectorSize());
                        }
                        if (this.nullIterator != null) {
                            this.nullVector = VectorSelectorUtils.populateNullVector(this.nullVector, this.offset, this.nullIterator);
                        }
                        this.id = this.offset.getId();
                    }
                };
            }
            throw DruidException.defensive("Cannot make vector value selector for [%s] typed nested field", this.types);
        }
        if (FieldTypeInfo.convertToSet(this.types.getByteValue()).stream().allMatch(TypeSignature::isNumeric)) {
            return new BaseDoubleVectorValueSelector(offset){
                private final double[] valueVector;
                private final int[] idVector;
                @Nullable
                private boolean[] nullVector;
                private int id;
                @Nullable
                private PeekableIntIterator nullIterator;
                private int offsetMark;
                {
                    this.valueVector = new double[this.offset.getMaxVectorSize()];
                    this.idVector = new int[this.offset.getMaxVectorSize()];
                    this.nullVector = null;
                    this.id = -1;
                    this.nullIterator = NestedFieldDictionaryEncodedColumn.this.nullBitmap != null ? NestedFieldDictionaryEncodedColumn.this.nullBitmap.peekableIterator() : null;
                    this.offsetMark = -1;
                }

                @Override
                public double[] getDoubleVector() {
                    this.computeVectorsIfNeeded();
                    return this.valueVector;
                }

                @Override
                @Nullable
                public boolean[] getNullVector() {
                    this.computeVectorsIfNeeded();
                    return this.nullVector;
                }

                private void computeVectorsIfNeeded() {
                    if (this.id == this.offset.getId()) {
                        return;
                    }
                    if (this.offset.isContiguous()) {
                        if (this.offset.getStartOffset() < this.offsetMark) {
                            this.nullIterator = NestedFieldDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                        }
                        this.offsetMark = this.offset.getStartOffset() + this.offset.getCurrentVectorSize();
                        NestedFieldDictionaryEncodedColumn.this.column.get(this.idVector, this.offset.getStartOffset(), this.offset.getCurrentVectorSize());
                    } else {
                        int[] offsets = this.offset.getOffsets();
                        if (offsets[offsets.length - 1] < this.offsetMark) {
                            this.nullIterator = NestedFieldDictionaryEncodedColumn.this.nullBitmap.peekableIterator();
                        }
                        this.offsetMark = offsets[offsets.length - 1];
                        NestedFieldDictionaryEncodedColumn.this.column.get(this.idVector, offsets, this.offset.getCurrentVectorSize());
                    }
                    for (int i = 0; i < this.offset.getCurrentVectorSize(); ++i) {
                        int globalId = (Integer)NestedFieldDictionaryEncodedColumn.this.dictionary.get(this.idVector[i]);
                        if (globalId == 0) continue;
                        this.valueVector[i] = globalId < NestedFieldDictionaryEncodedColumn.this.adjustDoubleId ? ((Long)NestedFieldDictionaryEncodedColumn.this.globalLongDictionary.get(globalId - NestedFieldDictionaryEncodedColumn.this.adjustLongId)).doubleValue() : ((Double)NestedFieldDictionaryEncodedColumn.this.globalDoubleDictionary.get(globalId - NestedFieldDictionaryEncodedColumn.this.adjustDoubleId)).doubleValue();
                    }
                    if (this.nullIterator != null) {
                        this.nullVector = VectorSelectorUtils.populateNullVector(this.nullVector, this.offset, this.nullIterator);
                    }
                    this.id = this.offset.getId();
                }
            };
        }
        throw DruidException.defensive("Cannot make vector value selector for variant typed [%s] nested field", this.types);
    }

    @Override
    public void close() throws IOException {
        CloseableUtils.closeAll(this.column, this.longsColumn, this.doublesColumn);
    }
}

