/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.projections;

import java.util.Map;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.RemapColumnSelectorFactory;
import org.apache.druid.segment.vector.RemapVectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class QueryableProjection<T> {
    private final CursorBuildSpec cursorBuildSpec;
    private final Map<String, String> remapColumns;
    private final T rowSelector;

    public QueryableProjection(CursorBuildSpec cursorBuildSpec, Map<String, String> remapColumns, T rowSelector) {
        this.cursorBuildSpec = cursorBuildSpec;
        this.remapColumns = remapColumns;
        this.rowSelector = rowSelector;
    }

    public CursorBuildSpec getCursorBuildSpec() {
        return this.cursorBuildSpec;
    }

    public ColumnSelectorFactory wrapColumnSelectorFactory(ColumnSelectorFactory selectorFactory) {
        return new RemapColumnSelectorFactory(selectorFactory, this.remapColumns);
    }

    public VectorColumnSelectorFactory wrapVectorColumnSelectorFactory(VectorColumnSelectorFactory selectorFactory) {
        return new RemapVectorColumnSelectorFactory(selectorFactory, this.remapColumns);
    }

    public T getRowSelector() {
        return this.rowSelector;
    }
}

