/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.druid.io.Channels;

public final class MetaSerdeHelper<T> {
    private final List<FieldWriter<T>> fieldWriters = new ArrayList<FieldWriter<T>>();

    public static <T> MetaSerdeHelper<T> firstWriteByte(ByteFieldWriter<T> fieldWriter) {
        return new MetaSerdeHelper<T>().writeByte(fieldWriter);
    }

    private MetaSerdeHelper() {
    }

    public MetaSerdeHelper<T> writeInt(IntFieldWriter<T> fieldWriter) {
        return this.writeSomething(fieldWriter);
    }

    public MetaSerdeHelper<T> writeByte(ByteFieldWriter<T> fieldWriter) {
        return this.writeSomething(fieldWriter);
    }

    public MetaSerdeHelper<T> maybeWriteByte(final Predicate<T> condition, final ByteFieldWriter<T> fieldWriter) {
        return this.writeSomething(new FieldWriter<T>(){

            @Override
            public void writeTo(ByteBuffer buffer, T x) {
                if (condition.test(x)) {
                    buffer.put(fieldWriter.getField(x));
                }
            }

            @Override
            public int size(T x) {
                return condition.test(x) ? 1 : 0;
            }
        });
    }

    public MetaSerdeHelper<T> writeByteArray(final Function<T, byte[]> getByteArray) {
        return this.writeSomething(new FieldWriter<T>(){

            @Override
            public void writeTo(ByteBuffer buffer, T x) {
                buffer.put((byte[])getByteArray.apply(x));
            }

            @Override
            public int size(T x) {
                return ((byte[])getByteArray.apply(x)).length;
            }
        });
    }

    public MetaSerdeHelper<T> writeSomething(FieldWriter<T> fieldWriter) {
        this.fieldWriters.add(fieldWriter);
        return this;
    }

    public void writeTo(WritableByteChannel channel, T x) throws IOException {
        ByteBuffer meta = ByteBuffer.allocate(this.size(x));
        for (FieldWriter<T> w : this.fieldWriters) {
            w.writeTo(meta, x);
        }
        meta.flip();
        Channels.writeFully(channel, meta);
    }

    public int size(T x) {
        int retVal = 0;
        for (FieldWriter<T> fieldWriter : this.fieldWriters) {
            retVal += fieldWriter.size(x);
        }
        return retVal;
    }

    @FunctionalInterface
    public static interface ByteFieldWriter<T>
    extends FieldWriter<T> {
        public byte getField(T var1);

        @Override
        default public void writeTo(ByteBuffer buffer, T x) {
            buffer.put(this.getField(x));
        }

        @Override
        default public int size(T x) {
            return 1;
        }
    }

    @FunctionalInterface
    public static interface IntFieldWriter<T>
    extends FieldWriter<T> {
        public int getField(T var1);

        @Override
        default public void writeTo(ByteBuffer buffer, T x) {
            buffer.putInt(this.getField(x));
        }

        @Override
        default public int size(T x) {
            return 4;
        }
    }

    public static interface FieldWriter<T> {
        public void writeTo(ByteBuffer var1, T var2);

        public int size(T var1);
    }
}

