/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.error;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.druid.error.ErrorResponse;
import org.apache.druid.java.util.common.StringUtils;

@NotThreadSafe
public class DruidException
extends RuntimeException {
    public static final String CLASS_NAME_STR = DruidException.class.getName();
    private final Persona targetPersona;
    private final Category category;
    private final String errorCode;
    protected final Map<String, String> context = new LinkedHashMap<String, String>();

    public static PartialDruidExceptionBuilder forPersona(Persona persona) {
        return new PartialDruidExceptionBuilder("general", persona);
    }

    public static DruidException fromFailure(Failure failure) {
        return failure.makeException(new DruidExceptionBuilder(failure.getErrorCode()));
    }

    public static DruidExceptionBuilder defensive() {
        return DruidException.forPersona(Persona.DEVELOPER).ofCategory(Category.DEFENSIVE);
    }

    public static DruidException defensive(String format, Object ... args) {
        return DruidException.defensive().build(format, args);
    }

    public static DruidException defensive(Throwable cause, String format, Object ... args) {
        return DruidException.defensive().build(cause, format, args);
    }

    public static void conditionalDefensive(boolean condition, String msg, Object ... args) {
        if (!condition) {
            throw DruidException.defensive(msg, args);
        }
    }

    private DruidException(Throwable cause, String errorCode, Persona targetPersona, Category category, String message) {
        this(cause, errorCode, targetPersona, category, message, false);
    }

    private DruidException(Throwable throwable, String errorCode, Persona targetPersona, Category category, String message, boolean deserialized) {
        super(message, throwable, true, !deserialized);
        this.errorCode = (String)Preconditions.checkNotNull((Object)errorCode, (Object)"errorCode");
        this.targetPersona = (Persona)((Object)Preconditions.checkNotNull((Object)((Object)targetPersona), (Object)"targetPersona"));
        this.category = (Category)((Object)Preconditions.checkNotNull((Object)((Object)category), (Object)"category"));
    }

    public DruidException withContext(String key, Object value) {
        this.context.put(key, value == null ? null : value.toString());
        return this;
    }

    public DruidException withContext(Map<String, String> values) {
        this.context.putAll(values);
        return this;
    }

    public Persona getTargetPersona() {
        return this.targetPersona;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getContextValue(String key) {
        return this.context.get(key);
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public int getStatusCode() {
        return this.category.getExpectedStatus();
    }

    @JsonValue
    public ErrorResponse toErrorResponse() {
        return new ErrorResponse(this);
    }

    public DruidException prependAndBuild(String msg, Object ... args) {
        return new DruidException(this, this.errorCode, this.targetPersona, this.category, StringUtils.format("%s: %s", StringUtils.nonStrictFormat(msg, args), this.getMessage())).withContext(this.context);
    }

    public static enum Persona {
        USER,
        ADMIN,
        OPERATOR,
        DEVELOPER;

    }

    public static enum Category {
        DEFENSIVE(500),
        INVALID_INPUT(400),
        UNAUTHORIZED(401),
        FORBIDDEN(403),
        NOT_FOUND(404),
        CAPACITY_EXCEEDED(429),
        CANCELED(500),
        RUNTIME_FAILURE(500),
        TIMEOUT(504),
        UNSUPPORTED(501),
        UNCATEGORIZED(500);

        private final int expectedStatus;

        private Category(int expectedStatus) {
            this.expectedStatus = expectedStatus;
        }

        public int getExpectedStatus() {
            return this.expectedStatus;
        }
    }

    public static class PartialDruidExceptionBuilder {
        private final String errorCode;
        private final Persona targetPersona;

        private PartialDruidExceptionBuilder(String errorCode, Persona targetPersona) {
            this.errorCode = errorCode;
            this.targetPersona = targetPersona;
        }

        public DruidExceptionBuilder ofCategory(Category category) {
            return new DruidExceptionBuilder(this.errorCode).forPersona(this.targetPersona).ofCategory(category);
        }
    }

    public static class DruidExceptionBuilder {
        private String errorCode;
        private Persona targetPersona;
        private Category category;
        private boolean deserialized = false;

        private DruidExceptionBuilder(String errorCode) {
            this.errorCode = errorCode;
        }

        public DruidExceptionBuilder forPersona(Persona targetPersona) {
            this.targetPersona = targetPersona;
            return this;
        }

        public DruidExceptionBuilder withErrorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public DruidExceptionBuilder ofCategory(Category category) {
            this.category = category;
            return this;
        }

        DruidExceptionBuilder wasDeserialized() {
            this.deserialized = true;
            return this;
        }

        public DruidException build(String formatMe, Object ... vals) {
            return this.build(null, formatMe, vals);
        }

        public DruidException build(Throwable cause, String formatMe, Object ... vals) {
            int firstNonDruidExceptionIndex;
            DruidException retVal = new DruidException(cause, this.errorCode, this.targetPersona, this.category, StringUtils.nonStrictFormat(formatMe, vals), this.deserialized);
            StackTraceElement[] stackTrace = retVal.getStackTrace();
            for (firstNonDruidExceptionIndex = 0; firstNonDruidExceptionIndex < stackTrace.length && stackTrace[firstNonDruidExceptionIndex].getClassName().startsWith(CLASS_NAME_STR); ++firstNonDruidExceptionIndex) {
            }
            if (firstNonDruidExceptionIndex > 0) {
                retVal.setStackTrace(Arrays.copyOfRange(stackTrace, firstNonDruidExceptionIndex, stackTrace.length));
            }
            return retVal;
        }
    }

    public static abstract class Failure {
        private final String errorCode;

        public Failure(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        protected abstract DruidException makeException(DruidExceptionBuilder var1);
    }
}

