/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.field.FieldPositionHelper;
import org.apache.druid.frame.field.NumericFieldReader;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.frame.field.TransformUtils;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.FloatColumnSelector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;

public class FloatFieldReader
extends NumericFieldReader {
    public static FloatFieldReader forPrimitive() {
        return new FloatFieldReader(false);
    }

    public static FloatFieldReader forArray() {
        return new FloatFieldReader(true);
    }

    private FloatFieldReader(boolean forArray) {
        super(forArray);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.FLOAT;
    }

    @Override
    public ColumnValueSelector<?> getColumnValueSelector(Memory memory, ReadableFieldPointer fieldPointer, byte nullIndicatorByte) {
        return new FloatFieldSelector(memory, fieldPointer, nullIndicatorByte);
    }

    @Override
    public Column makeRACColumn(Frame frame, RowSignature signature, String columnName) {
        return new FloatFieldReaderColumn(frame, signature.indexOf(columnName), signature.size());
    }

    private static class FloatFieldSelector
    extends NumericFieldReader.Selector
    implements FloatColumnSelector {
        final Memory dataRegion;
        final ReadableFieldPointer fieldPointer;

        public FloatFieldSelector(Memory dataRegion, ReadableFieldPointer fieldPointer, byte nullIndicatorByte) {
            super(dataRegion, fieldPointer, nullIndicatorByte);
            this.dataRegion = dataRegion;
            this.fieldPointer = fieldPointer;
        }

        @Override
        public float getFloat() {
            assert (NullHandling.replaceWithDefault() || !this.isNull());
            int bits = this.dataRegion.getInt(this.fieldPointer.position() + 1L);
            return TransformUtils.detransformToFloat(bits);
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }

        @Override
        public boolean isNull() {
            return super._isNull();
        }
    }

    private class FloatFieldReaderColumn
    implements Column {
        private final Frame frame;
        private final Memory dataRegion;
        private final FieldPositionHelper coach;

        public FloatFieldReaderColumn(Frame frame, int columnIndex, int numFields) {
            this.frame = frame;
            this.dataRegion = frame.region(1);
            this.coach = new FieldPositionHelper(frame, frame.region(0), this.dataRegion, columnIndex, numFields);
        }

        @Override
        @Nonnull
        public ColumnAccessor toAccessor() {
            return new ColumnAccessor(){

                @Override
                public ColumnType getType() {
                    return ColumnType.FLOAT;
                }

                @Override
                public int numRows() {
                    return FloatFieldReaderColumn.this.frame.numRows();
                }

                @Override
                public boolean isNull(int rowNum) {
                    long fieldPosition = FloatFieldReaderColumn.this.coach.computeFieldPosition(rowNum);
                    return FloatFieldReaderColumn.this.dataRegion.getByte(fieldPosition) == FloatFieldReader.this.getNullIndicatorByte();
                }

                @Override
                @Nullable
                public Object getObject(int rowNum) {
                    long fieldPosition = FloatFieldReaderColumn.this.coach.computeFieldPosition(rowNum);
                    if (FloatFieldReaderColumn.this.dataRegion.getByte(fieldPosition) == FloatFieldReader.this.getNullIndicatorByte()) {
                        return null;
                    }
                    return Float.valueOf(this.getFloatAtPosition(fieldPosition));
                }

                @Override
                public double getDouble(int rowNum) {
                    return this.getFloat(rowNum);
                }

                @Override
                public float getFloat(int rowNum) {
                    long fieldPosition = FloatFieldReaderColumn.this.coach.computeFieldPosition(rowNum);
                    if (FloatFieldReaderColumn.this.dataRegion.getByte(fieldPosition) == FloatFieldReader.this.getNullIndicatorByte()) {
                        return 0.0f;
                    }
                    return this.getFloatAtPosition(fieldPosition);
                }

                @Override
                public long getLong(int rowNum) {
                    return (long)this.getFloat(rowNum);
                }

                @Override
                public int getInt(int rowNum) {
                    return (int)this.getFloat(rowNum);
                }

                @Override
                public int compareRows(int lhsRowNum, int rhsRowNum) {
                    long lhsPosition = FloatFieldReaderColumn.this.coach.computeFieldPosition(lhsRowNum);
                    long rhsPosition = FloatFieldReaderColumn.this.coach.computeFieldPosition(rhsRowNum);
                    byte nullIndicatorByte = FloatFieldReader.this.getNullIndicatorByte();
                    if (FloatFieldReaderColumn.this.dataRegion.getByte(lhsPosition) == nullIndicatorByte) {
                        if (FloatFieldReaderColumn.this.dataRegion.getByte(rhsPosition) == nullIndicatorByte) {
                            return 0;
                        }
                        return -1;
                    }
                    if (FloatFieldReaderColumn.this.dataRegion.getByte(rhsPosition) == nullIndicatorByte) {
                        return 1;
                    }
                    return Float.compare(this.getFloatAtPosition(lhsPosition), this.getFloatAtPosition(rhsPosition));
                }

                private float getFloatAtPosition(long rhsPosition) {
                    return TransformUtils.detransformToFloat(FloatFieldReaderColumn.this.dataRegion.getInt(rhsPosition + 1L));
                }
            };
        }

        @Override
        @Nullable
        public <T> T as(Class<? extends T> clazz) {
            return null;
        }
    }
}

