/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.field.FieldPositionHelper;
import org.apache.druid.frame.field.NumericFieldReader;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.frame.field.TransformUtils;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.LongColumnSelector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;

public class LongFieldReader
extends NumericFieldReader {
    public static LongFieldReader forPrimitive() {
        return new LongFieldReader(false);
    }

    public static LongFieldReader forArray() {
        return new LongFieldReader(true);
    }

    private LongFieldReader(boolean forArray) {
        super(forArray);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.LONG;
    }

    @Override
    public ColumnValueSelector<?> getColumnValueSelector(Memory memory, ReadableFieldPointer fieldPointer, byte nullIndicatorByte) {
        return new LongFieldSelector(memory, fieldPointer, nullIndicatorByte);
    }

    @Override
    public Column makeRACColumn(Frame frame, RowSignature signature, String columnName) {
        return new LongFieldReaderColumn(frame, signature.indexOf(columnName), signature.size());
    }

    private static class LongFieldSelector
    extends NumericFieldReader.Selector
    implements LongColumnSelector {
        final Memory dataRegion;
        final ReadableFieldPointer fieldPointer;

        public LongFieldSelector(Memory dataRegion, ReadableFieldPointer fieldPointer, byte nullIndicatorByte) {
            super(dataRegion, fieldPointer, nullIndicatorByte);
            this.dataRegion = dataRegion;
            this.fieldPointer = fieldPointer;
        }

        @Override
        public long getLong() {
            assert (NullHandling.replaceWithDefault() || !this.isNull());
            long bits = this.dataRegion.getLong(this.fieldPointer.position() + 1L);
            return TransformUtils.detransformToLong(bits);
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }

        @Override
        public boolean isNull() {
            return super._isNull();
        }
    }

    private class LongFieldReaderColumn
    implements Column {
        private final Frame frame;
        private final Memory dataRegion;
        private final FieldPositionHelper coach;

        public LongFieldReaderColumn(Frame frame, int columnIndex, int numFields) {
            this.frame = frame;
            this.dataRegion = frame.region(1);
            this.coach = new FieldPositionHelper(frame, frame.region(0), this.dataRegion, columnIndex, numFields);
        }

        @Override
        @Nonnull
        public ColumnAccessor toAccessor() {
            return new ColumnAccessor(){

                @Override
                public ColumnType getType() {
                    return ColumnType.LONG;
                }

                @Override
                public int numRows() {
                    return LongFieldReaderColumn.this.frame.numRows();
                }

                @Override
                public boolean isNull(int rowNum) {
                    long fieldPosition = LongFieldReaderColumn.this.coach.computeFieldPosition(rowNum);
                    return LongFieldReaderColumn.this.dataRegion.getByte(fieldPosition) == LongFieldReader.this.getNullIndicatorByte();
                }

                @Override
                @Nullable
                public Object getObject(int rowNum) {
                    long fieldPosition = LongFieldReaderColumn.this.coach.computeFieldPosition(rowNum);
                    if (LongFieldReaderColumn.this.dataRegion.getByte(fieldPosition) == LongFieldReader.this.getNullIndicatorByte()) {
                        return null;
                    }
                    return this.getLongAtPosition(fieldPosition);
                }

                @Override
                public double getDouble(int rowNum) {
                    return this.getLong(rowNum);
                }

                @Override
                public float getFloat(int rowNum) {
                    return this.getLong(rowNum);
                }

                @Override
                public long getLong(int rowNum) {
                    long fieldPosition = LongFieldReaderColumn.this.coach.computeFieldPosition(rowNum);
                    if (LongFieldReaderColumn.this.dataRegion.getByte(fieldPosition) == LongFieldReader.this.getNullIndicatorByte()) {
                        return 0L;
                    }
                    return this.getLongAtPosition(fieldPosition);
                }

                @Override
                public int getInt(int rowNum) {
                    return (int)this.getLong(rowNum);
                }

                @Override
                public int compareRows(int lhsRowNum, int rhsRowNum) {
                    long lhsPosition = LongFieldReaderColumn.this.coach.computeFieldPosition(lhsRowNum);
                    long rhsPosition = LongFieldReaderColumn.this.coach.computeFieldPosition(rhsRowNum);
                    byte nullIndicatorByte = LongFieldReader.this.getNullIndicatorByte();
                    if (LongFieldReaderColumn.this.dataRegion.getByte(lhsPosition) == nullIndicatorByte) {
                        if (LongFieldReaderColumn.this.dataRegion.getByte(rhsPosition) == nullIndicatorByte) {
                            return 0;
                        }
                        return -1;
                    }
                    if (LongFieldReaderColumn.this.dataRegion.getByte(rhsPosition) == nullIndicatorByte) {
                        return 1;
                    }
                    return Long.compare(this.getLongAtPosition(lhsPosition), this.getLongAtPosition(rhsPosition));
                }

                private long getLongAtPosition(long rhsPosition) {
                    return TransformUtils.detransformToLong(LongFieldReaderColumn.this.dataRegion.getLong(rhsPosition + 1L));
                }
            };
        }

        @Override
        @Nullable
        public <T> T as(Class<? extends T> clazz) {
            return null;
        }
    }
}

