/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.NotYetImplemented;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.field.FieldPositionHelper;
import org.apache.druid.frame.field.FieldReader;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.frame.read.FrameReaderUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.column.accessor.ObjectColumnAccessorBase;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.RangeIndexedInts;

public class StringFieldReader
implements FieldReader {
    public static final byte[] EXPECTED_BYTES_FOR_NULL = new byte[]{2, 0, 1};
    private final boolean asArray;

    public StringFieldReader() {
        this(false);
    }

    protected StringFieldReader(boolean asArray) {
        this.asArray = asArray;
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(Memory memory, ReadableFieldPointer fieldPointer) {
        return new Selector(memory, fieldPointer, null, this.asArray);
    }

    @Override
    public DimensionSelector makeDimensionSelector(Memory memory, ReadableFieldPointer fieldPointer, @Nullable ExtractionFn extractionFn) {
        if (this.asArray) {
            throw new ISE("Cannot call makeDimensionSelector on field of type [%s]", ColumnType.STRING_ARRAY);
        }
        return new Selector(memory, fieldPointer, extractionFn, false);
    }

    @Override
    public boolean isNull(Memory memory, long position) {
        byte firstByte = memory.getByte(position);
        if (firstByte == 0) {
            return true;
        }
        if (!this.asArray) {
            return (NullHandling.replaceWithDefault() || firstByte == 2) && memory.getByte(position + 1L) == 0 && memory.getByte(position + 2L) == 1;
        }
        return false;
    }

    @Override
    public Column makeRACColumn(Frame frame, RowSignature signature, String columnName) {
        if (this.asArray) {
            return new StringArrayFieldReaderColumn(frame, signature.indexOf(columnName), signature.size());
        }
        return new StringFieldReaderColumn(frame, signature.indexOf(columnName), signature.size());
    }

    private static boolean addStringsToList(Memory memory, long fieldPosition, List<ByteBuffer> list) {
        long position = fieldPosition;
        long limit = memory.getCapacity();
        boolean rowTerminatorSeen = false;
        boolean isEffectivelyNull = false;
        block6: while (position < limit && !rowTerminatorSeen) {
            byte kind = memory.getByte(position);
            ++position;
            block0 : switch (kind) {
                case 0: {
                    if (position != fieldPosition + 1L) continue block6;
                    isEffectivelyNull = true;
                    break;
                }
                case 1: {
                    rowTerminatorSeen = true;
                    break;
                }
                case 2: {
                    list.add(null);
                    break;
                }
                case 3: {
                    long i = position;
                    while (true) {
                        if (i >= limit) {
                            throw new ISE("Value overrun", new Object[0]);
                        }
                        byte b = memory.getByte(i);
                        if (b == 0) {
                            int len = Ints.checkedCast((long)(i - position));
                            if (len == 0 && NullHandling.replaceWithDefault()) {
                                list.add(null);
                            } else {
                                ByteBuffer buf = FrameReaderUtils.readByteBuffer(memory, position, len);
                                list.add(buf);
                            }
                            position += (long)len;
                            break block0;
                        }
                        ++i;
                    }
                }
                default: {
                    throw new ISE("Invalid value start byte [%s]", kind);
                }
            }
        }
        if (!rowTerminatorSeen) {
            throw new ISE("Unexpected end of field", new Object[0]);
        }
        return isEffectivelyNull;
    }

    private static class Selector
    implements DimensionSelector {
        private final Memory memory;
        private final ReadableFieldPointer fieldPointer;
        @Nullable
        private final ExtractionFn extractionFn;
        private final boolean asArray;
        private long currentFieldPosition = -1L;
        private final RangeIndexedInts indexedInts = new RangeIndexedInts();
        private final List<ByteBuffer> currentUtf8Strings = new ArrayList<ByteBuffer>();
        private boolean currentUtf8StringsIsNull;

        private Selector(Memory memory, ReadableFieldPointer fieldPointer, @Nullable ExtractionFn extractionFn, boolean asArray) {
            this.memory = memory;
            this.fieldPointer = fieldPointer;
            this.extractionFn = extractionFn;
            this.asArray = asArray;
        }

        @Override
        @Nullable
        public Object getObject() {
            List<ByteBuffer> currentStrings = this.computeCurrentUtf8Strings();
            if (currentStrings == null) {
                return null;
            }
            int size = currentStrings.size();
            if (size == 0) {
                return this.asArray ? ObjectArrays.EMPTY_ARRAY : null;
            }
            if (size == 1) {
                Object object;
                if (this.asArray) {
                    Object[] objectArray = new Object[1];
                    object = objectArray;
                    objectArray[0] = this.lookupName(0);
                } else {
                    object = this.lookupName(0);
                }
                return object;
            }
            Object[] strings = new Object[size];
            for (int i = 0; i < size; ++i) {
                strings[i] = this.lookupName(i);
            }
            return this.asArray ? strings : Arrays.asList(strings);
        }

        @Override
        public IndexedInts getRow() {
            List<ByteBuffer> strings = this.computeCurrentUtf8Strings();
            int size = strings == null ? 0 : strings.size();
            this.indexedInts.setSize(size);
            return this.indexedInts;
        }

        @Override
        @Nullable
        public String lookupName(int id) {
            List<ByteBuffer> strings = this.computeCurrentUtf8Strings();
            if (strings == null) {
                return null;
            }
            ByteBuffer byteBuffer = strings.get(id);
            String s = byteBuffer != null ? StringUtils.fromUtf8(byteBuffer.duplicate()) : null;
            return this.extractionFn == null ? s : this.extractionFn.apply(s);
        }

        @Override
        public boolean supportsLookupNameUtf8() {
            return this.extractionFn == null;
        }

        @Override
        @Nullable
        public ByteBuffer lookupNameUtf8(int id) {
            if (this.extractionFn != null) {
                throw new ISE("Cannot use lookupNameUtf8 on this selector", new Object[0]);
            }
            List<ByteBuffer> strings = this.computeCurrentUtf8Strings();
            return strings == null ? null : strings.get(id);
        }

        @Override
        public int getValueCardinality() {
            return -1;
        }

        @Override
        public boolean nameLookupPossibleInAdvance() {
            return false;
        }

        @Override
        @Nullable
        public IdLookup idLookup() {
            return null;
        }

        @Override
        public ValueMatcher makeValueMatcher(@Nullable String value) {
            return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, value);
        }

        @Override
        public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
            return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicateFactory);
        }

        @Override
        public Class<?> classOfObject() {
            return Object.class;
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }

        @Nullable
        private List<ByteBuffer> computeCurrentUtf8Strings() {
            long fieldPosition = this.fieldPointer.position();
            if (fieldPosition != this.currentFieldPosition) {
                this.updateCurrentUtf8Strings(fieldPosition);
            }
            this.currentFieldPosition = fieldPosition;
            if (this.currentUtf8StringsIsNull) {
                return null;
            }
            return this.currentUtf8Strings;
        }

        private void updateCurrentUtf8Strings(long fieldPosition) {
            this.currentUtf8StringsIsNull = false;
            this.currentUtf8Strings.clear();
            this.currentUtf8StringsIsNull = StringFieldReader.addStringsToList(this.memory, fieldPosition, this.currentUtf8Strings);
        }
    }

    private static class StringArrayFieldReaderColumn
    implements Column {
        private final Frame frame;
        private final Memory dataRegion;
        private final FieldPositionHelper coach;

        public StringArrayFieldReaderColumn(Frame frame, int columnIndex, int numFields) {
            this.frame = frame;
            this.dataRegion = frame.region(1);
            this.coach = new FieldPositionHelper(frame, frame.region(0), this.dataRegion, columnIndex, numFields);
        }

        @Override
        @Nonnull
        public ColumnAccessor toAccessor() {
            return new ObjectColumnAccessorBase(){

                @Override
                public ColumnType getType() {
                    return ColumnType.STRING_ARRAY;
                }

                @Override
                public int numRows() {
                    return frame.numRows();
                }

                @Override
                public boolean isNull(int rowNum) {
                    long fieldPosition = coach.computeFieldPosition(rowNum);
                    return dataRegion.getByte(fieldPosition) == 0 && dataRegion.getByte(fieldPosition + 1L) == 1;
                }

                @Override
                public int compareRows(int lhsRowNum, int rhsRowNum) {
                    throw NotYetImplemented.ex(null, "Should implement this by comparing the actual bytes in the frame, they should be comparable", new Object[0]);
                }

                @Override
                protected Object getVal(int rowNum) {
                    return this.getStringsAtPosition(coach.computeFieldPosition(rowNum));
                }

                @Override
                protected Comparator<Object> getComparator() {
                    throw new UnsupportedOperationException();
                }

                @Nullable
                private List<String> getStringsAtPosition(long fieldPosition) {
                    List<ByteBuffer> bufs = this.getUTF8BytesAtPosition(fieldPosition);
                    if (bufs == null) {
                        return null;
                    }
                    ArrayList<String> retVal = new ArrayList<String>(bufs.size());
                    for (ByteBuffer buf : bufs) {
                        retVal.add(StringUtils.fromUtf8Nullable(buf));
                    }
                    return retVal;
                }

                @Nullable
                private List<ByteBuffer> getUTF8BytesAtPosition(long fieldPosition) {
                    ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
                    boolean isNull = StringFieldReader.addStringsToList(dataRegion, fieldPosition, buffers);
                    if (isNull) {
                        return null;
                    }
                    return buffers;
                }
            };
        }

        @Override
        @Nullable
        public <T> T as(Class<? extends T> clazz) {
            return null;
        }
    }

    private static class StringFieldReaderColumn
    implements Column {
        private final Frame frame;
        private final Memory dataRegion;
        private final FieldPositionHelper coach;

        public StringFieldReaderColumn(Frame frame, int columnIndex, int numFields) {
            this.frame = frame;
            this.dataRegion = frame.region(1);
            this.coach = new FieldPositionHelper(frame, frame.region(0), this.dataRegion, columnIndex, numFields);
        }

        @Override
        @Nonnull
        public ColumnAccessor toAccessor() {
            return new ObjectColumnAccessorBase(){

                @Override
                public ColumnType getType() {
                    return ColumnType.STRING;
                }

                @Override
                public int numRows() {
                    return frame.numRows();
                }

                @Override
                public boolean isNull(int rowNum) {
                    long fieldPosition = coach.computeFieldPosition(rowNum);
                    byte[] nullBytes = new byte[3];
                    dataRegion.getByteArray(fieldPosition, nullBytes, 0, 3);
                    return Arrays.equals(nullBytes, EXPECTED_BYTES_FOR_NULL);
                }

                @Override
                public int compareRows(int lhsRowNum, int rhsRowNum) {
                    ByteBuffer lhs = this.getUTF8BytesAtPosition(coach.computeFieldPosition(lhsRowNum));
                    ByteBuffer rhs = this.getUTF8BytesAtPosition(coach.computeFieldPosition(rhsRowNum));
                    if (lhs == null) {
                        if (rhs == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (rhs == null) {
                        return 1;
                    }
                    return lhs.compareTo(rhs);
                }

                @Override
                protected Object getVal(int rowNum) {
                    return this.getStringAtPosition(coach.computeFieldPosition(rowNum));
                }

                @Override
                protected Comparator<Object> getComparator() {
                    throw new UnsupportedOperationException();
                }

                @Nullable
                private String getStringAtPosition(long fieldPosition) {
                    return StringUtils.fromUtf8Nullable(this.getUTF8BytesAtPosition(fieldPosition));
                }

                @Nullable
                private ByteBuffer getUTF8BytesAtPosition(long fieldPosition) {
                    ArrayList buffers = new ArrayList();
                    boolean isNull = StringFieldReader.addStringsToList(dataRegion, fieldPosition, buffers);
                    if (isNull) {
                        return null;
                    }
                    if (buffers.size() > 1) {
                        throw DruidException.defensive("Can only work with single-valued strings, should use a COMPLEX or ARRAY typed Column instead", new Object[0]);
                    }
                    return (ByteBuffer)buffers.get(0);
                }
            };
        }

        @Override
        @Nullable
        public <T> T as(Class<? extends T> clazz) {
            return null;
        }
    }
}

