/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import java.util.Iterator;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;

public class BaseSequence<T, IterType extends Iterator<T>>
implements Sequence<T> {
    private final IteratorMaker<T, IterType> maker;

    public BaseSequence(IteratorMaker<T, IterType> maker) {
        this.maker = maker;
    }

    @Override
    public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> fn) {
        IterType iterator = this.maker.make();
        OutType accumulated = initValue;
        try {
            while (iterator.hasNext()) {
                accumulated = fn.accumulate(accumulated, iterator.next());
            }
        }
        finally {
            this.maker.cleanup(iterator);
        }
        return accumulated;
    }

    @Override
    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
        IterType iterator = this.maker.make();
        try {
            OutType retVal = initValue;
            while (!accumulator.yielded() && iterator.hasNext()) {
                retVal = accumulator.accumulate(retVal, iterator.next());
            }
            if (!accumulator.yielded()) {
                return Yielders.done(retVal, () -> this.maker.cleanup((Iterator)iterator));
            }
            return this.makeYielder(retVal, accumulator, iterator);
        }
        catch (Throwable t) {
            try {
                this.maker.cleanup(iterator);
            }
            catch (Exception e) {
                t.addSuppressed(e);
            }
            throw t;
        }
    }

    private <OutType> Yielder<OutType> makeYielder(final OutType retValue, final YieldingAccumulator<OutType, T> accumulator, IterType iter) {
        return new Yielder<OutType>(){
            OutType retVal;
            final /* synthetic */ Iterator val$iter;
            {
                this.val$iter = iterator;
                this.retVal = retValue;
            }

            @Override
            public OutType get() {
                return this.retVal;
            }

            @Override
            public Yielder<OutType> next(OutType initValue) {
                accumulator.reset();
                this.retVal = initValue;
                while (!accumulator.yielded() && this.val$iter.hasNext()) {
                    this.retVal = accumulator.accumulate(this.retVal, this.val$iter.next());
                }
                if (accumulator.yielded()) {
                    return this;
                }
                return Yielders.done(this.retVal, this);
            }

            @Override
            public boolean isDone() {
                return false;
            }

            @Override
            public void close() {
                BaseSequence.this.maker.cleanup(this.val$iter);
            }
        };
    }

    public static interface IteratorMaker<T, IterType extends Iterator<T>> {
        public IterType make();

        public void cleanup(IterType var1);
    }
}

