/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.firstlast.first;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.SerializablePairLongLong;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.firstlast.FirstLastUtils;
import org.apache.druid.query.aggregation.firstlast.first.GenericFirstAggregateCombiner;
import org.apache.druid.query.aggregation.firstlast.first.LongFirstAggregator;
import org.apache.druid.query.aggregation.firstlast.first.LongFirstBufferAggregator;
import org.apache.druid.query.aggregation.firstlast.first.LongFirstVectorAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

@JsonTypeName(value="longFirst")
public class LongFirstAggregatorFactory
extends AggregatorFactory {
    public static final ColumnType TYPE = ColumnType.ofComplex("serializablePairLongLong");
    private static final Aggregator NIL_AGGREGATOR = new LongFirstAggregator(NilColumnValueSelector.instance(), NilColumnValueSelector.instance(), false){

        @Override
        public void aggregate() {
        }
    };
    private static final BufferAggregator NIL_BUFFER_AGGREGATOR = new LongFirstBufferAggregator(NilColumnValueSelector.instance(), NilColumnValueSelector.instance(), false){

        @Override
        public void aggregate(ByteBuffer buf, int position) {
        }
    };
    public static final Comparator<SerializablePair<Long, Long>> VALUE_COMPARATOR = SerializablePair.createNullHandlingComparator(Long::compare, true);
    private final String fieldName;
    private final String timeColumn;
    private final String name;

    @JsonCreator
    public LongFirstAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="timeColumn") @Nullable String timeColumn) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null fieldName");
        this.name = name;
        this.fieldName = fieldName;
        this.timeColumn = timeColumn == null ? "__time" : timeColumn;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (valueSelector instanceof NilColumnValueSelector) {
            return NIL_AGGREGATOR;
        }
        return new LongFirstAggregator(metricFactory.makeColumnValueSelector(this.timeColumn), valueSelector, FirstLastUtils.selectorNeedsFoldCheck(valueSelector, metricFactory.getColumnCapabilities(this.fieldName), SerializablePairLongLong.class));
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (valueSelector instanceof NilColumnValueSelector) {
            return NIL_BUFFER_AGGREGATOR;
        }
        return new LongFirstBufferAggregator(metricFactory.makeColumnValueSelector(this.timeColumn), valueSelector, FirstLastUtils.selectorNeedsFoldCheck(valueSelector, metricFactory.getColumnCapabilities(this.fieldName), SerializablePairLongLong.class));
    }

    @Override
    public VectorAggregator factorizeVector(VectorColumnSelectorFactory columnSelectorFactory) {
        VectorValueSelector timeSelector = columnSelectorFactory.makeValueSelector(this.timeColumn);
        ColumnCapabilities capabilities = columnSelectorFactory.getColumnCapabilities(this.fieldName);
        if (Types.isNumeric(capabilities)) {
            VectorValueSelector valueSelector = columnSelectorFactory.makeValueSelector(this.fieldName);
            return new LongFirstVectorAggregator(timeSelector, valueSelector);
        }
        VectorObjectSelector objectSelector = columnSelectorFactory.makeObjectSelector(this.fieldName);
        return new LongFirstVectorAggregator(timeSelector, objectSelector);
    }

    @Override
    public boolean canVectorize(ColumnInspector columnInspector) {
        return true;
    }

    @Override
    public Comparator getComparator() {
        return VALUE_COMPARATOR;
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        Long leftTime = (Long)((SerializablePair)lhs).lhs;
        Long rightTime = (Long)((SerializablePair)rhs).lhs;
        if (leftTime <= rightTime) {
            return lhs;
        }
        return rhs;
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new GenericFirstAggregateCombiner<SerializablePairLongLong>(SerializablePairLongLong.class);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new LongFirstAggregatorFactory(this.name, this.name, this.timeColumn);
    }

    @Override
    public Object deserialize(Object object) {
        Map map = (Map)object;
        if (map.get("rhs") == null) {
            return new SerializablePairLongLong(((Number)map.get("lhs")).longValue(), null);
        }
        return new SerializablePairLongLong(((Number)map.get("lhs")).longValue(), ((Number)map.get("rhs")).longValue());
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object == null ? null : (Long)((SerializablePairLongLong)object).rhs;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public String getTimeColumn() {
        return this.timeColumn;
    }

    @Override
    public List<String> requiredFields() {
        return Arrays.asList(this.timeColumn, this.fieldName);
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(23).appendString(this.fieldName).appendString(this.timeColumn).build();
    }

    @Override
    public ColumnType getIntermediateType() {
        return TYPE;
    }

    @Override
    public ColumnType getResultType() {
        return ColumnType.LONG;
    }

    @Override
    public int getMaxIntermediateSize() {
        return 17;
    }

    @Override
    public AggregatorFactory withName(String newName) {
        return new LongFirstAggregatorFactory(newName, this.getFieldName(), this.getTimeColumn());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongFirstAggregatorFactory that = (LongFirstAggregatorFactory)o;
        return this.fieldName.equals(that.fieldName) && this.timeColumn.equals(that.timeColumn) && this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.fieldName.hashCode();
        return result;
    }

    public String toString() {
        return "LongFirstAggregatorFactory{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + ", timeColumn='" + this.timeColumn + '\'' + '}';
    }
}

