/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.expression.ExprUtils;

public class RegexpReplaceExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "regexp_replace";

    @Override
    public String name() {
        return FN_NAME;
    }

    @Override
    public Expr apply(List<Expr> args) {
        this.validationHelperCheckArgumentCount(args, 3);
        if (args.stream().skip(1L).allMatch(Expr::isLiteral)) {
            return new RegexpReplaceExpr(args);
        }
        return new RegexpReplaceDynamicExpr(args);
    }

    class RegexpReplaceExpr
    extends BaseRegexpReplaceExpr {
        private final Expr arg;
        private final Pattern pattern;
        private final String replacement;

        private RegexpReplaceExpr(List<Expr> args) {
            super(args);
            Expr patternExpr = args.get(1);
            Expr replacementExpr = args.get(2);
            if (!(ExprUtils.isStringLiteral(patternExpr) || patternExpr.isLiteral() && patternExpr.getLiteralValue() == null)) {
                throw RegexpReplaceExprMacro.this.validationFailed("pattern must be a string literal", new Object[0]);
            }
            if (!(ExprUtils.isStringLiteral(replacementExpr) || replacementExpr.isLiteral() && replacementExpr.getLiteralValue() == null)) {
                throw RegexpReplaceExprMacro.this.validationFailed("replacement must be a string literal", new Object[0]);
            }
            String patternString = NullHandling.nullToEmptyIfNeeded((String)patternExpr.getLiteralValue());
            this.arg = args.get(0);
            this.pattern = patternString != null ? Pattern.compile(patternString) : null;
            this.replacement = NullHandling.nullToEmptyIfNeeded((String)replacementExpr.getLiteralValue());
        }

        @Override
        @Nonnull
        public ExprEval<?> eval(Expr.ObjectBinding bindings) {
            if (this.pattern == null || this.replacement == null) {
                return ExprEval.of(null);
            }
            String s = NullHandling.nullToEmptyIfNeeded(this.arg.eval(bindings).asString());
            if (s == null) {
                return ExprEval.of(null);
            }
            Matcher matcher = this.pattern.matcher(s);
            String retVal = matcher.replaceAll(this.replacement);
            return ExprEval.of(retVal);
        }
    }

    class RegexpReplaceDynamicExpr
    extends BaseRegexpReplaceExpr {
        private RegexpReplaceDynamicExpr(List<Expr> args) {
            super(args);
        }

        @Override
        @Nonnull
        public ExprEval<?> eval(Expr.ObjectBinding bindings) {
            String s = NullHandling.nullToEmptyIfNeeded(((Expr)this.args.get(0)).eval(bindings).asString());
            String pattern = NullHandling.nullToEmptyIfNeeded(((Expr)this.args.get(1)).eval(bindings).asString());
            String replacement = NullHandling.nullToEmptyIfNeeded(((Expr)this.args.get(2)).eval(bindings).asString());
            if (s == null || pattern == null || replacement == null) {
                return ExprEval.of(null);
            }
            Matcher matcher = Pattern.compile(pattern).matcher(s);
            String retVal = matcher.replaceAll(replacement);
            return ExprEval.of(retVal);
        }
    }

    abstract class BaseRegexpReplaceExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        public BaseRegexpReplaceExpr(List<Expr> args) {
            super(RegexpReplaceExprMacro.this, args);
        }

        @Override
        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return ExpressionType.STRING;
        }
    }
}

