/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.expression.ExprUtils;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public class TimestampExtractExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "timestamp_extract";

    @Override
    public String name() {
        return FN_NAME;
    }

    private ExprEval getExprEval(DateTime dateTime, Unit unit) {
        long epoch = dateTime.getMillis() / 1000L;
        switch (unit.ordinal()) {
            case 0: {
                return ExprEval.of(epoch);
            }
            case 1: {
                return ExprEval.of(epoch / 1000L);
            }
            case 2: {
                return ExprEval.of(dateTime.millisOfSecond().get());
            }
            case 3: {
                return ExprEval.of(dateTime.secondOfMinute().get());
            }
            case 4: {
                return ExprEval.of(dateTime.minuteOfHour().get());
            }
            case 5: {
                return ExprEval.of(dateTime.hourOfDay().get());
            }
            case 6: {
                return ExprEval.of(dateTime.dayOfMonth().get());
            }
            case 7: {
                return ExprEval.of(dateTime.dayOfWeek().get());
            }
            case 8: {
                return ExprEval.of(dateTime.dayOfWeek().get());
            }
            case 9: {
                return ExprEval.of(dateTime.dayOfYear().get());
            }
            case 10: {
                return ExprEval.of(dateTime.weekOfWeekyear().get());
            }
            case 11: {
                return ExprEval.of(dateTime.monthOfYear().get());
            }
            case 12: {
                return ExprEval.of((dateTime.monthOfYear().get() - 1) / 3 + 1);
            }
            case 13: {
                return ExprEval.of(dateTime.year().get());
            }
            case 14: {
                return ExprEval.of(dateTime.year().get());
            }
            case 15: {
                return ExprEval.of(dateTime.year().get() / 10);
            }
            case 16: {
                return ExprEval.of(Math.ceil((double)dateTime.year().get() / 100.0));
            }
            case 17: {
                return ExprEval.of(Math.ceil((double)dateTime.year().get() / 1000.0));
            }
        }
        throw this.validationFailed("unhandled unit[%s]", new Object[]{unit});
    }

    private static ExpressionType getOutputExpressionType(Unit unit) {
        switch (unit.ordinal()) {
            case 16: 
            case 17: {
                return ExpressionType.DOUBLE;
            }
        }
        return ExpressionType.LONG;
    }

    private static ISOChronology computeChronology(List<Expr> args, Expr.ObjectBinding bindings) {
        String timeZoneVal = (String)args.get(2).eval(bindings).value();
        return timeZoneVal != null ? ISOChronology.getInstance((DateTimeZone)DateTimes.inferTzFromString(timeZoneVal)) : ISOChronology.getInstanceUTC();
    }

    @Override
    public Expr apply(List<Expr> args) {
        this.validationHelperCheckArgumentRange(args, 2, 3);
        if (!args.get(1).isLiteral() || args.get(1).getLiteralValue() == null) {
            throw this.validationFailed("unit arg must be literal", new Object[0]);
        }
        Unit unit = Unit.valueOf(StringUtils.toUpperCase((String)args.get(1).getLiteralValue()));
        if (args.size() > 2) {
            if (args.get(2).isLiteral()) {
                DateTimeZone timeZone = ExprUtils.toTimeZone(args.get(2));
                ISOChronology chronology = ISOChronology.getInstance((DateTimeZone)timeZone);
                return new TimestampExtractExpr(args, unit, chronology);
            }
            return new TimestampExtractDynamicExpr(args, unit);
        }
        return new TimestampExtractExpr(args, unit, ISOChronology.getInstanceUTC());
    }

    public static enum Unit {
        EPOCH,
        MICROSECOND,
        MILLISECOND,
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        DOW,
        ISODOW,
        DOY,
        WEEK,
        MONTH,
        QUARTER,
        YEAR,
        ISOYEAR,
        DECADE,
        CENTURY,
        MILLENNIUM;

    }

    public class TimestampExtractExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private final ISOChronology chronology;
        private final Unit unit;

        private TimestampExtractExpr(List<Expr> args, Unit unit, ISOChronology chronology) {
            super(TimestampExtractExprMacro.this, args);
            this.unit = unit;
            this.chronology = chronology;
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            Object val = ((Expr)this.args.get(0)).eval(bindings).value();
            if (val == null) {
                return ExprEval.of(null);
            }
            DateTime dateTime = new DateTime(val, (Chronology)this.chronology);
            return TimestampExtractExprMacro.this.getExprEval(dateTime, this.unit);
        }

        @Override
        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return TimestampExtractExprMacro.getOutputExpressionType(this.unit);
        }
    }

    public class TimestampExtractDynamicExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private final Unit unit;

        private TimestampExtractDynamicExpr(List<Expr> args, Unit unit) {
            super(TimestampExtractExprMacro.this, args);
            this.unit = unit;
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            Object val = ((Expr)this.args.get(0)).eval(bindings).value();
            if (val == null) {
                return ExprEval.of(null);
            }
            ISOChronology chronology = TimestampExtractExprMacro.computeChronology(this.args, bindings);
            DateTime dateTime = new DateTime(val, (Chronology)chronology);
            return TimestampExtractExprMacro.this.getExprEval(dateTime, this.unit);
        }

        @Override
        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return TimestampExtractExprMacro.getOutputExpressionType(this.unit);
        }
    }
}

