/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.filter.AbstractOptimizableDimFilter;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.DruidPredicateMatch;
import org.apache.druid.query.filter.FallbackPredicate;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherColumnProcessorFactory;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.NullableTypeStrategy;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.index.AllUnknownBitmapColumnIndex;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.semantic.DruidPredicateIndexes;
import org.apache.druid.segment.index.semantic.LexicographicalRangeIndexes;
import org.apache.druid.segment.index.semantic.NumericRangeIndexes;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class RangeFilter
extends AbstractOptimizableDimFilter
implements Filter {
    private final String column;
    private final ColumnType matchValueType;
    @Nullable
    private final Object upper;
    @Nullable
    private final Object lower;
    private final ExprEval<?> upperEval;
    private final ExprEval<?> lowerEval;
    private final boolean lowerOpen;
    private final boolean upperOpen;
    @Nullable
    private final FilterTuning filterTuning;
    private final Supplier<DruidObjectPredicate<String>> stringPredicateSupplier;
    private final Supplier<DruidLongPredicate> longPredicateSupplier;
    private final Supplier<DruidFloatPredicate> floatPredicateSupplier;
    private final Supplier<DruidDoublePredicate> doublePredicateSupplier;
    private final ConcurrentHashMap<TypeSignature<ValueType>, DruidObjectPredicate<Object[]>> arrayPredicates;
    private final Supplier<DruidObjectPredicate<Object[]>> typeDetectingArrayPredicateSupplier;

    @JsonCreator
    public RangeFilter(@JsonProperty(value="column") String column, @JsonProperty(value="matchValueType") ColumnType matchValueType, @JsonProperty(value="lower") @Nullable Object lower, @JsonProperty(value="upper") @Nullable Object upper, @JsonProperty(value="lowerOpen") @Nullable Boolean lowerOpen, @JsonProperty(value="upperOpen") @Nullable Boolean upperOpen, @JsonProperty(value="filterTuning") @Nullable FilterTuning filterTuning) {
        if (column == null) {
            throw InvalidInput.exception("Invalid range filter, column cannot be null", new Object[0]);
        }
        this.column = column;
        if (matchValueType == null) {
            throw InvalidInput.exception("Invalid range filter on column [%s], matchValueType cannot be null", column);
        }
        this.matchValueType = matchValueType;
        this.upper = upper;
        this.lower = lower;
        ExpressionType matchValueExpressionType = ExpressionType.fromColumnTypeStrict(matchValueType);
        this.upperEval = ExprEval.ofType(matchValueExpressionType, upper);
        this.lowerEval = ExprEval.ofType(matchValueExpressionType, lower);
        if (this.lowerEval.value() == null && this.upperEval.value() == null) {
            throw InvalidInput.exception("Invalid range filter on column [%s], lower and upper cannot be null at the same time", column);
        }
        if (this.matchValueType.isNumeric()) {
            if (lower != null && this.lowerEval.value() == null) {
                throw InvalidInput.exception("Invalid range filter on column [%s], lower bound [%s] cannot be parsed as specified match value type [%s]", column, lower, matchValueExpressionType);
            }
            if (upper != null && this.upperEval.value() == null) {
                throw InvalidInput.exception("Invalid range filter on column [%s], upper bound [%s] cannot be parsed as specified match value type [%s]", column, upper, matchValueExpressionType);
            }
        }
        this.lowerOpen = lowerOpen != null && lowerOpen != false;
        this.upperOpen = upperOpen != null && upperOpen != false;
        this.filterTuning = filterTuning;
        this.stringPredicateSupplier = this.makeStringPredicateSupplier();
        this.longPredicateSupplier = this.makeLongPredicateSupplier();
        this.floatPredicateSupplier = this.makeFloatPredicateSupplier();
        this.doublePredicateSupplier = this.makeDoublePredicateSupplier();
        this.arrayPredicates = new ConcurrentHashMap();
        this.typeDetectingArrayPredicateSupplier = this.makeTypeDetectingArrayPredicate();
    }

    @JsonProperty
    public String getColumn() {
        return this.column;
    }

    @JsonProperty
    public ColumnType getMatchValueType() {
        return this.matchValueType;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Object getUpper() {
        return this.upper;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Object getLower() {
        return this.lower;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isLowerOpen() {
        return this.lowerOpen;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isUpperOpen() {
        return this.upperOpen;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    public FilterTuning getFilterTuning() {
        return this.filterTuning;
    }

    public boolean hasLowerBound() {
        return this.lower != null;
    }

    public boolean hasUpperBound() {
        return this.upper != null;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] upperBytes;
        byte[] lowerBytes;
        ByteBuffer valueBuffer;
        int size;
        TypeStrategy<?> typeStrategy;
        if (this.hasLowerBound()) {
            typeStrategy = this.lowerEval.type().getStrategy();
            size = typeStrategy.estimateSizeBytes(this.lowerEval.value());
            valueBuffer = ByteBuffer.allocate(size);
            typeStrategy.write(valueBuffer, this.lowerEval.value(), size);
            lowerBytes = valueBuffer.array();
        } else {
            lowerBytes = new byte[]{};
        }
        if (this.hasUpperBound()) {
            typeStrategy = this.upperEval.type().getStrategy();
            size = typeStrategy.estimateSizeBytes(this.upperEval.value());
            valueBuffer = ByteBuffer.allocate(size);
            typeStrategy.write(valueBuffer, this.upperEval.value(), size);
            upperBytes = valueBuffer.array();
        } else {
            upperBytes = new byte[]{};
        }
        byte boundType = 1;
        if (this.getLower() == null) {
            boundType = 2;
        } else if (this.getUpper() == null) {
            boundType = 3;
        }
        byte lowerStrictByte = this.isLowerOpen() ? (byte)1 : 0;
        byte upperStrictByte = this.isUpperOpen() ? (byte)1 : 0;
        return new CacheKeyBuilder(20).appendByte(boundType).appendByte((byte)-1).appendString(this.column).appendByte((byte)-1).appendString(this.matchValueType.asTypeString()).appendByte((byte)-1).appendByteArray(upperBytes).appendByte((byte)-1).appendByteArray(lowerBytes).appendByte((byte)-1).appendByte(lowerStrictByte).appendByte((byte)-1).appendByte(upperStrictByte).build();
    }

    @Override
    public Filter toFilter() {
        return this;
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        if (!Objects.equals(this.column, dimension)) {
            return null;
        }
        Supplier lowerString = () -> this.lowerEval.isArray() ? Arrays.deepToString(this.lowerEval.asArray()) : this.lowerEval.asString();
        Supplier upperString = () -> this.upperEval.isArray() ? Arrays.deepToString(this.upperEval.asArray()) : this.upperEval.asString();
        TreeRangeSet retSet = TreeRangeSet.create();
        Range range = !this.hasLowerBound() ? (this.isUpperOpen() ? Range.lessThan((Comparable)((Object)((String)upperString.get()))) : Range.atMost((Comparable)((Object)((String)upperString.get())))) : (!this.hasUpperBound() ? (this.isLowerOpen() ? Range.greaterThan((Comparable)((Object)((String)lowerString.get()))) : Range.atLeast((Comparable)((Object)((String)lowerString.get())))) : Range.range((Comparable)((Object)((String)lowerString.get())), (BoundType)(this.isLowerOpen() ? BoundType.OPEN : BoundType.CLOSED), (Comparable)((Object)((String)upperString.get())), (BoundType)(this.isUpperOpen() ? BoundType.OPEN : BoundType.CLOSED)));
        retSet.add(range);
        return retSet;
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
        DruidPredicateIndexes predicateIndexes;
        Object rangeIndexes;
        if (!Filters.checkFilterTuningUseIndex(this.column, selector, this.filterTuning)) {
            return null;
        }
        ColumnIndexSupplier indexSupplier = selector.getIndexSupplier(this.column);
        if (indexSupplier == null) {
            return new AllUnknownBitmapColumnIndex(selector);
        }
        if (this.matchValueType.is(ValueType.STRING)) {
            rangeIndexes = indexSupplier.as(LexicographicalRangeIndexes.class);
            if (rangeIndexes != null) {
                String lower = this.hasLowerBound() ? this.lowerEval.asString() : null;
                String upper = this.hasUpperBound() ? this.upperEval.asString() : null;
                return rangeIndexes.forRange(lower, this.lowerOpen, upper, this.upperOpen);
            }
        } else if (this.matchValueType.isNumeric() && (rangeIndexes = indexSupplier.as(NumericRangeIndexes.class)) != null) {
            Number lower = (Number)this.lowerEval.value();
            Number upper = (Number)this.upperEval.value();
            return rangeIndexes.forRange(lower, this.lowerOpen, upper, this.upperOpen);
        }
        if ((predicateIndexes = indexSupplier.as(DruidPredicateIndexes.class)) != null) {
            return predicateIndexes.forPredicate(this.getPredicateFactory());
        }
        return null;
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.column, this.getPredicateFactory());
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        return ColumnProcessors.makeVectorProcessor(this.column, VectorValueMatcherColumnProcessorFactory.instance(), factory).makeMatcher(this.getPredicateFactory());
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return true;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.column);
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return true;
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        String rewriteDimensionTo = columnRewrites.get(this.column);
        if (rewriteDimensionTo == null) {
            throw new IAE("Received a non-applicable rewrite: %s, filter's dimension: %s", columnRewrites, this.column);
        }
        return new RangeFilter(rewriteDimensionTo, this.matchValueType, this.lower, this.upper, this.lowerOpen, this.upperOpen, this.filterTuning);
    }

    public boolean isEquality() {
        if (!this.hasUpperBound() || !this.hasLowerBound() || this.lowerOpen || this.upperOpen) {
            return false;
        }
        if (this.matchValueType.isArray()) {
            return Arrays.deepEquals(this.lowerEval.asArray(), this.upperEval.asArray());
        }
        return Objects.equals(this.upperEval.value(), this.lowerEval.value());
    }

    public boolean equals(Object o) {
        boolean lowerSame;
        boolean upperSame;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeFilter that = (RangeFilter)o;
        if (this.matchValueType.isArray()) {
            upperSame = Arrays.deepEquals(this.upperEval.asArray(), that.upperEval.asArray());
            lowerSame = Arrays.deepEquals(this.lowerEval.asArray(), that.lowerEval.asArray());
        } else {
            upperSame = Objects.equals(this.upperEval.value(), that.upperEval.value());
            lowerSame = Objects.equals(this.lowerEval.value(), that.lowerEval.value());
        }
        return this.lowerOpen == that.lowerOpen && this.upperOpen == that.upperOpen && this.column.equals(that.column) && Objects.equals(this.matchValueType, that.matchValueType) && upperSame && lowerSame && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.column, this.matchValueType, this.upperEval.value(), this.lowerEval.value(), this.lowerOpen, this.upperOpen, this.filterTuning);
    }

    public String toString() {
        DimFilter.DimFilterToStringBuilder builder = new DimFilter.DimFilterToStringBuilder();
        if (this.lower != null) {
            if (this.matchValueType.isArray()) {
                builder.append(Arrays.deepToString(this.lowerEval.asArray()));
            } else {
                builder.append(this.lower);
            }
            if (this.lowerOpen) {
                builder.append(" < ");
            } else {
                builder.append(" <= ");
            }
        }
        builder.appendDimension(this.column, null);
        builder.append(StringUtils.format(" as %s", this.matchValueType.toString()));
        if (this.upper != null) {
            if (this.upperOpen) {
                builder.append(" < ");
            } else {
                builder.append(" <= ");
            }
            if (this.matchValueType.isArray()) {
                builder.append(Arrays.deepToString(this.upperEval.asArray()));
            } else {
                builder.append(this.upper);
            }
        }
        return builder.appendFilterTuning(this.filterTuning).build();
    }

    private DruidPredicateFactory getPredicateFactory() {
        return new RangePredicateFactory(this);
    }

    private Supplier<DruidLongPredicate> makeLongPredicateSupplier() {
        return Suppliers.memoize(() -> {
            boolean hasUpperBound;
            long upperBound;
            boolean hasLowerBound;
            long lowerBound;
            if (this.hasLowerBound()) {
                ExprEval lowerCast = this.lowerEval.castTo(ExpressionType.LONG);
                if (lowerCast.isNumericNull()) {
                    return DruidLongPredicate.ALWAYS_FALSE_WITH_NULL_UNKNOWN;
                }
                lowerBound = this.lowerOpen ? (long)Math.floor(this.lowerEval.asDouble()) : (long)Math.ceil(this.lowerEval.asDouble());
                hasLowerBound = true;
            } else {
                hasLowerBound = false;
                lowerBound = Long.MIN_VALUE;
            }
            if (this.hasUpperBound()) {
                ExprEval upperCast = this.upperEval.castTo(ExpressionType.LONG);
                if (upperCast.isNumericNull()) {
                    return DruidLongPredicate.ALWAYS_FALSE_WITH_NULL_UNKNOWN;
                }
                upperBound = this.upperOpen ? (long)Math.ceil(this.upperEval.asDouble()) : (long)Math.floor(this.upperEval.asDouble());
                hasUpperBound = true;
            } else {
                hasUpperBound = false;
                upperBound = Long.MAX_VALUE;
            }
            RangeType rangeType = RangeType.of(hasLowerBound, this.lowerOpen, hasUpperBound, this.upperOpen);
            return RangeFilter.makeLongPredicate(rangeType, lowerBound, upperBound);
        });
    }

    private Supplier<DruidFloatPredicate> makeFloatPredicateSupplier() {
        return Suppliers.memoize(() -> {
            DruidDoublePredicate doublePredicate = (DruidDoublePredicate)this.makeDoublePredicateSupplier().get();
            return doublePredicate::applyDouble;
        });
    }

    private Supplier<DruidDoublePredicate> makeDoublePredicateSupplier() {
        return Suppliers.memoize(() -> {
            double upperBound;
            boolean hasUpperBound;
            boolean hasLowerBound;
            double lowerBound;
            if (this.hasLowerBound()) {
                ExprEval lowerCast = this.lowerEval.castTo(ExpressionType.DOUBLE);
                if (lowerCast.isNumericNull()) {
                    return DruidDoublePredicate.ALWAYS_FALSE_WITH_NULL_UNKNOWN;
                }
                lowerBound = lowerCast.asDouble();
                hasLowerBound = true;
            } else {
                hasLowerBound = false;
                lowerBound = Double.NEGATIVE_INFINITY;
            }
            if (this.hasUpperBound()) {
                ExprEval upperCast = this.upperEval.castTo(ExpressionType.DOUBLE);
                if (upperCast.isNumericNull()) {
                    return DruidDoublePredicate.ALWAYS_FALSE_WITH_NULL_UNKNOWN;
                }
                hasUpperBound = true;
                upperBound = upperCast.asDouble();
            } else {
                hasUpperBound = false;
                upperBound = Double.POSITIVE_INFINITY;
            }
            RangeType rangeType = RangeType.of(hasLowerBound, this.lowerOpen, hasUpperBound, this.upperOpen);
            return RangeFilter.makeDoublePredicate(rangeType, lowerBound, upperBound);
        });
    }

    private Supplier<DruidObjectPredicate<String>> makeStringPredicateSupplier() {
        return Suppliers.memoize(() -> {
            StringComparator stringComparator = this.matchValueType.isNumeric() ? StringComparators.NUMERIC : StringComparators.LEXICOGRAPHIC;
            String lowerBound = this.hasLowerBound() ? this.lowerEval.castTo(ExpressionType.STRING).asString() : null;
            String upperBound = this.hasUpperBound() ? this.upperEval.castTo(ExpressionType.STRING).asString() : null;
            RangeType rangeType = RangeType.of(this.hasLowerBound(), this.lowerOpen, this.hasUpperBound(), this.upperOpen);
            return RangeFilter.makeComparatorPredicate(rangeType, stringComparator, lowerBound, upperBound);
        });
    }

    private DruidObjectPredicate<Object[]> makeArrayPredicate(TypeSignature<ValueType> inputType) {
        Comparator arrayComparator = inputType.getElementType().is(ValueType.STRING) && Types.isNumericOrNumericArray(this.matchValueType) ? new NumericStringArrayComparator() : inputType.getNullableStrategy();
        ExpressionType expressionType = ExpressionType.fromColumnTypeStrict(inputType);
        RangeType rangeType = RangeType.of(this.hasLowerBound(), this.lowerOpen, this.hasUpperBound(), this.upperOpen);
        Object[] lowerBound = this.hasLowerBound() ? (this.lowerOpen ? this.lowerEval.castTo(expressionType).asArray() : RangeFilter.castArrayForComparisonWithCeilIfNeeded(this.lowerEval, expressionType)) : null;
        Object[] upperBound = this.hasUpperBound() ? (this.upperOpen ? RangeFilter.castArrayForComparisonWithCeilIfNeeded(this.upperEval, expressionType) : this.upperEval.castTo(expressionType).asArray()) : null;
        return RangeFilter.makeComparatorPredicate(rangeType, arrayComparator, lowerBound, upperBound);
    }

    private Supplier<DruidObjectPredicate<Object[]>> makeTypeDetectingArrayPredicate() {
        return Suppliers.memoize(() -> {
            RangeType rangeType = RangeType.of(this.hasLowerBound(), this.lowerOpen, this.hasUpperBound(), this.upperOpen);
            switch (rangeType.ordinal()) {
                case 0: {
                    return input -> {
                        if (input == null) {
                            return DruidPredicateMatch.UNKNOWN;
                        }
                        ExprEval val = ExprEval.bestEffortOf(input);
                        Object[] lowerBound = this.lowerEval.castTo(val.type()).asArray();
                        Object[] upperBound = RangeFilter.castArrayForComparisonWithCeilIfNeeded(this.upperEval, val.asArrayType());
                        NullableTypeStrategy<Object[]> comparator = val.type().getNullableStrategy();
                        int lowerComparing = comparator.compare(val.asArray(), lowerBound);
                        int upperComparing = comparator.compare(upperBound, val.asArray());
                        return DruidPredicateMatch.of(lowerComparing > 0 && upperComparing > 0);
                    };
                }
                case 3: {
                    return input -> {
                        if (input == null) {
                            return DruidPredicateMatch.UNKNOWN;
                        }
                        ExprEval val = ExprEval.bestEffortOf(input);
                        Object[] lowerBound = this.lowerEval.castTo(val.type()).asArray();
                        Object[] upperBound = this.upperEval.castTo(val.type()).asArray();
                        NullableTypeStrategy<Object[]> arrayComparator = val.type().getNullableStrategy();
                        int lowerComparing = arrayComparator.compare(val.asArray(), lowerBound);
                        int upperComparing = arrayComparator.compare(upperBound, val.asArray());
                        return DruidPredicateMatch.of(lowerComparing > 0 && upperComparing >= 0);
                    };
                }
                case 2: {
                    return input -> {
                        if (input == null) {
                            return DruidPredicateMatch.UNKNOWN;
                        }
                        ExprEval val = ExprEval.bestEffortOf(input);
                        Object[] lowerBound = RangeFilter.castArrayForComparisonWithCeilIfNeeded(this.lowerEval, val.asArrayType());
                        Object[] upperBound = RangeFilter.castArrayForComparisonWithCeilIfNeeded(this.upperEval, val.asArrayType());
                        NullableTypeStrategy<Object[]> arrayComparator = val.type().getNullableStrategy();
                        int lowerComparing = arrayComparator.compare(val.asArray(), lowerBound);
                        int upperComparing = arrayComparator.compare(upperBound, val.asArray());
                        return DruidPredicateMatch.of(lowerComparing >= 0 && upperComparing > 0);
                    };
                }
                case 1: {
                    return input -> {
                        if (input == null) {
                            return DruidPredicateMatch.UNKNOWN;
                        }
                        ExprEval val = ExprEval.bestEffortOf(input);
                        Object[] lowerBound = RangeFilter.castArrayForComparisonWithCeilIfNeeded(this.lowerEval, val.asArrayType());
                        Object[] upperBound = this.upperEval.castTo(val.type()).asArray();
                        NullableTypeStrategy<Object[]> arrayComparator = val.type().getNullableStrategy();
                        int lowerComparing = arrayComparator.compare(val.asArray(), lowerBound);
                        int upperComparing = arrayComparator.compare(upperBound, val.asArray());
                        return DruidPredicateMatch.of(lowerComparing >= 0 && upperComparing >= 0);
                    };
                }
                case 6: {
                    return input -> {
                        if (input == null) {
                            return DruidPredicateMatch.UNKNOWN;
                        }
                        ExprEval val = ExprEval.bestEffortOf(input);
                        Object[] upperBound = RangeFilter.castArrayForComparisonWithCeilIfNeeded(this.upperEval, val.asArrayType());
                        NullableTypeStrategy<Object[]> arrayComparator = val.type().getNullableStrategy();
                        int upperComparing = arrayComparator.compare(upperBound, val.asArray());
                        return DruidPredicateMatch.of(upperComparing > 0);
                    };
                }
                case 7: {
                    return input -> {
                        if (input == null) {
                            return DruidPredicateMatch.UNKNOWN;
                        }
                        ExprEval val = ExprEval.bestEffortOf(input);
                        Object[] upperBound = this.upperEval.castTo(val.type()).asArray();
                        NullableTypeStrategy<Object[]> arrayComparator = val.type().getNullableStrategy();
                        int upperComparing = arrayComparator.compare(upperBound, val.asArray());
                        return DruidPredicateMatch.of(upperComparing >= 0);
                    };
                }
                case 4: {
                    return input -> {
                        if (input == null) {
                            return DruidPredicateMatch.UNKNOWN;
                        }
                        ExprEval val = ExprEval.bestEffortOf(input);
                        Object[] lowerBound = this.lowerEval.castTo(val.type()).asArray();
                        NullableTypeStrategy<Object[]> arrayComparator = val.type().getNullableStrategy();
                        int lowerComparing = arrayComparator.compare(lowerBound, val.asArray());
                        return DruidPredicateMatch.of(lowerComparing > 0);
                    };
                }
                case 5: {
                    return input -> {
                        if (input == null) {
                            return DruidPredicateMatch.UNKNOWN;
                        }
                        ExprEval val = ExprEval.bestEffortOf(input);
                        Object[] lowerBound = RangeFilter.castArrayForComparisonWithCeilIfNeeded(this.lowerEval, val.asArrayType());
                        NullableTypeStrategy<Object[]> arrayComparator = val.type().getNullableStrategy();
                        int lowerComparing = arrayComparator.compare(lowerBound, val.asArray());
                        return DruidPredicateMatch.of(lowerComparing >= 0);
                    };
                }
            }
            return DruidObjectPredicate.notNull();
        });
    }

    private static Object[] castArrayForComparisonWithCeilIfNeeded(ExprEval<?> valueToCast, ExpressionType typeToCastTo) {
        if (ExpressionType.LONG_ARRAY.equals(typeToCastTo)) {
            ExprEval doubleArray = valueToCast.castTo(ExpressionType.DOUBLE_ARRAY);
            Object[] o = doubleArray.asArray();
            Object[] ceilArray = new Object[o.length];
            for (int i = 0; i < o.length; ++i) {
                ceilArray[i] = o[i] == null ? null : Long.valueOf((long)Math.ceil((Double)o[i]));
            }
            return ceilArray;
        }
        return valueToCast.castTo(typeToCastTo).asArray();
    }

    public static DruidLongPredicate makeLongPredicate(RangeType rangeType, long lowerLongBound, long upperLongBound) {
        switch (rangeType.ordinal()) {
            case 0: {
                return input -> DruidPredicateMatch.of(input > lowerLongBound && input < upperLongBound);
            }
            case 3: {
                return input -> DruidPredicateMatch.of(input > lowerLongBound && input <= upperLongBound);
            }
            case 2: {
                return input -> DruidPredicateMatch.of(input >= lowerLongBound && input < upperLongBound);
            }
            case 1: {
                return input -> DruidPredicateMatch.of(input >= lowerLongBound && input <= upperLongBound);
            }
            case 6: {
                return input -> DruidPredicateMatch.of(input < upperLongBound);
            }
            case 7: {
                return input -> DruidPredicateMatch.of(input <= upperLongBound);
            }
            case 4: {
                return input -> DruidPredicateMatch.of(input > lowerLongBound);
            }
            case 5: {
                return input -> DruidPredicateMatch.of(input >= lowerLongBound);
            }
        }
        return DruidLongPredicate.ALWAYS_TRUE;
    }

    public static DruidDoublePredicate makeDoublePredicate(RangeType rangeType, double lowerDoubleBound, double upperDoubleBound) {
        switch (rangeType.ordinal()) {
            case 0: {
                return input -> {
                    int lowerComparing = Double.compare(input, lowerDoubleBound);
                    int upperComparing = Double.compare(upperDoubleBound, input);
                    return DruidPredicateMatch.of(lowerComparing > 0 && upperComparing > 0);
                };
            }
            case 3: {
                return input -> {
                    int lowerComparing = Double.compare(input, lowerDoubleBound);
                    int upperComparing = Double.compare(upperDoubleBound, input);
                    return DruidPredicateMatch.of(lowerComparing > 0 && upperComparing >= 0);
                };
            }
            case 2: {
                return input -> {
                    int lowerComparing = Double.compare(input, lowerDoubleBound);
                    int upperComparing = Double.compare(upperDoubleBound, input);
                    return DruidPredicateMatch.of(lowerComparing >= 0 && upperComparing > 0);
                };
            }
            case 1: {
                return input -> {
                    int lowerComparing = Double.compare(input, lowerDoubleBound);
                    int upperComparing = Double.compare(upperDoubleBound, input);
                    return DruidPredicateMatch.of(lowerComparing >= 0 && upperComparing >= 0);
                };
            }
            case 6: {
                return input -> {
                    int upperComparing = Double.compare(upperDoubleBound, input);
                    return DruidPredicateMatch.of(upperComparing > 0);
                };
            }
            case 7: {
                return input -> {
                    int upperComparing = Double.compare(upperDoubleBound, input);
                    return DruidPredicateMatch.of(upperComparing >= 0);
                };
            }
            case 4: {
                return input -> {
                    int lowerComparing = Double.compare(input, lowerDoubleBound);
                    return DruidPredicateMatch.of(lowerComparing > 0);
                };
            }
            case 5: {
                return input -> {
                    int lowerComparing = Double.compare(input, lowerDoubleBound);
                    return DruidPredicateMatch.of(lowerComparing >= 0);
                };
            }
        }
        return DruidDoublePredicate.ALWAYS_TRUE;
    }

    public static <T> DruidObjectPredicate<T> makeComparatorPredicate(RangeType rangeType, Comparator<T> comparator, @Nullable T lowerBound, @Nullable T upperBound) {
        switch (rangeType.ordinal()) {
            case 0: {
                return input -> {
                    if (input == null) {
                        return DruidPredicateMatch.UNKNOWN;
                    }
                    int lowerComparing = comparator.compare(input, lowerBound);
                    int upperComparing = comparator.compare(upperBound, input);
                    return DruidPredicateMatch.of(lowerComparing > 0 && upperComparing > 0);
                };
            }
            case 3: {
                return input -> {
                    if (input == null) {
                        return DruidPredicateMatch.UNKNOWN;
                    }
                    int lowerComparing = comparator.compare(input, lowerBound);
                    int upperComparing = comparator.compare(upperBound, input);
                    return DruidPredicateMatch.of(lowerComparing > 0 && upperComparing >= 0);
                };
            }
            case 2: {
                return input -> {
                    if (input == null) {
                        return DruidPredicateMatch.UNKNOWN;
                    }
                    int lowerComparing = comparator.compare(input, lowerBound);
                    int upperComparing = comparator.compare(upperBound, input);
                    return DruidPredicateMatch.of(lowerComparing >= 0 && upperComparing > 0);
                };
            }
            case 1: {
                return input -> {
                    if (input == null) {
                        return DruidPredicateMatch.UNKNOWN;
                    }
                    int lowerComparing = comparator.compare(input, lowerBound);
                    int upperComparing = comparator.compare(upperBound, input);
                    return DruidPredicateMatch.of(lowerComparing >= 0 && upperComparing >= 0);
                };
            }
            case 6: {
                return input -> {
                    if (input == null) {
                        return DruidPredicateMatch.UNKNOWN;
                    }
                    int upperComparing = comparator.compare(upperBound, input);
                    return DruidPredicateMatch.of(upperComparing > 0);
                };
            }
            case 7: {
                return input -> {
                    if (input == null) {
                        return DruidPredicateMatch.UNKNOWN;
                    }
                    int upperComparing = comparator.compare(upperBound, input);
                    return DruidPredicateMatch.of(upperComparing >= 0);
                };
            }
            case 4: {
                return input -> {
                    if (input == null) {
                        return DruidPredicateMatch.UNKNOWN;
                    }
                    int lowerComparing = comparator.compare(input, lowerBound);
                    return DruidPredicateMatch.of(lowerComparing > 0);
                };
            }
            case 5: {
                return input -> {
                    if (input == null) {
                        return DruidPredicateMatch.UNKNOWN;
                    }
                    int lowerComparing = comparator.compare(input, lowerBound);
                    return DruidPredicateMatch.of(lowerComparing >= 0);
                };
            }
        }
        return DruidObjectPredicate.notNull();
    }

    private class RangePredicateFactory
    implements DruidPredicateFactory {
        private final RangeFilter rangeFilter;

        private RangePredicateFactory(RangeFilter rangeFilter2) {
            this.rangeFilter = rangeFilter2;
        }

        @Override
        public DruidObjectPredicate<String> makeStringPredicate() {
            return new FallbackPredicate<String>((DruidObjectPredicate)RangeFilter.this.stringPredicateSupplier.get(), ExpressionType.STRING);
        }

        @Override
        public DruidLongPredicate makeLongPredicate() {
            if (RangeFilter.this.matchValueType.isNumeric()) {
                return (DruidLongPredicate)RangeFilter.this.longPredicateSupplier.get();
            }
            DruidObjectPredicate<String> stringPredicate = this.makeStringPredicate();
            return input -> stringPredicate.apply(Evals.asString(input));
        }

        @Override
        public DruidFloatPredicate makeFloatPredicate() {
            if (RangeFilter.this.matchValueType.isNumeric()) {
                return (DruidFloatPredicate)RangeFilter.this.floatPredicateSupplier.get();
            }
            DruidObjectPredicate<String> stringPredicate = this.makeStringPredicate();
            return input -> stringPredicate.apply(Evals.asString(Float.valueOf(input)));
        }

        @Override
        public DruidDoublePredicate makeDoublePredicate() {
            if (RangeFilter.this.matchValueType.isNumeric()) {
                return (DruidDoublePredicate)RangeFilter.this.doublePredicateSupplier.get();
            }
            DruidObjectPredicate<String> stringPredicate = this.makeStringPredicate();
            return input -> stringPredicate.apply(Evals.asString(input));
        }

        @Override
        public DruidObjectPredicate<Object[]> makeArrayPredicate(@Nullable TypeSignature<ValueType> inputType) {
            if (inputType == null) {
                return (DruidObjectPredicate)RangeFilter.this.typeDetectingArrayPredicateSupplier.get();
            }
            return new FallbackPredicate<Object[]>(RangeFilter.this.arrayPredicates.computeIfAbsent(inputType, existing -> RangeFilter.this.makeArrayPredicate(inputType)), ExpressionType.fromColumnTypeStrict(inputType));
        }

        public int hashCode() {
            return this.rangeFilter.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RangePredicateFactory that = (RangePredicateFactory)o;
            return Objects.equals(this.rangeFilter, that.rangeFilter);
        }

        public String toString() {
            return "RangePredicateFactory{rangeFilter=" + this.rangeFilter + '}';
        }
    }

    private static class NumericStringArrayComparator
    implements Comparator<Object[]> {
        private NumericStringArrayComparator() {
        }

        @Override
        public int compare(Object[] o1, Object[] o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int iter = Math.min(o1.length, o2.length);
            for (int i = 0; i < iter; ++i) {
                int cmp = StringComparators.NUMERIC.compare((String)o1[i], (String)o2[i]);
                if (cmp == 0) continue;
                return cmp;
            }
            return Integer.compare(o1.length, o2.length);
        }
    }

    public static enum RangeType {
        OPEN,
        CLOSED,
        LOWER_CLOSED_UPPER_OPEN,
        LOWER_OPEN_UPPER_CLOSED,
        LOWER_OPEN_UPPER_UNBOUNDED,
        LOWER_CLOSED_UPPER_UNBOUNDED,
        LOWER_UNBOUNDED_UPPER_OPEN,
        LOWER_UNBOUNDED_UPPER_CLOSED,
        UNBOUNDED;


        public static RangeType of(boolean hasLower, boolean lowerOpen, boolean hasUpper, boolean upperOpen) {
            if (hasLower && hasUpper) {
                if (lowerOpen) {
                    return upperOpen ? OPEN : LOWER_OPEN_UPPER_CLOSED;
                }
                return upperOpen ? LOWER_CLOSED_UPPER_OPEN : CLOSED;
            }
            if (hasLower) {
                return lowerOpen ? LOWER_OPEN_UPPER_UNBOUNDED : LOWER_CLOSED_UPPER_UNBOUNDED;
            }
            if (hasUpper) {
                return upperOpen ? LOWER_UNBOUNDED_UPPER_OPEN : LOWER_UNBOUNDED_UPPER_CLOSED;
            }
            return UNBOUNDED;
        }
    }
}

