/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.utils.CollectionUtils;
import org.joda.time.Interval;

public class CursorBuildSpec {
    public static final CursorBuildSpec FULL_SCAN = CursorBuildSpec.builder().build();
    @Nullable
    private final Filter filter;
    private final Interval interval;
    @Nullable
    private final List<String> groupingColumns;
    private final VirtualColumns virtualColumns;
    @Nullable
    private final List<AggregatorFactory> aggregators;
    private final List<OrderBy> preferredOrdering;
    private final QueryContext queryContext;
    private final boolean isAggregate;
    @Nullable
    private final QueryMetrics<?> queryMetrics;

    public static CursorBuildSpecBuilder builder() {
        return new CursorBuildSpecBuilder();
    }

    public static CursorBuildSpecBuilder builder(CursorBuildSpec spec) {
        return new CursorBuildSpecBuilder(spec);
    }

    public CursorBuildSpec(@Nullable Filter filter, Interval interval, @Nullable List<String> groupingColumns, VirtualColumns virtualColumns, @Nullable List<AggregatorFactory> aggregators, List<OrderBy> preferredOrdering, QueryContext queryContext, @Nullable QueryMetrics<?> queryMetrics) {
        this.filter = filter;
        this.interval = (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval");
        this.groupingColumns = groupingColumns;
        this.virtualColumns = (VirtualColumns)Preconditions.checkNotNull((Object)virtualColumns, (Object)"virtualColumns");
        this.aggregators = aggregators;
        this.preferredOrdering = (List)Preconditions.checkNotNull(preferredOrdering, (Object)"preferredOrdering");
        this.queryContext = (QueryContext)Preconditions.checkNotNull((Object)queryContext, (Object)"queryContext");
        this.queryMetrics = queryMetrics;
        this.isAggregate = !CollectionUtils.isNullOrEmpty(groupingColumns) || !CollectionUtils.isNullOrEmpty(aggregators);
    }

    @Nullable
    public Filter getFilter() {
        return this.filter;
    }

    public Interval getInterval() {
        return this.interval;
    }

    @Nullable
    public List<String> getGroupingColumns() {
        return this.groupingColumns;
    }

    public VirtualColumns getVirtualColumns() {
        return this.virtualColumns;
    }

    @Nullable
    public List<AggregatorFactory> getAggregators() {
        return this.aggregators;
    }

    public List<OrderBy> getPreferredOrdering() {
        return this.preferredOrdering;
    }

    public QueryContext getQueryContext() {
        return this.queryContext;
    }

    @Nullable
    public QueryMetrics<?> getQueryMetrics() {
        return this.queryMetrics;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public boolean isCompatibleOrdering(List<OrderBy> ordering) {
        if (this.preferredOrdering.isEmpty()) {
            return true;
        }
        if (ordering.size() < this.preferredOrdering.size()) {
            return false;
        }
        for (int i = 0; i < this.preferredOrdering.size(); ++i) {
            if (ordering.get(i).equals(this.preferredOrdering.get(i))) continue;
            return false;
        }
        return true;
    }

    public static class CursorBuildSpecBuilder {
        @Nullable
        private Filter filter;
        private Interval interval = Intervals.ETERNITY;
        @Nullable
        private List<String> groupingColumns;
        private VirtualColumns virtualColumns = VirtualColumns.EMPTY;
        @Nullable
        private List<AggregatorFactory> aggregators;
        private List<OrderBy> preferredOrdering = Collections.emptyList();
        private QueryContext queryContext = QueryContext.empty();
        @Nullable
        private QueryMetrics<?> queryMetrics;

        private CursorBuildSpecBuilder() {
        }

        private CursorBuildSpecBuilder(CursorBuildSpec buildSpec) {
            this.filter = buildSpec.filter;
            this.interval = buildSpec.interval;
            this.groupingColumns = buildSpec.groupingColumns;
            this.virtualColumns = buildSpec.virtualColumns;
            this.aggregators = buildSpec.aggregators;
            this.preferredOrdering = buildSpec.preferredOrdering;
            this.queryContext = buildSpec.queryContext;
            this.queryMetrics = buildSpec.queryMetrics;
        }

        public CursorBuildSpecBuilder setFilter(@Nullable Filter filter) {
            this.filter = filter;
            return this;
        }

        public CursorBuildSpecBuilder setInterval(Interval interval) {
            this.interval = interval;
            return this;
        }

        public CursorBuildSpecBuilder setGroupingColumns(@Nullable List<String> groupingColumns) {
            this.groupingColumns = groupingColumns;
            return this;
        }

        public CursorBuildSpecBuilder setVirtualColumns(VirtualColumns virtualColumns) {
            this.virtualColumns = virtualColumns;
            return this;
        }

        public CursorBuildSpecBuilder setAggregators(@Nullable List<AggregatorFactory> aggregators) {
            this.aggregators = aggregators;
            return this;
        }

        public CursorBuildSpecBuilder setPreferredOrdering(List<OrderBy> preferredOrdering) {
            this.preferredOrdering = preferredOrdering;
            return this;
        }

        public CursorBuildSpecBuilder setQueryContext(QueryContext queryContext) {
            this.queryContext = queryContext;
            return this;
        }

        public CursorBuildSpecBuilder setQueryMetrics(@Nullable QueryMetrics<?> queryMetrics) {
            this.queryMetrics = queryMetrics;
            return this;
        }

        public CursorBuildSpec build() {
            return new CursorBuildSpec(this.filter, this.interval, this.groupingColumns, this.virtualColumns, this.aggregators, this.preferredOrdering, this.queryContext, this.queryMetrics);
        }
    }
}

