/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.annotations.SuppressFBWarnings;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.IntListUtils;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ColumnarLongs;
import org.apache.druid.segment.data.CompressedColumnarLongsSupplier;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.VByte;
import org.apache.druid.segment.index.AllFalseBitmapColumnIndex;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.DictionaryRangeScanningBitmapIndex;
import org.apache.druid.segment.index.DictionaryScanningBitmapIndex;
import org.apache.druid.segment.index.SimpleBitmapColumnIndex;
import org.apache.druid.segment.index.SimpleImmutableBitmapDelegatingIterableIndex;
import org.apache.druid.segment.index.SimpleImmutableBitmapIndex;
import org.apache.druid.segment.index.semantic.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.index.semantic.DictionaryEncodedValueIndex;
import org.apache.druid.segment.index.semantic.DruidPredicateIndexes;
import org.apache.druid.segment.index.semantic.NullValueIndex;
import org.apache.druid.segment.index.semantic.NumericRangeIndexes;
import org.apache.druid.segment.index.semantic.StringValueSetIndexes;
import org.apache.druid.segment.index.semantic.ValueIndexes;
import org.apache.druid.segment.index.semantic.ValueSetIndexes;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.nested.ScalarLongColumn;
import org.apache.druid.segment.serde.NestedCommonFormatColumnPartSerde;

public class ScalarLongColumnAndIndexSupplier
implements Supplier<NestedCommonFormatColumn>,
ColumnIndexSupplier {
    private final Supplier<FixedIndexed<Long>> longDictionarySupplier;
    private final Supplier<ColumnarLongs> valueColumnSupplier;
    private final GenericIndexed<ImmutableBitmap> valueIndexes;
    private final BitmapFactory bitmapFactory;
    private final ImmutableBitmap nullValueBitmap;
    private final ColumnConfig columnConfig;

    public static ScalarLongColumnAndIndexSupplier read(ByteOrder byteOrder, BitmapSerdeFactory bitmapSerdeFactory, ByteBuffer bb, ColumnBuilder columnBuilder, ColumnConfig columnConfig, @Nullable ScalarLongColumnAndIndexSupplier parent) {
        byte version = bb.get();
        int columnNameLength = VByte.readInt(bb);
        String columnName = StringUtils.fromUtf8(bb, columnNameLength);
        if (version == 0) {
            try {
                Object longDictionarySupplier;
                SmooshedFileMapper mapper = columnBuilder.getFileMapper();
                ByteBuffer longsValueColumn = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__longColumn");
                ByteBuffer valueIndexBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__valueIndexes");
                GenericIndexed<ImmutableBitmap> rBitmaps = GenericIndexed.read(valueIndexBuffer, bitmapSerdeFactory.getObjectStrategy(), columnBuilder.getFileMapper());
                if (parent != null) {
                    longDictionarySupplier = parent.longDictionarySupplier;
                } else {
                    ByteBuffer longDictionaryBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__longDictionary");
                    longDictionarySupplier = FixedIndexed.read(longDictionaryBuffer, ColumnType.LONG.getStrategy(), byteOrder, 8);
                }
                CompressedColumnarLongsSupplier longs = CompressedColumnarLongsSupplier.fromByteBuffer(longsValueColumn, byteOrder);
                return new ScalarLongColumnAndIndexSupplier((Supplier<FixedIndexed<Long>>)longDictionarySupplier, longs, rBitmaps, bitmapSerdeFactory.getBitmapFactory(), columnConfig);
            }
            catch (IOException ex) {
                throw new RE(ex, "Failed to deserialize V%s column.", version);
            }
        }
        throw new RE("Unknown version " + version, new Object[0]);
    }

    private ScalarLongColumnAndIndexSupplier(Supplier<FixedIndexed<Long>> longDictionarySupplier, Supplier<ColumnarLongs> valueColumnSupplier, GenericIndexed<ImmutableBitmap> valueIndexes, BitmapFactory bitmapFactory, ColumnConfig columnConfig) {
        this.longDictionarySupplier = longDictionarySupplier;
        this.valueColumnSupplier = valueColumnSupplier;
        this.valueIndexes = valueIndexes;
        this.bitmapFactory = bitmapFactory;
        this.nullValueBitmap = valueIndexes.get(0) == null ? bitmapFactory.makeEmptyImmutableBitmap() : (ImmutableBitmap)valueIndexes.get(0);
        this.columnConfig = columnConfig;
    }

    public NestedCommonFormatColumn get() {
        return new ScalarLongColumn((FixedIndexed)this.longDictionarySupplier.get(), (ColumnarLongs)this.valueColumnSupplier.get(), this.nullValueBitmap);
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        if (clazz.equals(NullValueIndex.class)) {
            SimpleImmutableBitmapIndex nullIndex = NullHandling.replaceWithDefault() ? new SimpleImmutableBitmapIndex(this.bitmapFactory.makeEmptyImmutableBitmap()) : new SimpleImmutableBitmapIndex(this.nullValueBitmap);
            return (T)((NullValueIndex)() -> nullIndex);
        }
        if (clazz.equals(ValueIndexes.class)) {
            return (T)new LongValueIndexes();
        }
        if (clazz.equals(ValueSetIndexes.class)) {
            return (T)new LongValueSetIndexes();
        }
        if (clazz.equals(StringValueSetIndexes.class)) {
            return (T)new LongStringValueSetIndexes();
        }
        if (clazz.equals(NumericRangeIndexes.class)) {
            return (T)new LongNumericRangeIndex();
        }
        if (clazz.equals(DruidPredicateIndexes.class)) {
            return (T)new LongPredicateIndexes();
        }
        if (clazz.equals(DictionaryEncodedStringValueIndex.class) || clazz.equals(DictionaryEncodedValueIndex.class)) {
            return (T)new LongDictionaryEncodedValueSetIndex();
        }
        return null;
    }

    private ImmutableBitmap getBitmap(int idx) {
        if (idx < 0) {
            return this.bitmapFactory.makeEmptyImmutableBitmap();
        }
        ImmutableBitmap bitmap = (ImmutableBitmap)this.valueIndexes.get(idx);
        return bitmap == null ? this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
    }

    private class LongValueIndexes
    implements ValueIndexes {
        private LongValueIndexes() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forValue(@Nonnull Object value, TypeSignature<ValueType> valueType) {
            ExprEval eval = ExprEval.ofType(ExpressionType.fromColumnTypeStrict(valueType), value);
            ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(eval, ExpressionType.LONG);
            if (castForComparison == null) {
                return new AllFalseBitmapColumnIndex(ScalarLongColumnAndIndexSupplier.this.bitmapFactory, ScalarLongColumnAndIndexSupplier.this.nullValueBitmap);
            }
            final long longValue = castForComparison.asLong();
            return new SimpleBitmapColumnIndex(){
                final FixedIndexed<Long> dictionary;
                {
                    this.dictionary = (FixedIndexed)ScalarLongColumnAndIndexSupplier.this.longDictionarySupplier.get();
                }

                @Override
                public int estimatedComputeCost() {
                    return 1;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                    int id = this.dictionary.indexOf(longValue);
                    if (includeUnknown) {
                        if (id < 0) {
                            return bitmapResultFactory.wrapDimensionValue(ScalarLongColumnAndIndexSupplier.this.nullValueBitmap);
                        }
                        return bitmapResultFactory.unionDimensionValueBitmaps((Iterable<ImmutableBitmap>)ImmutableList.of((Object)ScalarLongColumnAndIndexSupplier.this.getBitmap(id), (Object)ScalarLongColumnAndIndexSupplier.this.nullValueBitmap));
                    }
                    if (id < 0) {
                        return bitmapResultFactory.wrapDimensionValue(ScalarLongColumnAndIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    return bitmapResultFactory.wrapDimensionValue(ScalarLongColumnAndIndexSupplier.this.getBitmap(id));
                }
            };
        }
    }

    private final class LongValueSetIndexes
    implements ValueSetIndexes {
        final FixedIndexed<Long> dictionary;

        private LongValueSetIndexes() {
            this.dictionary = (FixedIndexed)ScalarLongColumnAndIndexSupplier.this.longDictionarySupplier.get();
        }

        @Override
        @Nullable
        public BitmapColumnIndex forSortedValues(@Nonnull List<?> sortedValues, TypeSignature<ValueType> matchValueType) {
            if (sortedValues.isEmpty()) {
                return new AllFalseBitmapColumnIndex(ScalarLongColumnAndIndexSupplier.this.bitmapFactory);
            }
            boolean matchNull = sortedValues.get(0) == null;
            Supplier unknownsIndex = () -> {
                if (!matchNull && this.dictionary.get(0) == null) {
                    return (ImmutableBitmap)ScalarLongColumnAndIndexSupplier.this.valueIndexes.get(0);
                }
                return null;
            };
            if (matchValueType.is(ValueType.LONG)) {
                List<?> tailSet;
                List<?> baseSet = sortedValues;
                if (sortedValues.size() >= 8) {
                    long minValueInColumn = this.dictionary.get(0) == null ? this.dictionary.get(1) : this.dictionary.get(0);
                    int position = Collections.binarySearch(sortedValues, minValueInColumn, matchValueType.getNullableStrategy());
                    tailSet = baseSet.subList(position >= 0 ? position : -(position + 1), baseSet.size());
                } else {
                    tailSet = baseSet;
                }
                if ((double)tailSet.size() > 0.12 * (double)this.dictionary.size()) {
                    return ValueSetIndexes.buildBitmapColumnIndexFromSortedIteratorScan(ScalarLongColumnAndIndexSupplier.this.bitmapFactory, ColumnType.LONG.getNullableStrategy(), tailSet, tailSet.size(), this.dictionary, ScalarLongColumnAndIndexSupplier.this.valueIndexes, (Supplier<ImmutableBitmap>)unknownsIndex);
                }
                return ValueSetIndexes.buildBitmapColumnIndexFromSortedIteratorBinarySearch(ScalarLongColumnAndIndexSupplier.this.bitmapFactory, tailSet, tailSet.size(), this.dictionary, ScalarLongColumnAndIndexSupplier.this.valueIndexes, (Supplier<ImmutableBitmap>)unknownsIndex);
            }
            return ValueSetIndexes.buildBitmapColumnIndexFromIteratorBinarySearch(ScalarLongColumnAndIndexSupplier.this.bitmapFactory, Iterables.transform(sortedValues, DimensionHandlerUtils::convertObjectToLong), sortedValues.size(), this.dictionary, ScalarLongColumnAndIndexSupplier.this.valueIndexes, (Supplier<ImmutableBitmap>)unknownsIndex);
        }
    }

    private class LongStringValueSetIndexes
    implements StringValueSetIndexes {
        final FixedIndexed<Long> dictionary;
        int defaultValueIndex;

        private LongStringValueSetIndexes() {
            this.dictionary = (FixedIndexed)ScalarLongColumnAndIndexSupplier.this.longDictionarySupplier.get();
            this.defaultValueIndex = this.dictionary.indexOf(NullHandling.defaultLongValue());
        }

        @Override
        public BitmapColumnIndex forValue(@Nullable String value) {
            final boolean inputNull = value == null;
            final Long longValue = GuavaUtils.tryParseLong(value);
            return new SimpleBitmapColumnIndex(){

                @Override
                public int estimatedComputeCost() {
                    return 1;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                    if (longValue == null) {
                        if (inputNull && NullHandling.sqlCompatible()) {
                            return bitmapResultFactory.wrapDimensionValue(ScalarLongColumnAndIndexSupplier.this.getBitmap(0));
                        }
                        return bitmapResultFactory.wrapDimensionValue(ScalarLongColumnAndIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    if (NullHandling.replaceWithDefault() && longValue.equals(NullHandling.defaultLongValue())) {
                        if (LongStringValueSetIndexes.this.defaultValueIndex >= 0) {
                            return bitmapResultFactory.unionDimensionValueBitmaps((Iterable<ImmutableBitmap>)ImmutableList.of((Object)ScalarLongColumnAndIndexSupplier.this.getBitmap(0), (Object)ScalarLongColumnAndIndexSupplier.this.getBitmap(LongStringValueSetIndexes.this.defaultValueIndex)));
                        }
                        return bitmapResultFactory.wrapDimensionValue(ScalarLongColumnAndIndexSupplier.this.getBitmap(0));
                    }
                    int id = LongStringValueSetIndexes.this.dictionary.indexOf(longValue);
                    if (includeUnknown) {
                        if (id < 0) {
                            return bitmapResultFactory.wrapDimensionValue(ScalarLongColumnAndIndexSupplier.this.nullValueBitmap);
                        }
                        return bitmapResultFactory.unionDimensionValueBitmaps((Iterable<ImmutableBitmap>)ImmutableList.of((Object)ScalarLongColumnAndIndexSupplier.this.getBitmap(id), (Object)ScalarLongColumnAndIndexSupplier.this.nullValueBitmap));
                    }
                    if (id < 0) {
                        return bitmapResultFactory.wrapDimensionValue(ScalarLongColumnAndIndexSupplier.this.bitmapFactory.makeEmptyImmutableBitmap());
                    }
                    return bitmapResultFactory.wrapDimensionValue(ScalarLongColumnAndIndexSupplier.this.getBitmap(id));
                }
            };
        }

        @Override
        public BitmapColumnIndex forSortedValues(final SortedSet<String> values) {
            return new SimpleImmutableBitmapDelegatingIterableIndex(){

                @Override
                public int estimatedComputeCost() {
                    return values.size();
                }

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    LongArraySet longs = new LongArraySet(values.size());
                    boolean needNullCheck = false;
                    for (String value : values) {
                        if (value == null) {
                            needNullCheck = true;
                            continue;
                        }
                        Long theValue = DimensionHandlerUtils.convertObjectToLong(value);
                        if (theValue == null) continue;
                        longs.add(theValue.longValue());
                        if (!NullHandling.replaceWithDefault() || !theValue.equals(NullHandling.defaultLongValue())) continue;
                        needNullCheck = true;
                    }
                    boolean doNullCheck = needNullCheck;
                    return () -> this.lambda$getBitmapIterable$0((LongSet)longs, doNullCheck);
                }

                @Override
                @Nullable
                @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
                protected ImmutableBitmap getUnknownsBitmap() {
                    if (!values.contains(null)) {
                        return ScalarLongColumnAndIndexSupplier.this.nullValueBitmap;
                    }
                    return null;
                }

                private /* synthetic */ Iterator lambda$getBitmapIterable$0(final LongSet longs, final boolean doNullCheck) {
                    return new Iterator<ImmutableBitmap>(){
                        final FixedIndexed<Long> dictionary;
                        final LongIterator iterator;
                        int next;
                        boolean nullChecked;
                        {
                            this.dictionary = (FixedIndexed)ScalarLongColumnAndIndexSupplier.this.longDictionarySupplier.get();
                            this.iterator = longs.iterator();
                            this.next = -1;
                            this.nullChecked = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (doNullCheck && !this.nullChecked) {
                                return true;
                            }
                            if (this.next < 0) {
                                this.findNext();
                            }
                            return this.next >= 0;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (doNullCheck && !this.nullChecked) {
                                this.nullChecked = true;
                                return ScalarLongColumnAndIndexSupplier.this.getBitmap(0);
                            }
                            if (this.next < 0) {
                                this.findNext();
                                if (this.next < 0) {
                                    throw new NoSuchElementException();
                                }
                            }
                            int swap = this.next;
                            this.next = -1;
                            return ScalarLongColumnAndIndexSupplier.this.getBitmap(swap);
                        }

                        private void findNext() {
                            while (this.next < 0 && this.iterator.hasNext()) {
                                long nextValue = this.iterator.nextLong();
                                this.next = this.dictionary.indexOf(nextValue);
                            }
                        }
                    };
                }
            };
        }
    }

    private class LongNumericRangeIndex
    implements NumericRangeIndexes {
        private LongNumericRangeIndex() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forRange(@Nullable Number startValue, boolean startStrict, @Nullable Number endValue, boolean endStrict) {
            FixedIndexed dictionary = (FixedIndexed)ScalarLongColumnAndIndexSupplier.this.longDictionarySupplier.get();
            Long startLong = startValue == null ? null : (startStrict ? Long.valueOf((long)Math.floor(startValue.doubleValue())) : Long.valueOf((long)Math.ceil(startValue.doubleValue())));
            Long endLong = endValue == null ? null : (endStrict ? Long.valueOf((long)Math.ceil(endValue.doubleValue())) : Long.valueOf((long)Math.floor(endValue.doubleValue())));
            IntIntPair range = dictionary.getRange(startLong, startStrict, endLong, endStrict);
            final int startIndex = range.leftInt();
            final int endIndex = range.rightInt();
            return new DictionaryRangeScanningBitmapIndex(ScalarLongColumnAndIndexSupplier.this.columnConfig.skipValueRangeIndexScale(), endIndex - startIndex){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        final IntIterator rangeIterator;
                        {
                            this.rangeIterator = IntListUtils.fromTo(startIndex, endIndex).iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.rangeIterator.hasNext();
                        }

                        @Override
                        public ImmutableBitmap next() {
                            return ScalarLongColumnAndIndexSupplier.this.getBitmap(this.rangeIterator.nextInt());
                        }
                    };
                }

                @Override
                @Nullable
                protected ImmutableBitmap getUnknownsBitmap() {
                    return ScalarLongColumnAndIndexSupplier.this.nullValueBitmap;
                }
            };
        }
    }

    private class LongPredicateIndexes
    implements DruidPredicateIndexes {
        private LongPredicateIndexes() {
        }

        @Override
        @Nullable
        public BitmapColumnIndex forPredicate(final DruidPredicateFactory matcherFactory) {
            final FixedIndexed dictionary = (FixedIndexed)ScalarLongColumnAndIndexSupplier.this.longDictionarySupplier.get();
            return new DictionaryScanningBitmapIndex(dictionary.size()){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable(final boolean includeUnknown) {
                    return () -> new Iterator<ImmutableBitmap>(){
                        final Iterator<Long> iterator;
                        final DruidLongPredicate longPredicate;
                        int index;
                        boolean nextSet;
                        {
                            this.iterator = dictionary.iterator();
                            this.longPredicate = matcherFactory.makeLongPredicate();
                            this.index = -1;
                            this.nextSet = false;
                        }

                        @Override
                        public boolean hasNext() {
                            if (!this.nextSet) {
                                this.findNext();
                            }
                            return this.nextSet;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (!this.nextSet) {
                                this.findNext();
                                if (!this.nextSet) {
                                    throw new NoSuchElementException();
                                }
                            }
                            this.nextSet = false;
                            return ScalarLongColumnAndIndexSupplier.this.getBitmap(this.index);
                        }

                        private void findNext() {
                            while (!this.nextSet && this.iterator.hasNext()) {
                                Long nextValue = this.iterator.next();
                                ++this.index;
                                if (nextValue == null) {
                                    if (NullHandling.sqlCompatible()) {
                                        this.nextSet = this.longPredicate.applyNull().matches(includeUnknown);
                                        continue;
                                    }
                                    this.nextSet = this.longPredicate.applyLong(NullHandling.defaultLongValue()).matches(includeUnknown);
                                    continue;
                                }
                                this.nextSet = this.longPredicate.applyLong(nextValue).matches(includeUnknown);
                            }
                        }
                    };
                }
            };
        }
    }

    private class LongDictionaryEncodedValueSetIndex
    implements DictionaryEncodedStringValueIndex {
        private final FixedIndexed<Long> dictionary;

        private LongDictionaryEncodedValueSetIndex() {
            this.dictionary = (FixedIndexed)ScalarLongColumnAndIndexSupplier.this.longDictionarySupplier.get();
        }

        @Override
        public ImmutableBitmap getBitmap(int idx) {
            return ScalarLongColumnAndIndexSupplier.this.getBitmap(idx);
        }

        @Override
        public int getCardinality() {
            return this.dictionary.size();
        }

        @Override
        @Nullable
        public String getValue(int index) {
            Long value = this.dictionary.get(index);
            return value == null ? null : String.valueOf(value);
        }

        @Override
        public BitmapFactory getBitmapFactory() {
            return ScalarLongColumnAndIndexSupplier.this.bitmapFactory;
        }
    }
}

