/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.timeline.partition.BaseDimensionRangeShardSpec;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.apache.druid.timeline.partition.BuildingDimensionRangeShardSpec;
import org.apache.druid.timeline.partition.BuildingSingleDimensionShardSpec;

public class DimensionRangeBucketShardSpec
extends BaseDimensionRangeShardSpec
implements BucketNumberedShardSpec<BuildingDimensionRangeShardSpec> {
    private final int bucketId;

    @JsonCreator
    public DimensionRangeBucketShardSpec(@JsonProperty(value="bucketId") int bucketId, @JsonProperty(value="dimensions") List<String> dimensions, @JsonProperty(value="start") @Nullable StringTuple start, @JsonProperty(value="end") @Nullable StringTuple end) {
        super(dimensions, start, end);
        Preconditions.checkArgument((start == null || start.size() == dimensions.size() ? 1 : 0) != 0, (Object)"Start tuple must either be null or of the same size as the number of partition dimensions");
        Preconditions.checkArgument((end == null || end.size() == dimensions.size() ? 1 : 0) != 0, (Object)"End tuple must either be null or of the same size as the number of partition dimensions");
        this.bucketId = bucketId;
    }

    @Override
    @JsonProperty
    public int getBucketId() {
        return this.bucketId;
    }

    @JsonProperty
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @Nullable
    @JsonProperty
    public StringTuple getStart() {
        return this.start;
    }

    @Nullable
    @JsonProperty
    public StringTuple getEnd() {
        return this.end;
    }

    @Override
    public BuildingDimensionRangeShardSpec convert(int partitionId) {
        return this.dimensions != null && this.dimensions.size() == 1 ? new BuildingSingleDimensionShardSpec(this.bucketId, (String)this.dimensions.get(0), StringTuple.firstOrNull(this.start), StringTuple.firstOrNull(this.end), partitionId) : new BuildingDimensionRangeShardSpec(this.bucketId, this.dimensions, this.start, this.end, partitionId);
    }

    @Override
    public String getType() {
        return "bucket_range";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionRangeBucketShardSpec bucket = (DimensionRangeBucketShardSpec)o;
        return this.bucketId == bucket.bucketId && Objects.equals(this.dimensions, bucket.dimensions) && Objects.equals(this.start, bucket.start) && Objects.equals(this.end, bucket.end);
    }

    public int hashCode() {
        return Objects.hash(this.bucketId, this.dimensions, this.start, this.end);
    }

    public String toString() {
        return "DimensionRangeBucketShardSpec{, bucketId=" + this.bucketId + ", dimension='" + this.dimensions + '\'' + ", start='" + this.start + '\'' + ", end='" + this.end + '\'' + '}';
    }
}

