/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public abstract class ColumnsFilter {
    public static ColumnsFilter all() {
        return new ExclusionBased(Collections.emptySet());
    }

    public static ColumnsFilter inclusionBased(Set<String> inclusions) {
        return new InclusionBased(inclusions);
    }

    public static ColumnsFilter exclusionBased(Set<String> exclusions) {
        return new ExclusionBased(exclusions);
    }

    public abstract boolean apply(String var1);

    public abstract ColumnsFilter plus(String var1);

    public static class ExclusionBased
    extends ColumnsFilter {
        private final Set<String> exclusions;

        public ExclusionBased(Set<String> exclusions) {
            this.exclusions = exclusions;
        }

        @Override
        public boolean apply(String column) {
            return !this.exclusions.contains(column);
        }

        @Override
        public ColumnsFilter plus(String column) {
            if (!this.exclusions.contains(column)) {
                return this;
            }
            HashSet<String> copy = new HashSet<String>(this.exclusions);
            copy.remove(column);
            return new ExclusionBased(copy);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExclusionBased that = (ExclusionBased)o;
            return Objects.equals(this.exclusions, that.exclusions);
        }

        public int hashCode() {
            return Objects.hash(this.exclusions);
        }

        public String toString() {
            return "ColumnsFilter.ExclusionBased{exclusions=" + this.exclusions + '}';
        }
    }

    public static class InclusionBased
    extends ColumnsFilter {
        private final Set<String> inclusions;

        private InclusionBased(Set<String> inclusions) {
            this.inclusions = inclusions;
        }

        @Override
        public boolean apply(String column) {
            return this.inclusions.contains(column);
        }

        @Override
        public ColumnsFilter plus(String column) {
            if (this.inclusions.contains(column)) {
                return this;
            }
            HashSet<String> copy = new HashSet<String>(this.inclusions);
            copy.add(column);
            return new InclusionBased(copy);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InclusionBased that = (InclusionBased)o;
            return Objects.equals(this.inclusions, that.inclusions);
        }

        public int hashCode() {
            return Objects.hash(this.inclusions);
        }

        public String toString() {
            return "ColumnsFilter.InclusionBased{inclusions=" + this.inclusions + '}';
        }
    }
}

